/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.routing.InstanceSet;
import oracle.ucp.util.Pair;

class DestinationMap {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final NavigableMap<Integer, InstanceSet> instsPerPriority = new TreeMap<Integer, InstanceSet>((o1, o2) -> o1 - o2);
    private final NavigableMap<Integer, InstanceSet> readWriteInstsPerPriority = new TreeMap<Integer, InstanceSet>((o1, o2) -> o1 - o2);
    private final Map<ServiceMember, Pair<Integer, Integer>> priorityAndStatePerInstance = new HashMap<ServiceMember, Pair<Integer, Integer>>();
    private final AtomicReference<Set<ServiceMember>> allInstancesSnapshot = new AtomicReference<Set<ServiceMember>>(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityAndStatePerInstance.keySet())));
    private final Set<ServiceMember> allReadWriteInstances = new HashSet<ServiceMember>();
    private final AtomicReference<Set<ServiceMember>> allReadWriteInstancesSnapshot = new AtomicReference<Set<ServiceMember>>(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.allReadWriteInstances)));

    DestinationMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ServiceMember inst, int priority, int state) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.instsPerPriority.computeIfAbsent(priority, p -> new InstanceSet()).add(inst);
            if (state == 0) {
                this.readWriteInstsPerPriority.computeIfAbsent(priority, p -> new InstanceSet()).add(inst);
                this.allReadWriteInstances.add(inst);
                this.allReadWriteInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.allReadWriteInstances)));
            }
            this.priorityAndStatePerInstance.put(inst, new Pair<Integer, Integer>(priority, state));
            this.allInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityAndStatePerInstance.keySet())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            Pair<Integer, Integer> entry = this.priorityAndStatePerInstance.remove(inst);
            Integer priority = entry.get1st();
            Integer state = entry.get2nd();
            if (null != priority) {
                InstanceSet insts = this.instsPerPriority.getOrDefault(priority, InstanceSet.EMPTY);
                insts.remove(inst);
                if (state == 0) {
                    InstanceSet rwInsts = this.readWriteInstsPerPriority.getOrDefault(priority, InstanceSet.EMPTY);
                    rwInsts.remove(inst);
                    this.allReadWriteInstances.remove(inst);
                    this.allReadWriteInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.allReadWriteInstances)));
                }
            }
            this.allInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityAndStatePerInstance.keySet())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markReadOnly(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.priorityAndStatePerInstance.replace(inst, new Pair<Integer, Integer>(this.priorityAndStatePerInstance.get(inst).get1st(), 1));
            this.allReadWriteInstances.remove(inst);
            for (InstanceSet insts : this.readWriteInstsPerPriority.values()) {
                if (!insts.allInstances().contains(inst)) continue;
                insts.remove(inst);
                break;
            }
            this.allReadWriteInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.allReadWriteInstances)));
            this.allInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityAndStatePerInstance.keySet())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    InstanceSet getHighestPriorityInstances(boolean isReadOnlyAllowed) {
        this.rLock.lock();
        try {
            if (this.instsPerPriority.isEmpty()) {
                InstanceSet instanceSet = new InstanceSet();
                return instanceSet;
            }
            InstanceSet instanceSet = isReadOnlyAllowed ? this.instsPerPriority.firstEntry().getValue() : this.readWriteInstsPerPriority.firstEntry().getValue();
            return instanceSet;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(ServiceMember inst, boolean isReadOnlyAllowed) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            boolean bl = isReadOnlyAllowed ? this.priorityAndStatePerInstance.containsKey(inst) : this.allReadWriteInstances.contains(inst);
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPriority(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Pair<Integer, Integer> priorityAndState = this.priorityAndStatePerInstance.get(inst);
            int n = null != priorityAndState ? priorityAndState.get1st() : -1;
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    Set<ServiceMember> allInstances(boolean isReadOnlyAllowed) {
        return isReadOnlyAllowed ? this.allInstancesSnapshot.get() : this.allReadWriteInstancesSnapshot.get();
    }
}

