/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

class UniversalPooledConnectionImpl
implements UniversalPooledConnection,
Diagnosable {
    static final String CLASS_NAME = UniversalPooledConnectionImpl.class.getName();
    private final UniversalConnectionPoolBase m_connectionPool;
    private final Object m_connection;
    private final AtomicReference<ConnectionRetrievalInfo> m_connectionRetrievalInfo = new AtomicReference<Object>(null);
    private ConnectionRetrievalInfo borrowCRI;
    AtomicReference<UniversalPooledConnectionStatus> m_status = new AtomicReference<UniversalPooledConnectionStatus>(UniversalPooledConnectionStatus.STATUS_NORMAL);
    private volatile long lastAccessedTime = Clock.clock();
    private boolean m_sqlWithQueryTimeoutInProgress = false;
    private volatile long availableStartTime = Clock.clock();
    private volatile long borrowedStartTime = Clock.clock();
    private final AtomicLong m_connectionReuseTimestamp = new AtomicLong(Clock.clock());
    private volatile int connectionReuseCounter = 0;
    private final AtomicBoolean m_isHarvestable = new AtomicBoolean(true);
    private AtomicReference<ConnectionHarvestingCallback> m_harvestingCallback = new AtomicReference<Object>(null);
    private AtomicReference<AbandonedConnectionTimeoutCallback> m_abandonedConnCallback = new AtomicReference<Object>(null);
    private AtomicReference<TimeToLiveConnectionTimeoutCallback> m_ttlConnCallback = new AtomicReference<Object>(null);
    private final AtomicLong m_lastConnectionValidationTime = new AtomicLong(0L);
    private final AtomicBoolean wasBorrowed = new AtomicBoolean(false);
    private final ReentrantLock labeledConnectionsCountLock = new ReentrantLock();
    protected final Semaphore validitySemaphore = new Semaphore(1);
    private final AtomicReference<CompletionStage<Boolean>> recentValidationCompletionStage = new AtomicReference<Object>(null);
    private AtomicBoolean available = new AtomicBoolean(true);
    private static final boolean selfTunerEnabled = Util.isSelfTunerEnabled();
    private AtomicReference<CoreConnection> delegator = new AtomicReference<Object>(null);

    UniversalPooledConnectionImpl(UniversalConnectionPoolBase connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (null == connectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        if (null == connection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(264);
        }
        if (null == connectionRetrievalInfo) {
            UCPErrorHandler.throwUniversalConnectionPoolException(4);
        }
        this.m_connectionPool = connectionPool;
        this.m_connection = connection;
        this.m_connectionRetrievalInfo.set(connectionRetrievalInfo);
        this.m_isHarvestable.set(true);
        this.m_connectionPool.getNeverUsedConnectionsCounter().getCounter(connectionRetrievalInfo).incrementAndGet();
    }

    @Override
    public Object getPhysicalConnection() {
        return this.m_connection;
    }

    @Override
    public ConnectionRetrievalInfo getConnectionRetrievalInfo() {
        return this.m_connectionRetrievalInfo.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionRetrievalInfo(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setConnectionRetrievalInfo", "entering args ({0})", null, null, connectionRetrievalInfo);
            this.labeledConnectionsCountLock.lock();
            try {
                void newCri;
                ConnectionRetrievalInfo oldCri = this.m_connectionRetrievalInfo.getAndSet((ConnectionRetrievalInfo)newCri);
                Properties oldLabels = oldCri.getLabels();
                Properties newLabels = newCri.getLabels();
                boolean wasLabeled = null != oldLabels && !oldLabels.isEmpty();
                boolean becameLabeled = null != newLabels && !newLabels.isEmpty();
                Counter counter = this.m_connectionPool.labeledConnectionsCount;
                if (wasLabeled) {
                    if (!becameLabeled) {
                        counter.decrementAndGet();
                    }
                } else if (becameLabeled) {
                    counter.incrementAndGet();
                }
            }
            finally {
                this.labeledConnectionsCountLock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setConnectionRetrievalInfo", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setConnectionRetrievalInfo", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    ConnectionRetrievalInfo getBorrowCRI() {
        return this.borrowCRI;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    void setBorrowCRI(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void borrowCRI;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setBorrowCRI", "entering args ({0})", null, null, connectionRetrievalInfo);
            this.borrowCRI = borrowCRI;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setBorrowCRI", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setBorrowCRI", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void heartbeat() {
        this.lastAccessedTime = Clock.clock();
    }

    @Override
    public void setSqlWithQueryTimeoutInProgress(boolean sqlWithQueryTimeoutInProgress) {
        this.m_sqlWithQueryTimeoutInProgress = sqlWithQueryTimeoutInProgress;
    }

    @Override
    public boolean isSqlWithQueryTimeoutInProgress() {
        return this.m_sqlWithQueryTimeoutInProgress;
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean isValid() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "entering args ()", null, null, new Object[0]);
            boolean bl = this.isValid(UniversalPooledConnection.ValidationType.SOCKET, this.m_connectionPool.getConnectionValidationTimeout());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean isValid(UniversalPooledConnection.ValidationType validationType) {
        try {
            void validationType2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "entering args ({0})", null, null, new Object[]{validationType});
            boolean bl = this.isValid((UniversalPooledConnection.ValidationType)validationType2, this.m_connectionPool.getConnectionValidationTimeout());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean isValid(UniversalPooledConnection.ValidationType validationType, int n) {
        try {
            boolean bl;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "entering args ({0}, {1})", null, null, new Object[]{validationType, n});
            try {
                void timeout;
                void validationType2;
                this.validitySemaphore.acquire();
                boolean bl2 = this.isValidHelper((UniversalPooledConnection.ValidationType)validationType2, (int)timeout);
                bl = bl2;
            }
            catch (InterruptedException e) {
                this.trace(Level.WARNING, CLASS_NAME, "isValid", "", null, e, new Object[0]);
                boolean bl3 = true;
                boolean bl4 = bl3;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "returning {0}", null, null, bl4);
                return bl4;
            }
            finally {
                this.validitySemaphore.release();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValid", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public CompletionStage<Boolean> isValidAsync(UniversalPooledConnection.ValidationType validationType, int n, Executor executor) {
        try {
            void executor2;
            void timeout;
            void validationType2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidAsync", "entering args ({0}, {1}, {2})", null, null, new Object[]{validationType, n, executor});
            CompletionStage<Boolean> completionStage = this.recentValidationCompletionStage.updateAndGet(arg_0 -> this.lambda$isValidAsync$1((UniversalPooledConnection.ValidationType)validationType2, (int)timeout, (Executor)executor2, arg_0));
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidAsync", "returning {0}", null, null, completionStage);
            return completionStage;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private boolean isValidHelper(UniversalPooledConnection.ValidationType validationType, int n) {
        try {
            void timeout;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidHelper", "entering args ({0}, {1})", null, null, new Object[]{validationType, n});
            UniversalPooledConnectionStatus status = this.getStatus();
            if (timeout < 0) {
                throw new IllegalArgumentException("negative timeout");
            }
            if (this.m_connectionPool != null && (status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
                void validationType2;
                this.debug(Level.FINEST, CLASS_NAME, "isValidHelper", "about to start validation", null, null, new Object[0]);
                this.validate((UniversalPooledConnection.ValidationType)validationType2, (int)timeout);
            }
            UniversalPooledConnectionStatus s = this.getStatus();
            this.debug(Level.FINEST, CLASS_NAME, "isValidHelper", "status={0}", null, null, s);
            boolean bl = !s.equals(UniversalPooledConnectionStatus.STATUS_CLOSED) && !s.equals(UniversalPooledConnectionStatus.STATUS_BAD) && !s.equals(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidHelper", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidHelper", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private CompletionStage<Boolean> isValidHelperAsync(UniversalPooledConnection.ValidationType validationType, int n, Executor executor) {
        try {
            void timeout;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidHelperAsync", "entering args ({0}, {1}, {2})", null, null, new Object[]{validationType, n, executor});
            if (timeout < 0) {
                CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
                cf.completeExceptionally(UCPErrorHandler.newSQLException(67, null));
                CompletableFuture<Boolean> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidHelperAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            UniversalPooledConnectionStatus status = this.getStatus();
            if (Objects.nonNull(this.m_connectionPool) && (status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
                void executor2;
                void validationType2;
                CompletionStage completionStage = CompletableFuture.supplyAsync(() -> this.lambda$isValidHelperAsync$2((UniversalPooledConnection.ValidationType)validationType2, (int)timeout, (Executor)executor2)).thenApplyAsync(nil -> {
                    UniversalPooledConnectionStatus _status = this.getStatus();
                    return !UniversalPooledConnectionStatus.STATUS_CLOSED.equals(_status) && !UniversalPooledConnectionStatus.STATUS_BAD.equals(_status) && !UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(_status);
                }, (Executor)executor2);
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidHelperAsync", "returning {0}", null, null, completionStage);
                return completionStage;
            }
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidHelperAsync", "returning {0}", null, null, completableFuture);
            return completableFuture;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "isValidHelperAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void validate() {
        this.validate(UniversalPooledConnection.ValidationType.SOCKET, this.m_connectionPool.getConnectionValidationTimeout());
    }

    @Override
    public void validate(UniversalPooledConnection.ValidationType validationType, int timeout) {
    }

    @Override
    public CompletionStage<Void> validateAsync(UniversalPooledConnection.ValidationType validationType, int timeout, Executor executor) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public long getLastNetworkAccessTime() {
        return 0L;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public UniversalPooledConnectionStatus getStatus() {
        return this.m_status.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setStatus(UniversalPooledConnectionStatus universalPooledConnectionStatus) throws UniversalConnectionPoolException {
        try {
            UniversalPooledConnectionStatus oldStatus;
            void status;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setStatus", "entering args ({0})", null, null, universalPooledConnectionStatus);
            if (null == status) {
                UCPErrorHandler.throwUniversalConnectionPoolException(152);
            }
            this.trace(Level.FINEST, CLASS_NAME, "setStatus", "about to set status={0} for conn={1}", null, null, status, this);
            while (!UniversalPooledConnectionStatus.STATUS_CLOSED.equals(oldStatus = this.getStatus()) && !this.m_status.compareAndSet(oldStatus, (UniversalPooledConnectionStatus)status)) {
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setStatus", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setStatus", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void setStatus(UniversalPooledConnectionStatus universalPooledConnectionStatus, String string) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setStatus", "entering args ({0}, {1})", null, null, universalPooledConnectionStatus, string);
            try {
                void status;
                this.setStatus((UniversalPooledConnectionStatus)status);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.FINEST, CLASS_NAME, "setStatus", "status setup failed", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setStatus", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setStatus", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public long getAvailableStartTime() {
        return this.availableStartTime;
    }

    @Override
    public void setAvailableStartTime() {
        this.availableStartTime = Clock.clock();
    }

    @Override
    public long getBorrowedStartTime() {
        return this.borrowedStartTime;
    }

    @Override
    public void setBorrowedStartTime() {
        this.borrowedStartTime = Clock.clock();
    }

    @Override
    public long getLastConnectionValidationTime() {
        return this.m_lastConnectionValidationTime.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setLastConnectionValidationTime(long l) {
        try {
            void lastConnectionValidationTime;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setLastConnectionValidationTime", "entering args ({0})", null, null, l);
            this.m_lastConnectionValidationTime.set((long)lastConnectionValidationTime);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setLastConnectionValidationTime", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setLastConnectionValidationTime", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private void checkForBeingAlive() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "checkForBeingAlive", "entering args ()", null, null, new Object[0]);
            UniversalPooledConnectionStatus status = this.getStatus();
            if (status.equals(UniversalPooledConnectionStatus.STATUS_BAD)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(158);
            }
            if (status.equals(UniversalPooledConnectionStatus.STATUS_CLOSED)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(154);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "checkForBeingAlive", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "checkForBeingAlive", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void applyConnectionLabel(String string, String string2) throws UniversalConnectionPoolException {
        try {
            void key;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "applyConnectionLabel", "entering args ({0}, {1})", null, null, string, string2);
            this.checkForBeingAlive();
            if (key == null || key.equals("")) {
                UCPErrorHandler.throwUniversalConnectionPoolException(153);
            }
            this.labeledConnectionsCountLock.lock();
            try {
                void value;
                ConnectionRetrievalInfo cri = this.m_connectionRetrievalInfo.get();
                Properties labels = cri.getLabels();
                boolean wasLabeled = null != labels && !labels.isEmpty();
                cri.addLabel((String)key, (String)value);
                if (!wasLabeled) {
                    this.m_connectionPool.labeledConnectionsCount.incrementAndGet();
                }
            }
            finally {
                this.labeledConnectionsCountLock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "applyConnectionLabel", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "applyConnectionLabel", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void removeConnectionLabel(String string) throws UniversalConnectionPoolException {
        try {
            void key;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeConnectionLabel", "entering args ({0})", null, null, string);
            this.checkForBeingAlive();
            if (null == key || key.equals("")) {
                UCPErrorHandler.throwUniversalConnectionPoolException(153);
            }
            this.labeledConnectionsCountLock.lock();
            try {
                boolean nowLabeled;
                ConnectionRetrievalInfo cri = this.m_connectionRetrievalInfo.get();
                Properties labels = cri.getLabels();
                boolean wasLabeled = null != labels && !labels.isEmpty();
                cri.removeLabel((String)key);
                labels = cri.getLabels();
                boolean bl = nowLabeled = null != labels && !labels.isEmpty();
                if (wasLabeled && !nowLabeled) {
                    this.m_connectionPool.labeledConnectionsCount.decrementAndGet();
                }
            }
            finally {
                this.labeledConnectionsCountLock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeConnectionLabel", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeConnectionLabel", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    void onInsert() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "onInsert", "entering args ()", null, null, new Object[0]);
            this.labeledConnectionsCountLock.lock();
            try {
                ConnectionRetrievalInfo cri = this.m_connectionRetrievalInfo.get();
                Properties labels = cri.getLabels();
                if (null != labels && !labels.isEmpty()) {
                    this.m_connectionPool.labeledConnectionsCount.incrementAndGet();
                }
            }
            finally {
                this.labeledConnectionsCountLock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "onInsert", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "onInsert", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    void onRetrieve() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "onRetrieve", "entering args ()", null, null, new Object[0]);
            this.labeledConnectionsCountLock.lock();
            try {
                ConnectionRetrievalInfo cri = this.m_connectionRetrievalInfo.get();
                Properties labels = cri.getLabels();
                if (null != labels && !labels.isEmpty()) {
                    this.m_connectionPool.labeledConnectionsCount.decrementAndGet();
                }
            }
            finally {
                this.labeledConnectionsCountLock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "onRetrieve", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "onRetrieve", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public Properties getConnectionLabels() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "getConnectionLabels", "entering args ()", null, null, new Object[0]);
            this.checkForBeingAlive();
            Properties properties = this.m_connectionRetrievalInfo.get().getLabels();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "getConnectionLabels", "returning {0}", null, null, properties);
            return properties;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "getConnectionLabels", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Properties getUnmatchedConnectionLabels(Properties properties) throws UniversalConnectionPoolException {
        try {
            void requestedLabels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "getUnmatchedConnectionLabels", "entering args ({0})", null, null, properties);
            this.checkForBeingAlive();
            Properties storedLabels = this.m_connectionRetrievalInfo.get().getLabels();
            if (requestedLabels == null || requestedLabels.isEmpty()) {
                if (storedLabels != null && !storedLabels.isEmpty()) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(93);
                } else {
                    Properties properties2 = null;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "getUnmatchedConnectionLabels", "returning {0}", null, null, properties2);
                    return properties2;
                }
            }
            Properties unmatchedLabels = new Properties();
            if (storedLabels == null || storedLabels.isEmpty()) {
                unmatchedLabels.putAll((Map<?, ?>)requestedLabels);
                Properties properties3 = unmatchedLabels;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "getUnmatchedConnectionLabels", "returning {0}", null, null, properties3);
                return properties3;
            }
            Iterator<Map.Entry<Object, Object>> itr = requestedLabels.entrySet().iterator();
            Set<Map.Entry<Object, Object>> storedLabelSet = storedLabels.entrySet();
            while (itr.hasNext()) {
                Map.Entry<Object, Object> label = itr.next();
                String key = (String)label.getKey();
                String value = (String)label.getValue();
                if (storedLabelSet.contains(label)) continue;
                unmatchedLabels.setProperty(key, value);
            }
            Properties properties4 = unmatchedLabels.isEmpty() ? null : unmatchedLabels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "getUnmatchedConnectionLabels", "returning {0}", null, null, properties4);
            return properties4;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "getUnmatchedConnectionLabels", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setConnectionHarvestable(boolean bl) throws UniversalConnectionPoolException {
        try {
            void isConnectionHarvestable;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setConnectionHarvestable", "entering args ({0})", null, null, bl);
            this.checkForBeingAlive();
            this.m_isHarvestable.set((boolean)isConnectionHarvestable);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setConnectionHarvestable", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "setConnectionHarvestable", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean isConnectionHarvestable() {
        return this.m_isHarvestable.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback connectionHarvestingCallback) throws UniversalConnectionPoolException {
        try {
            void cbk;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerConnectionHarvestingCallback", "entering args ({0})", null, null, connectionHarvestingCallback);
            this.checkForBeingAlive();
            if (!this.m_harvestingCallback.compareAndSet(null, (ConnectionHarvestingCallback)cbk)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(155);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerConnectionHarvestingCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerConnectionHarvestingCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() {
        this.m_harvestingCallback.set(null);
    }

    @Override
    public ConnectionHarvestingCallback getConnectionHarvestingCallback() {
        return this.m_harvestingCallback.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback abandonedConnectionTimeoutCallback) throws UniversalConnectionPoolException {
        try {
            void cbk;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerAbandonedConnectionTimeoutCallback", "entering args ({0})", null, null, abandonedConnectionTimeoutCallback);
            this.checkForBeingAlive();
            if (!this.m_abandonedConnCallback.compareAndSet(null, (AbandonedConnectionTimeoutCallback)cbk)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(156);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerAbandonedConnectionTimeoutCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerAbandonedConnectionTimeoutCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void removeAbandonedConnectionTimeoutCallback() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeAbandonedConnectionTimeoutCallback", "entering args ()", null, null, new Object[0]);
            this.m_abandonedConnCallback.set(null);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeAbandonedConnectionTimeoutCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeAbandonedConnectionTimeoutCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public AbandonedConnectionTimeoutCallback getAbandonedConnectionTimeoutCallback() {
        return this.m_abandonedConnCallback.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback timeToLiveConnectionTimeoutCallback) throws UniversalConnectionPoolException {
        try {
            void cbk;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerTimeToLiveConnectionTimeoutCallback", "entering args ({0})", null, null, timeToLiveConnectionTimeoutCallback);
            this.checkForBeingAlive();
            if (!this.m_ttlConnCallback.compareAndSet(null, (TimeToLiveConnectionTimeoutCallback)cbk)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(157);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerTimeToLiveConnectionTimeoutCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "registerTimeToLiveConnectionTimeoutCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void removeTimeToLiveConnectionTimeoutCallback() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeTimeToLiveConnectionTimeoutCallback", "entering args ()", null, null, new Object[0]);
            this.m_ttlConnCallback.set(null);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeTimeToLiveConnectionTimeoutCallback", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "removeTimeToLiveConnectionTimeoutCallback", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public TimeToLiveConnectionTimeoutCallback getTimeToLiveConnectionTimeoutCallback() {
        return this.m_ttlConnCallback.get();
    }

    private int getConnectionReuseCounter() {
        return this.connectionReuseCounter;
    }

    private long getConnectionReuseTimestamp() {
        return this.m_connectionReuseTimestamp.get();
    }

    @Override
    public boolean isReusable() {
        int countToGiveUp;
        long timeToGiveUp;
        long reuseTime = this.m_connectionPool.getMaxConnectionReuseTime();
        if (reuseTime > 0L && (timeToGiveUp = this.getConnectionReuseTimestamp() + reuseTime * 1000L) <= Clock.clock()) {
            return false;
        }
        int reuseCount = this.m_connectionPool.getMaxConnectionReuseCount();
        return reuseCount <= 0 || (countToGiveUp = this.getConnectionReuseCounter()) < reuseCount;
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void close() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "close", "entering args ()", null, null, new Object[0]);
            this.delegator.get().close();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "close", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "close", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    void closeNoStatsUpdate() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "closeNoStatsUpdate", "entering args ()", null, null, new Object[0]);
            try {
                Object physicalConnection = this.getPhysicalConnection();
                if (null != physicalConnection) {
                    this.m_connectionPool.getConnectionFactoryAdapter().closeConnection(physicalConnection);
                }
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "closeNoStatsUpdate", "", null, e, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "closeNoStatsUpdate", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "closeNoStatsUpdate", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    CompletionStage<Void> closeNoStatsUpdateAsync(Executor executor) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "closeNoStatsUpdateAsync", "entering args ({0})", null, null, executor);
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            Object physicalConnection = this.getPhysicalConnection();
            if (null != physicalConnection) {
                void executor2;
                this.m_connectionPool.getConnectionFactoryAdapter().closeConnectionAsync(physicalConnection, (Executor)executor2).whenCompleteAsync((p, e) -> {
                    if (Objects.nonNull(e)) {
                        cf.completeExceptionally((Throwable)e);
                        return;
                    }
                    cf.complete(null);
                }, (Executor)executor2);
            }
            CompletableFuture<Void> completableFuture = cf;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "closeNoStatsUpdateAsync", "returning {0}", null, null, completableFuture);
            return completableFuture;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "closeNoStatsUpdateAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void abort() {
    }

    @Override
    public void handleTimeout() {
    }

    @Override
    public boolean isAvailable() {
        return this.available.get();
    }

    @Override
    public boolean setAvailable() {
        return this.setAvailable(true);
    }

    @Override
    public boolean setBorrowed() {
        return this.setAvailable(false);
    }

    private boolean setAvailable(boolean available) {
        boolean wasSet = this.available.compareAndSet(!available, available);
        if (wasSet) {
            if (available) {
                ++this.m_connectionPool.cumulativeReturnedConnectionsCount;
                if (selfTunerEnabled) {
                    this.m_connectionPool.insertToBorrowedHistogram(this.getConnectionRetrievalInfo(), Clock.clock() - this.getBorrowedStartTime());
                }
            } else {
                ++this.connectionReuseCounter;
                ++this.m_connectionPool.cumulativeBorrowedConnectionsCount;
                if (selfTunerEnabled) {
                    this.m_connectionPool.insertToAvailableHistogram(this.getConnectionRetrievalInfo(), Clock.clock() - this.getAvailableStartTime());
                }
                if (this.wasBorrowed.compareAndSet(false, true)) {
                    this.m_connectionPool.getNeverUsedConnectionsCounter().getCounter(this.getConnectionRetrievalInfo()).decrementAndGet();
                }
            }
        }
        return wasSet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public int labelingCost(Properties properties) {
        try {
            int totalCount;
            void labels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "labelingCost", "entering args ({0})", null, null, properties);
            Properties connLabels = this.m_connectionRetrievalInfo.get().getLabels();
            if (null == labels) {
                int n = null == connLabels ? 0 : Integer.MAX_VALUE;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "labelingCost", "returning {0}", null, null, n);
                return n;
            }
            ConnectionLabelingCallback callback = this.m_connectionPool.getConnectionLabelingCallback();
            if (null == callback) {
                int n = 0;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "labelingCost", "returning {0}", null, null, n);
                return n;
            }
            int cost = callback.cost((Properties)labels, null == connLabels ? new Properties() : connLabels);
            if (cost >= this.m_connectionPool.getConnectionLabelingHighCost() && ((totalCount = this.m_connectionPool.getTotalConnectionsCount()) < this.m_connectionPool.getHighCostConnectionReuseThreshold() || totalCount < this.m_connectionPool.getMinPoolSize()) && this.isLoggingLevelFinest()) {
                this.debug(Level.FINEST, CLASS_NAME, "labelingCost", "restricted by the labeling high cost mechanism:  cost={0}, highCost={1}, totalCount={2}, threshold={3}, minPoolSize={4}", null, null, cost, this.m_connectionPool.getConnectionLabelingHighCost(), totalCount, this.m_connectionPool.getHighCostConnectionReuseThreshold(), this.m_connectionPool.getMinPoolSize());
                int n = Integer.MAX_VALUE;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "labelingCost", "returning {0}", null, null, n);
                return n;
            }
            int n = cost;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "labelingCost", "returning {0}", null, null, n);
            return n;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.UniversalPooledConnectionImpl", "labelingCost", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public void plugDelegator(CoreConnection delegator) {
        if (!this.delegator.compareAndSet(null, delegator)) {
            throw new IllegalStateException("delegator was already plugged");
        }
    }

    @Override
    public CoreConnection getDelegator() {
        CoreConnection connection = this.delegator.get();
        if (null == connection) {
            throw new IllegalStateException("delegator was not plugged yet");
        }
        return connection;
    }

    public String getService() {
        return "";
    }

    @Override
    public Properties getDatabaseConnectionProperties() {
        return new Properties();
    }

    @Override
    public boolean isOracle() {
        return this.m_connectionPool.isOraclePool();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.m_connectionPool.getDiagnosable();
    }

    public UniversalConnectionPoolBase getPool() {
        return this.m_connectionPool;
    }

    private /* synthetic */ CompletionStage lambda$isValidHelperAsync$2(UniversalPooledConnection.ValidationType validationType, int timeout, Executor executor) {
        return this.validateAsync(validationType, timeout, executor);
    }

    private /* synthetic */ CompletionStage lambda$isValidAsync$1(UniversalPooledConnection.ValidationType validationType, int timeout, Executor executor, CompletionStage currentStage) {
        if (Objects.nonNull(currentStage)) {
            return currentStage;
        }
        return this.isValidHelperAsync(validationType, timeout, executor).thenApplyAsync(res -> {
            this.recentValidationCompletionStage.set(null);
            return res;
        }, executor);
    }
}

