/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.ucp.util.Chain;

public class ListChain<T>
implements Chain<T> {
    private final Atom head = new Atom();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public Atom add(T data) {
        Atom a;
        this.wLock.lock();
        try {
            a = new Atom(this.head, this.head.next, data);
            if (null != this.head.next) {
                this.head.next.prev = a;
            }
            this.head.next = a;
        }
        finally {
            this.wLock.unlock();
        }
        return a;
    }

    @Override
    public void forEach(Consumer<T> consumer) {
        this.rLock.lock();
        try {
            Atom a = this.head.next;
            while (null != a) {
                consumer.accept(a.getData());
                a = a.next;
            }
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public List<T> toList() {
        ArrayList elms = new ArrayList();
        this.rLock.lock();
        try {
            Atom a = this.head.next;
            while (null != a) {
                elms.add(a.getData());
                a = a.next;
            }
        }
        finally {
            this.rLock.unlock();
        }
        return elms;
    }

    public String toString() {
        return this.toList().toString();
    }

    @Override
    public void clear() {
        this.wLock.lock();
        try {
            this.head.next = null;
            this.head.prev = null;
        }
        finally {
            this.wLock.unlock();
        }
    }

    static {
        try {
            $$$methodRef$$$6 = ListChain.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ListChain.class.getDeclaredMethod("add", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ListChain.class.getDeclaredMethod("clear", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ListChain.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ListChain.class.getDeclaredMethod("toList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ListChain.class.getDeclaredMethod("forEach", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ListChain.class.getDeclaredMethod("add", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    public class Atom
    implements Chain.Atom<T> {
        private Atom prev;
        private Atom next;
        private final T data;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private Atom(Atom prev, Atom next, T data) {
            this.prev = prev;
            this.next = next;
            this.data = data;
        }

        private Atom() {
            this(null, null, null);
        }

        @Override
        public T getData() {
            return this.data;
        }

        @Override
        public void remove() {
            ListChain.this.wLock.lock();
            try {
                if (null == this.prev) {
                    return;
                }
                this.prev.next = this.next;
                if (null != this.next) {
                    this.next.prev = this.prev;
                }
                this.next = null;
                this.prev = null;
            }
            finally {
                ListChain.this.wLock.unlock();
            }
        }

        static {
            try {
                $$$methodRef$$$3 = Atom.class.getDeclaredConstructor(ListChain.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Atom.class.getDeclaredConstructor(ListChain.class, Atom.class, Atom.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Atom.class.getDeclaredMethod("remove", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Atom.class.getDeclaredMethod("getData", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

