/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.common.Core;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalConnectionPoolStatisticsImpl;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.tuners.PoolSizeTuner;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public class UniversalConnectionPoolImpl
extends UniversalConnectionPoolBase {
    static final String loggerName = "oracle.ucp.common";
    private static final Logger logger;
    private boolean isNoWaitBorrow = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;

    public UniversalConnectionPoolImpl(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        JDBCConnectionRetrievalInfo jdbcCri;
        if (null == connectionRetrievalInfo) {
            UCPErrorHandler.throwUniversalConnectionPoolException(203);
        }
        PoolSizeTuner.trigger();
        ConnectionRetrievalInfo criCopy = connectionRetrievalInfo;
        if (connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo && (jdbcCri = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo).getServiceName() == null) {
            criCopy = jdbcCri.getCopyWithService(this.getServiceName());
        }
        UniversalPooledConnection conn = null;
        this.m_pendingRequestsCount.incrementAndGet();
        try {
            conn = this.borrowConnectionAndValidate(criCopy);
            this.borrowedAccumulator.addAndGet(this.getBorrowedConnectionsCount());
            this.borrowedSamples.incrementAndGet();
            if (conn != null) {
                ((UniversalPooledConnectionImpl)conn).setBorrowCRI(criCopy);
            }
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            throw e;
        }
        finally {
            this.m_pendingRequestsCount.decrementAndGet();
        }
        return conn;
    }

    private UniversalPooledConnection borrowConnectionAndValidate(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        UniversalPooledConnection upc = null;
        Properties requestedLabels = cri.getLabels();
        boolean isLabeledRequest = requestedLabels != null;
        upc = this.borrowConnectionAndValidateHelper(cri, null);
        if (isLabeledRequest && upc == null) {
            ConnectionRetrievalInfo criNoLabels = cri.getCopyWithNoLabels();
            upc = this.borrowConnectionAndValidateHelper(criNoLabels, requestedLabels);
        }
        return upc;
    }

    private UniversalPooledConnection borrowConnectionAndValidateHelper(ConnectionRetrievalInfo cri, Properties requestedLabelsForRetry) throws UniversalConnectionPoolException {
        UniversalPooledConnection universalPooledConnection;
        block12: {
            UniversalPooledConnection upc = null;
            try {
                if (logger.getLevel() == Level.FINEST) {
                    ClioSupport.ilogFinest(null, null, null, null, "borrow: total=" + this.getTotalConnectionsCount() + ", borrowed=" + this.getBorrowedConnectionsCount());
                }
                boolean needToValidate = this.getValidateConnectionOnBorrow();
                boolean successfullyConfigured = true;
                do {
                    Properties requestedLabels;
                    Properties criLabels;
                    if (!needToValidate) {
                        upc = this.borrowConnectionWithoutCountingRequests(cri);
                    } else {
                        long delta;
                        int stt;
                        while (!(null == (upc = this.borrowConnectionWithoutCountingRequests(cri)) || (stt = this.getSecondsToTrustIdleConnection()) > 0 && (delta = Clock.clock() - upc.getLastNetworkAccessTime()) < (long)stt * 1000L || upc.isValid())) {
                            upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                            upc.setLastConnectionValidationTime(0L);
                            this.returnConnection(upc);
                            upc = null;
                        }
                    }
                    if (null == upc) {
                        UCPErrorHandler.throwUniversalConnectionPoolException(56);
                    }
                    boolean isLabeledRequest = (criLabels = cri.getLabels()) != null || requestedLabelsForRetry != null;
                    Properties properties = requestedLabels = criLabels != null ? criLabels : requestedLabelsForRetry;
                    if (upc == null || (!isLabeledRequest || !this.needToConfigureConnection(upc, requestedLabels) && (Core.Match.UNKNOWN != this.core.match.get() || upc.labelingCost(requestedLabels) <= 0) && Core.Match.ACCEPTABLE != this.core.match.get()) && null == requestedLabelsForRetry || (successfullyConfigured = this.getConnectionLabelingCallback().configure(requestedLabels, this.getConnectionObjectForLabelingConfigure(upc)))) continue;
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    this.returnConnection(upc);
                    upc = null;
                } while (!successfullyConfigured);
                universalPooledConnection = upc;
                if (logger.getLevel() != Level.FINEST) break block12;
            }
            catch (Throwable e) {
                try {
                    ClioSupport.ilogWarning(null, null, null, null, "got unchecked exception from user-defined connection labeling callback");
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                    if (null != upc) {
                        upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                        this.returnConnection(upc);
                    }
                    upc = null;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (logger.getLevel() == Level.FINEST) {
                        ClioSupport.ilogFinest(null, null, null, null, "borrow: total=" + this.getTotalConnectionsCount() + ", borrowed=" + this.getBorrowedConnectionsCount() + ", borrowedUpc=" + upc + ", delegator=" + (null != upc ? upc.getDelegator() : "null"));
                    }
                    throw throwable;
                }
            }
            ClioSupport.ilogFinest(null, null, null, null, "borrow: total=" + this.getTotalConnectionsCount() + ", borrowed=" + this.getBorrowedConnectionsCount() + ", borrowedUpc=" + upc + ", delegator=" + (null != upc ? upc.getDelegator() : "null"));
        }
        return universalPooledConnection;
    }

    protected long computeBorrowGiveUpTimestamp() {
        return Clock.clock() + (this.isNoWaitBorrow ? 0L : (long)this.getConnectionWaitTimeout() * 1000L);
    }

    protected boolean isStillOkayToBorrow(long giveUp) {
        return Clock.clock() <= giveUp || this.core.pendingAvailableGrows() > 0;
    }

    private UniversalPooledConnection borrowConnectionWithoutCountingRequests(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        long timeToRetry;
        assert (cri != null);
        Properties reqLabels = cri.getLabels();
        if (reqLabels != null && this.getConnectionLabelingCallback() == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(92);
        }
        long begTime = Clock.clock();
        long giveUp = this.computeBorrowGiveUpTimestamp();
        int ITERATIONS_TO_YIELD = 5;
        int iteration = 0;
        while (this.isStillOkayToBorrow(giveUp)) {
            UniversalPooledConnection upc;
            boolean growForLabeledRequest;
            if (!this.isLifecycleRunning()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
            this.validatePoolSizes();
            boolean bl = growForLabeledRequest = iteration > 0 && null != reqLabels;
            if (growForLabeledRequest || this.core.uselessConnsCleanerInProgress() || 0 == this.getAvailableConnectionsCount() || !this.core.available(cri)) {
                timeToRetry = Math.max(0L, giveUp - Clock.clock());
                upc = this.helpGrowBorrowed(cri, this.getConnectionAffinityCallback(), timeToRetry);
                if (null != upc) {
                    return this.postBorrow(upc, begTime);
                }
                if (this.isNoWaitBorrow) {
                    return null;
                }
            }
            if (0 == ++iteration % 5) {
                Thread.yield();
            }
            if ((upc = this.getAvailableConnection(cri, timeToRetry = Math.max(0L, giveUp - Clock.clock()))) != null) {
                return this.postBorrow(upc, begTime);
            }
            ConnectionAffinityCallback callback = this.getConnectionAffinityCallback();
            if (null == callback || null == callback.getConnectionAffinityContext()) continue;
            callback.setConnectionAffinityContext(null);
        }
        UniversalPooledConnection upc = this.getAvailableConnection(cri, 0L);
        if (null != upc) {
            return this.postBorrow(upc, begTime);
        }
        timeToRetry = Math.max(0L, giveUp - Clock.clock());
        upc = this.helpGrowBorrowed(cri, this.getConnectionAffinityCallback(), timeToRetry);
        if (null != upc) {
            return this.postBorrow(upc, begTime);
        }
        this.updateConnectionWaitCounters(false, begTime);
        if (this.isNoWaitBorrow) {
            return null;
        }
        if (this.core.noMoreGrows()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(65);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(64, this.getStatistics().shortForm());
        }
        return null;
    }

    private UniversalPooledConnection helpGrowBorrowed(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeToRetry) throws UniversalConnectionPoolException {
        timeToRetry = Math.max(0L, timeToRetry);
        long started = Clock.clock();
        CoreConnection conn = this.core.growBorrowed(cri, callback, timeToRetry);
        this.insertToCreatedHistogram(cri, Clock.clock() - started);
        return null == conn ? null : (UniversalPooledConnection)conn.getDelegate();
    }

    private UniversalPooledConnection postBorrow(UniversalPooledConnection upc, long begTime) {
        if (null == upc) {
            throw new IllegalArgumentException("no upc");
        }
        upc.setBorrowedStartTime();
        upc.heartbeat();
        this.updateConnectionWaitCounters(true, begTime);
        return upc;
    }

    protected UniversalPooledConnection createOnePooledConnection() {
        UniversalPooledConnection upc = null;
        try {
            ConnectionRetrievalInfo cri = this.getConnectionRetrievalInfo();
            if (null == cri) {
                UCPErrorHandler.throwUniversalConnectionPoolException(4);
            }
            upc = this.createOnePooledConnection(cri);
        }
        catch (UniversalConnectionPoolException exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
            upc = null;
        }
        ClioSupport.ilogFinest(null, null, null, null, "upc=" + upc);
        return upc;
    }

    private void updateConnectionWaitCounters(boolean success, long begTime) {
        long waitTime = Clock.clock() - begTime;
        (success ? this.m_cumulativeSuccessfulConnectionWaitCount : this.m_cumulativeFailedConnectionWaitCount).incrementAndGet();
        (success ? this.m_cumulativeSuccessfulConnectionWaitTime : this.m_cumulativeFailedConnectionWaitTime).addAndGet(waitTime);
        this.m_peakConnectionWaitTime.update(waitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        assert (cri != null);
        this.checkLifecycle();
        Object connection = null;
        UniversalPooledConnection pooledConnection = null;
        try {
            ConnectionFactoryAdapter cfa = this.getConnectionFactoryAdapter();
            connection = cfa.createConnection(cri);
            if (null == connection) {
                UCPErrorHandler.throwUniversalConnectionPoolException(100);
            }
            pooledConnection = cfa.createPooledConnection(connection, cri.getCopyWithNoLabels());
            this.incrementConnectionsCreatedCount();
            this.m_cumulativeConnectionsCreated.incrementAndGet();
        }
        finally {
            if (null != connection && null == pooledConnection) {
                this.closePhysicalConnection(connection);
            }
        }
        return pooledConnection;
    }

    @Override
    public void returnConnection(UniversalPooledConnection upc) throws UniversalConnectionPoolException {
        block8: {
            block9: {
                try {
                    if (logger.getLevel() == Level.FINEST) {
                        ClioSupport.ilogFinest(null, null, null, null, "return: upc=" + upc);
                    }
                    if (null == upc) {
                        UCPErrorHandler.throwUniversalConnectionPoolException(150);
                    }
                    if (this.m_lifeCycleState.get() != UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING) {
                        UCPErrorHandler.throwUniversalConnectionPoolException(60);
                    }
                    if (!upc.isAvailable()) break block8;
                    if (logger.getLevel() != Level.FINEST) break block9;
                    ClioSupport.ilogFinest(null, null, null, null, "returned: upc=" + upc + ", delegator=" + (null != upc ? upc.getDelegator() : "null"));
                }
                catch (Throwable throwable) {
                    if (logger.getLevel() == Level.FINEST) {
                        ClioSupport.ilogFinest(null, null, null, null, "returned: upc=" + upc + ", delegator=" + (null != upc ? upc.getDelegator() : "null"));
                    }
                    throw throwable;
                }
            }
            return;
        }
        this.core.reclaim(upc.getDelegator());
        if (logger.getLevel() == Level.FINEST) {
            ClioSupport.ilogFinest(null, null, null, null, "returned: upc=" + upc + ", delegator=" + (null != upc ? upc.getDelegator() : "null"));
        }
    }

    @Override
    public void closeConnection(UniversalPooledConnection pooledConnection) throws UniversalConnectionPoolException {
        this.checkLifecycle();
        if (null == pooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        this.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - pooledConnection.getBorrowedStartTime());
        if (UniversalPooledConnectionStatus.STATUS_RECONNECTING == pooledConnection.getStatus()) {
            Object removedConnection = null;
        } else {
            this.closePooledConnection(pooledConnection);
        }
        ClioSupport.ilogFinest(null, null, null, null, "pooledConnection=" + pooledConnection);
    }

    private void closePooledConnection(UniversalPooledConnection pooledConnection) {
        CoreConnection conn = pooledConnection.getDelegator();
        if (this.core.retrieve(conn)) {
            conn.close();
        }
    }

    @Override
    public void purge() throws UniversalConnectionPoolException {
        this.checkLifecycle();
        this.core.closeAll();
        ClioSupport.ilogFinest(null, null, null, null, "purge");
    }

    @Override
    public void refresh() throws UniversalConnectionPoolException {
        this.checkLifecycle();
        this.core.replaceAvailable();
        ClioSupport.ilogFinest(null, null, null, null, "regresh");
    }

    @Override
    public void recycle() throws UniversalConnectionPoolException {
        this.checkLifecycle();
        this.core.replaceInvalidAvailable();
        ClioSupport.ilogFinest(null, null, null, null, "recycle");
    }

    @Override
    void processConnectionHarvesting() {
        this.core.harvest(this.getConnectionHarvestTriggerCount(), this.getConnectionHarvestMaxCount());
    }

    protected void setConnectionHarvestable(UniversalPooledConnection pooledConnection, boolean isConnectionHarvestable) {
        try {
            pooledConnection.setConnectionHarvestable(isConnectionHarvestable);
            ClioSupport.ilogFinest(null, null, null, null, "isConnectionHarvestable=" + isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    @Override
    protected void closePhysicalConnection(Object physicalConnection) {
        super.closePhysicalConnection(physicalConnection);
    }

    @Override
    public UniversalConnectionPoolStatistics getStatistics() {
        return new UniversalConnectionPoolStatisticsImpl(this);
    }

    @Override
    protected void discardUsedConnection(Object physicalConnection) {
        UniversalPooledConnection pooledConnection = this.getUsedConnection(physicalConnection);
        if (null != pooledConnection) {
            this.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - this.getUsedConnection(physicalConnection).getBorrowedStartTime());
            this.core.retrieve(pooledConnection.getDelegator());
            this.totalConnectionsCount.decrementAndGet();
            this.borrowedConnectionsCount.decrementAndGet();
        }
    }

    @Override
    protected UniversalPooledConnection getUsedConnection(Object physicalConnection) {
        CoreConnection coreConn = this.core.findSpecificConnection(physicalConnection);
        return null == coreConn ? null : (UniversalPooledConnection)coreConn.getDelegate();
    }

    @Override
    protected boolean returnUsedPhysicalConnection(Object physicalConnection) throws UniversalConnectionPoolException {
        UniversalPooledConnection pooledConnection = this.getUsedConnection(physicalConnection);
        if (pooledConnection == null) {
            return false;
        }
        this.returnConnection(pooledConnection);
        return true;
    }

    @Override
    protected boolean closeUsedPhysicalConnection(Object physicalConnection) {
        UniversalPooledConnection pooledConnection = this.getUsedConnection(physicalConnection);
        if (pooledConnection == null) {
            return false;
        }
        this.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - pooledConnection.getBorrowedStartTime());
        CoreConnection conn = pooledConnection.getDelegator();
        if (this.core.retrieve(conn)) {
            conn.close();
        }
        return true;
    }

    private UniversalPooledConnection getAvailableConnection(ConnectionRetrievalInfo cri, long timeout) throws UniversalConnectionPoolException {
        assert (cri != null);
        CoreConnection coreConn = this.core.borrow(cri, this.getConnectionAffinityCallback(), timeout);
        return null == coreConn ? null : (UniversalPooledConnection)coreConn.getDelegate();
    }

    protected Object getConnectionObjectForLabelingConfigure(UniversalPooledConnection upc) {
        return upc.getPhysicalConnection();
    }

    protected void incrementCumulativeConnectionsCreated() {
        this.m_cumulativeConnectionsCreated.incrementAndGet();
    }

    private void checkLifecycle() throws UniversalConnectionPoolException {
        if (this.isLifecycleFailed() || this.isLifecycleStopped()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
    }

    protected boolean needToConfigureConnection(UniversalPooledConnection pc, Properties requestedLabels) throws UniversalConnectionPoolException {
        return false;
    }

    static {
        try {
            $$$methodRef$$$30 = UniversalConnectionPoolImpl.class.getDeclaredConstructor(ConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = UniversalConnectionPoolImpl.class.getDeclaredMethod("needToConfigureConnection", UniversalPooledConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = UniversalConnectionPoolImpl.class.getDeclaredMethod("checkLifecycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = UniversalConnectionPoolImpl.class.getDeclaredMethod("incrementCumulativeConnectionsCreated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getConnectionObjectForLabelingConfigure", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getAvailableConnection", ConnectionRetrievalInfo.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closeUsedPhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = UniversalConnectionPoolImpl.class.getDeclaredMethod("returnUsedPhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getUsedConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = UniversalConnectionPoolImpl.class.getDeclaredMethod("discardUsedConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closePhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = UniversalConnectionPoolImpl.class.getDeclaredMethod("setConnectionHarvestable", UniversalPooledConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = UniversalConnectionPoolImpl.class.getDeclaredMethod("processConnectionHarvesting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = UniversalConnectionPoolImpl.class.getDeclaredMethod("recycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = UniversalConnectionPoolImpl.class.getDeclaredMethod("refresh", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = UniversalConnectionPoolImpl.class.getDeclaredMethod("purge", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closePooledConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closeConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = UniversalConnectionPoolImpl.class.getDeclaredMethod("returnConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = UniversalConnectionPoolImpl.class.getDeclaredMethod("createOnePooledConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = UniversalConnectionPoolImpl.class.getDeclaredMethod("updateConnectionWaitCounters", Boolean.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = UniversalConnectionPoolImpl.class.getDeclaredMethod("createOnePooledConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = UniversalConnectionPoolImpl.class.getDeclaredMethod("postBorrow", UniversalPooledConnection.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = UniversalConnectionPoolImpl.class.getDeclaredMethod("helpGrowBorrowed", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnectionWithoutCountingRequests", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = UniversalConnectionPoolImpl.class.getDeclaredMethod("isStillOkayToBorrow", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = UniversalConnectionPoolImpl.class.getDeclaredMethod("computeBorrowGiveUpTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnectionAndValidateHelper", ConnectionRetrievalInfo.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnectionAndValidate", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        logger = Logger.getLogger(loggerName);
    }
}

