/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.other.StatementProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={Connection.class, XAConnection.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ConnectionProxy
implements LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection,
XAConnection,
LogicalObject {
    protected final long creationTS = Clock.clock();
    final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicBoolean actuallyReturned = new AtomicBoolean(false);
    protected Chain<StatementProxy> statementsToClose = new MapChain<StatementProxy>();
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;

    UniversalPooledConnection getUPC() {
        Object c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = this.getCreator())) {
            this.proxiedPooledConnection = c instanceof Creator ? ((Creator)c).getUPC() : ((ConnectionProxy)c).getUPC();
            upc = this.proxiedPooledConnection;
        }
        return upc;
    }

    UniversalConnectionPool getUCP() {
        Object c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = this.getCreator())) {
            this.proxiedPool = c instanceof Creator ? ((Creator)c).getUCP() : ((ConnectionProxy)c).getUCP();
            ucp = this.proxiedPool;
        }
        return ucp;
    }

    @GetDelegate
    protected abstract Connection getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    @Pre
    @Methods(signatures={@Signature(name="addConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="addStatementEventListener", args={StatementEventListener.class}), @Signature(name="removeConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="removeStatementEventListener", args={StatementEventListener.class}), @Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setClientInfo", args={Properties.class})})
    protected void preNoThrow(Method m, Object receiver, Object ... args) {
        try {
            this.pre(m, receiver, args);
        }
        catch (SQLException e) {
            throw new ProxyException(e);
        }
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (this.closed.get()) {
            String msg = UCPErrorHandler.findSQLMessage(31, null);
            throw new SQLRecoverableException(msg, null, 31);
        }
    }

    private void setDefaultQueryTimeout(Statement statement) {
        int queryTimeout = ((UniversalConnectionPoolBase)this.getUCP()).getQueryTimeout();
        if (queryTimeout > 0) {
            try {
                statement.setQueryTimeout(queryTimeout);
            }
            catch (SQLException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="createStatement", args={}), @Signature(name="createStatement", args={int.class, int.class}), @Signature(name="createStatement", args={int.class, int.class, int.class})})
    protected Statement post(Method m, Statement result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveStatementProxy(result);
        this.setDefaultQueryTimeout(result);
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, Properties.class})})
    protected CallableStatement post(Method m, CallableStatement result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveStatementProxy(result);
        this.setDefaultQueryTimeout(result);
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class})})
    protected PreparedStatement post(Method m, PreparedStatement result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveStatementProxy(result);
        this.setDefaultQueryTimeout(result);
        return result;
    }

    @Post
    protected Object postRest(Method m, Object result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveStatementProxy(result);
        return result;
    }

    @OnError(value=SQLException.class)
    protected void onSQLExceptionErrorVoid(Method m, SQLException e) throws SQLException {
        this.onSQLExceptionError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onSQLExceptionError(Method m, SQLException e) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.handleSQLRecoverableException(e);
        throw e;
    }

    @OnError(value=RuntimeException.class)
    protected void onRuntimeExceptionErrorVoid(Method m, RuntimeException e) throws RuntimeException {
        this.onRuntimeExceptionError(m, e);
    }

    @OnError(value=RuntimeException.class)
    protected Object onRuntimeExceptionError(Method m, RuntimeException e) throws RuntimeException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.handleRuntimeException(e);
        throw e;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    private void handleExceptionHelper() {
        if (!this.actuallyReturned.get()) {
            try {
                try {
                    for (StatementProxy stmt : this.statementsToClose.toList()) {
                        stmt.close();
                    }
                }
                catch (Throwable t) {
                    ClioSupport.ilogThrowing(null, null, null, null, t);
                }
                this.statementsToClose.clear();
                UniversalPooledConnection upc = this.getUPC();
                assert (null != upc) : "upc shold be defined at this point";
                UniversalConnectionPool ucp = this.getUCP();
                assert (null != upc) : "ucp shold be defined at this point";
                try {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                }
                catch (Throwable t) {
                    ClioSupport.ilogThrowing(null, null, null, null, t);
                }
                ucp.returnConnection(upc);
                this.actuallyReturned.set(true);
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException ucpe) {
                ClioSupport.ilogThrowing(null, null, null, null, ucpe);
            }
        }
    }

    protected void handleSQLRecoverableException(SQLException e) throws SQLException {
        if (e instanceof SQLRecoverableException) {
            this.handleExceptionHelper();
        }
    }

    protected void handleRuntimeException(RuntimeException e) throws RuntimeException {
        this.handleExceptionHelper();
    }

    @Override
    public void close() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        UniversalConnectionPool ucp = this.getUCP();
        assert (null != upc) : "ucp shold be defined at this point";
        upc.heartbeat();
        if (this.closed.get()) {
            return;
        }
        try {
            try {
                for (StatementProxy stmt : this.statementsToClose.toList()) {
                    stmt.close();
                }
            }
            catch (Throwable t) {
                ClioSupport.ilogThrowing(null, null, null, null, t);
            }
            this.statementsToClose.clear();
            this.closed.set(true);
            ucp.returnConnection(upc);
            this.actuallyReturned.set(true);
            upc.heartbeat();
        }
        catch (UniversalConnectionPoolException e) {
            Throwable cause = e.getCause();
            if (null == cause) {
                throw new SQLException(e);
            }
            Throwable cause2 = cause.getCause();
            if (null == cause2 || !(cause2 instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw (SQLException)cause2;
        }
    }

    public boolean isValid(int timeout) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getDelegate().isValid(timeout);
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc.isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        try {
            upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException e) {
            throw new SQLException(e);
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        return this.getDelegate().isClosed();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Override
    public void applyConnectionLabel(String key, String value) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.applyConnectionLabel(key, value);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(32, ucpExc);
        }
    }

    @Override
    public void removeConnectionLabel(String key) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeConnectionLabel(key);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(33, ucpExc);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            props = upc.getConnectionLabels();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(34, ucpExc);
        }
        return props;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            props = upc.getUnmatchedConnectionLabels(requestedLabels);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(35, ucpExc);
        }
        return props;
    }

    @Override
    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.setConnectionHarvestable(isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(36, ucpExc);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc.isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerConnectionHarvestingCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(37, ucpExc);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(38, ucpExc);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerAbandonedConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(39, ucpExc);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(40, ucpExc);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerTimeToLiveConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(41, ucpExc);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(42, ucpExc);
        }
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ConnectionProxy ? ((ConnectionProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    protected void saveStatementProxy(Object result) {
        if (result instanceof StatementProxy) {
            StatementProxy statementProxy = (StatementProxy)result;
            statementProxy.setStatementChainAtom(this.statementsToClose.add(statementProxy));
        }
    }

    static {
        try {
            $$$methodRef$$$38 = ConnectionProxy.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = ConnectionProxy.class.getDeclaredMethod("saveStatementProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = ConnectionProxy.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = ConnectionProxy.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = ConnectionProxy.class.getDeclaredMethod("removeTimeToLiveConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = ConnectionProxy.class.getDeclaredMethod("registerTimeToLiveConnectionTimeoutCallback", TimeToLiveConnectionTimeoutCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = ConnectionProxy.class.getDeclaredMethod("removeAbandonedConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = ConnectionProxy.class.getDeclaredMethod("registerAbandonedConnectionTimeoutCallback", AbandonedConnectionTimeoutCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = ConnectionProxy.class.getDeclaredMethod("removeConnectionHarvestingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = ConnectionProxy.class.getDeclaredMethod("registerConnectionHarvestingCallback", ConnectionHarvestingCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = ConnectionProxy.class.getDeclaredMethod("isConnectionHarvestable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = ConnectionProxy.class.getDeclaredMethod("setConnectionHarvestable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = ConnectionProxy.class.getDeclaredMethod("getUnmatchedConnectionLabels", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = ConnectionProxy.class.getDeclaredMethod("getConnectionLabels", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = ConnectionProxy.class.getDeclaredMethod("removeConnectionLabel", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = ConnectionProxy.class.getDeclaredMethod("applyConnectionLabel", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = ConnectionProxy.class.getDeclaredMethod("isLogicallyClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = ConnectionProxy.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = ConnectionProxy.class.getDeclaredMethod("setInvalid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = ConnectionProxy.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = ConnectionProxy.class.getDeclaredMethod("isValid", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = ConnectionProxy.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = ConnectionProxy.class.getDeclaredMethod("handleRuntimeException", RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = ConnectionProxy.class.getDeclaredMethod("handleSQLRecoverableException", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = ConnectionProxy.class.getDeclaredMethod("handleExceptionHelper", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = ConnectionProxy.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = ConnectionProxy.class.getDeclaredMethod("onRuntimeExceptionError", Method.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = ConnectionProxy.class.getDeclaredMethod("onRuntimeExceptionErrorVoid", Method.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = ConnectionProxy.class.getDeclaredMethod("onSQLExceptionError", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = ConnectionProxy.class.getDeclaredMethod("onSQLExceptionErrorVoid", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ConnectionProxy.class.getDeclaredMethod("postRest", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ConnectionProxy.class.getDeclaredMethod("post", Method.class, PreparedStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ConnectionProxy.class.getDeclaredMethod("post", Method.class, CallableStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ConnectionProxy.class.getDeclaredMethod("post", Method.class, Statement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ConnectionProxy.class.getDeclaredMethod("setDefaultQueryTimeout", Statement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ConnectionProxy.class.getDeclaredMethod("pre", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ConnectionProxy.class.getDeclaredMethod("preNoThrow", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ConnectionProxy.class.getDeclaredMethod("getUCP", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ConnectionProxy.class.getDeclaredMethod("getUPC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

