/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.jdbc.internal.OracleConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class ReplayDataSourceConnectionFactoryAdapter
extends OracleDataSourceConnectionFactoryAdapter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public ReplayDataSourceConnectionFactoryAdapter(DataSource dataSource) throws UniversalConnectionPoolException {
        super(dataSource);
    }

    @Override
    public void initializeUrlFromConnectionFactory() {
        Class<?> dsClass = this.m_dataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, dsClass.getClassLoader());
            Method m = cls.getMethod("getURL", new Class[0]);
            this.m_url = (String)m.invoke((Object)this.m_dataSource, new Object[0]);
            ClioSupport.ilogFinest(null, null, null, null, "initializeUrlFromConnectionFactory() succeeded");
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
    }

    @Override
    public void setUrl(String url) {
        Class<?> dsClass = this.m_dataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, dsClass.getClassLoader());
            Method m = cls.getMethod("setURL", String.class);
            m.invoke((Object)this.m_dataSource, url);
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        OracleDataSource ods = null;
        Connection connection = null;
        try {
            if (!(this.m_dataSource instanceof OracleDataSource)) {
                ClioSupport.ilogFinest(null, null, null, null, "about to create connection without specifying instance");
                connection = (Connection)super.createConnection(connectionRequestInfo);
            } else {
                String instanceName;
                ods = (OracleDataSource)this.m_dataSource;
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
                if (connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo) {
                    instanceName = ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName();
                    ClioSupport.ilogFinest(null, null, null, null, "about to create connection to the instance " + instanceName);
                } else {
                    instanceName = null;
                }
                OracleConnectionBuilderImpl builder = ods.createConnectionBuilder();
                connection = ((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)builder.user(jdbcCri.getUser())).password(jdbcCri.getPassword().toJDBCOpaqueString())).instanceName(instanceName)).serviceName(jdbcCri.getServiceName())).shardingKey(jdbcCri.getShardingKey())).superShardingKey(jdbcCri.getSuperShardingKey())).build();
                if (connection instanceof OracleConnection) {
                    Properties proxyProps;
                    String in = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
                    assert (null != in);
                    assert (instanceName == null || Util.equalsNormalized(in, instanceName)) : "internal error: got connection from the wrong instance";
                    if (instanceName != null && !"".equals(instanceName) && !Util.equalsNormalized(in, instanceName)) {
                        ClioSupport.ilogFinest(null, null, null, null, "wrong conn opened, desired:" + instanceName + ", actual:" + in);
                    }
                    if ((proxyProps = jdbcCri.getProxyProperties()) != null) {
                        int proxyType = jdbcCri.getProxyType();
                        ClioSupport.ilogFinest(null, null, null, null, " Opening proxy session with Properties = " + proxyProps);
                        ((OracleConnection)connection).openProxySession(proxyType, proxyProps);
                    }
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "not an oracle connection");
                }
            }
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
        }
        return connection;
    }

    static {
        try {
            $$$methodRef$$$3 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(DataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("setUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("initializeUrlFromConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

