/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.ShardConnectionStatistics;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AbandonedConnectionTimerTask;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionHarvestingTimerTask;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.Core;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CounterImpl;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.Failoverable;
import oracle.ucp.common.Limits;
import oracle.ucp.common.PeakIntegerCounter;
import oracle.ucp.common.PeakLongCounter;
import oracle.ucp.common.TimeToLiveConnectionTimerTask;
import oracle.ucp.common.Topology;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.tuners.ConnectionGrower;
import oracle.ucp.tuners.ConnectionReducer;
import oracle.ucp.tuners.PoolSizeTuner;
import oracle.ucp.tuners.Tunable;
import oracle.ucp.tuners.stats.CounterMap;
import oracle.ucp.tuners.stats.HistogramRingRegistry;
import oracle.ucp.tuners.stats.RingRegistry;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.UniqueIdentifier;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public abstract class UniversalConnectionPoolBase
implements UniversalConnectionPool,
Failoverable {
    static final int DEFAULT_INITIAL_POOL_SIZE = 0;
    static final int DEFAULT_MIN_POOL_SIZE = 0;
    static final int DEFAULT_MAX_POOL_SIZE = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_SERVICE = Integer.MAX_VALUE;
    static final int DEFAULT_INACTIVE_CONNECTION_TIMEOUT = 0;
    private static final int DEFAULT_TIMEOUT_CHECK_INTERVAL = 30;
    static final int DEFAULT_ABANDONED_CONNECTION_TIMEOUT = 0;
    static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 3;
    static final int DEFAULT_TIME_TO_LIVE_CONNECTION_TIMEOUT = 0;
    private static final boolean DEFAULT_VALIDATE_BORROWED_CONNECTION = false;
    private static final int DEFAULT_SECONDS_TO_TRUST_IDLE_CONNECTION = 0;
    private static final int DEFAULT_CONNECTION_HARVEST_TRIGGER_COUNT = Integer.MAX_VALUE;
    private static final int DEFAULT_CONNECTION_HARVEST_MAX_COUNT = 1;
    private static final int DEFAULT_QUERY_TIMEOUT = 0;
    private static final int DEFAULT_QUERY_TIMEOUT_IF_ABANDONEMENT_RUNS = 60;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_SHARD = Integer.MAX_VALUE;
    public static final int DEFAULT_CONNECTION_VALIDATION_TIMEOUT = 15;
    private static final String DEFAULT_POOLNAME_PREFIX;
    protected AtomicReference<UniversalConnectionPoolLifeCycleState> m_lifeCycleState = new AtomicReference<UniversalConnectionPoolLifeCycleState>(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED);
    private AtomicInteger m_initialPoolSize = new AtomicInteger(0);
    private AtomicInteger m_minPoolSize = new AtomicInteger(0);
    private final AtomicInteger m_maxPoolSize = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger maxConnectionsPerService = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger m_inactiveConnectionTimeout = new AtomicInteger(0);
    private final AtomicInteger m_timeoutCheckInterval = new AtomicInteger(30);
    private final AtomicInteger m_abandonedConnectionTimeout = new AtomicInteger(0);
    private final AtomicInteger m_connectionWaitTimeout = new AtomicInteger(3);
    final AtomicInteger m_numConnectionsCreated = new AtomicInteger(0);
    private final AtomicInteger m_numConnectionsClosed = new AtomicInteger(0);
    private final AtomicInteger m_timeToLiveConnectionTimeout = new AtomicInteger(0);
    private final AtomicBoolean m_validateConnectionOnBorrow = new AtomicBoolean(false);
    private final AtomicInteger m_connectionHarvestTriggerCount = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicLong m_maxConnectionReuseTime = new AtomicLong(0L);
    private final AtomicInteger m_maxConnectionReuseCount = new AtomicInteger(0);
    private final AtomicInteger m_connectionHarvestMaxCount = new AtomicInteger(1);
    private final AtomicInteger connectionValidationTimeout = new AtomicInteger(15);
    private final AtomicBoolean readOnlyInstanceAllowed = new AtomicBoolean(false);
    private final ConnectionFactoryAdapter m_connectionFactoryAdapter;
    private volatile ConnectionRetrievalInfo defaultConnectionRetrievalInfo = null;
    private final AtomicReference<ConnectionLabelingCallback> m_connectionLabelingCallback = new AtomicReference<Object>(null);
    private volatile ConnectionAffinityCallback connectionAffinityCallback = null;
    private final AtomicReference<TimerHandle> m_abandonedConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_inactiveConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_timeToLiveConnectionTimer = new AtomicReference<Object>(null);
    private final AtomicReference<TimerHandle> m_connectionHarvestTimer = new AtomicReference<Object>(null);
    private final AtomicBoolean m_failoverEnabled = new AtomicBoolean(false);
    private final AtomicBoolean failoverExplicitlySet = new AtomicBoolean(false);
    private AtomicReference<String> m_poolName = new AtomicReference<String>(new UniqueIdentifier(DEFAULT_POOLNAME_PREFIX).toString());
    private final AtomicInteger m_abandonedConnectionsCount = new AtomicInteger(0);
    protected volatile long cumulativeReturnedConnectionsCount = 0L;
    protected volatile long cumulativeBorrowedConnectionsCount = 0L;
    final AtomicLong m_cumulativeSuccessfulConnectionWaitCount = new AtomicLong(0L);
    final AtomicLong m_cumulativeFailedConnectionWaitCount = new AtomicLong(0L);
    final PeakIntegerCounter m_peakBorrowedConnectionsCount = new PeakIntegerCounter();
    AtomicInteger m_cumulativeConnectionsCreated = new AtomicInteger();
    final AtomicLong m_cumulativeSuccessfulConnectionWaitTime = new AtomicLong(0L);
    final AtomicLong m_cumulativeFailedConnectionWaitTime = new AtomicLong(0L);
    PeakLongCounter m_peakConnectionWaitTime = new PeakLongCounter();
    final AtomicInteger m_pendingRequestsCount = new AtomicInteger(0);
    final AtomicLong m_cumulativeConnectionUseTime = new AtomicLong(0L);
    final AtomicLong borrowedAccumulator = new AtomicLong(0L);
    final AtomicLong borrowedSamples = new AtomicLong(0L);
    private AtomicReference<TimerHandle> m_replaceNonReusableConnectionsTimer = new AtomicReference<Object>(null);
    private static final AtomicInteger m_poolsRunning;
    private AtomicInteger connectionLabelingHighCost = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger highCostConnectionReuseThreshold = new AtomicInteger(0);
    private final AtomicInteger m_secondsToTrustIdleConnection = new AtomicInteger(0);
    private final AtomicInteger connectionRepurposeThreshold = new AtomicInteger(0);
    private final AtomicInteger maxConnectionsPerShard = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicBoolean shareable = new AtomicBoolean(false);
    private final AtomicBoolean shardingMode = new AtomicBoolean(true);
    private Limits limits = new Limits(){
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        @Override
        public int getMin() {
            return UniversalConnectionPoolBase.this.m_minPoolSize.get();
        }

        @Override
        public int getInitial() {
            return UniversalConnectionPoolBase.this.m_initialPoolSize.get();
        }

        @Override
        public int getMax() {
            return UniversalConnectionPoolBase.this.m_maxPoolSize.get();
        }

        @Override
        public int getRepurposeThreshold() {
            return UniversalConnectionPoolBase.this.connectionRepurposeThreshold.get();
        }

        @Override
        public int getMaxPerService() {
            return UniversalConnectionPoolBase.this.maxConnectionsPerService.get();
        }

        @Override
        public int getMaxPerShard() {
            return UniversalConnectionPoolBase.this.maxConnectionsPerShard.get();
        }

        static {
            try {
                $$$methodRef$$$6 = 1.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = 1.class.getDeclaredMethod("getMaxPerShard", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = 1.class.getDeclaredMethod("getMaxPerService", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = 1.class.getDeclaredMethod("getRepurposeThreshold", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = 1.class.getDeclaredMethod("getMax", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 1.class.getDeclaredMethod("getInitial", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredMethod("getMin", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    };
    final Counter totalConnectionsCount = new CounterImpl(){
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        @Override
        public int getAndIncrement() {
            int count = super.getAndIncrement();
            if (count > UniversalConnectionPoolBase.this.limits.getMax()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            return count;
        }

        @Override
        public int decrementAndGet() {
            int count = super.decrementAndGet();
            if (count < UniversalConnectionPoolBase.this.limits.getMin()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            return count;
        }

        @Override
        public int getAndDecrement() {
            int count = super.getAndDecrement();
            if (count < UniversalConnectionPoolBase.this.limits.getMin()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            return count;
        }

        @Override
        public int incrementAndGet() {
            int count = super.incrementAndGet();
            if (count > UniversalConnectionPoolBase.this.limits.getMax()) {
                UniversalConnectionPoolBase.this.core.kickAdjuster();
            }
            return count;
        }

        static {
            try {
                $$$methodRef$$$4 = 2.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = 2.class.getDeclaredMethod("incrementAndGet", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = 2.class.getDeclaredMethod("getAndDecrement", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 2.class.getDeclaredMethod("decrementAndGet", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 2.class.getDeclaredMethod("getAndIncrement", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    };
    final Counter borrowedConnectionsCount = new CounterImpl();
    final Counter labeledConnectionsCount = new CounterImpl();
    private String onsConfig;
    protected final Core core;
    private volatile int queryTimeout = 0;
    private AtomicInteger loginTimeout = new AtomicInteger();
    private PrintWriter logWriter = null;
    public static final long HISTOGRAM_TIME_SPAN = 60000L;
    public static final long HISTOGRAM_STEP = 5L;
    public static final int FRAMES = 5;
    private HistogramRingRegistry availableRegistry = new HistogramRingRegistry(5, 0L, 60000L, 5L);
    private HistogramRingRegistry borrowedRegistry = new HistogramRingRegistry(5, 0L, 60000L, 5L);
    private HistogramRingRegistry createdRegistry = new HistogramRingRegistry(5, 0L, 60000L, 5L);
    private CounterMap neverUsedConnectionsCounter = new CounterMap();
    private final Tunable poolSizeTunable = new Tunable(){
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        @Override
        public RingRegistry getAvailableRegistry() {
            return UniversalConnectionPoolBase.this.availableRegistry.merge(UniversalConnectionPoolBase.this.composeCurrentAvailableHistogramRingRegistry());
        }

        @Override
        public RingRegistry getBorrowedRegistry() {
            return UniversalConnectionPoolBase.this.borrowedRegistry.merge(UniversalConnectionPoolBase.this.composeCurrentBorrowedHistogramRingRegistry());
        }

        @Override
        public RingRegistry getCreatedRegistry() {
            return UniversalConnectionPoolBase.this.createdRegistry;
        }

        @Override
        public CounterMap getNeverUsedConnectionsCounter() {
            return UniversalConnectionPoolBase.this.neverUsedConnectionsCounter;
        }

        @Override
        public boolean availableGrowsInProgress() {
            return 0 != UniversalConnectionPoolBase.this.core.pendingAvailableGrows();
        }

        @Override
        public int getTotalConnectionsCount(ConnectionRetrievalInfo cri) {
            return UniversalConnectionPoolBase.this.core.connectionSource().totalCount(cri).get();
        }

        @Override
        public ConnectionGrower getConnectionGrower() {
            return cri -> UniversalConnectionPoolBase.this.core.growAvailableAsynch(cri);
        }

        @Override
        public ConnectionReducer getConnectionReducer() {
            return cri -> UniversalConnectionPoolBase.this.core.reduce(cri);
        }

        static {
            try {
                $$$methodRef$$$10 = 8.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = 8.class.getDeclaredMethod("lambda$getConnectionGrower$0", ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = 8.class.getDeclaredMethod("lambda$getConnectionReducer$1", ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = 8.class.getDeclaredMethod("getConnectionReducer", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = 8.class.getDeclaredMethod("getConnectionGrower", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = 8.class.getDeclaredMethod("getTotalConnectionsCount", ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = 8.class.getDeclaredMethod("availableGrowsInProgress", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = 8.class.getDeclaredMethod("getNeverUsedConnectionsCounter", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = 8.class.getDeclaredMethod("getCreatedRegistry", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 8.class.getDeclaredMethod("getBorrowedRegistry", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 8.class.getDeclaredMethod("getAvailableRegistry", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    };
    private final AtomicBoolean isOraclePool;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;
    private static Executable $$$methodRef$$$123;
    private static Logger $$$loggerRef$$$123;
    private static Executable $$$methodRef$$$124;
    private static Logger $$$loggerRef$$$124;
    private static Executable $$$methodRef$$$125;
    private static Logger $$$loggerRef$$$125;
    private static Executable $$$methodRef$$$126;
    private static Logger $$$loggerRef$$$126;
    private static Executable $$$methodRef$$$127;
    private static Logger $$$loggerRef$$$127;
    private static Executable $$$methodRef$$$128;
    private static Logger $$$loggerRef$$$128;
    private static Executable $$$methodRef$$$129;
    private static Logger $$$loggerRef$$$129;
    private static Executable $$$methodRef$$$130;
    private static Logger $$$loggerRef$$$130;
    private static Executable $$$methodRef$$$131;
    private static Logger $$$loggerRef$$$131;
    private static Executable $$$methodRef$$$132;
    private static Logger $$$loggerRef$$$132;
    private static Executable $$$methodRef$$$133;
    private static Logger $$$loggerRef$$$133;
    private static Executable $$$methodRef$$$134;
    private static Logger $$$loggerRef$$$134;
    private static Executable $$$methodRef$$$135;
    private static Logger $$$loggerRef$$$135;
    private static Executable $$$methodRef$$$136;
    private static Logger $$$loggerRef$$$136;
    private static Executable $$$methodRef$$$137;
    private static Logger $$$loggerRef$$$137;
    private static Executable $$$methodRef$$$138;
    private static Logger $$$loggerRef$$$138;
    private static Executable $$$methodRef$$$139;
    private static Logger $$$loggerRef$$$139;
    private static Executable $$$methodRef$$$140;
    private static Logger $$$loggerRef$$$140;
    private static Executable $$$methodRef$$$141;
    private static Logger $$$loggerRef$$$141;
    private static Executable $$$methodRef$$$142;
    private static Logger $$$loggerRef$$$142;
    private static Executable $$$methodRef$$$143;
    private static Logger $$$loggerRef$$$143;
    private static Executable $$$methodRef$$$144;
    private static Logger $$$loggerRef$$$144;
    private static Executable $$$methodRef$$$145;
    private static Logger $$$loggerRef$$$145;
    private static Executable $$$methodRef$$$146;
    private static Logger $$$loggerRef$$$146;

    public String toStringProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("[minPoolSize=").append(this.limits.getMin());
        sb.append(", maxPoolSize=").append(this.limits.getMax());
        sb.append(", initPoolSize=").append(this.limits.getInitial());
        sb.append(", repurposeThreshold=").append(this.limits.getRepurposeThreshold());
        sb.append(", maxPerService=").append(this.limits.getMaxPerService());
        sb.append(", maxPerShard=").append(this.limits.getMaxPerShard());
        sb.append(", maxPerShard=").append(this.limits.getMaxPerShard());
        sb.append(", inactiveConnectionsTimeout=").append(this.m_inactiveConnectionTimeout.get());
        sb.append(", timeoutCheckInterval=").append(this.m_timeoutCheckInterval.get());
        sb.append(", abandonedConnectionTimeout=").append(this.m_abandonedConnectionTimeout.get());
        sb.append(", connectionWaitTimeout=").append(this.m_connectionWaitTimeout.get());
        sb.append(", timeToLiveConnectionTimeout=").append(this.m_timeToLiveConnectionTimeout.get());
        sb.append(", validateConnectionOnBorrow=").append(this.m_validateConnectionOnBorrow.get());
        sb.append(", connectionHarvestTriggerCount=").append(this.m_connectionHarvestTriggerCount.get());
        sb.append(", maxConnectionReuseTime=").append(this.m_maxConnectionReuseTime.get());
        sb.append(", maxConnectionReuseCount=").append(this.m_maxConnectionReuseCount.get());
        sb.append(", connectionHarvestMaxCount=").append(this.m_connectionHarvestMaxCount.get());
        sb.append(", connectionValidationTimeout=").append(this.connectionValidationTimeout.get());
        sb.append(", failoverEnabled=").append(this.m_failoverEnabled.get());
        sb.append(", failoverExplicitlySet=").append(this.failoverExplicitlySet.get());
        sb.append(", connectionLabelingHighCost=").append(this.connectionLabelingHighCost.get());
        sb.append(", secondsToTrustIdleConnection=").append(this.m_secondsToTrustIdleConnection.get());
        sb.append(", connectionRepurposeThreshold=").append(this.connectionRepurposeThreshold.get());
        sb.append(", shareable=").append(this.shareable.get());
        sb.append(", shardingMode=").append(this.shardingMode.get());
        sb.append(", readOnlyInstanceAllowed=").append(this.readOnlyInstanceAllowed.get()).append("]");
        return sb.toString();
    }

    UniversalConnectionPoolBase(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        PoolSizeTuner.plug(this.poolSizeTunable);
        this.isOraclePool = new AtomicBoolean(true);
        if (connectionFactoryAdapter == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(104);
        }
        this.m_connectionFactoryAdapter = connectionFactoryAdapter;
        this.m_connectionFactoryAdapter.setUniversalConnectionPool(this);
        this.core = new Core();
        this.core.plugConnectionSource(new Topology(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            private static Executable $$$methodRef$$$11;
            private static Logger $$$loggerRef$$$11;
            private static Executable $$$methodRef$$$12;
            private static Logger $$$loggerRef$$$12;

            @Override
            protected ConnectionFactoryAdapter getConnectionFactoryAdapter() {
                return UniversalConnectionPoolBase.this.m_connectionFactoryAdapter;
            }

            @Override
            public boolean failoverEnabled() {
                return UniversalConnectionPoolBase.this.isFailoverExplicitlySet() ? UniversalConnectionPoolBase.this.isFailoverEnabled() : this.isFANHeuristicallyEnabled();
            }

            @Override
            protected String getONSConfig() {
                return UniversalConnectionPoolBase.this.getONSConfiguration();
            }

            @Override
            protected AtomicInteger connectionsCreated() {
                return UniversalConnectionPoolBase.this.m_numConnectionsCreated;
            }

            @Override
            protected AtomicInteger connectionsClosed() {
                return UniversalConnectionPoolBase.this.m_numConnectionsClosed;
            }

            @Override
            protected AtomicLong cumulativeConnectionUseTime() {
                return UniversalConnectionPoolBase.this.m_cumulativeConnectionUseTime;
            }

            @Override
            public Counter totalCount() {
                return UniversalConnectionPoolBase.this.totalConnectionsCount;
            }

            @Override
            public Counter borrowedCount() {
                return UniversalConnectionPoolBase.this.borrowedConnectionsCount;
            }

            @Override
            public Limits limits() {
                return UniversalConnectionPoolBase.this.limits;
            }

            @Override
            protected boolean shardingMode() {
                return UniversalConnectionPoolBase.this.shardingMode.get();
            }

            @Override
            public boolean isShareable() {
                return UniversalConnectionPoolBase.this.shareable.get();
            }

            @Override
            public boolean isReadOnlyInstanceAllowed() {
                return UniversalConnectionPoolBase.this.readOnlyInstanceAllowed.get();
            }

            static {
                try {
                    $$$methodRef$$$12 = 3.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$11 = 3.class.getDeclaredMethod("isReadOnlyInstanceAllowed", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$10 = 3.class.getDeclaredMethod("isShareable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 3.class.getDeclaredMethod("shardingMode", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 3.class.getDeclaredMethod("limits", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 3.class.getDeclaredMethod("borrowedCount", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 3.class.getDeclaredMethod("totalCount", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 3.class.getDeclaredMethod("cumulativeConnectionUseTime", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 3.class.getDeclaredMethod("connectionsClosed", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 3.class.getDeclaredMethod("connectionsCreated", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredMethod("getONSConfig", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("failoverEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("getConnectionFactoryAdapter", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
        this.core.plugLimits(this.limits);
    }

    public String getONSConfiguration() {
        return this.onsConfig;
    }

    public void setONSConfiguration(String onsConfig) {
        if (null == onsConfig) {
            onsConfig = "";
        }
        this.onsConfig = onsConfig;
    }

    @Override
    public abstract UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    protected abstract UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void returnConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void closeConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void purge() throws UniversalConnectionPoolException;

    @Override
    public abstract void refresh() throws UniversalConnectionPoolException;

    @Override
    public abstract void recycle() throws UniversalConnectionPoolException;

    @Override
    public void reconfigure(Properties props) throws UniversalConnectionPoolException {
    }

    @Override
    public void start(boolean keepMetadataConn) throws UniversalConnectionPoolException {
        if (!this.isLifecycleStopped() && !this.isLifecycleFailed()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
        this.setLifecycleStarting();
        if (1 == m_poolsRunning.incrementAndGet()) {
            UniversalConnectionPoolManagerBase.getTaskManager().start();
            UniversalConnectionPoolManagerBase.getTimerManager().start();
            Clock.start();
        }
        if (this.getConnectionRetrievalInfo() == null) {
            this.setLifecycleFailed();
            UCPErrorHandler.throwUniversalConnectionPoolException(203);
        }
        try {
            this.core.start(this.getConnectionRetrievalInfo(), keepMetadataConn);
            this.setConnectionRetrievalInfo(this.core.connectionSource().defaultCri());
            if (this.core.connectionSource().isRacDataAffinityEnabled() && this.getConnectionAffinityCallback() != null) {
                UCPErrorHandler.throwUniversalConnectionPoolException(314);
            }
            this.initAbandonedConnectionTimeoutTimer();
            this.initInactiveConnectionTimeoutTimer();
            this.initTimeToLiveConnectionTimeoutTimer();
            this.initConnectionHarvestingTimer();
            this.initReplaceNonReusableConnectionsTimer();
            this.validatePoolSizes();
            this.core.initialize();
        }
        catch (UniversalConnectionPoolException e) {
            this.setLifecycleFailed();
            ClioSupport.ilogThrowing(null, null, null, null, e);
            try {
                this.purge();
            }
            catch (Exception e1) {
                ClioSupport.ilogThrowing(null, null, null, null, e1);
            }
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            this.cancelReplaceNonReusableConnectionsTimer();
            this.core.stop();
            this.failoverExplicitlySet.set(false);
            if (1 == m_poolsRunning.getAndDecrement()) {
                Clock.stop();
                UniversalConnectionPoolManagerBase.getTaskManager().stop();
                UniversalConnectionPoolManagerBase.getTimerManager().stop();
                m_poolsRunning.set(0);
            }
            throw e;
        }
        this.setLifecycleRunning();
        ClioSupport.ilogFine(null, null, null, null, "pool started");
    }

    @Override
    public void stop() throws UniversalConnectionPoolException {
        if (this.isLifecycleStopped()) {
            return;
        }
        boolean wasRunning = this.isLifecycleRunning();
        this.setLifecycleStopping();
        try {
            this.purge();
        }
        catch (UniversalConnectionPoolException e) {
            this.setLifecycleFailed();
            ClioSupport.ilogThrowing(null, null, null, null, e);
            throw e;
        }
        finally {
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            this.cancelReplaceNonReusableConnectionsTimer();
            this.resetNonCumulativePoolStatistics();
        }
        this.core.stop();
        this.failoverExplicitlySet.set(false);
        PoolSizeTuner.unplug(this.poolSizeTunable);
        if (wasRunning && 1 == m_poolsRunning.getAndDecrement()) {
            Clock.stop();
            UniversalConnectionPoolManagerBase.getTaskManager().stop();
            UniversalConnectionPoolManagerBase.getTimerManager().stop();
            m_poolsRunning.set(0);
        }
        this.setLifecycleStopped();
        this.resetNonCumulativePoolStatistics();
        ClioSupport.ilogFine(null, null, null, null, "pool stopped");
    }

    protected void resetAllPoolStatistics() {
        this.m_numConnectionsCreated.set(0);
        this.m_numConnectionsClosed.set(0);
        this.m_abandonedConnectionsCount.set(0);
        this.m_peakBorrowedConnectionsCount.set(0);
        this.m_peakConnectionWaitTime.set(0L);
        this.m_pendingRequestsCount.set(0);
        this.cumulativeReturnedConnectionsCount = 0L;
        this.cumulativeBorrowedConnectionsCount = 0L;
        this.m_cumulativeSuccessfulConnectionWaitCount.set(0L);
        this.m_cumulativeFailedConnectionWaitCount.set(0L);
        this.m_cumulativeSuccessfulConnectionWaitTime.set(0L);
        this.m_cumulativeFailedConnectionWaitTime.set(0L);
        this.m_cumulativeConnectionUseTime.set(0L);
        this.m_cumulativeConnectionsCreated.set(0);
        this.borrowedAccumulator.set(0L);
        this.borrowedSamples.set(0L);
        ClioSupport.ilogFinest(null, null, null, null, "reset");
    }

    protected void resetNonCumulativePoolStatistics() {
        this.m_numConnectionsCreated.set(0);
        this.m_numConnectionsClosed.set(0);
        this.m_abandonedConnectionsCount.set(0);
        this.m_peakBorrowedConnectionsCount.set(0);
        this.m_peakConnectionWaitTime.set(0L);
        this.m_pendingRequestsCount.set(0);
        this.borrowedAccumulator.set(0L);
        this.borrowedSamples.set(0L);
        ClioSupport.ilogFinest(null, null, null, null, "reset");
    }

    @Override
    public String getName() {
        return this.m_poolName.get();
    }

    @Override
    public void setName(String name) {
        this.m_poolName.set(name);
        ClioSupport.ilogFinest(null, null, null, null, "name=" + name);
    }

    @Override
    public int getInitialPoolSize() {
        return this.m_initialPoolSize.get();
    }

    @Override
    public void setInitialPoolSize(int initialPoolSize) throws UniversalConnectionPoolException {
        if (initialPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_initialPoolSize.set(initialPoolSize);
        ClioSupport.ilogFinest(null, null, null, null, "initialPoolSize=" + initialPoolSize);
    }

    @Override
    public int getMinPoolSize() {
        return this.m_minPoolSize.get();
    }

    @Override
    public void setMinPoolSize(int minPoolSize) throws UniversalConnectionPoolException {
        if (minPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_minPoolSize.set(minPoolSize);
        ClioSupport.ilogFinest(null, null, null, null, "minPoolSize=" + minPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.m_maxPoolSize.get();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) throws UniversalConnectionPoolException {
        if (maxPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_maxPoolSize.set(maxPoolSize);
        this.core.adjustMaxLimit();
        ClioSupport.ilogFinest(null, null, null, null, "maxPoolSize=" + maxPoolSize);
    }

    protected void closePhysicalConnection(Object physicalConnection) {
        try {
            this.m_connectionFactoryAdapter.closeConnection(physicalConnection);
            ClioSupport.ilogFinest(null, null, null, null, "closed physicalConnection=" + physicalConnection);
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        finally {
            if (this.isLifecycleRunning()) {
                this.incrementConnectionsClosedCount();
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "pool is not running");
            }
        }
    }

    @Override
    public int getInactiveConnectionTimeout() {
        return this.m_inactiveConnectionTimeout.get();
    }

    private void initInactiveConnectionTimeoutTimer() {
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && this.m_inactiveConnectionTimeout.get() > 0 && this.m_inactiveConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new UCPTimerTaskImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        UniversalConnectionPoolBase.this.core.closeAvailableInactive(UniversalConnectionPoolBase.this.m_inactiveConnectionTimeout.get() * 1000);
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(4.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
            }

            static {
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }, 0L, timeoutCheck * 1000))) {
            ClioSupport.ilogFinest(null, null, null, null, "scheduled");
        }
    }

    private void disableInactiveConnectionTimeoutTimer() {
        TimerHandle timerToCancel = this.m_inactiveConnectionTimer.getAndSet(null);
        if (timerToCancel != null) {
            timerToCancel.cancel();
            ClioSupport.ilogFinest(null, null, null, null, "canceled");
        }
    }

    @Override
    public void setInactiveConnectionTimeout(int inactiveConnectionTimeout) throws UniversalConnectionPoolException {
        int formerValue;
        if (inactiveConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((formerValue = this.m_inactiveConnectionTimeout.getAndSet(inactiveConnectionTimeout)) != inactiveConnectionTimeout) {
            this.disableInactiveConnectionTimeoutTimer();
            if (inactiveConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initInactiveConnectionTimeoutTimer();
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "inactiveConnectionTimeout=" + inactiveConnectionTimeout);
    }

    protected TimerHandle getInactiveConnectionTimer() {
        return this.m_inactiveConnectionTimer.get();
    }

    @Override
    public int getConnectionWaitTimeout() {
        return this.m_connectionWaitTimeout.get();
    }

    @Override
    public void setConnectionWaitTimeout(int waitTimeout) throws UniversalConnectionPoolException {
        if (waitTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_connectionWaitTimeout.set(waitTimeout);
        ClioSupport.ilogFinest(null, null, null, null, "waitTimeout=" + waitTimeout);
    }

    @Override
    public int getTimeToLiveConnectionTimeout() {
        return this.m_timeToLiveConnectionTimeout.get();
    }

    void processTimeToLiveTimeout() {
        final int ttl = this.m_timeToLiveConnectionTimeout.get();
        if (ttl > 0) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    UniversalConnectionPoolBase.this.core.returnTTLed(ttl * 1000);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 5.class.getDeclaredConstructor(UniversalConnectionPoolBase.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 5.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    private void initTimeToLiveConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && this.m_timeToLiveConnectionTimeout.get() > 0 && this.m_timeToLiveConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new TimeToLiveConnectionTimerTask(this), 0L, timeoutCheck * 1000))) {
            ClioSupport.ilogFinest(null, null, null, null, "scheduled");
        }
    }

    private void disableTimeToLiveConnectionTimeoutTimer() {
        TimerHandle timerToCancel = this.m_timeToLiveConnectionTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            ClioSupport.ilogFinest(null, null, null, null, "canceled");
        }
    }

    @Override
    public void setTimeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) throws UniversalConnectionPoolException {
        int prevValue;
        if (timeToLiveConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((prevValue = this.m_timeToLiveConnectionTimeout.getAndSet(timeToLiveConnectionTimeout)) != timeToLiveConnectionTimeout) {
            this.disableTimeToLiveConnectionTimeoutTimer();
            if (timeToLiveConnectionTimeout != 0 && this.isLifecycleRunning()) {
                this.initTimeToLiveConnectionTimeoutTimer();
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "timeToLiveConnectionTimeout=" + timeToLiveConnectionTimeout);
    }

    protected TimerHandle getTimeToLiveConnectionTimer() {
        return this.m_timeToLiveConnectionTimer.get();
    }

    @Override
    public int getTimeoutCheckInterval() {
        return this.m_timeoutCheckInterval.get();
    }

    @Override
    public void setTimeoutCheckInterval(int timeoutCheckInterval) throws UniversalConnectionPoolException {
        int prevValue;
        if (timeoutCheckInterval < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if ((prevValue = this.m_timeoutCheckInterval.getAndSet(timeoutCheckInterval)) != timeoutCheckInterval) {
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            if (timeoutCheckInterval != 0 && this.isLifecycleRunning()) {
                this.initAbandonedConnectionTimeoutTimer();
                this.initInactiveConnectionTimeoutTimer();
                this.initTimeToLiveConnectionTimeoutTimer();
                this.initConnectionHarvestingTimer();
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "timeoutCheckInterval=" + timeoutCheckInterval);
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        return this.m_validateConnectionOnBorrow.get();
    }

    @Override
    public void setValidateConnectionOnBorrow(boolean validateConnectionOnBorrow) {
        this.m_validateConnectionOnBorrow.set(validateConnectionOnBorrow);
        ClioSupport.ilogFinest(null, null, null, null, "validateConnectionOnBorrow=" + validateConnectionOnBorrow);
    }

    @Override
    public int getSecondsToTrustIdleConnection() {
        return this.m_secondsToTrustIdleConnection.get();
    }

    @Override
    public void setSecondsToTrustIdleConnection(int secondsToTrustIdleConnection) throws UniversalConnectionPoolException {
        if (!(secondsToTrustIdleConnection == 0 || this.getValidateConnectionOnBorrow() && secondsToTrustIdleConnection >= 0)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        ClioSupport.ilogFinest(null, null, null, null, "set: secondsToTrustIdleConnection");
        this.m_secondsToTrustIdleConnection.set(secondsToTrustIdleConnection);
        ClioSupport.ilogFinest(null, null, null, null, "secondsToTrustIdleConnection=" + secondsToTrustIdleConnection);
    }

    @Override
    public int getConnectionHarvestTriggerCount() {
        return this.m_connectionHarvestTriggerCount.get();
    }

    @Override
    public void setConnectionHarvestTriggerCount(int connectionHarvestTriggerCount) throws UniversalConnectionPoolException {
        int prevValue;
        if (connectionHarvestTriggerCount < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (connectionHarvestTriggerCount != (prevValue = this.m_connectionHarvestTriggerCount.getAndSet(connectionHarvestTriggerCount))) {
            this.disableConnectionHarvestingTimer();
            if (this.m_connectionHarvestTriggerCount.get() >= 0 && this.m_connectionHarvestTriggerCount.get() < Integer.MAX_VALUE && this.isLifecycleRunning()) {
                this.initConnectionHarvestingTimer();
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "connectionHarvestTriggerCount=" + connectionHarvestTriggerCount);
    }

    @Override
    public int getConnectionHarvestMaxCount() {
        return this.m_connectionHarvestMaxCount.get();
    }

    @Override
    public void setConnectionHarvestMaxCount(int connectionHarvestMaxCount) throws UniversalConnectionPoolException {
        if (connectionHarvestMaxCount < 1) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_connectionHarvestMaxCount.set(connectionHarvestMaxCount);
        ClioSupport.ilogFinest(null, null, null, null, "connectionHarvestMaxCount=" + connectionHarvestMaxCount);
    }

    int getConnectionsCreatedCount() {
        return this.m_numConnectionsCreated.get();
    }

    protected void incrementConnectionsCreatedCount() {
        this.m_numConnectionsCreated.incrementAndGet();
    }

    int getConnectionsClosedCount() {
        return this.m_numConnectionsClosed.get();
    }

    protected void incrementConnectionsClosedCount() {
        this.m_numConnectionsClosed.incrementAndGet();
    }

    @Override
    public int getAvailableConnectionsCount() {
        return this.totalConnectionsCount.get() - this.borrowedConnectionsCount.get();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.borrowedConnectionsCount.get();
    }

    public int getTotalConnectionsCount() {
        return this.totalConnectionsCount.get();
    }

    @Override
    public abstract UniversalConnectionPoolStatistics getStatistics();

    @Override
    public UniversalConnectionPoolLifeCycleState getLifeCycleState() {
        return this.m_lifeCycleState.get();
    }

    public ConnectionFactoryAdapter getConnectionFactoryAdapter() {
        return this.m_connectionFactoryAdapter;
    }

    @Override
    public ConnectionRetrievalInfo getConnectionRetrievalInfo() {
        return this.defaultConnectionRetrievalInfo;
    }

    @Override
    public void setConnectionRetrievalInfo(ConnectionRetrievalInfo defaultCRI) {
        this.defaultConnectionRetrievalInfo = defaultCRI;
    }

    public String getServiceName() {
        return this.core.connectionSource().defaultServiceName();
    }

    @Override
    public void registerConnectionLabelingCallback(ConnectionLabelingCallback cbk) throws UniversalConnectionPoolException {
        if (!this.m_connectionLabelingCallback.compareAndSet(null, cbk)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(91);
        }
        ClioSupport.ilogFinest(null, null, null, null, "cbk=" + cbk);
    }

    @Override
    public void removeConnectionLabelingCallback() {
        this.m_connectionLabelingCallback.set(null);
        ClioSupport.ilogFinest(null, null, null, null, "removed");
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        this.connectionAffinityCallback = cbk;
        ClioSupport.ilogFinest(null, null, null, null, "cbk=" + cbk);
    }

    @Override
    public void removeConnectionAffinityCallback() throws UniversalConnectionPoolException {
        this.connectionAffinityCallback = null;
        ClioSupport.ilogFinest(null, null, null, null, "removed");
    }

    public ConnectionAffinityCallback getConnectionAffinityCallback() {
        return this.connectionAffinityCallback;
    }

    @Override
    public int getAbandonedConnectionTimeout() {
        return this.m_abandonedConnectionTimeout.get();
    }

    void processAbandonedConnections() {
        ClioSupport.ilogFinest(null, null, null, null, "about to process abandoned connections");
        final int abandonedTimeout = this.m_abandonedConnectionTimeout.get();
        if (abandonedTimeout > 0) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    UniversalConnectionPoolBase.this.core.returnAbandoned(abandonedTimeout * 1000);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredConstructor(UniversalConnectionPoolBase.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    private void initAbandonedConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && this.m_abandonedConnectionTimeout.get() > 0) {
            this.m_abandonedConnectionTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new AbandonedConnectionTimerTask(this), 0L, timeoutCheck * 1000));
        }
    }

    protected void validatePoolSizes() throws UniversalConnectionPoolException {
        int initialPoolSize = this.m_initialPoolSize.get();
        int minPoolSize = this.m_minPoolSize.get();
        int maxPoolSize = this.m_maxPoolSize.get();
        if (initialPoolSize < 0 || minPoolSize < 0 || minPoolSize > maxPoolSize || maxPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (0 == maxPoolSize) {
            UCPErrorHandler.throwUniversalConnectionPoolException(59);
        }
    }

    private void disableAbandonedConnectionTimeoutTimer() {
        TimerHandle timerToCancel = this.m_abandonedConnectionTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            ClioSupport.ilogFinest(null, null, null, null, "disabled");
        }
    }

    @Override
    public void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) throws UniversalConnectionPoolException {
        int prevValue;
        if (abandonedConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (abandonedConnectionTimeout != (prevValue = this.m_abandonedConnectionTimeout.getAndSet(abandonedConnectionTimeout))) {
            this.disableAbandonedConnectionTimeoutTimer();
            if (abandonedConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initAbandonedConnectionTimeoutTimer();
                this.setQueryTimeout(60);
            } else {
                this.setQueryTimeout(0);
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "abandonedConnectionTimeout=" + abandonedConnectionTimeout);
    }

    protected TimerHandle getAbandonedConnectionTimer() {
        return this.m_abandonedConnectionTimer.get();
    }

    abstract void processConnectionHarvesting();

    private void initConnectionHarvestingTimer() throws UniversalConnectionPoolException {
        int connectionHarvestTriggerCount = this.m_connectionHarvestTriggerCount.get();
        int timeoutCheck = this.m_timeoutCheckInterval.get();
        if (timeoutCheck > 0 && connectionHarvestTriggerCount >= 0 && connectionHarvestTriggerCount < Integer.MAX_VALUE && this.m_connectionHarvestTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new ConnectionHarvestingTimerTask(this), 0L, timeoutCheck * 1000))) {
            ClioSupport.ilogFinest(null, null, null, null, "scheduled");
        }
    }

    private void disableConnectionHarvestingTimer() {
        TimerHandle timerToCancel = this.m_connectionHarvestTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            ClioSupport.ilogFinest(null, null, null, null, "cancelled");
        }
    }

    private void initReplaceNonReusableConnectionsTimer() {
        long reuseTime = this.m_maxConnectionReuseTime.get();
        long timerInterval = reuseTime / 4L + reuseTime % 4L;
        if (reuseTime > 0L && this.m_replaceNonReusableConnectionsTimer.compareAndSet(null, UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new UCPTimerTaskImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        UniversalConnectionPoolBase.this.core.replaceNonReusable();
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(7.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
            }

            static {
                try {
                    $$$methodRef$$$1 = 7.class.getDeclaredConstructor(UniversalConnectionPoolBase.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 7.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }, 0L, timerInterval * 1000L))) {
            ClioSupport.ilogFinest(null, null, null, null, "scheduled");
        }
    }

    private void cancelReplaceNonReusableConnectionsTimer() {
        TimerHandle timerToCancel = this.m_replaceNonReusableConnectionsTimer.getAndSet(null);
        if (null != timerToCancel) {
            timerToCancel.cancel();
            ClioSupport.ilogFinest(null, null, null, null, "cancelled");
        }
    }

    public boolean isFailoverEnabled() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return this.isFailoverExplicitlySet() ? this.m_failoverEnabled.get() : ((Topology)cs).isFANHeuristicallyEnabled();
        }
        return this.m_failoverEnabled.get();
    }

    protected boolean isFailoverExplicitlySet() {
        return this.failoverExplicitlySet.get();
    }

    public void setFailoverEnabled(boolean failoverEnabled) {
        this.m_failoverEnabled.set(failoverEnabled);
        this.failoverExplicitlySet.set(true);
        ClioSupport.ilogFinest(null, null, null, null, "failoverEnabled=" + failoverEnabled);
    }

    @Override
    public long getMaxConnectionReuseTime() {
        return this.m_maxConnectionReuseTime.get();
    }

    @Override
    public void setMaxConnectionReuseTime(long maxConnectionReuseTime) throws UniversalConnectionPoolException {
        if (maxConnectionReuseTime < 0L) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (maxConnectionReuseTime != this.m_maxConnectionReuseTime.get()) {
            this.cancelReplaceNonReusableConnectionsTimer();
            this.m_maxConnectionReuseTime.set(maxConnectionReuseTime);
            if (maxConnectionReuseTime > 0L && this.isLifecycleRunning()) {
                this.initReplaceNonReusableConnectionsTimer();
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "maxConnectionReuseTime=" + maxConnectionReuseTime);
    }

    @Override
    public int getMaxConnectionReuseCount() {
        return this.m_maxConnectionReuseCount.get();
    }

    @Override
    public void setMaxConnectionReuseCount(int maxConnectionReuseCount) throws UniversalConnectionPoolException {
        if (maxConnectionReuseCount < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_maxConnectionReuseCount.set(maxConnectionReuseCount);
        ClioSupport.ilogFinest(null, null, null, null, "maxConnectionReuseCount=" + maxConnectionReuseCount);
    }

    public boolean isRuntimeLoadBalancingEnabled() {
        return false;
    }

    public void setRuntimeLoadBalancingEnabled(boolean RLBEnabled) throws UniversalConnectionPoolException {
    }

    protected abstract void discardUsedConnection(Object var1);

    protected abstract UniversalPooledConnection getUsedConnection(Object var1);

    protected abstract boolean returnUsedPhysicalConnection(Object var1) throws UniversalConnectionPoolException;

    protected abstract boolean closeUsedPhysicalConnection(Object var1) throws UniversalConnectionPoolException;

    @Override
    public void setFailoverInfo(Object info) {
    }

    @Override
    public Object getFailoverInfo() {
        return null;
    }

    @Override
    public void handleFailoverEvent(FailoverEvent event) {
    }

    int getAbandonedConnectionsCount() {
        return this.m_abandonedConnectionsCount.get();
    }

    int getPendingRequestsCount() {
        return this.m_pendingRequestsCount.get();
    }

    long getCumulativeConnectionReturnedCount() {
        return this.cumulativeReturnedConnectionsCount;
    }

    long getCumulativeSuccessfulConnectionWaitCount() {
        return this.m_cumulativeSuccessfulConnectionWaitCount.get();
    }

    long getCumulativeFailedConnectionWaitCount() {
        return this.m_cumulativeFailedConnectionWaitCount.get();
    }

    long getCumulativeSuccessfulConnectionWaitTime() {
        return this.m_cumulativeSuccessfulConnectionWaitTime.get();
    }

    long getCumulativeFailedConnectionWaitTime() {
        return this.m_cumulativeFailedConnectionWaitTime.get();
    }

    long getCumulativeConnectionBorrowedCount() {
        return this.cumulativeBorrowedConnectionsCount;
    }

    long getPeakConnectionWaitTime() {
        return this.m_peakConnectionWaitTime.get();
    }

    long getCumulativeConnectionUseTime() {
        return this.m_cumulativeConnectionUseTime.get();
    }

    int getPeakConnectionsCount() {
        return this.m_peakBorrowedConnectionsCount.get();
    }

    int getCumulativeConnectionsCreated() {
        return this.m_cumulativeConnectionsCreated.get();
    }

    int getAverageBorrowedConnectionsCount() {
        long accum = new Long(this.borrowedAccumulator.get());
        long samples = new Long(this.borrowedSamples.get());
        return 0L != samples ? new Long(accum / samples).intValue() : 0;
    }

    public boolean isLifecycleRunning() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING;
    }

    public boolean isLifecycleStarting() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING;
    }

    public boolean isLifecycleStopping() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING;
    }

    public boolean isLifecycleStopped() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED;
    }

    public boolean isLifecycleFailed() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED;
    }

    void setLifecycleFailed() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED);
        ClioSupport.ilogFinest(null, null, null, null, "LifeCycle set: failed");
    }

    private void setLifecycleStarting() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING);
        ClioSupport.ilogFinest(null, null, null, null, "LifeCycle set: starting");
    }

    private void setLifecycleStopping() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING);
        ClioSupport.ilogFinest(null, null, null, null, "LifeCycle set: stopping");
    }

    private void setLifecycleRunning() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING);
        ClioSupport.ilogFinest(null, null, null, null, "LifeCycle set: running");
    }

    private void setLifecycleStopped() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED);
        ClioSupport.ilogFinest(null, null, null, null, "LifeCycle set: stopped");
    }

    public ConnectionLabelingCallback getConnectionLabelingCallback() {
        return this.m_connectionLabelingCallback.get();
    }

    protected long getCumulativeReturnedConnectionCount() {
        return this.cumulativeReturnedConnectionsCount;
    }

    @Override
    public int getConnectionLabelingHighCost() {
        return this.connectionLabelingHighCost.get();
    }

    @Override
    public void setConnectionLabelingHighCost(int highCost) throws UniversalConnectionPoolException {
        if (highCost < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionLabelingHighCost.set(highCost);
        ClioSupport.ilogFinest(null, null, null, null, "highCost=" + highCost);
    }

    @Override
    public int getHighCostConnectionReuseThreshold() {
        return this.highCostConnectionReuseThreshold.get();
    }

    @Override
    public void setHighCostConnectionReuseThreshold(int threshold) throws UniversalConnectionPoolException {
        if (threshold < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.highCostConnectionReuseThreshold.set(threshold);
        ClioSupport.ilogFinest(null, null, null, null, "threshold=" + threshold);
    }

    @Override
    public int getMaxConnectionsPerService() {
        return this.maxConnectionsPerService.get();
    }

    @Override
    public void setMaxConnectionsPerService(int maxPerService) throws UniversalConnectionPoolException {
        if (maxPerService < 1) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.isLifecycleRunning() && maxPerService != this.maxConnectionsPerService.get()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(279);
        }
        this.maxConnectionsPerService.set(maxPerService);
        ClioSupport.ilogFinest(null, null, null, null, "maxPerService=" + maxPerService);
    }

    public void setShareable(boolean shared) {
        this.shareable.set(shared);
        ClioSupport.ilogFinest(null, null, null, null, "shared=" + shared);
    }

    @Override
    public boolean isShareable() {
        return this.shareable.get();
    }

    @Override
    public int getConnectionRepurposeThreshold() {
        return this.connectionRepurposeThreshold.get();
    }

    @Override
    public void setConnectionRepurposeThreshold(Integer threshold) throws UniversalConnectionPoolException {
        if (threshold < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionRepurposeThreshold.set(threshold);
        ClioSupport.ilogFinest(null, null, null, null, "threshold=" + threshold);
    }

    public int getMaxConnectionsPerShard() {
        return this.maxConnectionsPerShard.get();
    }

    public void setMaxConnectionsPerShard(Integer maxConnsPerShard) throws UniversalConnectionPoolException {
        if (maxConnsPerShard < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.maxConnectionsPerShard.set(maxConnsPerShard);
        ClioSupport.ilogFinest(null, null, null, null, "maxConnsPerShard=" + maxConnsPerShard);
    }

    @Override
    public void setConnectionValidationTimeout(int connectionValidationTimeout) throws UniversalConnectionPoolException {
        if (connectionValidationTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.connectionValidationTimeout.set(connectionValidationTimeout);
        ClioSupport.ilogFinest(null, null, null, null, "connectionValidationTimeout=" + connectionValidationTimeout);
    }

    @Override
    public int getConnectionValidationTimeout() {
        return this.connectionValidationTimeout.get();
    }

    @Override
    public void setShardingMode(boolean shardingMode) {
        this.shardingMode.set(shardingMode);
        ClioSupport.ilogFinest(null, null, null, null, "setShardingMode=" + shardingMode);
    }

    @Override
    public boolean getShardingMode() {
        return this.shardingMode.get();
    }

    @Override
    public boolean isReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed.get();
    }

    @Override
    public void setReadOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.readOnlyInstanceAllowed.set(readOnlyInstanceAllowed);
        ClioSupport.ilogFinest(null, null, null, null, "readOnlyInstanceAllowed=" + readOnlyInstanceAllowed);
    }

    int pendingGrowsCount() {
        return this.core.pendingGrowsCount();
    }

    void clearWFPTree() {
        this.core.clearWFPTree();
    }

    public String getDatabaseTopologyInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getDatabaseTopologyInfo();
        }
        return "not collected yet";
    }

    public String getShardedDatabaseInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getShardedDatabaseInfo();
        }
        return "not discovered";
    }

    public String getShardRoutingCacheInfo() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getShardRoutingCacheInfo();
        }
        return "No shard routing cache built in UCP";
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) throws UniversalConnectionPoolException {
        if (queryTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.queryTimeout = queryTimeout;
        ClioSupport.ilogFinest(null, null, null, null, "queryTimeout=" + queryTimeout);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout.get();
    }

    @Override
    public void setLoginTimeout(int seconds) throws UniversalConnectionPoolException {
        if (seconds < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.loginTimeout.set(seconds);
        ClioSupport.ilogFinest(null, null, null, null, "seconds=" + seconds);
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    private HistogramRingRegistry composeCurrentAvailableHistogramRingRegistry() {
        HistogramRingRegistry regAvailable = new HistogramRingRegistry(1, 0L, 60000L, 5L);
        this.core.forEach(conn -> {
            UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
            if (conn.available()) {
                long delta = Clock.clock() - upc.getAvailableStartTime();
                regAvailable.insert(conn.cri(), delta);
            }
        });
        return regAvailable;
    }

    private HistogramRingRegistry composeCurrentBorrowedHistogramRingRegistry() {
        HistogramRingRegistry regBorrowed = new HistogramRingRegistry(1, 0L, 60000L, 5L);
        this.core.forEach(conn -> {
            UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
            if (!conn.available()) {
                regBorrowed.insert(conn.cri(), Clock.clock() - upc.getBorrowedStartTime());
            }
        });
        return regBorrowed;
    }

    void insertToAvailableHistogram(ConnectionRetrievalInfo cri, long time) {
        this.availableRegistry.insert(cri, time);
    }

    void insertToBorrowedHistogram(ConnectionRetrievalInfo cri, long time) {
        this.borrowedRegistry.insert(cri, time);
    }

    void insertToCreatedHistogram(ConnectionRetrievalInfo cri, long time) {
        this.createdRegistry.insert(cri, time);
    }

    CounterMap getNeverUsedConnectionsCounter() {
        return this.neverUsedConnectionsCounter;
    }

    int getLabeledConnectionsCount() {
        return this.labeledConnectionsCount.get();
    }

    Map<String, ShardConnectionStatistics> getShardConnectionStats() {
        ConnectionSource cs = this.core.connectionSource();
        if (cs instanceof Topology) {
            return ((Topology)cs).getShardConnectionStats();
        }
        return Collections.emptyMap();
    }

    public void setOraclePool(boolean isOraclePool) {
        this.isOraclePool.set(isOraclePool);
        ClioSupport.ilogFinest(null, null, null, null, "setOraclePool=" + isOraclePool);
    }

    boolean isOraclePool() {
        return this.isOraclePool.get();
    }

    static {
        try {
            $$$methodRef$$$146 = UniversalConnectionPoolBase.class.getDeclaredConstructor(ConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$146 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$145 = UniversalConnectionPoolBase.class.getDeclaredMethod("lambda$composeCurrentAvailableHistogramRingRegistry$0", HistogramRingRegistry.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$145 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$144 = UniversalConnectionPoolBase.class.getDeclaredMethod("lambda$composeCurrentBorrowedHistogramRingRegistry$1", HistogramRingRegistry.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$144 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$143 = UniversalConnectionPoolBase.class.getDeclaredMethod("isOraclePool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$143 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$142 = UniversalConnectionPoolBase.class.getDeclaredMethod("setOraclePool", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$142 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$141 = UniversalConnectionPoolBase.class.getDeclaredMethod("getShardConnectionStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$141 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$140 = UniversalConnectionPoolBase.class.getDeclaredMethod("getLabeledConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$140 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$139 = UniversalConnectionPoolBase.class.getDeclaredMethod("getNeverUsedConnectionsCounter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$139 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$138 = UniversalConnectionPoolBase.class.getDeclaredMethod("insertToCreatedHistogram", ConnectionRetrievalInfo.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$138 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$137 = UniversalConnectionPoolBase.class.getDeclaredMethod("insertToBorrowedHistogram", ConnectionRetrievalInfo.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$137 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$136 = UniversalConnectionPoolBase.class.getDeclaredMethod("insertToAvailableHistogram", ConnectionRetrievalInfo.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$136 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$135 = UniversalConnectionPoolBase.class.getDeclaredMethod("composeCurrentBorrowedHistogramRingRegistry", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$135 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$134 = UniversalConnectionPoolBase.class.getDeclaredMethod("composeCurrentAvailableHistogramRingRegistry", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$134 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$133 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$133 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$132 = UniversalConnectionPoolBase.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$132 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$131 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLoginTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$131 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$130 = UniversalConnectionPoolBase.class.getDeclaredMethod("getLoginTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$130 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$129 = UniversalConnectionPoolBase.class.getDeclaredMethod("setQueryTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$129 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$128 = UniversalConnectionPoolBase.class.getDeclaredMethod("getQueryTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$128 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$127 = UniversalConnectionPoolBase.class.getDeclaredMethod("getShardRoutingCacheInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$127 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$126 = UniversalConnectionPoolBase.class.getDeclaredMethod("getShardedDatabaseInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$126 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$125 = UniversalConnectionPoolBase.class.getDeclaredMethod("getDatabaseTopologyInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$125 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$124 = UniversalConnectionPoolBase.class.getDeclaredMethod("clearWFPTree", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$124 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$123 = UniversalConnectionPoolBase.class.getDeclaredMethod("pendingGrowsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$123 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$122 = UniversalConnectionPoolBase.class.getDeclaredMethod("setReadOnlyInstanceAllowed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$121 = UniversalConnectionPoolBase.class.getDeclaredMethod("isReadOnlyInstanceAllowed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$120 = UniversalConnectionPoolBase.class.getDeclaredMethod("getShardingMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$119 = UniversalConnectionPoolBase.class.getDeclaredMethod("setShardingMode", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$118 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionValidationTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$117 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionValidationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$116 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxConnectionsPerShard", Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$115 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxConnectionsPerShard", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$114 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionRepurposeThreshold", Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$113 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionRepurposeThreshold", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$112 = UniversalConnectionPoolBase.class.getDeclaredMethod("isShareable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$111 = UniversalConnectionPoolBase.class.getDeclaredMethod("setShareable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$110 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxConnectionsPerService", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$109 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxConnectionsPerService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$108 = UniversalConnectionPoolBase.class.getDeclaredMethod("setHighCostConnectionReuseThreshold", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$107 = UniversalConnectionPoolBase.class.getDeclaredMethod("getHighCostConnectionReuseThreshold", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$106 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionLabelingHighCost", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$105 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionLabelingHighCost", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$104 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeReturnedConnectionCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$103 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionLabelingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$102 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleStopped", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$101 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleRunning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$100 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleStopping", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$99 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleStarting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$98 = UniversalConnectionPoolBase.class.getDeclaredMethod("setLifecycleFailed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$97 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleFailed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$96 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleStopped", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$95 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleStopping", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$94 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleStarting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$93 = UniversalConnectionPoolBase.class.getDeclaredMethod("isLifecycleRunning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$92 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAverageBorrowedConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$91 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeConnectionsCreated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$90 = UniversalConnectionPoolBase.class.getDeclaredMethod("getPeakConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$89 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeConnectionUseTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$88 = UniversalConnectionPoolBase.class.getDeclaredMethod("getPeakConnectionWaitTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$87 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeConnectionBorrowedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$86 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeFailedConnectionWaitTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$85 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeSuccessfulConnectionWaitTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$84 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeFailedConnectionWaitCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$83 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeSuccessfulConnectionWaitCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$82 = UniversalConnectionPoolBase.class.getDeclaredMethod("getCumulativeConnectionReturnedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$81 = UniversalConnectionPoolBase.class.getDeclaredMethod("getPendingRequestsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$80 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAbandonedConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$79 = UniversalConnectionPoolBase.class.getDeclaredMethod("handleFailoverEvent", FailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$78 = UniversalConnectionPoolBase.class.getDeclaredMethod("getFailoverInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$77 = UniversalConnectionPoolBase.class.getDeclaredMethod("setFailoverInfo", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$76 = UniversalConnectionPoolBase.class.getDeclaredMethod("setRuntimeLoadBalancingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$75 = UniversalConnectionPoolBase.class.getDeclaredMethod("isRuntimeLoadBalancingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$74 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxConnectionReuseCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$73 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxConnectionReuseCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$72 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxConnectionReuseTime", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$71 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxConnectionReuseTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$70 = UniversalConnectionPoolBase.class.getDeclaredMethod("setFailoverEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$69 = UniversalConnectionPoolBase.class.getDeclaredMethod("isFailoverExplicitlySet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$68 = UniversalConnectionPoolBase.class.getDeclaredMethod("isFailoverEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$67 = UniversalConnectionPoolBase.class.getDeclaredMethod("cancelReplaceNonReusableConnectionsTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$66 = UniversalConnectionPoolBase.class.getDeclaredMethod("initReplaceNonReusableConnectionsTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$65 = UniversalConnectionPoolBase.class.getDeclaredMethod("disableConnectionHarvestingTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$64 = UniversalConnectionPoolBase.class.getDeclaredMethod("initConnectionHarvestingTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$63 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAbandonedConnectionTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$62 = UniversalConnectionPoolBase.class.getDeclaredMethod("setAbandonedConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$61 = UniversalConnectionPoolBase.class.getDeclaredMethod("disableAbandonedConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$60 = UniversalConnectionPoolBase.class.getDeclaredMethod("validatePoolSizes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$59 = UniversalConnectionPoolBase.class.getDeclaredMethod("initAbandonedConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$58 = UniversalConnectionPoolBase.class.getDeclaredMethod("processAbandonedConnections", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$57 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAbandonedConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$56 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionAffinityCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$55 = UniversalConnectionPoolBase.class.getDeclaredMethod("removeConnectionAffinityCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$54 = UniversalConnectionPoolBase.class.getDeclaredMethod("registerConnectionAffinityCallback", ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$53 = UniversalConnectionPoolBase.class.getDeclaredMethod("removeConnectionLabelingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$52 = UniversalConnectionPoolBase.class.getDeclaredMethod("registerConnectionLabelingCallback", ConnectionLabelingCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$51 = UniversalConnectionPoolBase.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$50 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionRetrievalInfo", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$49 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionRetrievalInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$48 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionFactoryAdapter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$47 = UniversalConnectionPoolBase.class.getDeclaredMethod("getLifeCycleState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$46 = UniversalConnectionPoolBase.class.getDeclaredMethod("getTotalConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$45 = UniversalConnectionPoolBase.class.getDeclaredMethod("getBorrowedConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$44 = UniversalConnectionPoolBase.class.getDeclaredMethod("getAvailableConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$43 = UniversalConnectionPoolBase.class.getDeclaredMethod("incrementConnectionsClosedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$42 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionsClosedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$41 = UniversalConnectionPoolBase.class.getDeclaredMethod("incrementConnectionsCreatedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$40 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionsCreatedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$39 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionHarvestMaxCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$38 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionHarvestMaxCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionHarvestTriggerCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionHarvestTriggerCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = UniversalConnectionPoolBase.class.getDeclaredMethod("setSecondsToTrustIdleConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = UniversalConnectionPoolBase.class.getDeclaredMethod("getSecondsToTrustIdleConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = UniversalConnectionPoolBase.class.getDeclaredMethod("setValidateConnectionOnBorrow", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = UniversalConnectionPoolBase.class.getDeclaredMethod("getValidateConnectionOnBorrow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = UniversalConnectionPoolBase.class.getDeclaredMethod("setTimeoutCheckInterval", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = UniversalConnectionPoolBase.class.getDeclaredMethod("getTimeoutCheckInterval", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = UniversalConnectionPoolBase.class.getDeclaredMethod("getTimeToLiveConnectionTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = UniversalConnectionPoolBase.class.getDeclaredMethod("setTimeToLiveConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = UniversalConnectionPoolBase.class.getDeclaredMethod("disableTimeToLiveConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = UniversalConnectionPoolBase.class.getDeclaredMethod("initTimeToLiveConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = UniversalConnectionPoolBase.class.getDeclaredMethod("processTimeToLiveTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = UniversalConnectionPoolBase.class.getDeclaredMethod("getTimeToLiveConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = UniversalConnectionPoolBase.class.getDeclaredMethod("setConnectionWaitTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = UniversalConnectionPoolBase.class.getDeclaredMethod("getConnectionWaitTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = UniversalConnectionPoolBase.class.getDeclaredMethod("getInactiveConnectionTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = UniversalConnectionPoolBase.class.getDeclaredMethod("setInactiveConnectionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = UniversalConnectionPoolBase.class.getDeclaredMethod("disableInactiveConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = UniversalConnectionPoolBase.class.getDeclaredMethod("initInactiveConnectionTimeoutTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = UniversalConnectionPoolBase.class.getDeclaredMethod("getInactiveConnectionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = UniversalConnectionPoolBase.class.getDeclaredMethod("closePhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMaxPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMaxPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = UniversalConnectionPoolBase.class.getDeclaredMethod("setMinPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = UniversalConnectionPoolBase.class.getDeclaredMethod("getMinPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = UniversalConnectionPoolBase.class.getDeclaredMethod("setInitialPoolSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = UniversalConnectionPoolBase.class.getDeclaredMethod("getInitialPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = UniversalConnectionPoolBase.class.getDeclaredMethod("setName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = UniversalConnectionPoolBase.class.getDeclaredMethod("getName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = UniversalConnectionPoolBase.class.getDeclaredMethod("resetNonCumulativePoolStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = UniversalConnectionPoolBase.class.getDeclaredMethod("resetAllPoolStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = UniversalConnectionPoolBase.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = UniversalConnectionPoolBase.class.getDeclaredMethod("start", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = UniversalConnectionPoolBase.class.getDeclaredMethod("reconfigure", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = UniversalConnectionPoolBase.class.getDeclaredMethod("setONSConfiguration", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UniversalConnectionPoolBase.class.getDeclaredMethod("getONSConfiguration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UniversalConnectionPoolBase.class.getDeclaredMethod("toStringProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        DEFAULT_POOLNAME_PREFIX = "UniversalConnectionPool(" + UniversalConnectionPoolBase.class.hashCode() + ")-";
        m_poolsRunning = new AtomicInteger(0);
    }
}

