/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.util.RingBuffer;
import oracle.ucp.util.Util;

@DisableTrace
public class DiagnosticsSummary {
    private static RingBuffer<Throwable> throwables;
    private static RingBuffer<String> lbSummaries;
    private static final Object securedLogger;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    private DiagnosticsSummary() {
    }

    public static void addException(Throwable e) {
        throwables.addItem(e);
    }

    public static void addLBSummary(String summary) {
        lbSummaries.addItem(summary);
    }

    public static String collect() throws UniversalConnectionPoolException {
        StringBuilder sb = new StringBuilder();
        UniversalConnectionPoolManager manager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        String[] poolNames = manager.getConnectionPoolNames();
        sb.append("<pools>");
        for (String poolName : poolNames) {
            UniversalConnectionPoolBase ucp = (UniversalConnectionPoolBase)manager.getConnectionPool(poolName);
            sb.append("<pool name=\"").append(poolName);
            sb.append("\", lifecycle=\"").append(ucp.getLifeCycleState());
            sb.append("\", properties=\"").append(ucp.toStringProperties());
            sb.append("\", stats=\"").append(ucp.getStatistics().toString());
            sb.append("\", topology=\"").append(ucp.getDatabaseTopologyInfo());
            sb.append("\", shardedDb=\"").append(ucp.getShardedDatabaseInfo());
            sb.append("\", shardRoutingCache=\"").append(ucp.getShardRoutingCacheInfo());
            sb.append("\", workingSet=\"");
            ucp.core.forEach(conn -> sb.append(conn.getDelegate().toString()).append(", "));
            sb.append("\" />");
        }
        sb.append("</pools>");
        sb.append("<throwables>");
        throwables.getAsList().forEach(e -> sb.append("<throwable message=\"").append(e.getMessage()).append("\", stack=\"").append(Arrays.deepToString(e.getStackTrace())).append("\" />"));
        sb.append("</throwables>");
        sb.append("<lbstats>");
        lbSummaries.getAsList().forEach(s -> sb.append("<lbstat>").append((String)s).append("</lbstat>"));
        sb.append("</lbstats>");
        return sb.toString();
    }

    public static Object getSecuredLogger() {
        return securedLogger;
    }

    static {
        Class<?> clsSecuredLogger;
        try {
            $$$methodRef$$$8 = DiagnosticsSummary.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = DiagnosticsSummary.class.getDeclaredMethod("lambda$collect$0", StringBuilder.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = DiagnosticsSummary.class.getDeclaredMethod("lambda$collect$1", StringBuilder.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = DiagnosticsSummary.class.getDeclaredMethod("lambda$collect$2", StringBuilder.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = DiagnosticsSummary.class.getDeclaredMethod("lambda$static$3", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = DiagnosticsSummary.class.getDeclaredMethod("getSecuredLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = DiagnosticsSummary.class.getDeclaredMethod("collect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = DiagnosticsSummary.class.getDeclaredMethod("addLBSummary", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = DiagnosticsSummary.class.getDeclaredMethod("addException", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        throwables = new RingBuffer(1024);
        lbSummaries = new RingBuffer(1024);
        try {
            clsSecuredLogger = Util.getClassForName("oracle.jdbc.diagnostics.SecuredLogger", false, Thread.currentThread().getContextClassLoader(), DiagnosticsSummary.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            clsSecuredLogger = null;
        }
        if (null != clsSecuredLogger) {
            Object logger;
            try {
                Method m = clsSecuredLogger.getMethod("newLogger", String.class);
                logger = m.invoke(null, "UCP-logBuffer-" + UUID.randomUUID().toString(), null);
            }
            catch (IllegalAccessException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                logger = null;
            }
            securedLogger = logger;
        } else {
            securedLogger = null;
        }
        if (null != DiagnosticsSummary.getSecuredLogger()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    ClioSupport.ilogInfo(null, null, null, null, DiagnosticsSummary.collect());
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                ClioSupport.ilogFinest(null, null, null, null, "diagnostics summary hook stopped");
                if (!throwables.getAsList().isEmpty()) {
                    ((SecuredLogger)securedLogger).dumpLog();
                }
            }));
        }
    }
}

