/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

final class RangeMap<K extends Comparable<? super K>, V> {
    private final NavigableMap<K, Value<K, V>> map = new TreeMap<K, Value<K, V>>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    RangeMap() {
    }

    private static <K extends Comparable<? super K>, V> K getFloor(Map.Entry<K, Value<K, V>> entry) {
        return (K)((Comparable)Objects.requireNonNull(entry).getKey());
    }

    private static <K extends Comparable<? super K>, V> K getCeiling(Map.Entry<K, Value<K, V>> entry) {
        return Objects.requireNonNull(entry).getValue().keyCeiling;
    }

    private SortedMap<K, Value<K, V>> submap(K fromKey, K toKey) {
        return Objects.nonNull(fromKey) ? (Objects.nonNull(toKey) ? this.map.subMap(fromKey, true, toKey, true) : this.map.tailMap(fromKey, true)) : (Objects.nonNull(toKey) ? this.map.headMap(toKey, true) : Collections.emptySortedMap());
    }

    private static <K extends Comparable<? super K>, V> boolean isOneSameRange(SortedMap<K, Value<K, V>> subMap, K keyFloor, K keyCeiling) {
        if (Objects.requireNonNull(keyFloor).compareTo(Objects.requireNonNull(keyCeiling)) > 0) {
            throw new IllegalArgumentException("floor over ceiling");
        }
        Objects.requireNonNull(subMap);
        return 1 == subMap.size() && subMap.containsKey(keyFloor) && keyCeiling.compareTo(((Value)subMap.get(keyFloor)).keyCeiling) == 0;
    }

    private static <K extends Comparable<? super K>, V> boolean isOneLargerRange(SortedMap<K, Value<K, V>> subMap, K keyFloor, K keyCeiling) {
        if (Objects.requireNonNull(keyFloor).compareTo(Objects.requireNonNull(keyCeiling)) > 0) {
            throw new IllegalArgumentException("floor over ceiling");
        }
        Objects.requireNonNull(subMap);
        if (subMap.size() != 1) {
            return false;
        }
        Map.Entry area = (Map.Entry)subMap.entrySet().stream().findAny().get();
        return keyFloor.compareTo(area.getKey()) > 0 && keyCeiling.compareTo(((Value)area.getValue()).keyCeiling) < 0;
    }

    private static <K extends Comparable<? super K>, V> boolean isOneSmallerRange(SortedMap<K, Value<K, V>> subMap, K keyFloor, K keyCeiling) {
        if (Objects.requireNonNull(keyFloor).compareTo(Objects.requireNonNull(keyCeiling)) > 0) {
            throw new IllegalArgumentException("floor over ceiling");
        }
        Objects.requireNonNull(subMap);
        if (subMap.size() != 1) {
            return false;
        }
        Map.Entry area = (Map.Entry)subMap.entrySet().stream().findAny().get();
        return keyFloor.compareTo(area.getKey()) <= 0 && keyCeiling.compareTo(((Value)area.getValue()).keyCeiling) > 0 || keyFloor.compareTo(area.getKey()) < 0 && keyCeiling.compareTo(((Value)area.getValue()).keyCeiling) >= 0;
    }

    void put(K keyFloor, K keyCeiling, List<V> values) {
        K fromKey;
        if (((Comparable)Objects.requireNonNull(keyFloor)).compareTo(Objects.requireNonNull(keyCeiling)) > 0) {
            throw new IllegalArgumentException("floor over ceiling");
        }
        Objects.requireNonNull(values);
        Map.Entry<K, Value<K, V>> fromEntry = this.map.floorEntry(keyFloor);
        Map.Entry<K, Value<K, V>> toEntry = this.map.floorEntry(keyCeiling);
        K k = Objects.isNull(fromEntry) ? keyFloor : (fromKey = RangeMap.getCeiling(fromEntry).compareTo(keyFloor) > 0 ? RangeMap.getFloor(fromEntry) : keyFloor);
        K toKey = Objects.isNull(toEntry) ? keyCeiling : (RangeMap.getCeiling(toEntry).compareTo(keyCeiling) >= 0 ? RangeMap.getCeiling(toEntry) : keyCeiling);
        SortedMap<Comparable, Value<Comparable, Value>> sm = this.submap(fromKey, toKey);
        if (sm.isEmpty()) {
            this.map.put(fromKey, new Value(toKey, new ArrayList(), new ArrayList<V>(values)));
        } else if (RangeMap.isOneSameRange(sm, keyFloor, keyCeiling)) {
            ((Value)sm.get(keyFloor)).values.addAll(values);
        } else if (RangeMap.isOneLargerRange(sm, keyFloor, keyCeiling)) {
            RangeMap<K, List<V>> rm;
            Map.Entry area = (Map.Entry)sm.entrySet().stream().findAny().get();
            if (((Value)area.getValue()).nestedRanges.isEmpty()) {
                rm = new RangeMap<K, V>();
                ((Value)area.getValue()).nestedRanges.add(rm);
            } else {
                rm = ((Value)area.getValue()).nestedRanges.get(0);
            }
            rm.put(keyFloor, keyCeiling, values);
        } else if (RangeMap.isOneSmallerRange(sm, keyFloor, keyCeiling)) {
            RangeMap<K, V> rm = new RangeMap<K, V>();
            rm.map.putAll(sm);
            sm.forEach((p, q) -> this.map.remove(p));
            this.map.put(fromKey, new Value<K, V>(toKey, new ArrayList<RangeMap<K, V>>(Collections.singletonList(rm)), new ArrayList<V>(values)));
        } else {
            RangeMap<K, V> rm1 = new RangeMap<K, V>();
            rm1.map.putAll(sm);
            sm.forEach((p, q) -> this.map.remove(p));
            RangeMap<K, ArrayList<V>> rm2 = new RangeMap<K, ArrayList<V>>();
            rm2.put(keyFloor, keyCeiling, new ArrayList<V>(values));
            this.map.put(fromKey, new Value(toKey, new ArrayList(Arrays.asList(rm1, rm2)), new ArrayList()));
        }
    }

    void put(K key, V value) {
        this.put(key, key, (V)Collections.singletonList(value));
    }

    void put(K key, List<V> values) {
        this.put(key, key, (V)values);
    }

    void put(K keyFloor, K keyCeiling, V value) {
        this.put(keyFloor, keyCeiling, (V)Collections.singletonList(value));
    }

    List<V> get(K key) {
        Objects.requireNonNull(key);
        Map.Entry<K, Value<K, V>> floorEntry = this.map.floorEntry(key);
        if (Objects.nonNull(floorEntry)) {
            K floorKey = RangeMap.getFloor(floorEntry);
            Value<K, V> value = floorEntry.getValue();
            if (floorKey.equals(value.keyCeiling) && key.equals(floorKey) || key.compareTo(value.keyCeiling) < 0) {
                if (value.nestedRanges.isEmpty()) {
                    return value.values;
                }
                ArrayList values = new ArrayList();
                values.addAll(value.values);
                value.nestedRanges.forEach(p -> {
                    List vals = p.get(key);
                    if (Objects.nonNull(vals)) {
                        values.addAll(vals);
                    }
                });
                return values;
            }
        }
        return Collections.emptyList();
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int[] i = new int[]{1};
        int sz = this.map.size();
        this.map.forEach((k, v) -> {
            if (!v.nestedRanges.isEmpty()) {
                sb.append(v.nestedRanges);
            }
            if (v.values.isEmpty()) {
                i[0] = i[0] + 1;
            } else {
                int n = i[0];
                i[0] = n + 1;
                sb.append('[').append(k).append(",").append(v.keyCeiling).append("]->").append(v.values).append(n < sz ? ", " : "");
            }
        });
        sb.append(']');
        return sb.toString();
    }

    static {
        try {
            $$$methodRef$$$17 = RangeMap.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = RangeMap.class.getDeclaredMethod("lambda$put$0", Comparable.class, Value.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = RangeMap.class.getDeclaredMethod("lambda$put$1", Comparable.class, Value.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = RangeMap.class.getDeclaredMethod("lambda$get$2", Comparable.class, List.class, RangeMap.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = RangeMap.class.getDeclaredMethod("lambda$toString$3", StringBuilder.class, int[].class, Integer.TYPE, Comparable.class, Value.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = RangeMap.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = RangeMap.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = RangeMap.class.getDeclaredMethod("get", Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = RangeMap.class.getDeclaredMethod("put", Comparable.class, Comparable.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = RangeMap.class.getDeclaredMethod("put", Comparable.class, List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = RangeMap.class.getDeclaredMethod("put", Comparable.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = RangeMap.class.getDeclaredMethod("put", Comparable.class, Comparable.class, List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = RangeMap.class.getDeclaredMethod("isOneSmallerRange", SortedMap.class, Comparable.class, Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = RangeMap.class.getDeclaredMethod("isOneLargerRange", SortedMap.class, Comparable.class, Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = RangeMap.class.getDeclaredMethod("isOneSameRange", SortedMap.class, Comparable.class, Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = RangeMap.class.getDeclaredMethod("submap", Comparable.class, Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = RangeMap.class.getDeclaredMethod("getCeiling", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = RangeMap.class.getDeclaredMethod("getFloor", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    private static class Value<K extends Comparable<? super K>, V> {
        private final K keyCeiling;
        private final List<RangeMap<K, V>> nestedRanges;
        private final List<V> values;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        private Value(K keyCeiling, List<RangeMap<K, V>> nestedRanges, List<V> values) {
            this.keyCeiling = (Comparable)Objects.requireNonNull(keyCeiling);
            this.nestedRanges = Objects.requireNonNull(nestedRanges);
            this.values = Objects.requireNonNull(values);
        }

        public String toString() {
            return "[" + this.keyCeiling + ", " + this.nestedRanges + ", " + this.values + "]";
        }

        static {
            try {
                $$$methodRef$$$1 = Value.class.getDeclaredConstructor(Comparable.class, List.class, List.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Value.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

