/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.RingBuffer;

@DefaultLogger(value="oracle.ucp.jdbc.oracle.rlb")
@Supports(value={Feature.POOL_STATISTICS})
public class MetricsAccumulator
implements RLBInfo {
    final Frame cumulative = new Frame();
    private RingBuffer<RLBInfo.Frame> history = new RingBuffer();
    private Collection<OracleDatabaseInstanceInfo> racMetadata = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public Frame getCumulative() {
        return this.cumulative;
    }

    @Override
    public Frame getCurrentFrame() {
        List<RLBInfo.Frame> list = this.history.getAsList();
        return list.size() > 0 ? (Frame)list.get(0) : new Frame();
    }

    @Override
    public Frame getPreviousFrame() {
        List<RLBInfo.Frame> list = this.history.getAsList();
        return list.size() > 2 ? (Frame)list.get(1) : new Frame();
    }

    @Override
    public List<RLBInfo.Frame> getReel() {
        return this.history.getAsList();
    }

    @Override
    public Collection<OracleDatabaseInstanceInfo> getInstances() {
        return this.racMetadata;
    }

    public synchronized void newEvent(String serviceName, byte[] eventBody, Collection<OracleDatabaseInstanceInfo> racMetadata) {
        this.racMetadata = racMetadata;
        for (OracleDatabaseInstanceInfo info : racMetadata) {
            if (null == info) continue;
            InstanceStats stats = this.cumulative.getStats(info.getInstanceName());
            stats.total = info.getNumberOfConnectionsCount();
            stats.percent = info.getAdvisoryPercent();
            Frame currentFrame = this.getCurrentFrame();
            if (null == currentFrame) continue;
            stats = (InstanceStats)currentFrame.getStats(info.getInstanceName());
            stats.total = info.getNumberOfConnectionsCount();
            stats.percent = info.getAdvisoryPercent();
        }
        this.history.addItem(new Frame(serviceName, eventBody));
    }

    private void resetCumulative() {
        ClioSupport.ilogWarning(null, null, null, null, "all cumulative RLB counters are reset because long int capacity exhausted");
        this.getCumulative().reset();
    }

    private void resetCurrent() {
        ClioSupport.ilogWarning(null, null, null, null, "all current frame RLB counters are reset because long int capacity exhausted");
        this.getCurrentFrame().reset();
    }

    public synchronized void incrementOpened(OracleUniversalPooledConnection conn) {
        Frame currentFrame;
        String instance = conn.getInstance();
        if (++this.cumulative.getStats((String)instance).created < 0L) {
            this.resetCumulative();
        }
        if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats((String)instance).created < 0L) {
            this.resetCurrent();
        }
    }

    public synchronized void incrementClosed(OracleUniversalPooledConnection conn) {
        Frame currentFrame;
        String instance = conn.getInstance();
        if (++this.cumulative.getStats((String)instance).closed < 0L) {
            this.resetCumulative();
        }
        if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats((String)instance).closed < 0L) {
            this.resetCurrent();
        }
    }

    public synchronized void incrementAborted(OracleUniversalPooledConnection conn) {
        Frame currentFrame;
        String instance = conn.getInstance();
        if (++this.cumulative.getStats((String)instance).aborted < 0L) {
            this.resetCumulative();
        }
        if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats((String)instance).aborted < 0L) {
            this.resetCurrent();
        }
    }

    public synchronized void incrementBorrowed(OracleUniversalPooledConnection conn) {
        String instance = conn.getInstance();
        InstanceStats stats = this.cumulative.getStats(instance);
        if (++stats.borrowed < 0L) {
            this.resetCumulative();
        }
        stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
        Frame currentFrame = this.getCurrentFrame();
        if (null != currentFrame) {
            stats = currentFrame.getStats(instance);
            if (++stats.borrowed < 0L) {
                this.resetCurrent();
            }
            if (++currentFrame.totalBorrowed < 0L) {
                this.resetCurrent();
            }
            stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
            if (null != conn.getRlbBorrowStats()) {
                ClioSupport.ilogWarning(null, null, null, null, "internal error: RLBStatisticsFrame already set");
            }
            conn.setRlbBorrowStats(currentFrame);
        }
    }

    public synchronized void incrementReturned(OracleUniversalPooledConnection conn) {
        String instance = conn.getInstance();
        InstanceStats stats = this.cumulative.getStats(instance);
        if (++stats.returned < 0L) {
            this.resetCumulative();
        }
        stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
        long bs = System.currentTimeMillis() - conn.getBorrowedStartTime();
        stats.timeBorrowedTotal += bs;
        stats.timeBorrowedMin = Math.min(bs, stats.timeBorrowedMin);
        stats.timeBorrowedMax = Math.max(bs, stats.timeBorrowedMax);
        Frame frame = (Frame)conn.getRlbBorrowStats();
        if (null == frame) {
            return;
        }
        conn.setRlbBorrowStats(null);
        stats = frame.getStats(instance);
        if (++stats.returned < 0L) {
            this.resetCurrent();
        }
        stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
        stats.timeBorrowedTotal += bs;
        stats.timeBorrowedMin = Math.min(bs, stats.timeBorrowedMin);
        stats.timeBorrowedMax = Math.max(bs, stats.timeBorrowedMax);
    }

    @DisableTrace
    public synchronized String toString() {
        return "cumulative: " + this.cumulative.toString() + "; delta: " + super.toString();
    }

    @DisableTrace
    public synchronized String toString(int nFrames) {
        return "cumulative: " + this.cumulative.toString() + "; delta: " + this.history.toString(nFrames);
    }

    static {
        try {
            $$$methodRef$$$17 = MetricsAccumulator.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = MetricsAccumulator.class.getDeclaredMethod("getCurrentFrame", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = MetricsAccumulator.class.getDeclaredMethod("getPreviousFrame", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = MetricsAccumulator.class.getDeclaredMethod("toString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = MetricsAccumulator.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = MetricsAccumulator.class.getDeclaredMethod("incrementReturned", OracleUniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = MetricsAccumulator.class.getDeclaredMethod("incrementBorrowed", OracleUniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = MetricsAccumulator.class.getDeclaredMethod("incrementAborted", OracleUniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = MetricsAccumulator.class.getDeclaredMethod("incrementClosed", OracleUniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = MetricsAccumulator.class.getDeclaredMethod("incrementOpened", OracleUniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = MetricsAccumulator.class.getDeclaredMethod("resetCurrent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = MetricsAccumulator.class.getDeclaredMethod("resetCumulative", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = MetricsAccumulator.class.getDeclaredMethod("newEvent", String.class, byte[].class, Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = MetricsAccumulator.class.getDeclaredMethod("getInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = MetricsAccumulator.class.getDeclaredMethod("getReel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = MetricsAccumulator.class.getDeclaredMethod("getPreviousFrame", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = MetricsAccumulator.class.getDeclaredMethod("getCurrentFrame", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = MetricsAccumulator.class.getDeclaredMethod("getCumulative", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    public static class Frame
    implements RLBInfo.Frame {
        final long timestamp = System.currentTimeMillis();
        final String serviceName;
        final byte[] eventBody;
        public long totalBorrowed = 0L;
        public final Map<String, InstanceStats> distribution = new HashMap<String, InstanceStats>();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        Frame() {
            this(null, null);
        }

        Frame(String serviceName, byte[] eventBody) {
            this.serviceName = serviceName;
            this.eventBody = eventBody;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public long getTotalBorrowed() {
            return this.totalBorrowed;
        }

        public synchronized void reset() {
            for (InstanceStats stats : this.distribution.values()) {
                stats.reset();
            }
        }

        @Override
        public synchronized InstanceStats getStats(String instance) {
            InstanceStats stats = this.distribution.get(instance);
            if (null == stats) {
                stats = new InstanceStats();
                this.distribution.put(instance, stats);
            }
            return stats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DisableTrace
        public synchronized String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("timestamp=").append(new Date(this.timestamp)).append(", ");
            if (null != this.serviceName) {
                sb.append("serviceName=").append(this.serviceName).append(", ");
            }
            if (null != this.eventBody) {
                sb.append("eventBody=").append(new String(this.eventBody)).append(", ");
            }
            Frame frame = this;
            synchronized (frame) {
                for (Map.Entry<String, InstanceStats> entry : this.distribution.entrySet()) {
                    sb.append("(instanceName=").append(entry.getKey()).append(entry.getValue()).append(')');
                }
            }
            return sb.toString();
        }

        static {
            try {
                $$$methodRef$$$7 = Frame.class.getDeclaredConstructor(String.class, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = Frame.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = Frame.class.getDeclaredMethod("getStats", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = Frame.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = Frame.class.getDeclaredMethod("getStats", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Frame.class.getDeclaredMethod("reset", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Frame.class.getDeclaredMethod("getTotalBorrowed", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Frame.class.getDeclaredMethod("getTimestamp", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    public static class InstanceStats
    implements RLBInfo.InstanceStats {
        private long created = 0L;
        private long closed = 0L;
        private long aborted = 0L;
        private long borrowed = 0L;
        private long peakBorrowed = 0L;
        private long returned = 0L;
        private int total = 0;
        private long timeBorrowedMin = Long.MAX_VALUE;
        private long timeBorrowedMax = Long.MIN_VALUE;
        private long timeBorrowedTotal = 0L;
        private float percent = 0.0f;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;

        @Override
        public long getConnsCreated() {
            return this.created;
        }

        @Override
        public long getConnsClosed() {
            return this.closed;
        }

        @Override
        public long getConnsAborted() {
            return this.aborted;
        }

        @Override
        public long getConnsBorrowed() {
            return this.borrowed;
        }

        @Override
        public long getConnsBorrowedPeak() {
            return this.peakBorrowed;
        }

        @Override
        public long getConnsReturned() {
            return this.returned;
        }

        @Override
        public long getTimeBorrowedMin() {
            return this.timeBorrowedMin;
        }

        @Override
        public long getTimeBorrowedMax() {
            return this.timeBorrowedMax;
        }

        @Override
        public long getTimeBorrowedTotal() {
            return this.timeBorrowedTotal;
        }

        public int getConnsTotal() {
            return this.total;
        }

        public float getAdvisoryPercent() {
            return this.percent;
        }

        public synchronized void reset() {
            this.returned = 0L;
            this.borrowed = 0L;
            this.aborted = 0L;
            this.closed = 0L;
            this.created = 0L;
            this.total = 0;
            this.percent = 0.0f;
        }

        @DisableTrace
        public synchronized String toString() {
            long timeBorrowedAverage = 0L == this.returned ? 0L : this.timeBorrowedTotal / this.returned;
            return " created=" + this.created + " closed=" + this.closed + " aborted=" + this.aborted + " borrowed=" + this.borrowed + " peakBorrowed=" + this.peakBorrowed + " timeBorrowedMin=" + this.timeBorrowedMin + " timeBorrowedMax=" + this.timeBorrowedMax + " timeBorrowedAverage=" + timeBorrowedAverage + " returned=" + this.returned + " total=" + this.total + " percent=" + this.percent;
        }

        static {
            try {
                $$$methodRef$$$13 = InstanceStats.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$12 = InstanceStats.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$11 = InstanceStats.class.getDeclaredMethod("reset", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$10 = InstanceStats.class.getDeclaredMethod("getAdvisoryPercent", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = InstanceStats.class.getDeclaredMethod("getConnsTotal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = InstanceStats.class.getDeclaredMethod("getTimeBorrowedTotal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = InstanceStats.class.getDeclaredMethod("getTimeBorrowedMax", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = InstanceStats.class.getDeclaredMethod("getTimeBorrowedMin", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = InstanceStats.class.getDeclaredMethod("getConnsReturned", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = InstanceStats.class.getDeclaredMethod("getConnsBorrowedPeak", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = InstanceStats.class.getDeclaredMethod("getConnsBorrowed", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = InstanceStats.class.getDeclaredMethod("getConnsAborted", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = InstanceStats.class.getDeclaredMethod("getConnsClosed", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = InstanceStats.class.getDeclaredMethod("getConnsCreated", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

