/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool.kdtree;

import java.lang.reflect.Executable;
import java.util.Objects;
import java.util.logging.Logger;

public class Range {
    private final boolean infinite;
    private final Comparable<?> low;
    private final Comparable<?> high;
    private int hashCode;
    public static final Range INFINITE;
    private static final String IR = "infinite range";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public Range(Comparable<?> low, Comparable<?> high) {
        this.infinite = false;
        this.low = low;
        this.high = high;
        this.hashCode = Objects.hash(low, high, this.infinite);
        if (!low.getClass().equals(high.getClass())) {
            throw new IllegalArgumentException("incompatible coordinates");
        }
    }

    public Range(Comparable<?> coord) {
        this(coord, coord);
    }

    private Range() {
        this.high = IR;
        this.low = IR;
        this.infinite = true;
    }

    public Comparable<?> low() {
        if (this.infinite) {
            throw new IllegalStateException(IR);
        }
        return this.low;
    }

    public Comparable<?> high() {
        if (this.infinite) {
            throw new IllegalStateException(IR);
        }
        return this.high;
    }

    public boolean infinite() {
        return this.infinite;
    }

    public String toString() {
        if (this.infinite()) {
            return "[INFINITE]";
        }
        return "[" + this.low + ", " + this.high + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object thatObj) {
        if (null != thatObj && thatObj instanceof Range) {
            Range that = (Range)thatObj;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            return Objects.equals(this.low, that.low) && Objects.equals(this.high, that.high) && Objects.equals(this.infinite, that.infinite);
        }
        return false;
    }

    static {
        try {
            $$$methodRef$$$8 = Range.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = Range.class.getDeclaredConstructor(Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = Range.class.getDeclaredConstructor(Comparable.class, Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = Range.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = Range.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Range.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Range.class.getDeclaredMethod("infinite", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Range.class.getDeclaredMethod("high", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Range.class.getDeclaredMethod("low", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        INFINITE = new Range();
    }
}

