/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.oracle.OracleConnectionProxyFactory;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OraclePooledConnectionConnectionPool
extends OracleJDBCConnectionPool
implements ConnectionEventListener {
    private final ConnectionProxyFactory cpf = new OracleConnectionProxyFactory();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public OraclePooledConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    public PooledConnection getPooledConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        PooledConnection pc = (PooledConnection)this.borrowConnection(connectionRetrievalInfo).getPhysicalConnection();
        return pc;
    }

    public boolean returnPooledConnection(PooledConnection pooledConnection) throws UniversalConnectionPoolException {
        return this.returnUsedPhysicalConnection(pooledConnection);
    }

    public boolean closePooledConnection(PooledConnection pooledConnection) throws UniversalConnectionPoolException {
        return this.closeUsedPhysicalConnection(pooledConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardConnection(ConnectionEvent event) {
        PooledConnection jdbcPooledConnection = (PooledConnection)event.getSource();
        if (jdbcPooledConnection != null) {
            jdbcPooledConnection.removeConnectionEventListener(this);
            OraclePooledConnectionConnectionPool oraclePooledConnectionConnectionPool = this;
            synchronized (oraclePooledConnectionConnectionPool) {
                this.discardUsedConnection(jdbcPooledConnection);
            }
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        ClioSupport.ilogFinest(null, null, null, null, "Connection-closed event raised: " + event);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        this.discardConnection(event);
    }

    @Override
    protected ConnectionProxyFactory getProxyFactory() {
        return this.cpf;
    }

    static {
        try {
            $$$methodRef$$$7 = OraclePooledConnectionConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = OraclePooledConnectionConnectionPool.class.getDeclaredMethod("getProxyFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = OraclePooledConnectionConnectionPool.class.getDeclaredMethod("connectionErrorOccurred", ConnectionEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = OraclePooledConnectionConnectionPool.class.getDeclaredMethod("connectionClosed", ConnectionEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = OraclePooledConnectionConnectionPool.class.getDeclaredMethod("discardConnection", ConnectionEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = OraclePooledConnectionConnectionPool.class.getDeclaredMethod("closePooledConnection", PooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = OraclePooledConnectionConnectionPool.class.getDeclaredMethod("returnPooledConnection", PooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = OraclePooledConnectionConnectionPool.class.getDeclaredMethod("getPooledConnection", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

