/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Pattern;
import oracle.ucp.common.ConnectionCreationBroker;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.Strings;

public class Util {
    static final String CLASS_NAME = Util.class.getName();
    static final Pattern onsMaskPattern = Pattern.compile("(walletfile=|walletpassword=).*(\n|$)");
    public static int PLANNED_DRAINING_INTERVAL = 5;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final long DEFAULT_RLB_GRAVITATION_INOPERABLE_PERIOD = 60L;

    public static boolean sameOrEqual(Object o1, Object o2) {
        return o1 == o2 || null != o1 && o1.equals(o2);
    }

    public static String maskONSConfigurationString(String onsConfigStr) {
        return onsConfigStr == null || "".equals(onsConfigStr) ? "" : onsMaskPattern.matcher(onsConfigStr).replaceAll("*****");
    }

    private static String readSystemPropertyAsString(String properyName, String defaultValue) {
        Objects.requireNonNull(properyName);
        String dv = null == defaultValue ? null : defaultValue.trim();
        try {
            PrivilegedExceptionAction<String> readAction = () -> System.getProperty(properyName.trim(), dv);
            String result = AccessController.doPrivileged(readAction);
            if (null != result) {
                return result.trim();
            }
            return null;
        }
        catch (PrivilegedActionException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "readSystemPropertyAsString", "failed to read system property", null, e, new Object[0]);
            return dv;
        }
    }

    private static Boolean readSystemPropertyAsBoolean(String properyName, boolean defaultValue) {
        String dv = Boolean.toString(defaultValue);
        return new Boolean(Util.readSystemPropertyAsString(properyName, dv));
    }

    public static boolean createConnectionInBorrowThread() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.createConnectionInBorrowThread", false);
    }

    public static boolean isAffinityStrict() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.jdbc.oracle.affinity.strict", false);
    }

    public static int getMaxInitThreads() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Math.max(0, Integer.parseInt(System.getProperty("oracle.ucp.MaxInitThreads", "4").trim()));
                }
            });
        }
        catch (PrivilegedActionException e) {
            return 4;
        }
    }

    public static boolean isPreWLS1212Compatible() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.PreWLS1212Compatible", false);
    }

    public static long getConnectionCreationRetryDelay() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() {
                    return Long.parseUnsignedLong(System.getProperty("oracle.ucp.ConnectionCreationRetryDelay", ConnectionCreationBroker.MAX_INTERVAL.toString()));
                }
            });
        }
        catch (PrivilegedActionException e) {
            return ConnectionCreationBroker.MAX_INTERVAL;
        }
    }

    public static void disableDriverHA() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    return System.setProperty("oracle.jdbc.fanEnabled", "false");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public static void disableImplicitBeginRequest() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    return System.setProperty("oracle.jdbc.beginRequestAtConnectionCreation", "false");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public static String getXMLConfigurationFilePath() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() {
                return System.getProperty("oracle.ucp.jdbc.xmlConfigFile");
            }
        });
    }

    public static boolean isDestroyOnReloadEnabled() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.destroyOnReload", false);
    }

    public static boolean simulateAsyncBorrow() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.imitateAsyncBorrow", false);
    }

    public static boolean equalsNormalized(String item1, String item2) {
        if (null == item1) {
            return null == item2;
        }
        if (null == item2) {
            return false;
        }
        return item1.trim().toLowerCase().equals(item2.trim().toLowerCase());
    }

    public static boolean isSelfTunerEnabled() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.selftuning", false);
    }

    public static boolean isJTASupportForWLSEnabled() {
        boolean enabled = Util.readSystemPropertyAsBoolean("oracle.ucp.wls.jta", true);
        if (enabled) {
            try {
                Class.forName("weblogic.transaction.TransactionManager");
            }
            catch (Throwable err) {
                enabled = false;
                DiagnosticsCollectorImpl.getCommon().debug(Level.FINE, CLASS_NAME, "isJTASupportForWLSEnabled", "========= WebLogic TransactionManager is not on the classpath, JTA/XA support for WLS is disabled, {0}", (String)null, (Throwable)null, err);
            }
        }
        return enabled;
    }

    public static boolean timersAffectAllConnections() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.timersAffectAllConnections", false);
    }

    public static boolean isTraceEnabled() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.diagnostic.enableTrace", true);
    }

    public static boolean isLoggingEnabled() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.diagnostic.enableLogging", false);
    }

    public static int getBufferSize() {
        try {
            int size = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        return Integer.parseInt(System.getProperty("oracle.ucp.diagnostic.bufferSize", Integer.toString(1024)).trim());
                    }
                    catch (NumberFormatException e) {
                        return 1024;
                    }
                }
            });
            return size > 0 ? size : 1024;
        }
        catch (PrivilegedActionException e) {
            return 1024;
        }
    }

    public static Level getLoggingLevel() {
        return Util.getLoggingLevel(Level.INFO);
    }

    public static Level getLoggingLevel(final Level defaultLevel) {
        assert (null != defaultLevel);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Level>(){

                @Override
                public Level run() {
                    try {
                        String sLevel = System.getProperty("oracle.ucp.diagnostic.loggingLevel", defaultLevel.toString()).trim().toUpperCase();
                        assert (!Strings.isNullOrEmpty(sLevel));
                        return Level.parse(sLevel);
                    }
                    catch (IllegalArgumentException e) {
                        return defaultLevel;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            return defaultLevel;
        }
    }

    public static String getLoggingConfigFileName() {
        return Util.readSystemPropertyAsString("java.util.logging.config.file", "");
    }

    public static void setLoggingConfigFileName(final String filename) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("java.util.logging.config.file", Objects.requireNonNull(filename));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public static String getErrorCodesToWatchList() {
        return Util.readSystemPropertyAsString("oracle.ucp.diagnostic.errorCodesToWatchList", "[ \"oracle.ucp.UniversalConnectionPoolException:45054,45065,45067\", \"java.sql.SQLException:12521,12514,12757,12523\", \"java.lang.IllegalStateException\", \"java.lang.NullPointerException\" ]");
    }

    public static boolean isShutdownHookEnabled() {
        return Util.readSystemPropertyAsBoolean("oracle.ucp.enableShutdownHook", true);
    }

    public static long getRLBGravitationInoperablePeriod() {
        try {
            long timeout = AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() {
                    try {
                        return Long.parseLong(System.getProperty("oracle.ucp.RLBInoperabilityTimeout", Long.toString(60L)).trim());
                    }
                    catch (NumberFormatException e) {
                        return 60L;
                    }
                }
            });
            return timeout > 0L ? timeout : 60L;
        }
        catch (PrivilegedActionException e) {
            return 60L;
        }
    }

    public static Class<?> getClassForName(String name, boolean initialize, ClassLoader ... classLoaders) throws ClassNotFoundException {
        if (0 == classLoaders.length) {
            throw new IllegalArgumentException("no class loader specified");
        }
        ClassNotFoundException latest = null;
        for (ClassLoader cl : classLoaders) {
            try {
                return Class.forName(name, initialize, cl);
            }
            catch (ClassNotFoundException e) {
                latest = e;
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINE, CLASS_NAME, "getClassForName", "unsuccessful attempt to load class {0} with loader {1}", null, null, name, cl.toString());
            }
        }
        if (null != latest) {
            throw latest;
        }
        return null;
    }
}

