/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;
import oracle.ucp.util.RingBuffer;

public class MetricsAccumulator
implements RLBInfo {
    static final String CLASS_NAME = MetricsAccumulator.class.getName();
    final Frame cumulative = new Frame();
    private RingBuffer<RLBInfo.Frame> history = new RingBuffer();
    private Collection<OracleDatabaseInstanceInfo> racMetadata = null;

    public Frame getCumulative() {
        return this.cumulative;
    }

    @Override
    public Frame getCurrentFrame() {
        List<RLBInfo.Frame> list = this.history.getAsList();
        return list.size() > 0 ? (Frame)list.get(0) : new Frame();
    }

    @Override
    public Frame getPreviousFrame() {
        List<RLBInfo.Frame> list = this.history.getAsList();
        return list.size() > 2 ? (Frame)list.get(1) : new Frame();
    }

    @Override
    public List<RLBInfo.Frame> getReel() {
        return this.history.getAsList();
    }

    @Override
    public Collection<OracleDatabaseInstanceInfo> getInstances() {
        return this.racMetadata;
    }

    public synchronized void newEvent(String serviceName, byte[] eventBody, Collection<OracleDatabaseInstanceInfo> racMetadata) {
        this.racMetadata = racMetadata;
        for (OracleDatabaseInstanceInfo info : racMetadata) {
            if (null == info) continue;
            InstanceStats stats = this.cumulative.getStats(info.getInstanceName());
            stats.total = info.getNumberOfConnectionsCount();
            stats.percent = info.getAdvisoryPercent();
            Frame currentFrame = this.getCurrentFrame();
            if (null == currentFrame) continue;
            stats = (InstanceStats)currentFrame.getStats(info.getInstanceName());
            stats.total = info.getNumberOfConnectionsCount();
            stats.percent = info.getAdvisoryPercent();
        }
        this.history.addItem(new Frame(serviceName, eventBody));
    }

    private void resetCumulative() {
        assert (false) : "all cumulative RLB counters are reset because long int capacity exhausted";
        this.getCumulative().reset();
    }

    private void resetCurrent() {
        assert (false) : "all current frame RLB counters are reset because long int capacity exhausted";
        this.getCurrentFrame().reset();
    }

    public synchronized void incrementOpened(OracleUniversalPooledConnection conn) {
        Frame currentFrame;
        String instance = conn.getInstance();
        if (++this.cumulative.getStats(instance).created < 0L) {
            this.resetCumulative();
        }
        if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats(instance).created < 0L) {
            this.resetCurrent();
        }
    }

    public synchronized void incrementClosed(OracleUniversalPooledConnection conn) {
        Frame currentFrame;
        String instance = conn.getInstance();
        if (++this.cumulative.getStats(instance).closed < 0L) {
            this.resetCumulative();
        }
        if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats(instance).closed < 0L) {
            this.resetCurrent();
        }
    }

    public synchronized void incrementAborted(OracleUniversalPooledConnection conn) {
        Frame currentFrame;
        String instance = conn.getInstance();
        if (++this.cumulative.getStats(instance).aborted < 0L) {
            this.resetCumulative();
        }
        if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats(instance).aborted < 0L) {
            this.resetCurrent();
        }
    }

    public synchronized void incrementBorrowed(OracleUniversalPooledConnection conn) {
        String instance = conn.getInstance();
        InstanceStats stats = this.cumulative.getStats(instance);
        if (++stats.borrowed < 0L) {
            this.resetCumulative();
        }
        stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
        Frame currentFrame = this.getCurrentFrame();
        if (null != currentFrame) {
            stats = currentFrame.getStats(instance);
            if (++stats.borrowed < 0L) {
                this.resetCurrent();
            }
            if (++currentFrame.totalBorrowed < 0L) {
                this.resetCurrent();
            }
            stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
            if (null != conn.getRlbBorrowStats()) {
                throw new IllegalStateException("internal error: RLBStatisticsFrame already set");
            }
            conn.setRlbBorrowStats(currentFrame);
        }
    }

    public synchronized void incrementReturned(OracleUniversalPooledConnection conn) {
        String instance = conn.getInstance();
        InstanceStats stats = this.cumulative.getStats(instance);
        if (++stats.returned < 0L) {
            this.resetCumulative();
        }
        stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
        long bs = System.currentTimeMillis() - conn.getBorrowedStartTime();
        InstanceStats instanceStats = stats;
        instanceStats.timeBorrowedTotal = instanceStats.timeBorrowedTotal + bs;
        stats.timeBorrowedMin = Math.min(bs, stats.timeBorrowedMin);
        stats.timeBorrowedMax = Math.max(bs, stats.timeBorrowedMax);
        Frame frame = (Frame)conn.getRlbBorrowStats();
        if (null == frame) {
            return;
        }
        conn.setRlbBorrowStats(null);
        stats = frame.getStats(instance);
        if (++stats.returned < 0L) {
            this.resetCurrent();
        }
        stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
        InstanceStats instanceStats2 = stats;
        instanceStats2.timeBorrowedTotal = instanceStats2.timeBorrowedTotal + bs;
        stats.timeBorrowedMin = Math.min(bs, stats.timeBorrowedMin);
        stats.timeBorrowedMax = Math.max(bs, stats.timeBorrowedMax);
    }

    public synchronized String toString() {
        return "cumulative: " + this.cumulative.toString() + "; delta: " + super.toString();
    }

    public synchronized String toString(int nFrames) {
        return "cumulative: " + this.cumulative.toString() + "; delta: " + this.history.toString(nFrames);
    }

    public static class Frame
    implements RLBInfo.Frame {
        final long timestamp = System.currentTimeMillis();
        final String serviceName;
        final byte[] eventBody;
        public long totalBorrowed = 0L;
        public final Map<String, InstanceStats> distribution = new HashMap<String, InstanceStats>();

        Frame() {
            this(null, null);
        }

        Frame(String serviceName, byte[] eventBody) {
            this.serviceName = serviceName;
            this.eventBody = eventBody;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public long getTotalBorrowed() {
            return this.totalBorrowed;
        }

        public synchronized void reset() {
            for (InstanceStats stats : this.distribution.values()) {
                stats.reset();
            }
        }

        @Override
        public synchronized InstanceStats getStats(String instance) {
            InstanceStats stats = this.distribution.get(instance);
            if (null == stats) {
                stats = new InstanceStats();
                this.distribution.put(instance, stats);
            }
            return stats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("timestamp=").append(new Date(this.timestamp)).append(", ");
            if (null != this.serviceName) {
                sb.append("serviceName=").append(this.serviceName).append(", ");
            }
            if (null != this.eventBody) {
                sb.append("eventBody=").append(new String(this.eventBody)).append(", ");
            }
            Frame frame = this;
            synchronized (frame) {
                for (Map.Entry<String, InstanceStats> entry : this.distribution.entrySet()) {
                    sb.append("(instanceName=").append(entry.getKey()).append(entry.getValue()).append(')');
                }
            }
            return sb.toString();
        }
    }

    public static class InstanceStats
    implements RLBInfo.InstanceStats {
        private long created = 0L;
        private long closed = 0L;
        private long aborted = 0L;
        private long borrowed = 0L;
        private long peakBorrowed = 0L;
        private long returned = 0L;
        private int total = 0;
        private long timeBorrowedMin = Long.MAX_VALUE;
        private long timeBorrowedMax = Long.MIN_VALUE;
        private long timeBorrowedTotal = 0L;
        private float percent = 0.0f;

        @Override
        public long getConnsCreated() {
            return this.created;
        }

        @Override
        public long getConnsClosed() {
            return this.closed;
        }

        @Override
        public long getConnsAborted() {
            return this.aborted;
        }

        @Override
        public long getConnsBorrowed() {
            return this.borrowed;
        }

        @Override
        public long getConnsBorrowedPeak() {
            return this.peakBorrowed;
        }

        @Override
        public long getConnsReturned() {
            return this.returned;
        }

        @Override
        public long getTimeBorrowedMin() {
            return this.timeBorrowedMin;
        }

        @Override
        public long getTimeBorrowedMax() {
            return this.timeBorrowedMax;
        }

        @Override
        public long getTimeBorrowedTotal() {
            return this.timeBorrowedTotal;
        }

        public int getConnsTotal() {
            return this.total;
        }

        public float getAdvisoryPercent() {
            return this.percent;
        }

        public synchronized void reset() {
            this.returned = 0L;
            this.borrowed = 0L;
            this.aborted = 0L;
            this.closed = 0L;
            this.created = 0L;
            this.total = 0;
            this.percent = 0.0f;
        }

        public synchronized String toString() {
            long timeBorrowedAverage = 0L == this.returned ? 0L : this.timeBorrowedTotal / this.returned;
            return " created=" + this.created + " closed=" + this.closed + " aborted=" + this.aborted + " borrowed=" + this.borrowed + " peakBorrowed=" + this.peakBorrowed + " timeBorrowedMin=" + this.timeBorrowedMin + " timeBorrowedMax=" + this.timeBorrowedMax + " timeBorrowedAverage=" + timeBorrowedAverage + " returned=" + this.returned + " total=" + this.total + " percent=" + this.percent;
        }
    }
}

