/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.ShardConnectionStatistics;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.CoreConnectionImpl;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CriStats;
import oracle.ucp.common.CriStatsRegistry;
import oracle.ucp.common.Database;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.Limits;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.common.WLSJTAPlugin;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.util.Strings;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public abstract class Topology
extends Database {
    static final String CLASS_NAME = Topology.class.getName();
    private volatile Service defaultService = null;
    private final Map<String, Service> fullNameToService = new ConcurrentHashMap<String, Service>();
    private final Map<String, Service> logicalNameToService = new ConcurrentHashMap<String, Service>();
    private final AtomicReference<ONSDriver> onsDriver = new AtomicReference<Object>(null);
    private boolean onsStarted = false;
    private boolean isShardedDatabase = false;
    private boolean isCatalogDatabase = false;
    private boolean isMultitenantDatabase = false;
    private boolean isRacDataAffinityEnabled = false;
    private boolean isDataDependentRoutingEnabled = false;
    private final AtomicBoolean fanHeuristicallyEnabled = new AtomicBoolean(false);
    private volatile long outboundConnectTimeout = 0L;
    protected boolean replayable = false;
    private final CriStatsRegistry criStatsRegistry = new CriStatsRegistry();
    final LongAdder cumulativeConnectionCreationAttemts = new LongAdder();
    final LongAdder connectionCreationAttemtsSinceLastOutage = new LongAdder();

    @Override
    public Service getServiceByName(String serviceName) {
        if (Strings.isNullOrEmpty(serviceName)) {
            return this.defaultService;
        }
        String lowerServiceName = serviceName.toLowerCase();
        Service service = this.fullNameToService.get(lowerServiceName);
        if (null != service) {
            return service;
        }
        return this.logicalNameToService.get(lowerServiceName);
    }

    Topology(Diagnosable diagnosticsCollector) {
        super(diagnosticsCollector);
    }

    protected abstract String getONSConfig() throws UniversalConnectionPoolException;

    protected abstract AtomicLong cumulativeConnectionUseTime();

    public abstract Limits limits();

    protected abstract boolean shardingMode();

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public CoreConnection create(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback, EnumSet<ConnectionSource.CreateMode> enumSet, long l) throws UniversalConnectionPoolException {
        try {
            void createModes;
            void affinityCallback;
            JDBCConnectionRetrievalInfo jdbcCri;
            Service requestedService;
            void cri;
            long timeToRetry;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "create", "entering args ({0}, {1}, {2}, {3})", null, null, connectionRetrievalInfo, connectionAffinityCallback, enumSet, l);
            timeToRetry = Math.max(0L, timeToRetry);
            if (Objects.nonNull(cri) && cri instanceof JDBCConnectionRetrievalInfo) {
                requestedService = this.getServiceByName(((JDBCConnectionRetrievalInfo)cri).getServiceName());
                assert (null != requestedService);
                jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            } else {
                requestedService = this.defaultService;
                jdbcCri = null;
            }
            if (requestedService == null) {
                throw UCPErrorHandler.newUniversalConnectionPoolException(204, "Unknown service " + requestedService.getFullServiceName());
            }
            CoreConnection conn = requestedService.create((ConnectionRetrievalInfo)cri, (ConnectionAffinityCallback)affinityCallback, (EnumSet<ConnectionSource.CreateMode>)createModes, timeToRetry);
            if (null == conn) {
                CoreConnection coreConnection = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "create", "returning {0}", null, null, coreConnection);
                return coreConnection;
            }
            Service connService = conn.service();
            if (jdbcCri != null) {
                if (jdbcCri.getUserRequestedServiceName() == null && !requestedService.equals(connService)) {
                    if (!this.failoverEnabled() || this.defaultService.activeMembers.get() == 0 && connService.activeMembers.get() == 1) {
                        this.defaultService = conn.service();
                    }
                } else if (jdbcCri.getUserRequestedServiceName() != null && !requestedService.equals(connService)) {
                    conn.close();
                    throw UCPErrorHandler.newUniversalConnectionPoolException(204, "Unknown service " + requestedService.getFullServiceName());
                }
            }
            CoreConnection coreConnection = conn;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "create", "returning {0}", null, null, coreConnection);
            return coreConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "create", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void start(ConnectionRetrievalInfo connectionRetrievalInfo, Consumer<String> consumer, Consumer<CoreConnection> consumer2) throws UniversalConnectionPoolException {
        try {
            void cri;
            void serviceNameConsumer;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "start", "entering args ({0}, {1}, {2})", null, null, connectionRetrievalInfo, consumer, consumer2);
            if (!this.isOracle()) {
                this.trace(Level.FINEST, CLASS_NAME, "start", "non-oracle case, no metadata connection needed", null, null, new Object[0]);
                serviceNameConsumer.accept("");
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "start", "returning void", null, null, new Object[0]);
                return;
            }
            this.trace(Level.FINEST, CLASS_NAME, "start", "oracle case, metadata connection will be attempted to be created", null, null, new Object[0]);
            Util.disableDriverHA();
            Util.disableImplicitBeginRequest();
            UniversalPooledConnection upc = null;
            try {
                upc = this.createPooledConnection((ConnectionRetrievalInfo)cri);
                assert (Objects.nonNull(upc));
                if (!(upc instanceof OracleUniversalPooledConnection)) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "start", "returning void", null, null, new Object[0]);
                    return;
                }
                OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)upc;
                boolean[] shardingMode = oupc.getShardingMode();
                this.isShardedDatabase = shardingMode[0];
                if (this.isShardedDatabase && !this.shardingMode()) {
                    this.isShardedDatabase = false;
                }
                this.isCatalogDatabase = shardingMode[1];
                this.isMultitenantDatabase = oupc.isMultitenantDatabase();
                this.isRacDataAffinityEnabled = shardingMode[2];
                this.isDataDependentRoutingEnabled = this.isShardedDatabase | this.isRacDataAffinityEnabled;
                this.enableFANHeuristically(oupc);
                Connection conn = oupc.getSQLConnection(oupc.getPhysicalConnection());
                OracleConnection oconn = conn.unwrap(OracleConnection.class);
                this.outboundConnectTimeout = oconn.getOutboundConnectTimeout();
                this.trace(Level.FINE, CLASS_NAME, "start", "outbound connection timeout is {0} seconds", null, null, this.outboundConnectTimeout);
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "start", "failed to read database metadata", null, e, new Object[0]);
                throw new UniversalConnectionPoolException(e);
            }
            finally {
                if (Objects.nonNull(upc)) {
                    void connectionConsumer;
                    UniversalPooledConnectionImpl upci = (UniversalPooledConnectionImpl)upc;
                    String fullServiceName = upci.getService();
                    if (Objects.nonNull(serviceNameConsumer) && Objects.nonNull(fullServiceName)) {
                        serviceNameConsumer.accept(fullServiceName);
                    }
                    if (Objects.nonNull(connectionConsumer) && Objects.nonNull(fullServiceName)) {
                        Service svc = this.getServiceByName(fullServiceName);
                        upci.setConnectionRetrievalInfo(this.newCri((ConnectionRetrievalInfo)cri, svc.getLogicalServiceName()));
                        upc.plugDelegator(CoreConnectionImpl.create(svc, upc, this.getDiagnosable()));
                        connectionConsumer.accept(upc.getDelegator());
                    } else {
                        this.connectionsCreated().decrementAndGet();
                        ((UniversalPooledConnectionImpl)upc).closeNoStatsUpdate();
                    }
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "start", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "start", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private ConnectionRetrievalInfo newCri(ConnectionRetrievalInfo cri, String serviceName) {
        ConnectionRetrievalInfo noLabelsCopyCri = cri.getCopyWithNoLabels();
        return noLabelsCopyCri instanceof JDBCConnectionRetrievalInfo ? ((JDBCConnectionRetrievalInfo)noLabelsCopyCri).getCopyWithService(serviceName) : noLabelsCopyCri;
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void stop() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "stop", "entering args ()", null, null, new Object[0]);
            if (null != this.onsDriver.getAndSet(null)) {
                this.onsStarted = false;
                this.fullNameToService.values().forEach(service -> {
                    service.stop();
                    service.routingCache().destroy();
                });
            }
            this.fullNameToService.clear();
            this.logicalNameToService.clear();
            this.defaultService = null;
            this.fanHeuristicallyEnabled.set(false);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "stop", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "stop", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean isReplayable() {
        return this.replayable;
    }

    @Override
    public void setReplayable(boolean isReplayable) {
        this.replayable = isReplayable;
    }

    @Override
    public LoadBalancer.Stats loadBalancerStats(String serviceName) {
        Service service = null == serviceName ? this.defaultService : this.getServiceByName(serviceName);
        if (null != service) {
            return service.loadBalancerStats();
        }
        return new LoadBalancer.Stats();
    }

    @Override
    public FailoverDriver.Stats failoverDriverStats(String serviceName) {
        Service service = null == serviceName ? this.defaultService : this.getServiceByName(serviceName);
        if (null != service) {
            return service.failoverDriverStats();
        }
        return new FailoverDriver.Stats();
    }

    @Override
    public String getColocationStats(String serviceName) {
        StringBuilder sb = new StringBuilder();
        sb.append("[isRacDataAffinityEnabled: ").append(this.isRacDataAffinityEnabled()).append(", isDataDependentRoutingEnabled: ").append(this.isDataDependentRoutingEnabled()).append(", isRLBEnabled: ").append(this.defaultService.isRLBEnabled()).append(", allow INSTANCE_NAME at connection creations: ").append(this.defaultService.allowInstanceNameAtConnect()).append("]");
        return sb.toString();
    }

    @Override
    public Predicate<CoreConnection> loadBalancedBorrowSelector(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback) {
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            Service service = this.getServiceByName(jdbcCri.getServiceName());
            assert (null != service);
            return service.loadBalancedBorrowSelector(cri, affinityCallback);
        }
        return p -> true;
    }

    @Override
    public Predicate<CoreConnection> routingKeyBasedBorrowSelector(ConnectionRetrievalInfo cri, boolean usePriority) {
        assert (cri instanceof JDBCConnectionRetrievalInfo);
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (this.isDataDependentRoutingEnabled()) {
            Service service = this.getServiceByName(jdbcCri.getServiceName());
            assert (null != service);
            DataDependentRoutingCache routingCache = service.routingCache();
            if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
                return p -> true;
            }
            OracleShardingKey key = jdbcCri.getShardingKey();
            if (key == null) {
                return p -> true;
            }
            HashSet<ServiceMember> instanceSet = new HashSet<ServiceMember>();
            ServiceMember xaInstance = WLSJTAPlugin.getXAInstance();
            if (xaInstance != null) {
                instanceSet.add(xaInstance);
            } else if (usePriority) {
                instanceSet.addAll(routingCache.allPriorityInstances(cri));
            } else {
                instanceSet.addAll(routingCache.allInstances(cri));
            }
            return conn -> routingCache.selected((CoreConnection)conn, (Set<ServiceMember>)instanceSet);
        }
        return p -> true;
    }

    @Override
    public String serviceName(ConnectionRetrievalInfo cri) {
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            return ((JDBCConnectionRetrievalInfo)cri).getServiceName();
        }
        return this.defaultService.getFullServiceName();
    }

    @Override
    public String defaultServiceName() {
        Service service = this.defaultService;
        if (Objects.isNull(service)) {
            return "";
        }
        return service.getLogicalServiceName();
    }

    public ONSDriver onsDriver(String onsConfig) throws UniversalConnectionPoolException {
        if (this.onsDriver.compareAndSet(null, ONSDriver.instance())) {
            ONSDriver onsDrvr = this.onsDriver.get();
            this.onsStarted = onsDrvr.start(onsConfig);
        }
        if (this.onsStarted) {
            return this.onsDriver.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void registerService(String string, ConnectionSource.FailoverCallback failoverCallback, ConnectionSource.RebalanceCallback rebalanceCallback) {
        try {
            void rebalanceCallback2;
            void failoverCallback2;
            void fullServiceName;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "registerService", "entering args ({0}, {1}, {2})", null, null, string, failoverCallback, rebalanceCallback);
            if (Objects.isNull(fullServiceName)) {
                throw new IllegalArgumentException("internal error: fullServiceName is null");
            }
            Service resService = this.fullNameToService.computeIfAbsent(fullServiceName.toLowerCase(), arg_0 -> this.lambda$registerService$6((ConnectionSource.FailoverCallback)failoverCallback2, (ConnectionSource.RebalanceCallback)rebalanceCallback2, arg_0));
            this.logicalNameToService.computeIfAbsent(resService.getLogicalServiceName(), p -> resService);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "registerService", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "registerService", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public boolean isServiceRegistered(String serviceName) {
        return null != this.getServiceByName(serviceName);
    }

    @Override
    @Deprecated
    public Predicate<CoreConnection> serviceSelector(String serviceName) {
        Service service = this.getServiceByName(serviceName);
        assert (Objects.nonNull(service));
        return this.serviceSelector(service);
    }

    public Predicate<CoreConnection> serviceSelector(Service service) {
        assert (Objects.nonNull(service));
        return conn -> {
            Service connService = conn.service();
            assert (Objects.nonNull(connService));
            return connService.equals(service);
        };
    }

    @Override
    public boolean isShardedDatabase() {
        return this.isShardedDatabase;
    }

    @Override
    public boolean isCatalogDatabase() {
        return this.isCatalogDatabase;
    }

    @Override
    public boolean isMultitenantDatabase() {
        return this.isMultitenantDatabase;
    }

    @Override
    public boolean isRacDataAffinityEnabled() {
        return this.isRacDataAffinityEnabled && !this.isColocation();
    }

    boolean isDataDependentRoutingEnabled() {
        return this.isDataDependentRoutingEnabled && !this.isColocation();
    }

    @Override
    public boolean validateCri(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return true;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        Service service = this.getServiceByName(jdbcCri.getServiceName());
        if (Objects.isNull(service)) {
            return false;
        }
        if (this.isDataDependentRoutingEnabled()) {
            return service.routingCache().validateCri(jdbcCri);
        }
        return true;
    }

    @Override
    public boolean available(ConnectionRetrievalInfo cri) {
        assert (cri instanceof JDBCConnectionRetrievalInfo);
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        Service service = this.getServiceByName(jdbcCri.getServiceName());
        if (service == null) {
            return false;
        }
        CriStats criMetadata = this.getCriMetadata(cri);
        if ((long)(criMetadata.totalConnCount().get() - criMetadata.borrowedConnCount().get()) - criMetadata.getBorrowSemaphore().getWaitingAcquires() <= 0L) {
            return false;
        }
        if (this.isShardedDatabase) {
            Set<ServiceMember> matchingShardInstances = service.routingCache().allInstances(cri);
            for (ServiceMember inst : matchingShardInstances) {
                if (inst.activeCount.get() - inst.borrowedCount.get() <= 0) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Predicate<CoreConnection> serviceBasedRepurposeSelector(ConnectionRetrievalInfo cri, boolean balanced) {
        if (null == cri) {
            return p -> true;
        }
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            Service service = this.getServiceByName(jdbcCri.getServiceName());
            assert (Objects.nonNull(service));
            return service.serviceBasedRepurposeSelector(cri, balanced);
        }
        return p -> true;
    }

    String getDatabaseTopologyInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.fullNameToService.isEmpty()) {
            sb.append("[]");
        } else {
            for (Service svc : this.fullNameToService.values()) {
                sb.append("[service name=").append(svc.getFullServiceName()).append(": insts=").append(svc.getAllMembers()).append("]");
            }
        }
        return sb.toString();
    }

    String getShardedDatabaseInfo() {
        StringBuffer infoStr = new StringBuffer();
        if (this.isDataDependentRoutingEnabled() && Objects.nonNull(this.defaultService)) {
            infoStr.append(this.defaultService.routingCache().metadataInfo());
        } else {
            infoStr.append("not populated or not connected");
        }
        return infoStr.toString();
    }

    String getShardRoutingCacheInfo() {
        StringBuffer infoStr = new StringBuffer();
        if (this.isDataDependentRoutingEnabled() && Objects.nonNull(this.defaultService)) {
            infoStr.append(this.defaultService.routingCache().cacheEntries());
        } else {
            infoStr.append("not populated or not connected");
        }
        return infoStr.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private void enableFANHeuristically(OracleUniversalPooledConnection oracleUniversalPooledConnection) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "enableFANHeuristically", "entering args ({0})", null, null, oracleUniversalPooledConnection);
            OracleConnection oconn = null;
            try {
                void oupc;
                Connection conn = oupc.getSQLConnection(oupc.getPhysicalConnection());
                if (conn instanceof OracleConnection) {
                    oconn = (OracleConnection)conn;
                }
            }
            catch (Exception exc) {
                oconn = null;
                this.trace(Level.WARNING, CLASS_NAME, "enableFANHeuristically", "", null, exc, new Object[0]);
            }
            if (oconn == null) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "enableFANHeuristically", "returning void", null, null, new Object[0]);
                return;
            }
            boolean fanEnabled = true;
            try {
                Util.getClassForName("oracle.ons.ONS", false, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader());
            }
            catch (Throwable err) {
                fanEnabled = false;
                this.trace(Level.FINE, CLASS_NAME, "enableFANHeuristically", "ons.jar is not on the classpath, FAN is disabled, {0}", null, null, err);
            }
            if (fanEnabled) {
                this.trace(Level.FINE, CLASS_NAME, "enableFANHeuristically", "Heuristically determine whether to enable FAN", null, null, new Object[0]);
                try {
                    short dbver = oconn.getVersionNumber();
                    if (dbver < 12101) {
                        fanEnabled = false;
                        this.trace(Level.FINE, CLASS_NAME, "enableFANHeuristically", "Pre-12c DB, FAN is heuristically disabled", null, null, new Object[0]);
                    } else {
                        Properties connSig = oconn.getServerSessionInfo();
                        String autoONSConfig = connSig.getProperty("AUTH_ONS_CONFIG");
                        if (autoONSConfig == null) {
                            fanEnabled = false;
                            this.trace(Level.FINE, CLASS_NAME, "enableFANHeuristically", "Single-instance 12.x DB, FAN is heuristically disabled", null, null, new Object[0]);
                        } else {
                            fanEnabled = true;
                            this.trace(Level.FINE, CLASS_NAME, "enableFANHeuristically", "RAC/GDS 12.x, FAN is heuristically enabled", null, null, new Object[0]);
                        }
                    }
                }
                catch (Throwable exc) {
                    fanEnabled = false;
                    this.trace(Level.FINE, CLASS_NAME, "Internal error happened, FAN is heuristically disabled, {0}", null, null, exc, new Object[0]);
                }
            }
            this.fanHeuristicallyEnabled.set(fanEnabled);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "enableFANHeuristically", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Topology", "enableFANHeuristically", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    boolean isFANHeuristicallyEnabled() {
        return this.fanHeuristicallyEnabled.get();
    }

    @Override
    public Counter totalCount(ConnectionRetrievalInfo cri) {
        return this.criStatsRegistry.getCriStats(cri).totalConnCount();
    }

    @Override
    public Counter borrowedCount(ConnectionRetrievalInfo cri) {
        return this.criStatsRegistry.getCriStats(cri).borrowedConnCount();
    }

    @Override
    public CriStats getCriMetadata(ConnectionRetrievalInfo cri) {
        return this.criStatsRegistry.getCriStats(cri);
    }

    Map<String, ShardConnectionStatistics> getShardConnectionStats() {
        if (!this.isShardedDatabase) {
            return Collections.emptyMap();
        }
        if (null == this.defaultService) {
            return Collections.emptyMap();
        }
        return ((ShardRoutingCache)this.defaultService.routingCache()).getShardConnectionStats();
    }

    @Override
    public long getOutboundConnectTimeout() {
        return this.outboundConnectTimeout;
    }

    @Override
    public LongAdder getCumulativeConnectionCreationAttempts() {
        return this.cumulativeConnectionCreationAttemts;
    }

    @Override
    public LongAdder getConnectionCreationAttemptsSinceLastOutage() {
        return this.connectionCreationAttemtsSinceLastOutage;
    }

    private /* synthetic */ Service lambda$registerService$6(ConnectionSource.FailoverCallback failoverCallback, ConnectionSource.RebalanceCallback rebalanceCallback, String p) {
        Service service = new Service(this, p, failoverCallback, rebalanceCallback, this.getDiagnosable());
        if (null == this.defaultService) {
            this.defaultService = service;
        }
        return service;
    }
}

