/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.RoutingKey;
import oracle.ucp.routing.ShardingRangeMap;
import oracle.ucp.util.Pair;

abstract class ShardRoutingCacheBase {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final NavigableMap<RoutingKey, Chunk> keysToChunks = new TreeMap<RoutingKey, Chunk>();
    private volatile NavigableMap<RoutingKey, Chunk> keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
    private volatile ShardingRangeMap shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
    private volatile int routingTableSize = 0;
    private final Map<String, Set<RoutingKey>> chunkNamesToKeys = new HashMap<String, Set<RoutingKey>>();
    private final Map<Chunk, Set<RoutingKey>> chunksToKeys = new HashMap<Chunk, Set<RoutingKey>>();
    private final Map<ServiceMember, Set<Chunk>> instsToChunks = new HashMap<ServiceMember, Set<Chunk>>();
    protected final Map<String, Set<Chunk>> chunkAbsNamesToChunks = new HashMap<String, Set<Chunk>>();
    protected final Map<Pair<ServiceMember, String>, Set<Chunk>> instsAndChunkAbsNamesToChunks = new HashMap<Pair<ServiceMember, String>, Set<Chunk>>();
    private volatile Map<Integer, List<Chunk>> chunkIdsToChunks = Collections.unmodifiableMap(new HashMap());

    ShardRoutingCacheBase() {
    }

    protected abstract long getShardkeyOraHash(OracleShardingKey var1);

    protected final Set<RoutingKey> keyForChunk(String chunkName) {
        if (null == chunkName) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<RoutingKey> set = this.chunkNamesToKeys.getOrDefault(chunkName, Collections.emptySet());
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final List<Chunk> chunks(OracleShardingKey superKey, OracleShardingKey key) {
        return Objects.requireNonNull(this.shardingRangeMap.get(superKey, key));
    }

    protected final int getRoutingTableSize() {
        return this.routingTableSize;
    }

    protected final NavigableMap<RoutingKey, Chunk> keyToChunkMap() {
        return this.keysToChunksSnapshot;
    }

    protected final Chunk get(RoutingKey key) {
        if (null == key) {
            throw new IllegalArgumentException();
        }
        return (Chunk)this.keysToChunksSnapshot.get(key);
    }

    protected final Set<Chunk> chunks(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.instsToChunks.getOrDefault(inst, Collections.emptySet());
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<Chunk> chunks(ServiceMember inst, String chunkAbsName) {
        if (null == inst) {
            return this.chunks(chunkAbsName);
        }
        if (null == chunkAbsName) {
            return new HashSet<Chunk>();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.instsAndChunkAbsNamesToChunks.getOrDefault(new Pair<ServiceMember, String>(inst, chunkAbsName), Collections.emptySet());
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final Set<Chunk> chunks(String chunkAbsName) {
        if (null == chunkAbsName) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.chunkAbsNamesToChunks.getOrDefault(chunkAbsName, Collections.emptySet());
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected List<Chunk> chunks(int id) {
        return this.chunkIdsToChunks.get(id);
    }

    protected final int chunksCount() {
        this.rLock.lock();
        try {
            int n = this.chunksToKeys.keySet().size();
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void remove(Chunk chunk) {
        if (null == chunk) {
            throw new IllegalArgumentException();
        }
        String name = chunk.name();
        String absName = chunk.absoluteName();
        this.wLock.lock();
        try {
            Set<RoutingKey> keys = this.chunksToKeys.getOrDefault(chunk, Collections.emptySet());
            keys.forEach(p -> {
                if (chunk.equals(this.keysToChunks.get(p))) {
                    this.keysToChunks.remove(p);
                }
            });
            this.keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
            this.chunkIdsToChunks = Collections.unmodifiableMap(this.keysToChunks.values().stream().collect(Collectors.groupingBy(c -> c.Id().get())));
            this.shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
            this.routingTableSize = this.keysToChunks.size();
            this.chunkNamesToKeys.getOrDefault(name, Collections.emptySet()).removeAll(keys);
            this.chunksToKeys.getOrDefault(chunk, Collections.emptySet()).removeAll(keys);
            chunk.instances().forEach(p -> this.instsToChunks.getOrDefault(p, Collections.emptySet()).remove(chunk));
            this.chunkAbsNamesToChunks.getOrDefault(absName, Collections.emptySet()).remove(chunk);
            chunk.instances().forEach(p -> this.instsAndChunkAbsNamesToChunks.getOrDefault(new Pair<ServiceMember, String>((ServiceMember)p, absName), Collections.emptySet()).remove(chunk));
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected final void remove(ServiceMember instance) {
        if (null == instance) {
            throw new IllegalArgumentException();
        }
        Set<Chunk> chunks = this.chunks(instance);
        chunks.forEach(p -> p.removeInstance(instance));
        this.wLock.lock();
        try {
            chunks.forEach(p -> this.instsAndChunkAbsNamesToChunks.remove(new Pair<ServiceMember, String>(instance, p.absoluteName())));
            this.instsToChunks.remove(instance);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void replace(RoutingKey key, Chunk oldChunk, Chunk newChunk) {
        if (null == key || null == oldChunk || null == newChunk) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.remove(oldChunk);
            this.putIfAbsent(key, newChunk);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateChunkRoutingKey(Chunk chunk, RoutingKey newKey) {
        if (null == newKey || null == chunk) {
            throw new IllegalArgumentException();
        }
        String name = chunk.name();
        this.wLock.lock();
        try {
            Set<RoutingKey> keys = this.chunksToKeys.getOrDefault(chunk, Collections.emptySet());
            keys.forEach(p -> {
                if (chunk.equals(this.keysToChunks.get(p))) {
                    this.keysToChunks.remove(p);
                }
            });
            this.chunkNamesToKeys.getOrDefault(name, Collections.emptySet()).removeAll(keys);
            this.chunksToKeys.getOrDefault(chunk, Collections.emptySet()).removeAll(keys);
            this.keysToChunks.putIfAbsent(newKey, chunk);
            this.keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
            this.shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
            this.routingTableSize = this.keysToChunks.size();
            this.chunkNamesToKeys.computeIfAbsent(name, p -> new HashSet()).add(newKey);
            this.chunksToKeys.computeIfAbsent(chunk, p -> new HashSet()).add(newKey);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Chunk putIfAbsent(RoutingKey key, Chunk chunk) {
        Chunk chunkToReturn;
        if (null == key || null == chunk) {
            throw new IllegalArgumentException();
        }
        String name = chunk.name();
        String absName = chunk.absoluteName();
        this.wLock.lock();
        try {
            chunkToReturn = this.keysToChunks.putIfAbsent(key, chunk);
            this.keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
            this.shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
            this.routingTableSize = this.keysToChunks.size();
            this.chunkNamesToKeys.computeIfAbsent(name, p -> new HashSet()).add(key);
            this.chunksToKeys.computeIfAbsent(chunk, p -> new HashSet()).add(key);
            chunk.instances().forEach(p -> this.instsToChunks.computeIfAbsent((ServiceMember)p, q -> new HashSet()).add(chunk));
            this.chunkAbsNamesToChunks.computeIfAbsent(absName, q -> new HashSet()).add(chunk);
            chunk.instances().forEach(p -> this.instsAndChunkAbsNamesToChunks.computeIfAbsent(new Pair<ServiceMember, String>((ServiceMember)p, absName), q -> new HashSet()).add(chunk));
        }
        finally {
            this.wLock.unlock();
        }
        return chunkToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToInstanceRelatedCaches(Chunk chunk, ServiceMember instance) {
        this.wLock.lock();
        try {
            this.instsToChunks.computeIfAbsent(instance, q -> new HashSet()).add(chunk);
            String chunkAbsName = chunk.absoluteName();
            this.chunkAbsNamesToChunks.computeIfAbsent(chunkAbsName, q -> new HashSet()).add(chunk);
            this.instsAndChunkAbsNamesToChunks.computeIfAbsent(new Pair<ServiceMember, String>(instance, chunkAbsName), q -> new HashSet()).add(chunk);
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected void populateChunkIdToChunkCache() {
        this.wLock.lock();
        try {
            this.chunkIdsToChunks = Collections.unmodifiableMap(this.keysToChunks.values().stream().collect(Collectors.groupingBy(c -> c.Id().get())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromInstanceRelatedCaches(Chunk chunk, ServiceMember instance) {
        this.wLock.lock();
        try {
            this.instsToChunks.getOrDefault(instance, Collections.emptySet()).remove(chunk);
            String chunkAbsName = chunk.absoluteName();
            this.chunkAbsNamesToChunks.getOrDefault(chunkAbsName, Collections.emptySet()).remove(chunk);
            this.instsAndChunkAbsNamesToChunks.getOrDefault(new Pair<ServiceMember, String>(instance, chunkAbsName), Collections.emptySet()).remove(chunk);
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected final void clear() {
        this.wLock.lock();
        try {
            this.keysToChunks.clear();
            this.keysToChunksSnapshot = Collections.unmodifiableNavigableMap(new TreeMap<RoutingKey, Chunk>((SortedMap<RoutingKey, Chunk>)this.keysToChunks));
            this.chunkIdsToChunks = Collections.unmodifiableMap(this.keysToChunks.values().stream().collect(Collectors.groupingBy(c -> c.Id().get())));
            this.shardingRangeMap = new ShardingRangeMap(this.keysToChunks, p -> this.getShardkeyOraHash((OracleShardingKey)p));
            this.routingTableSize = this.keysToChunks.size();
            this.chunksToKeys.clear();
            this.chunkNamesToKeys.clear();
            this.instsToChunks.clear();
            this.chunkAbsNamesToChunks.clear();
            this.instsAndChunkAbsNamesToChunks.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected final String routingTableToString() {
        this.rLock.lock();
        try {
            String string = this.keysToChunks.toString();
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final String routingTableToHumanReadableString() {
        this.rLock.lock();
        try {
            String string = "\n\t\t SHARD ROUTING CACHE \n\n " + "\nSUPER SHARDING KEY\t\t SHARDING KEY\t\t\t\t\tCHUNK NAME \t\tINSTANCES\n\n" + this.keysToChunks.entrySet().stream().map(entry -> String.format("%-70s", entry.getKey()) + "\t\t" + ((Chunk)entry.getValue()).toString()).collect(Collectors.joining("\n"));
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public String toString() {
        return this.routingTableToString();
    }
}

