/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.ucp.logging.annotations.DisableTrace;

@DisableTrace
public class UCPFormatter
extends Formatter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    @Override
    public String format(LogRecord lr) {
        String msg = lr.getMessage();
        Level level = lr.getLevel();
        return new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS a Z").format(new Date(lr.getMillis()), new StringBuffer(), new FieldPosition(0)).append(" UCP ").append(level.toString()).append(" seq-").append(lr.getSequenceNumber()).append(",thread-").append(lr.getThreadID()).append(' ').append(lr.getSourceClassName()).append('.').append(lr.getSourceMethodName()).append(' ').append(this.fmtMsgParams(lr)).append(this.fmtThrown(lr)).append('\n').toString();
    }

    private String fmtMsgParams(LogRecord lr) {
        String msg = lr.getMessage();
        if (msg == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] parts = msg.split("\\{\\d+\\}");
        Object[] params = lr.getParameters();
        int i = 0;
        for (String part : parts) {
            sb.append((Object)part);
            if (params == null || params.length <= i) continue;
            sb.append(params[i++]);
        }
        return sb.toString();
    }

    private String fmtThrown(LogRecord lr) {
        Throwable thrown = lr.getThrown();
        if (thrown == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        thrown.printStackTrace(new PrintWriter(writer));
        return "" + '\n' + writer + '\n';
    }

    static {
        try {
            $$$methodRef$$$3 = UCPFormatter.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = UCPFormatter.class.getDeclaredMethod("fmtThrown", LogRecord.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UCPFormatter.class.getDeclaredMethod("fmtMsgParams", LogRecord.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UCPFormatter.class.getDeclaredMethod("format", LogRecord.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

