/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.logging.runtime;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.ucp.logging.annotations.Blinder;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.runtime.Features;
import oracle.ucp.logging.runtime.TraceController;

@DisableTrace
public class TraceControllerImpl
implements TraceController {
    private static final Features features;
    private RuntimeException reSuspended = new IllegalStateException("trace controller is currently suspended");
    public static long feature;
    private static long backup;
    private static int suspends;
    private static final ReentrantLock CLASS_LOCK;
    private static final Blinder<Object> bogusBlinder;
    private static final ConcurrentMap<Class<? extends Blinder<?>>, Blinder<?>> instantiatedBlindersMap;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(boolean enable, Feature ... features) {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                throw this.reSuspended;
            }
            long fMask = 0L;
            for (Feature f : features) {
                fMask |= f.bitVector();
            }
            feature = enable ? feature | fMask : feature & (fMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getEnabledFeatures() {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                Feature[] featureArray = new Feature[]{};
                return featureArray;
            }
            ArrayList<Feature> enabledFeatures = new ArrayList<Feature>();
            if (feature == Feature.ALL.bitVector()) {
                enabledFeatures.add(Feature.ALL);
            } else {
                for (Feature f : this.getSupportedFeatures()) {
                    if (Feature.ALL == f || 0L == (feature & f.bitVector())) continue;
                    enabledFeatures.add(f);
                }
            }
            Feature[] featureArray = enabledFeatures.toArray(new Feature[0]);
            return featureArray;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getSupportedFeatures() {
        CLASS_LOCK.lock();
        try {
            ArrayList<Feature> supportedFeatures = new ArrayList<Feature>();
            for (Feature feature : Feature.values()) {
                supportedFeatures.add(feature);
            }
            Feature[] featureArray = supportedFeatures.toArray(new Feature[0]);
            return featureArray;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    @Override
    public void suspend() {
        CLASS_LOCK.lock();
        try {
            if (0 == suspends++) {
                backup = feature;
                feature = 0L;
            }
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    @Override
    public void resume() {
        CLASS_LOCK.lock();
        try {
            int s = --suspends;
            if (0 == s) {
                feature = backup;
            } else if (s < 0) {
                suspends = 0;
            }
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTracing(Feature ... supportedFeatures) {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                boolean bl = false;
                return bl;
            }
            boolean isTracing = true;
            for (Feature f : supportedFeatures) {
                if (0L != (feature & f.bitVector())) continue;
                isTracing = false;
            }
            boolean bl = isTracing;
            return bl;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    private static <T> Blinder<T> getBlinder(Class<? extends Blinder<T>> blinderClass) {
        RuntimeException[] exception = new RuntimeException[]{null};
        Blinder blinder = instantiatedBlindersMap.computeIfAbsent(blinderClass, p -> {
            try {
                return (Blinder)p.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                exception[0] = new RuntimeException(e);
                return bogusBlinder;
            }
        });
        if (Objects.nonNull(exception[0])) {
            throw exception[0];
        }
        return blinder;
    }

    public static <T> String blind(Class<? extends Blinder<T>> blinderClass, T value) {
        return TraceControllerImpl.getBlinder(blinderClass).blind(value);
    }

    static {
        String trace;
        try {
            $$$methodRef$$$10 = TraceControllerImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = TraceControllerImpl.class.getDeclaredMethod("lambda$static$0", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = TraceControllerImpl.class.getDeclaredMethod("lambda$getBlinder$1", RuntimeException[].class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = TraceControllerImpl.class.getDeclaredMethod("blind", Class.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = TraceControllerImpl.class.getDeclaredMethod("getBlinder", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = TraceControllerImpl.class.getDeclaredMethod("isTracing", Feature[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = TraceControllerImpl.class.getDeclaredMethod("resume", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = TraceControllerImpl.class.getDeclaredMethod("suspend", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = TraceControllerImpl.class.getDeclaredMethod("getSupportedFeatures", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = TraceControllerImpl.class.getDeclaredMethod("getEnabledFeatures", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = TraceControllerImpl.class.getDeclaredMethod("trace", Boolean.TYPE, Feature[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        features = new Features("oracle.ucp.logging.annotations.Supports");
        feature = Feature.ALL_UCP.bitVector();
        String prop = System.getProperty("oracle.jdbc.Trace");
        if (null != prop && ("true".equals(trace = prop.trim().toLowerCase()) || "on".equals(trace))) {
            feature |= Feature.ALL_JDBC.bitVector();
        }
        String PREFIX = "clio.feature";
        String configFile = System.getProperty("java.util.logging.config.file");
        if (null != configFile) {
            Properties props = new Properties();
            InputStream inputStream = TraceControllerImpl.class.getClassLoader().getResourceAsStream(configFile);
            if (null == inputStream) {
                try {
                    inputStream = new FileInputStream(configFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (null != inputStream) {
                try {
                    props.load(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            long selectedFeature = 0L;
            for (Feature f : Feature.values()) {
                String key = "clio.feature." + f.toString().toLowerCase();
                String value = props.getProperty(key);
                if (null == value) continue;
                String v = value.toLowerCase().trim();
                if ("on".equals(v) || "true".equals(v)) {
                    selectedFeature |= f.bitVector();
                    continue;
                }
                if (!"off".equals(v) && !"false".equals(v)) continue;
                selectedFeature &= f.bitVector() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (0L != selectedFeature) {
                feature = selectedFeature;
            }
        }
        backup = 0L;
        suspends = 0;
        CLASS_LOCK = new ReentrantLock();
        bogusBlinder = p -> "*** error: bogus blinder invoked instead, an appropriate blinder was not properly instantiated ***";
        instantiatedBlindersMap = new ConcurrentHashMap();
    }
}

