/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.LabelCache;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.LABELING, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.CONN_HARVESTING, Feature.TTL_CONN_TIMEOUT, Feature.ABANDONED_CONN_TIMEOUT})
abstract class Database
implements ConnectionSource {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    Database() {
    }

    protected abstract ConnectionFactoryAdapter getConnectionFactoryAdapter();

    protected abstract AtomicInteger connectionsCreated();

    protected abstract AtomicInteger connectionsClosed();

    @Override
    public Comparator<CoreConnection> costComparator(final LabelCache labelCache) {
        return new Comparator<CoreConnection>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public int compare(CoreConnection conn1, CoreConnection conn2) {
                if (null == conn1) {
                    throw new IllegalArgumentException("conn1 is null");
                }
                if (null == conn2) {
                    throw new IllegalArgumentException("conn2 is null");
                }
                return labelCache.getCost(conn1) - labelCache.getCost(conn2);
            }

            @Override
            public boolean equals(Object that) {
                if (!(that instanceof Comparator)) {
                    return false;
                }
                return this == that;
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(Database.class, LabelCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("compare", Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("equals", Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("compare", CoreConnection.class, CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector perfectCostSelector(final LabelCache labelCache) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                int cost = labelCache.getCost(conn);
                return 0 == cost;
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(Database.class, LabelCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector physicalConnectionSelector(final Object physicalConn) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
                return physicalConn == upc.getPhysicalConnection();
            }

            static {
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(Database.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector wrongCostSelector(final LabelCache labelCache) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                int cost = labelCache.getCost(conn);
                return Integer.MAX_VALUE == cost;
            }

            static {
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredConstructor(Database.class, LabelCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector matchingCriSelector(final ConnectionRetrievalInfo cri) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                return conn.cri().equalsIncludingPassword(cri);
            }

            static {
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredConstructor(Database.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector availableConnectionsSelector() {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                return conn.available();
            }

            static {
                try {
                    $$$methodRef$$$1 = 6.class.getDeclaredConstructor(Database.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 6.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector harvestableConnectionSelector() {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                return ((UniversalPooledConnection)conn.getDelegate()).isConnectionHarvestable();
            }

            static {
                try {
                    $$$methodRef$$$1 = 7.class.getDeclaredConstructor(Database.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 7.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector inactiveConnectionsSelector(final long inactivityTimeout) {
        Selector inactive = new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
                return Clock.clock() - inactivityTimeout >= upc.getAvailableStartTime();
            }

            static {
                try {
                    $$$methodRef$$$1 = 8.class.getDeclaredConstructor(Database.class, Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 8.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        return Selectors.and(this.availableConnectionsSelector(), inactive);
    }

    @Override
    public Selector abandonedConnectionsSelector(final long abandonedTimeout) {
        Selector abandoned = new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                AbandonedConnectionTimeoutCallback cbkOnThisConn;
                long now = Clock.clock();
                UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
                if (upc.getAvailableStartTime() > now || upc.getBorrowedStartTime() > now) {
                    return false;
                }
                if (upc.getLastAccessedTime() > now - abandonedTimeout || upc.isSqlWithQueryTimeoutInProgress()) {
                    return false;
                }
                try {
                    cbkOnThisConn = upc.getAbandonedConnectionTimeoutCallback();
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                    return false;
                }
                return cbkOnThisConn == null || cbkOnThisConn != null && !cbkOnThisConn.handleTimedOutConnection();
            }

            static {
                try {
                    $$$methodRef$$$1 = 9.class.getDeclaredConstructor(Database.class, Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 9.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        return Selectors.and(Selectors.not(this.availableConnectionsSelector()), this.harvestableConnectionSelector(), abandoned);
    }

    @Override
    public Selector ttlConnectionsSelector(final long TTLTimeout) {
        Selector abandoned = new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                TimeToLiveConnectionTimeoutCallback cbkOnThisConn;
                long now = Clock.clock();
                UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
                if (upc.getAvailableStartTime() > now || upc.getBorrowedStartTime() > now) {
                    return false;
                }
                if (upc.getBorrowedStartTime() > now - TTLTimeout) {
                    return false;
                }
                try {
                    cbkOnThisConn = upc.getTimeToLiveConnectionTimeoutCallback();
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                    return false;
                }
                return cbkOnThisConn == null || cbkOnThisConn != null && !cbkOnThisConn.handleTimedOutConnection();
            }

            static {
                try {
                    $$$methodRef$$$1 = 10.class.getDeclaredConstructor(Database.class, Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 10.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        return Selectors.and(Selectors.not(this.availableConnectionsSelector()), this.harvestableConnectionSelector(), abandoned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UniversalPooledConnection createPooledConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        if (cri == null) {
            ClioSupport.ilogWarning(null, null, null, null, "CRI is not defined");
            return null;
        }
        Object connection = null;
        UniversalPooledConnection upc = null;
        try {
            connection = this.getConnectionFactoryAdapter().createConnection(cri);
            if (null == connection) {
                UCPErrorHandler.throwUniversalConnectionPoolException(100);
            }
            upc = this.getConnectionFactoryAdapter().createPooledConnection(connection, cri.getCopyWithNoLabels());
            this.connectionsCreated().incrementAndGet();
        }
        finally {
            if (null != connection && null == upc) {
                try {
                    this.getConnectionFactoryAdapter().closeConnection(connection);
                    this.connectionsClosed().incrementAndGet();
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
            }
        }
        return upc;
    }

    static {
        try {
            $$$methodRef$$$11 = Database.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Database.class.getDeclaredMethod("createPooledConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Database.class.getDeclaredMethod("ttlConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Database.class.getDeclaredMethod("abandonedConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Database.class.getDeclaredMethod("inactiveConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Database.class.getDeclaredMethod("harvestableConnectionSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Database.class.getDeclaredMethod("availableConnectionsSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Database.class.getDeclaredMethod("matchingCriSelector", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Database.class.getDeclaredMethod("wrongCostSelector", LabelCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Database.class.getDeclaredMethod("physicalConnectionSelector", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Database.class.getDeclaredMethod("perfectCostSelector", LabelCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Database.class.getDeclaredMethod("costComparator", LabelCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }
}

