/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class ConnectionPoolDataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    protected ConnectionPoolDataSource m_connectionPoolDataSource;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public ConnectionPoolDataSourceConnectionFactoryAdapter(ConnectionPoolDataSource connectionPoolDataSource) throws UniversalConnectionPoolException {
        if (null == connectionPoolDataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(251);
        }
        this.m_connectionPoolDataSource = connectionPoolDataSource;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.m_connectionPoolDataSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        void connectionRequestInfo;
        boolean bl;
        boolean bl2 = bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        JDBCConnectionRetrievalInfo jdbcConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
        PooledConnection pooledConnection = null;
        try {
            pooledConnection = this.m_connectionPoolDataSource.getPooledConnection(jdbcConnectionRequestInfo.getUser(), jdbcConnectionRequestInfo.getPassword());
            UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
            if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
                pooledConnection.addConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
            }
        }
        catch (SQLException sqlException) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$1, ConnectionPoolDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$1, this, sqlException);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(253, sqlException);
        }
        return pooledConnection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeConnection(Object object) throws UniversalConnectionPoolException {
        void connection;
        boolean bl;
        boolean bl2 = bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(connection instanceof PooledConnection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(254);
        }
        PooledConnection pooledConnection = (PooledConnection)connection;
        UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
        if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
            pooledConnection.removeConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
        }
        try {
            pooledConnection.close();
        }
        catch (SQLException sqlException) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$2, ConnectionPoolDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$2, this, sqlException);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = ConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(ConnectionPoolDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = ConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("closeConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = ConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("getConnectionPoolDataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

