/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CriType;
import oracle.ucp.common.Database;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.Limits;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
abstract class Topology
extends Database {
    private final AtomicReference<ConnectionRetrievalInfo> defaultCri = new AtomicReference<Object>(null);
    private String defaultServiceName = null;
    private final Map<String, Service> services = new ConcurrentHashMap<String, Service>();
    private final AtomicReference<ONSDriver> onsDriver = new AtomicReference<Object>(null);
    private boolean onsStarted = false;
    private boolean isShardedDatabase = false;
    private boolean isMultitenantDatabase = false;
    private String poolRegionName = null;
    private final AtomicBoolean fanHeuristicallyEnabled = new AtomicBoolean(false);
    protected final Map<ConnectionRetrievalInfo, CriType> poolCriTypes = new ConcurrentHashMap<ConnectionRetrievalInfo, CriType>();
    protected boolean replayable = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    Topology() {
    }

    protected abstract String getONSConfig() throws UniversalConnectionPoolException;

    protected abstract AtomicLong cumulativeConnectionUseTime();

    protected abstract Limits limits();

    @Override
    public CoreConnection create(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback, EnumSet<ConnectionSource.CreateMode> createModes, long timeToRetry) throws UniversalConnectionPoolException {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            throw new UniversalConnectionPoolException("wrong CRI");
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        String requestedServiceName = this.serviceName(jdbcCri);
        Service service = this.service(requestedServiceName);
        if (service == null) {
            throw new IllegalStateException("Service " + requestedServiceName + " is unknown or not registered in UCP");
        }
        CoreConnection conn = service.create(cri, affinityCallback, createModes, timeToRetry);
        if (null == conn) {
            return null;
        }
        if (!requestedServiceName.equals(conn.serviceName())) {
            throw new IllegalArgumentException("Non existent or Unknown Service: " + requestedServiceName);
        }
        return conn;
    }

    private String logicalServiceName(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        if (!serviceName.contains("%")) {
            return serviceName;
        }
        return serviceName.substring(serviceName.indexOf(37) + 1);
    }

    private String extractRegionName(String serviceName) {
        if (serviceName == null || !serviceName.contains("%")) {
            return null;
        }
        return serviceName.substring(0, serviceName.indexOf(37));
    }

    private String prefixRegionName(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        String regionPrefix = this.poolRegionName == null ? "" : this.poolRegionName + "%";
        return regionPrefix + this.logicalServiceName(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        Util.disableDriverHA();
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            throw new UniversalConnectionPoolException("wrong CRI");
        }
        UniversalPooledConnection conn = null;
        try {
            conn = this.createPooledConnection(cri);
            if (!(conn instanceof UniversalPooledConnectionImpl)) {
                this.defaultCri.compareAndSet(null, cri);
                return;
            }
            UniversalPooledConnectionImpl upc = (UniversalPooledConnectionImpl)conn;
            this.defaultServiceName = this.logicalServiceName(upc.getService());
            ConnectionRetrievalInfo newCri = ((JDBCConnectionRetrievalInfo)cri).getCopyWithService(this.defaultServiceName);
            this.defaultCri.compareAndSet(null, newCri);
            if (!(conn instanceof OracleUniversalPooledConnection)) {
                return;
            }
            OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)conn;
            this.isShardedDatabase = oupc.isShardedDatabase();
            this.isMultitenantDatabase = oupc.isMultitenantDatabase();
            this.poolRegionName = this.extractRegionName(upc.getService());
            this.enableFANHeuristically(oupc);
        }
        finally {
            if (conn != null) {
                this.connectionsCreated().decrementAndGet();
                ((UniversalPooledConnectionImpl)conn).closeNoStatsUpdate();
            }
        }
    }

    @Override
    public void stop() {
        if (null != this.onsDriver.getAndSet(null)) {
            this.onsStarted = false;
            this.services.forEach((name, service) -> {
                service.stop();
                service.shardRoutingCache().destroy();
            });
            this.defaultCri.set(null);
        }
        this.services.clear();
        this.fanHeuristicallyEnabled.set(false);
    }

    @Override
    public boolean isReplayable() {
        return this.replayable;
    }

    @Override
    public void setReplayable(boolean isReplayable) {
        this.replayable = isReplayable;
    }

    @Override
    public LoadBalancer.Stats loadBalancerStats(String serviceName) {
        Service service;
        if (!(this.defaultCri() instanceof JDBCConnectionRetrievalInfo)) {
            throw new IllegalStateException("wrong CRI in th pool ");
        }
        if (serviceName == null) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)this.defaultCri();
            serviceName = jdbcCri.getServiceName();
        }
        if ((service = this.service(serviceName)) != null) {
            return this.service(serviceName).loadBalancerStats();
        }
        return new LoadBalancer.Stats();
    }

    @Override
    public FailoverDriver.Stats failoverDriverStats(String serviceName) {
        Service service;
        if (!(this.defaultCri() instanceof JDBCConnectionRetrievalInfo)) {
            throw new IllegalStateException("wrong CRI in th pool ");
        }
        if (serviceName == null) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)this.defaultCri();
            serviceName = jdbcCri.getServiceName();
        }
        if ((service = this.service(serviceName)) != null) {
            return this.service(serviceName).failoverDriverStats();
        }
        return new FailoverDriver.Stats();
    }

    @Override
    public Selector loadBalancedBorrowSelector(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback) {
        return this.service(this.serviceName(cri)).loadBalancedBorrowSelector(cri, affinityCallback);
    }

    @Override
    public Selector shardKeyBasedBorrowSelector(ConnectionRetrievalInfo cri, boolean usePriority) {
        if (this.isShardedDatabase) {
            return this.service(this.serviceName(cri)).shardRoutingCache().shardKeyBorrowSelector(cri, usePriority);
        }
        return Selectors.EVERY;
    }

    @Override
    public String shardConnectionStats(String serviceName) {
        if (!this.isShardedDatabase || !this.isServiceRegistered(serviceName)) {
            return "";
        }
        return this.service(serviceName).shardRoutingCache().shardConnectionStats();
    }

    @Override
    public String serviceName(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return null;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        String logicalSvcName = jdbcCri.getServiceName();
        return this.poolRegionName == null ? logicalSvcName : this.prefixRegionName(logicalSvcName);
    }

    @Override
    public ConnectionRetrievalInfo defaultCri() {
        return this.defaultCri.get();
    }

    @Override
    public String defaultServiceName() {
        return this.defaultServiceName;
    }

    public ONSDriver onsDriver(String onsConfig) throws UniversalConnectionPoolException {
        if (this.onsDriver.compareAndSet(null, ONSDriver.instance())) {
            ONSDriver onsDrvr = this.onsDriver.get();
            this.onsStarted = onsDrvr.start(onsConfig);
        }
        if (this.onsStarted) {
            return this.onsDriver.get();
        }
        return null;
    }

    public Service service(String serviceName) {
        if (this.poolRegionName != null) {
            serviceName = this.prefixRegionName(serviceName);
        }
        return this.services.get(serviceName);
    }

    @Override
    public void registerService(String serviceName, ConnectionSource.FailoverCallback failoverCallback, ConnectionSource.RebalanceCallback rebalanceCallBack) {
        Service service = this.service(serviceName);
        if (service == null) {
            boolean isNewSvc;
            Service newService = new Service(this, serviceName);
            boolean bl = isNewSvc = this.services.putIfAbsent(serviceName, newService) == null;
            if (isNewSvc) {
                newService.registerFailoverCallback(failoverCallback);
                newService.registerRebalanceCallback(rebalanceCallBack);
            }
        }
    }

    @Override
    public boolean isServiceRegistered(String serviceName) {
        return this.service(serviceName) != null;
    }

    @Override
    public boolean isShardedDatabase() {
        return this.isShardedDatabase;
    }

    @Override
    public boolean isMultitenantDatabase() {
        return this.isMultitenantDatabase;
    }

    @Override
    public boolean validateCri(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return true;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (!this.isServiceRegistered(jdbcCri.getServiceName())) {
            return false;
        }
        if (this.isShardedDatabase) {
            return this.service(this.serviceName(cri)).shardRoutingCache().validateCri(jdbcCri);
        }
        return true;
    }

    @Override
    public boolean available(ConnectionRetrievalInfo cri) {
        String svcName = this.serviceName(cri);
        if (!this.isServiceRegistered(svcName)) {
            return false;
        }
        if (this.totalCount(cri).get() - this.borrowedCount(cri).get() <= 0) {
            return false;
        }
        if (this.isShardedDatabase) {
            return this.service(svcName).shardRoutingCache().available(cri);
        }
        return true;
    }

    @Override
    public Selector serviceBasedRepurposeSelector(ConnectionRetrievalInfo cri, boolean balanced) {
        String svcName = this.serviceName(cri);
        if (!(cri instanceof JDBCConnectionRetrievalInfo) || !this.isServiceRegistered(svcName)) {
            return Selectors.NONE;
        }
        return this.service(svcName).serviceBasedRepurposeSelector(cri, balanced);
    }

    String getDatabaseTopologyInfo() {
        StringBuffer infoStr = new StringBuffer();
        infoStr.append("SERVICES: \n" + this.services.values().stream().map(k -> k.toString()).collect(Collectors.joining("\n")));
        for (Service svc : this.services.values()) {
            infoStr.append("\nService " + svc.name() + " - INSTANCES:\n" + svc.getAllMembers().stream().map(inst -> inst.name()).collect(Collectors.joining("\n")));
        }
        return infoStr.toString();
    }

    String getShardedDatabaseInfo() {
        StringBuffer infoStr = new StringBuffer();
        if (this.isShardedDatabase) {
            infoStr.append(this.service(this.defaultServiceName).shardRoutingCache().metadataInfo());
        } else {
            infoStr.append("Shard metadata not populated or not connected to a sharded database");
        }
        return infoStr.toString();
    }

    String getShardRoutingCacheInfo() {
        StringBuffer infoStr = new StringBuffer();
        if (this.isShardedDatabase) {
            infoStr.append(this.service(this.defaultServiceName).shardRoutingCache().cacheInfo());
        } else {
            infoStr.append("Shard routing cache not populated or not connected to a sharded database");
        }
        return infoStr.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void enableFANHeuristically(OracleUniversalPooledConnection oracleUniversalPooledConnection) {
        boolean fanEnabled;
        block19: {
            OracleConnection oconn;
            boolean bl;
            block18: {
                block17: {
                    bl = (0xF6000000000000L & TraceControllerImpl.feature) != 0L;
                    oconn = null;
                    try {
                        void oupc;
                        Connection conn = oupc.getSQLConnection(oupc.getPhysicalConnection());
                        if (conn instanceof OracleConnection) {
                            oconn = (OracleConnection)conn;
                        }
                    }
                    catch (Exception exc) {
                        oconn = null;
                        if (!bl) break block17;
                        ClioSupport.ilogThrowing($$$loggerRef$$$28, Topology.class, $$$methodRef$$$28, this, exc);
                    }
                }
                if (oconn == null) {
                    return;
                }
                fanEnabled = true;
                try {
                    ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
                    Class.forName("oracle.ons.ONS", false, clsLoader);
                }
                catch (Throwable err) {
                    fanEnabled = false;
                    if (!bl) break block18;
                    ClioSupport.ilogFine($$$loggerRef$$$28, Topology.class, $$$methodRef$$$28, this, "ons.jar is not on the classpath, FAN is disabled, " + err);
                }
            }
            if (fanEnabled) {
                if (bl) {
                    ClioSupport.ilogFine($$$loggerRef$$$28, Topology.class, $$$methodRef$$$28, this, "Heuristically determine whether to enable FAN");
                }
                try {
                    short dbver = oconn.getVersionNumber();
                    if (dbver < 12101) {
                        fanEnabled = false;
                        if (bl) {
                            ClioSupport.ilogFine($$$loggerRef$$$28, Topology.class, $$$methodRef$$$28, this, "Pre-12c DB, FAN is heuristically disabled");
                        }
                    } else {
                        Properties connSig = oconn.getServerSessionInfo();
                        String autoONSConfig = connSig.getProperty("AUTH_ONS_CONFIG");
                        if (autoONSConfig == null) {
                            fanEnabled = false;
                            if (bl) {
                                ClioSupport.ilogFine($$$loggerRef$$$28, Topology.class, $$$methodRef$$$28, this, "Single-instance 12.x DB, FAN is heuristically disabled");
                            }
                        } else {
                            fanEnabled = true;
                            if (bl) {
                                ClioSupport.ilogFine($$$loggerRef$$$28, Topology.class, $$$methodRef$$$28, this, "RAC/GDS 12.x, FAN is heuristically enabled");
                            }
                        }
                    }
                }
                catch (Throwable exc) {
                    fanEnabled = false;
                    if (!bl) break block19;
                    ClioSupport.ilogFine($$$loggerRef$$$28, Topology.class, $$$methodRef$$$28, this, "Internal error happened, FAN is heuristically disabled, " + exc);
                }
            }
        }
        this.fanHeuristicallyEnabled.set(fanEnabled);
    }

    protected boolean isFANHeuristicallyEnabled() {
        return this.fanHeuristicallyEnabled.get();
    }

    public Counter totalCount(ConnectionRetrievalInfo cri) {
        this.poolCriTypes.putIfAbsent(cri, new CriType(cri));
        return this.poolCriTypes.get(cri).totalConnCount();
    }

    public Counter borrowedCount(ConnectionRetrievalInfo cri) {
        this.poolCriTypes.putIfAbsent(cri, new CriType(cri));
        return this.poolCriTypes.get(cri).borrowedConnCount();
    }

    static {
        try {
            $$$methodRef$$$35 = Topology.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = Topology.class.getDeclaredMethod("lambda$stop$0", String.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = Topology.class.getDeclaredMethod("lambda$getDatabaseTopologyInfo$1", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = Topology.class.getDeclaredMethod("lambda$getDatabaseTopologyInfo$2", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = Topology.class.getDeclaredMethod("borrowedCount", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = Topology.class.getDeclaredMethod("totalCount", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = Topology.class.getDeclaredMethod("isFANHeuristicallyEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = Topology.class.getDeclaredMethod("enableFANHeuristically", OracleUniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = Topology.class.getDeclaredMethod("getShardRoutingCacheInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = Topology.class.getDeclaredMethod("getShardedDatabaseInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = Topology.class.getDeclaredMethod("getDatabaseTopologyInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = Topology.class.getDeclaredMethod("serviceBasedRepurposeSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = Topology.class.getDeclaredMethod("available", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = Topology.class.getDeclaredMethod("validateCri", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = Topology.class.getDeclaredMethod("isMultitenantDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = Topology.class.getDeclaredMethod("isShardedDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = Topology.class.getDeclaredMethod("isServiceRegistered", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = Topology.class.getDeclaredMethod("registerService", String.class, ConnectionSource.FailoverCallback.class, ConnectionSource.RebalanceCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = Topology.class.getDeclaredMethod("service", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = Topology.class.getDeclaredMethod("onsDriver", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = Topology.class.getDeclaredMethod("defaultServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = Topology.class.getDeclaredMethod("defaultCri", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = Topology.class.getDeclaredMethod("serviceName", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = Topology.class.getDeclaredMethod("shardConnectionStats", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = Topology.class.getDeclaredMethod("shardKeyBasedBorrowSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Topology.class.getDeclaredMethod("loadBalancedBorrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Topology.class.getDeclaredMethod("failoverDriverStats", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Topology.class.getDeclaredMethod("loadBalancerStats", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Topology.class.getDeclaredMethod("setReplayable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Topology.class.getDeclaredMethod("isReplayable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Topology.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Topology.class.getDeclaredMethod("start", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Topology.class.getDeclaredMethod("prefixRegionName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Topology.class.getDeclaredMethod("extractRegionName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Topology.class.getDeclaredMethod("logicalServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Topology.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }
}

