/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.FailoverableUniversalPooledConnectionBase;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class JDBCUniversalPooledConnection
extends FailoverableUniversalPooledConnectionBase {
    private static final Logger logger = UCPLoggerFactory.createLogger(JDBCUniversalPooledConnection.class.getCanonicalName());
    private final JDBCConnectionPool m_cp;
    private int m_maxStatements = 0;

    public JDBCUniversalPooledConnection(JDBCConnectionPool connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo, boolean connectionFailoverEnabled) throws UniversalConnectionPoolException {
        super(connectionPool, connection, connectionRetrievalInfo, connectionFailoverEnabled);
        this.m_cp = connectionPool;
    }

    public void validate() {
        String SQLString = this.m_cp.getSQLForValidateConnection();
        boolean isConnectionValid = SQLString != null && !SQLString.equals("") ? this.validateConnectionWithSQL(SQLString) : this.validateConnectionWithoutSQL();
        if (!isConnectionValid) {
            this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean validateConnectionWithSQL(String sqlExpression) {
        boolean e2;
        Statement stmt;
        boolean valid = false;
        try {
            try {
                stmt = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
            }
            catch (SQLException e2) {
                logger.log(Level.FINEST, "creating statement", e2);
                boolean bl = false;
                Object var10_9 = null;
                logger.log(Level.FINEST, "connection is {1} and validated using \"{0}\"", new Object[]{sqlExpression, valid ? "valid" : "invalid"});
                return bl;
            }
            stmt.execute(sqlExpression);
            valid = true;
            e2 = true;
            Object var7_13 = null;
            try {
                stmt.close();
            }
            catch (SQLException e3) {
                logger.log(Level.FINEST, "closing statement", e3);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            logger.log(Level.FINEST, "connection is {1} and validated using \"{0}\"", new Object[]{sqlExpression, valid ? "valid" : "invalid"});
            throw throwable;
        }
        logger.log(Level.FINEST, "connection is {1} and validated using \"{0}\"", new Object[]{sqlExpression, valid ? "valid" : "invalid"});
        {
            return e2;
            catch (SQLException e2) {
                boolean bl;
                try {
                    logger.log(Level.FINEST, "executing SQL expression", e2);
                    bl = false;
                    Object var7_14 = null;
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e3) {
                        logger.log(Level.FINEST, "closing statement", e3);
                    }
                    throw throwable;
                }
                try {
                    stmt.close();
                }
                catch (SQLException e3) {
                    logger.log(Level.FINEST, "closing statement", e3);
                }
                Object var10_11 = null;
                logger.log(Level.FINEST, "connection is {1} and validated using \"{0}\"", new Object[]{sqlExpression, valid ? "valid" : "invalid"});
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateConnectionWithoutSQL() {
        boolean e2;
        boolean valid = false;
        try {
            Connection conn;
            try {
                conn = this.getSQLConnection(this.getPhysicalConnection());
            }
            catch (SQLException e2) {
                logger.log(Level.FINEST, "getting connection", e2);
                boolean bl = false;
                Object var6_9 = null;
                logger.log(Level.FINEST, "connection is {0}", new Object[]{valid ? "valid" : "invalid"});
                return bl;
            }
            try {
                e2 = valid = ((Boolean)conn.getClass().getMethod("isValid", Integer.TYPE).invoke((Object)conn, 0)).booleanValue();
            }
            catch (Throwable e3) {
                if (!(e3 instanceof NoSuchMethodException) && !(e3 instanceof AbstractMethodError)) {
                    logger.log(Level.FINEST, "validating connection", e3);
                    if (null != e3.getCause()) {
                        logger.log(Level.FINEST, "cause", e3.getCause());
                    }
                }
                try {
                    valid = !conn.isClosed();
                }
                catch (SQLException ea) {
                    logger.log(Level.FINEST, "checking connection", ea);
                }
                boolean bl = valid;
                Object var6_11 = null;
                logger.log(Level.FINEST, "connection is {0}", new Object[]{valid ? "valid" : "invalid"});
                return bl;
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            logger.log(Level.FINEST, "connection is {0}", new Object[]{valid ? "valid" : "invalid"});
            throw throwable;
        }
        logger.log(Level.FINEST, "connection is {0}", new Object[]{valid ? "valid" : "invalid"});
        return e2;
    }

    public Connection getSQLConnection(Object physicalConnection) throws SQLException {
        logger.log(Level.FINEST, "physicalConnection: {0}", physicalConnection.toString());
        if (physicalConnection instanceof Connection) {
            return (Connection)physicalConnection;
        }
        if (physicalConnection instanceof PooledConnection) {
            return ((PooledConnection)physicalConnection).getConnection();
        }
        return null;
    }

    protected void initFailoverParameters() throws UniversalConnectionPoolException {
    }

    public int getMaxStatements() {
        return this.m_maxStatements;
    }

    public synchronized void setMaxStatements(int maxStatements) throws SQLException {
        logger.log(Level.FINEST, "maxStatements: {0}", maxStatements);
        this.m_maxStatements = maxStatements;
    }
}

