/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class JDBCConnectionRetrievalInfo
implements ConnectionRetrievalInfo {
    private static final Logger logger = UCPLoggerFactory.createLogger(JDBCConnectionRetrievalInfo.class.getCanonicalName());
    private final String m_user;
    private final String m_password;
    private final int m_hashcode;
    private Properties m_labels;

    public JDBCConnectionRetrievalInfo(String user, String password) {
        this(user, password, null);
    }

    public JDBCConnectionRetrievalInfo(String user, String password, Properties labels) {
        this.m_user = user;
        this.m_password = password;
        if (labels == null) {
            this.m_labels = null;
        } else {
            this.m_labels = new Properties();
            this.m_labels.putAll((Map<?, ?>)labels);
        }
        String tuser = user == null ? "" : user;
        String tpassword = password == null ? "" : password;
        this.m_hashcode = 31 * tuser.hashCode() + tpassword.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo other = (JDBCConnectionRetrievalInfo)obj;
        String user = this.m_user == null ? "" : this.m_user;
        String password = this.m_password == null ? "" : this.m_password;
        String ouser = other.m_user == null ? "" : other.m_user;
        String opassword = other.m_password == null ? "" : other.m_password;
        return user.equals(ouser) && password.equals(opassword);
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void addLabel(String key, String value) throws UniversalConnectionPoolException {
        String val;
        if (key == null || key.equals("")) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(201);
            logger.throwing(this.getClass().getName(), "addLabel", ucpe);
            throw ucpe;
        }
        String string = val = value == null ? "" : value;
        if (this.m_labels == null) {
            this.m_labels = new Properties();
        }
        this.m_labels.setProperty(key, val);
        logger.log(Level.FINEST, "label added: key={0}, value={1}", new Object[]{key, val});
    }

    public void removeLabel(String key) throws UniversalConnectionPoolException {
        if (key == null || key.equals("")) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(201);
            logger.throwing(this.getClass().getName(), "removeLabel", ucpe);
            throw ucpe;
        }
        if (this.m_labels != null) {
            this.m_labels.remove(key);
            logger.log(Level.FINEST, "label removed successfully: key={0}", key);
        }
    }

    public ConnectionRetrievalInfo getCopyWithNoLabels() {
        return new JDBCConnectionRetrievalInfo(this.m_user, this.m_password, null);
    }

    public Properties getLabels() {
        if (this.m_labels == null) {
            return null;
        }
        Properties labels = new Properties();
        labels.putAll((Map<?, ?>)this.m_labels);
        return labels;
    }
}

