/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class DataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(DataSourceConnectionFactoryAdapter.class.getCanonicalName());
    protected DataSource m_dataSource;

    public DataSourceConnectionFactoryAdapter(DataSource dataSource) throws UniversalConnectionPoolException {
        if (null == dataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(256);
        }
        this.m_dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        JDBCConnectionRetrievalInfo JDBCConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
        Connection connection = null;
        try {
            connection = this.m_dataSource.getConnection(JDBCConnectionRequestInfo.getUser(), JDBCConnectionRequestInfo.getPassword());
        }
        catch (SQLException sqlException) {
            UCPErrorHandler.throwUniversalConnectionPoolException(257, sqlException);
        }
        logger.finest("connection is created successfully");
        return connection;
    }

    public void closeConnection(Object connection) throws UniversalConnectionPoolException {
        if (!(connection instanceof Connection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(258);
        }
        Connection javaSQLConnection = (Connection)connection;
        try {
            javaSQLConnection.close();
        }
        catch (SQLException sqlException) {
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
        logger.finest("connection is closed successfully");
    }
}

