/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTask;
import oracle.ucp.common.Failoverable;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FailoverEventHandlerTaskBase
extends UCPTaskBase<Object>
implements FailoverEventHandlerTask {
    private static final Logger logger = UCPLoggerFactory.createLogger(FailoverEventHandlerTaskBase.class.getCanonicalName());
    private final AtomicBoolean m_terminate = new AtomicBoolean(false);
    private Failoverable m_failoverableObject;
    private TaskHandle<Object> m_taskHandle = null;

    public FailoverEventHandlerTaskBase(Failoverable failoverableObject) throws UniversalConnectionPoolException {
        this.setFailoverableObject(failoverableObject);
    }

    @Override
    public void handleEvent(FailoverEvent event) throws UniversalConnectionPoolException {
        this.m_failoverableObject.handleFailoverEvent(event);
    }

    @Override
    public abstract void run();

    @Override
    public Failoverable getFailoverableObject() {
        return this.m_failoverableObject;
    }

    @Override
    public void setFailoverableObject(Failoverable failoverableObject) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "failoverableObject: {0}", failoverableObject);
        if (failoverableObject == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(58);
            logger.throwing(this.getClass().getName(), "setFailoverableObject", ucpe);
            throw ucpe;
        }
        this.m_failoverableObject = failoverableObject;
    }

    @Override
    public boolean isTerminate() {
        return this.m_terminate.get();
    }

    @Override
    public void setTerminate(boolean terminate) {
        logger.finest(terminate ? "true" : "false");
        this.m_terminate.set(terminate);
    }

    @Override
    public void start() {
        this.m_terminate.set(false);
        if (null == this.m_taskHandle) {
            this.m_taskHandle = this.getTaskManager().submitTask(this);
        } else {
            logger.warning("attempt to start the running failover task");
        }
    }

    protected TaskManager getTaskManager() {
        return UniversalConnectionPoolManagerBase.getTaskManager();
    }

    @Override
    public void waitTerminate() {
        this.m_terminate.set(true);
        if (null != this.m_taskHandle) {
            try {
                this.m_taskHandle.get(100000L);
                this.m_taskHandle = null;
            }
            catch (TaskManagerException e) {
                logger.warning("failed to wait for failover task termination");
            }
        }
    }
}

