/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public abstract class ConnectionFactoryAdapterBase
implements ConnectionFactoryAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(ConnectionFactoryAdapterBase.class.getCanonicalName());
    private UniversalConnectionPool m_universalConnectionPool;

    public abstract Object createConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    public abstract void closeConnection(Object var1) throws UniversalConnectionPoolException;

    public UniversalPooledConnection createPooledConnection(Object connection, ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        UniversalConnectionPoolBase connectionPool = (UniversalConnectionPoolBase)this.getUniversalConnectionPool();
        logger.fine("pooled connection created");
        return new UniversalPooledConnectionImpl(connectionPool, connection, connectionRequestInfo);
    }

    public UniversalConnectionPool getUniversalConnectionPool() {
        return this.m_universalConnectionPool;
    }

    public void setUniversalConnectionPool(UniversalConnectionPool universalConnectionPool) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "universalConnectionPool: {0}", universalConnectionPool);
        if (universalConnectionPool == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(54);
            logger.throwing(this.getClass().getName(), "setUniversalConnectionPool", ucpe);
            throw ucpe;
        }
        this.m_universalConnectionPool = universalConnectionPool;
    }
}

