/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolMBeanBase;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class JDBCUniversalConnectionPoolMBeanImpl
extends UniversalConnectionPoolMBeanBase {
    private static final Logger logger = UCPLoggerFactory.createLogger(JDBCUniversalConnectionPoolMBeanImpl.class.getCanonicalName());
    private JDBCConnectionPool m_genericJDBCConnectionPool = null;
    private OracleJDBCConnectionPool m_oracleJDBCConnectionPool = null;

    public JDBCUniversalConnectionPoolMBeanImpl(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        super(connectionPool);
        if (connectionPool instanceof UniversalConnectionPoolBase) {
            this.m_genericJDBCConnectionPool = (JDBCConnectionPool)connectionPool;
            if (connectionPool instanceof OracleJDBCConnectionPool) {
                this.m_oracleJDBCConnectionPool = (OracleJDBCConnectionPool)connectionPool;
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(365);
        }
    }

    public void setSQLForValidateConnection(String SQLString) throws SQLException {
        logger.log(Level.FINEST, "SQLString: {0}", SQLString);
        if (SQLString == null) {
            throw UCPErrorHandler.newSQLException(46);
        }
        this.m_genericJDBCConnectionPool.setSQLForValidateConnection(SQLString);
    }

    public String getSQLForValidateConnection() {
        return this.m_genericJDBCConnectionPool.getSQLForValidateConnection();
    }

    public void setMaxStatements(int maxStatements) throws SQLException {
        logger.log(Level.FINEST, "maxStatements: {0}", maxStatements);
        this.m_genericJDBCConnectionPool.setMaxStatements(maxStatements);
    }

    public int getMaxStatements() {
        return this.m_genericJDBCConnectionPool.getMaxStatements();
    }

    public void setMaxIdleTime(int idleTime) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "idleTime: {0}", idleTime);
        this.setInactiveConnectionTimeout(idleTime);
    }

    public int getMaxIdleTime() {
        return this.getInactiveConnectionTimeout();
    }

    public void setPropertyCycle(int propertyCycle) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "propertyCycle: {0}", propertyCycle);
        this.setTimeoutCheckInterval(propertyCycle);
    }

    public int getPropertyCycle() {
        return this.getTimeoutCheckInterval();
    }

    public void setFastConnectionFailoverEnabled(boolean failoverEnabled) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "failoverEnabled: {0}", failoverEnabled);
        this.m_genericJDBCConnectionPool.setFailoverEnabled(failoverEnabled);
    }

    public boolean getFastConnectionFailoverEnabled() {
        return this.m_genericJDBCConnectionPool.isFailoverEnabled();
    }

    public void setONSConfiguration(String onsConfigStr) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "onsConfigStr: {0}", Util.maskONSConfigurationString(onsConfigStr));
        if (this.m_oracleJDBCConnectionPool != null) {
            this.m_oracleJDBCConnectionPool.setONSConfiguration(onsConfigStr);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(378);
        }
    }

    public String getONSConfiguration() throws UniversalConnectionPoolException {
        String onsConfigString = null;
        if (this.m_oracleJDBCConnectionPool != null) {
            onsConfigString = this.m_oracleJDBCConnectionPool.getONSConfiguration();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(378);
        }
        return onsConfigString;
    }

    public ModelMBeanInfo getMBeanInfo(ObjectName mbeanObjName, String mbeanDisplayName) throws UniversalConnectionPoolException {
        logger.finest("constructing MBeanInfo");
        if (mbeanObjName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(381);
        }
        if (mbeanDisplayName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(382);
        }
        ModelMBeanInfoSupport jdbcPoolMBeanInfo = null;
        try {
            String descriptorType = "mbean";
            String mbeanName = "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl";
            String mbeanDescription = "JDBCUniversalConnectionPoolMBeanImpl Object";
            DescriptorSupport modelMBeanDescriptor = new DescriptorSupport("name=" + mbeanObjName, "descriptorType=" + descriptorType, "displayName=" + mbeanDisplayName);
            jdbcPoolMBeanInfo = new ModelMBeanInfoSupport(mbeanName, mbeanDescription, this.getJDBCPoolAttributesInfo(), JDBCUniversalConnectionPoolMBeanImpl.getConstructorsInfo(), this.getJDBCPoolOperationsInfo(), JDBCUniversalConnectionPoolMBeanImpl.getNotificationsInfo());
            jdbcPoolMBeanInfo.setMBeanDescriptor(modelMBeanDescriptor);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(367, e);
        }
        catch (MBeanException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(366, e);
        }
        return jdbcPoolMBeanInfo;
    }

    private static ModelMBeanConstructorInfo[] getConstructorsInfo() throws UniversalConnectionPoolException {
        ModelMBeanConstructorInfo[] jdbcPoolConstructorsInfo = new ModelMBeanConstructorInfo[1];
        logger.finest("constructing ConstructorsInfo");
        try {
            Class<JDBCUniversalConnectionPoolMBeanImpl> mBeanClass = JDBCUniversalConnectionPoolMBeanImpl.class;
            Constructor<?>[] constructors = mBeanClass.getConstructors();
            DescriptorSupport jdbcPoolConstructor = new DescriptorSupport();
            jdbcPoolConstructor.setField("name", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            jdbcPoolConstructor.setField("descriptorType", "operation");
            jdbcPoolConstructor.setField("role", "constructor");
            jdbcPoolConstructorsInfo[0] = new ModelMBeanConstructorInfo(UCPErrorHandler.findMessage("JDBCMBeanConstructorDescription"), constructors[0], (Descriptor)jdbcPoolConstructor);
        }
        catch (RuntimeOperationsException ex) {
            UCPErrorHandler.throwUniversalConnectionPoolException(368, ex);
        }
        return jdbcPoolConstructorsInfo;
    }

    private ModelMBeanAttributeInfo[] getJDBCPoolAttributesInfo() throws UniversalConnectionPoolException {
        ModelMBeanAttributeInfo[] jdbcPoolAtributesInfo = new ModelMBeanAttributeInfo[22];
        logger.finest("constructing AttributesInfo");
        try {
            ModelMBeanAttributeInfo[] universalPoolAtributesInfo = this.getUCPMBeanAttributes();
            System.arraycopy(universalPoolAtributesInfo, 0, jdbcPoolAtributesInfo, 0, 16);
            DescriptorSupport sqlForValidateConnectionAttribute = new DescriptorSupport();
            sqlForValidateConnectionAttribute.setField("name", "SQLForValidateConnection");
            sqlForValidateConnectionAttribute.setField("descriptorType", "attribute");
            sqlForValidateConnectionAttribute.setField("displayName", UCPErrorHandler.findMessage("SQLForValidateConnectionAttrDisplayName"));
            sqlForValidateConnectionAttribute.setField("getMethod", "getSQLForValidateConnection");
            sqlForValidateConnectionAttribute.setField("setMethod", "setSQLForValidateConnection");
            jdbcPoolAtributesInfo[16] = new ModelMBeanAttributeInfo("SQLForValidateConnection", "java.lang.String", UCPErrorHandler.findMessage("SQLForValidateConnectionAttrDescription"), true, true, false, sqlForValidateConnectionAttribute);
            DescriptorSupport maxStatementsAttribute = new DescriptorSupport();
            maxStatementsAttribute.setField("name", "maxStatements");
            maxStatementsAttribute.setField("descriptorType", "attribute");
            maxStatementsAttribute.setField("displayName", UCPErrorHandler.findMessage("MaxStatementsAttrDisplayName"));
            maxStatementsAttribute.setField("getMethod", "getMaxStatements");
            maxStatementsAttribute.setField("setMethod", "setMaxStatements");
            jdbcPoolAtributesInfo[17] = new ModelMBeanAttributeInfo("maxStatements", "int", UCPErrorHandler.findMessage("MaxStatementsAttrDescription"), true, true, false, maxStatementsAttribute);
            DescriptorSupport maxIdleTimeAttribute = new DescriptorSupport();
            maxIdleTimeAttribute.setField("name", "maxIdleTime");
            maxIdleTimeAttribute.setField("descriptorType", "attribute");
            maxIdleTimeAttribute.setField("displayName", UCPErrorHandler.findMessage("MaxIdleTimeAttrDisplayName"));
            maxIdleTimeAttribute.setField("getMethod", "getMaxIdleTime");
            maxIdleTimeAttribute.setField("setMethod", "setMaxIdleTime");
            jdbcPoolAtributesInfo[18] = new ModelMBeanAttributeInfo("maxIdleTime", "int", UCPErrorHandler.findMessage("MaxIdleTimeAttrDescription"), true, true, false, maxIdleTimeAttribute);
            DescriptorSupport propertyCycleAttribute = new DescriptorSupport();
            propertyCycleAttribute.setField("name", "propertyCycle");
            propertyCycleAttribute.setField("descriptorType", "attribute");
            propertyCycleAttribute.setField("displayName", UCPErrorHandler.findMessage("PropertyCycleAttrDisplayName"));
            propertyCycleAttribute.setField("getMethod", "getPropertyCycle");
            propertyCycleAttribute.setField("setMethod", "setPropertyCycle");
            jdbcPoolAtributesInfo[19] = new ModelMBeanAttributeInfo("propertyCycle", "int", UCPErrorHandler.findMessage("PropertyCycleAttrDescription"), true, true, false, propertyCycleAttribute);
            DescriptorSupport failoverEnabledAttribute = new DescriptorSupport();
            failoverEnabledAttribute.setField("name", "failoverEnabled");
            failoverEnabledAttribute.setField("descriptorType", "attribute");
            failoverEnabledAttribute.setField("displayName", UCPErrorHandler.findMessage("FailoverEnabledAttrDisplayName"));
            failoverEnabledAttribute.setField("getMethod", "getFastConnectionFailoverEnabled");
            failoverEnabledAttribute.setField("setMethod", "setFastConnectionFailoverEnabled");
            jdbcPoolAtributesInfo[20] = new ModelMBeanAttributeInfo("failoverEnabled", "boolean", UCPErrorHandler.findMessage("FailoverEnabledAttrDescription"), true, true, false, failoverEnabledAttribute);
            DescriptorSupport onsConfigurationAttribute = new DescriptorSupport();
            onsConfigurationAttribute.setField("name", "onsConfiguration");
            onsConfigurationAttribute.setField("descriptorType", "attribute");
            onsConfigurationAttribute.setField("displayName", UCPErrorHandler.findMessage("ONSConfigurationAttrDisplayName"));
            onsConfigurationAttribute.setField("getMethod", "getONSConfiguration");
            onsConfigurationAttribute.setField("setMethod", "setONSConfiguration");
            jdbcPoolAtributesInfo[21] = new ModelMBeanAttributeInfo("onsConfiguration", "java.lang.String", UCPErrorHandler.findMessage("ONSConfigurationAttrDescription"), true, true, false, onsConfigurationAttribute);
        }
        catch (RuntimeOperationsException ex) {
            UCPErrorHandler.throwUniversalConnectionPoolException(369, ex);
        }
        return jdbcPoolAtributesInfo;
    }

    private ModelMBeanOperationInfo[] getJDBCPoolOperationsInfo() throws UniversalConnectionPoolException {
        ModelMBeanOperationInfo[] JDBCPoolOperationsInfo = new ModelMBeanOperationInfo[49];
        logger.finest("constructing OperationsInfo");
        try {
            ModelMBeanOperationInfo[] universalPoolOperationsInfo = this.getUCPMBeanOperations();
            System.arraycopy(universalPoolOperationsInfo, 0, JDBCPoolOperationsInfo, 0, 37);
            MBeanParameterInfo[] params = null;
            String mBeanName = "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl";
            DescriptorSupport getSQLForValidateConnectionOperation = new DescriptorSupport();
            getSQLForValidateConnectionOperation.setField("name", "getSQLForValidateConnection");
            getSQLForValidateConnectionOperation.setField("descriptorType", "operation");
            getSQLForValidateConnectionOperation.setField("class", mBeanName);
            getSQLForValidateConnectionOperation.setField("role", "getter");
            JDBCPoolOperationsInfo[37] = new ModelMBeanOperationInfo("getSQLForValidateConnection", UCPErrorHandler.findMessage("GetSQLForValidateConnectionOperationDescription"), params, "String", 0, getSQLForValidateConnectionOperation);
            DescriptorSupport setSQLForValidateConnectionOperation = new DescriptorSupport();
            setSQLForValidateConnectionOperation.setField("name", "setSQLForValidateConnection");
            setSQLForValidateConnectionOperation.setField("descriptorType", "operation");
            setSQLForValidateConnectionOperation.setField("class", mBeanName);
            setSQLForValidateConnectionOperation.setField("role", "setter");
            String setSQLForValidateConnectionOperationDescription = UCPErrorHandler.findMessage("SetSQLForValidateConnectionOperationDescription");
            MBeanParameterInfo[] sqlForValidateConnectionParams = new MBeanParameterInfo[]{new MBeanParameterInfo("SQLForValidateConnection", "java.lang.String", setSQLForValidateConnectionOperationDescription)};
            JDBCPoolOperationsInfo[38] = new ModelMBeanOperationInfo("setSQLForValidateConnection", setSQLForValidateConnectionOperationDescription, sqlForValidateConnectionParams, "void", 1, setSQLForValidateConnectionOperation);
            DescriptorSupport getMaxStatementsOperation = new DescriptorSupport();
            getMaxStatementsOperation.setField("name", "getMaxStatements");
            getMaxStatementsOperation.setField("descriptorType", "operation");
            getMaxStatementsOperation.setField("class", mBeanName);
            getMaxStatementsOperation.setField("role", "getter");
            JDBCPoolOperationsInfo[39] = new ModelMBeanOperationInfo("getMaxStatements", UCPErrorHandler.findMessage("GetMaxStatementsOperationDescription"), params, "int", 0, getMaxStatementsOperation);
            DescriptorSupport setMaxStatementsOperation = new DescriptorSupport();
            setMaxStatementsOperation.setField("name", "setMaxStatements");
            setMaxStatementsOperation.setField("descriptorType", "operation");
            setMaxStatementsOperation.setField("class", mBeanName);
            setMaxStatementsOperation.setField("role", "setter");
            String setMaxStatementsOperationDescription = UCPErrorHandler.findMessage("SetMaxStatementsOperationDescription");
            MBeanParameterInfo[] maxStatementsParams = new MBeanParameterInfo[]{new MBeanParameterInfo("maxStatements", "java.lang.Integer", setMaxStatementsOperationDescription)};
            JDBCPoolOperationsInfo[40] = new ModelMBeanOperationInfo("setMaxStatements", setMaxStatementsOperationDescription, maxStatementsParams, "void", 1, setMaxStatementsOperation);
            DescriptorSupport getMaxIdleTimeOperation = new DescriptorSupport();
            getMaxIdleTimeOperation.setField("name", "getMaxIdleTime");
            getMaxIdleTimeOperation.setField("descriptorType", "operation");
            getMaxIdleTimeOperation.setField("class", mBeanName);
            getMaxIdleTimeOperation.setField("role", "getter");
            JDBCPoolOperationsInfo[41] = new ModelMBeanOperationInfo("getMaxIdleTime", UCPErrorHandler.findMessage("GetMaxIdleTimeOperationDescription"), params, "int", 0, getMaxIdleTimeOperation);
            DescriptorSupport setMaxIdleTimeOperation = new DescriptorSupport();
            setMaxIdleTimeOperation.setField("name", "setMaxIdleTime");
            setMaxIdleTimeOperation.setField("descriptorType", "operation");
            setMaxIdleTimeOperation.setField("class", mBeanName);
            setMaxIdleTimeOperation.setField("role", "setter");
            String setMaxIdleTimeOperationDescription = UCPErrorHandler.findMessage("SetMaxIdleTimeOperationDescription");
            MBeanParameterInfo[] maxIdleParams = new MBeanParameterInfo[]{new MBeanParameterInfo("maxIdleTime", "java.lang.Integer", setMaxIdleTimeOperationDescription)};
            JDBCPoolOperationsInfo[42] = new ModelMBeanOperationInfo("setMaxIdleTime", setMaxIdleTimeOperationDescription, maxIdleParams, "void", 1, setMaxIdleTimeOperation);
            DescriptorSupport getPropertyCycleOperation = new DescriptorSupport();
            getPropertyCycleOperation.setField("name", "getPropertyCycle");
            getPropertyCycleOperation.setField("descriptorType", "operation");
            getPropertyCycleOperation.setField("class", mBeanName);
            getPropertyCycleOperation.setField("role", "getter");
            JDBCPoolOperationsInfo[43] = new ModelMBeanOperationInfo("getPropertyCycle", UCPErrorHandler.findMessage("GetPropertyCycleOperationDescription"), params, "int", 0, getPropertyCycleOperation);
            DescriptorSupport setPropertyCycleOperation = new DescriptorSupport();
            setPropertyCycleOperation.setField("name", "setPropertyCycle");
            setPropertyCycleOperation.setField("descriptorType", "operation");
            setPropertyCycleOperation.setField("class", mBeanName);
            setPropertyCycleOperation.setField("role", "setter");
            String setPropertyCycleOperationDescription = UCPErrorHandler.findMessage("SetPropertyCycleOperationDescription");
            MBeanParameterInfo[] propertyCycleParams = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyCycle", "java.lang.Integer", setPropertyCycleOperationDescription)};
            JDBCPoolOperationsInfo[44] = new ModelMBeanOperationInfo("setPropertyCycle", setPropertyCycleOperationDescription, propertyCycleParams, "void", 1, setPropertyCycleOperation);
            DescriptorSupport getFastConnectionFailoverEnabledOperation = new DescriptorSupport();
            getFastConnectionFailoverEnabledOperation.setField("name", "getFastConnectionFailoverEnabled");
            getFastConnectionFailoverEnabledOperation.setField("descriptorType", "operation");
            getFastConnectionFailoverEnabledOperation.setField("class", mBeanName);
            getFastConnectionFailoverEnabledOperation.setField("role", "getter");
            JDBCPoolOperationsInfo[45] = new ModelMBeanOperationInfo("getFastConnectionFailoverEnabled", UCPErrorHandler.findMessage("GetFastConnectionFailoverEnabledOperationDescription"), params, "boolean", 0, getFastConnectionFailoverEnabledOperation);
            DescriptorSupport setFastConnectionFailoverEnabledOperation = new DescriptorSupport();
            setFastConnectionFailoverEnabledOperation.setField("name", "setFastConnectionFailoverEnabled");
            setFastConnectionFailoverEnabledOperation.setField("descriptorType", "operation");
            setFastConnectionFailoverEnabledOperation.setField("class", mBeanName);
            setFastConnectionFailoverEnabledOperation.setField("role", "setter");
            String setFastConnectionFailoverEnabledOperationDescription = UCPErrorHandler.findMessage("SetFastConnectionFailoverEnabledOperationDescription");
            MBeanParameterInfo[] fastConnectionFailoverEnabledParams = new MBeanParameterInfo[]{new MBeanParameterInfo("failoverEnabled", "java.lang.Boolean", setFastConnectionFailoverEnabledOperationDescription)};
            JDBCPoolOperationsInfo[46] = new ModelMBeanOperationInfo("setFastConnectionFailoverEnabled", setFastConnectionFailoverEnabledOperationDescription, fastConnectionFailoverEnabledParams, "void", 1, setFastConnectionFailoverEnabledOperation);
            DescriptorSupport getONSConfigurationOperation = new DescriptorSupport();
            getONSConfigurationOperation.setField("name", "getONSConfiguration");
            getONSConfigurationOperation.setField("descriptorType", "operation");
            getONSConfigurationOperation.setField("class", mBeanName);
            getONSConfigurationOperation.setField("role", "getter");
            JDBCPoolOperationsInfo[47] = new ModelMBeanOperationInfo("getONSConfiguration", UCPErrorHandler.findMessage("jdbcmbeanOperationDescription47"), params, "String", 0, getONSConfigurationOperation);
            DescriptorSupport setONSConfigurationOperation = new DescriptorSupport();
            setONSConfigurationOperation.setField("name", "setONSConfiguration");
            setONSConfigurationOperation.setField("descriptorType", "operation");
            setONSConfigurationOperation.setField("class", mBeanName);
            setONSConfigurationOperation.setField("role", "setter");
            MBeanParameterInfo[] onsConfigurationParams = new MBeanParameterInfo[]{new MBeanParameterInfo("onsConfiguration", "java.lang.String", UCPErrorHandler.findMessage("jdbcmbeanOperationDescription48"))};
            JDBCPoolOperationsInfo[48] = new ModelMBeanOperationInfo("setONSConfiguration", UCPErrorHandler.findMessage("jdbcmbeanOperationDescription48"), onsConfigurationParams, "void", 1, setONSConfigurationOperation);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(370, e);
        }
        return JDBCPoolOperationsInfo;
    }

    private static ModelMBeanNotificationInfo[] getNotificationsInfo() {
        ModelMBeanNotificationInfo[] JDBCPoolNotificationInfo = new ModelMBeanNotificationInfo[]{};
        return JDBCPoolNotificationInfo;
    }
}

