/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import oracle.jdbc.internal.OracleConnection;
import oracle.rsi.RSIException;
import oracle.rsi.internal.AbstractIngester;
import oracle.rsi.internal.PartitionManager;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;

class IngesterForPartitionedTable
extends AbstractIngester {
    private final Map<String, StagingArea> partitionNameStagingAreaMap = new HashMap<String, StagingArea>();
    private int jdbcCharsetId;
    private PartitionManager partitionManager = null;

    protected IngesterForPartitionedTable(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.initialize();
        this.scheduleBufferIntervalTask();
    }

    private void initialize() throws Exception {
        this.initDataSource();
        this.initializeJdbcCharsetId();
        this.partitionManager = new PartitionManager(this.dbMetadata, this.predeclaredColumnsMetadataList, this.jdbcCharsetId);
    }

    private void initializeJdbcCharsetId() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            Class<OracleConnection> clazz = OracleConnection.class;
            if (!connection.isWrapperFor(clazz)) {
                throw new RSIException("Connection is not a wrapper for internal OracleConnection");
            }
            OracleConnection oracleConnection = connection.unwrap(clazz);
            this.jdbcCharsetId = Short.toUnsignedInt(oracleConnection.getJdbcCsId());
        }
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.partitionNameStagingAreaMap.forEach((string, stagingArea) -> stagingArea.flushIfDue(bl));
    }

    @Override
    protected void accept(Object object) {
        String string = this.partitionManager.computePartition(object);
        this.partitionNameStagingAreaMap.computeIfAbsent(string, string2 -> new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, this.getPublishedItemsConsumer(string))).accept(object);
    }

    private Consumer<List<Object>> getPublishedItemsConsumer(String string) {
        return list -> {
            try {
                this.jobsQueuedForExecution.incrementAndGet();
                this.executor.execute(new AbstractIngester.IngestJob(this.dataSource, string, (List<Object>)list));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
            }
        };
    }

    @Override
    protected void cleanup() {
        this.partitionNameStagingAreaMap.forEach((string, stagingArea) -> stagingArea.close());
    }
}

