/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleType;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.rsi.RSIException;
import oracle.rsi.ReactiveStreamsIngestion;
import oracle.rsi.StreamEntity;
import oracle.rsi.diagnostics.Diagnosable;
import oracle.rsi.diagnostics.RSIDiagnosable;
import oracle.rsi.internal.FlowSubscriber;
import oracle.rsi.internal.IngesterForNonShardedDatabase;
import oracle.rsi.internal.IngesterForPartitionedTable;
import oracle.rsi.internal.IngesterForShardedDatabase;
import oracle.rsi.internal.Metadata;
import oracle.rsi.internal.RSIBuilder;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSourceImpl;

public abstract class AbstractIngester
implements ReactiveStreamsIngestion,
Diagnosable {
    private static final String CLASS_NAME = AbstractIngester.class.getName();
    private final AtomicInteger currentBufferedRows = new AtomicInteger(0);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    protected final AtomicInteger jobsQueuedForExecution = new AtomicInteger(0);
    protected Executor executor;
    protected Duration bufferInterval;
    private long maxRowsToBuffer = 0L;
    protected int maxRowsPerStagingQueue = 0;
    protected boolean isUseDP;
    protected boolean isUpsert;
    protected String dbUrl;
    protected String dbSchema;
    protected String dbUser;
    protected OpaqueString dbPassword;
    protected String shardedDbGlobalServiceName;
    private String tableName;
    private String[] columns;
    private String[] normalizedColumns;
    private Class<?> entityClass;
    private Field[] fields;
    private Method[] methods;
    private final Properties dpStmtProps = new Properties();
    private Function<byte[], Object> transformer;
    private String insertSql = null;
    private String updateSql = null;
    protected Metadata dbMetadata;
    protected boolean isUseDataLoadMode;
    protected DataSource dataSource;
    protected UniversalConnectionPoolManager ucpManager = null;
    protected final List<Metadata.ColumnMetadata> predeclaredColumnsMetadataList = new ArrayList<Metadata.ColumnMetadata>();
    private String[] primaryConstraintsColumns = null;
    private int maxRowLength = 0;
    protected static final int CONNECTION_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int NEW_DEMAND = 1;
    private final AtomicInteger recordsDueFromSubscriptions = new AtomicInteger(0);
    private final Queue<FlowSubscriber<?>> subscribersList = new ConcurrentLinkedQueue();
    private static final String RSI_CLOSED_ERROR_MSG = "Reactive Streams Ingestion is in closed state.";
    protected static final EnumSet<OracleConnection.CommitOption> COMMIT_OPTIONS = EnumSet.of(OracleConnection.CommitOption.WRITEBATCH, OracleConnection.CommitOption.NOWAIT);
    private final ConcurrentHashMap<Long, Map<DataSource, ThreadLocalContext>> threadContextMap = new ConcurrentHashMap();

    static ReactiveStreamsIngestion newIngestSuiteForNonShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        return new IngesterForNonShardedDatabase(rSIBuilder);
    }

    static ReactiveStreamsIngestion newIngestSuiteForShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        return new IngesterForShardedDatabase(rSIBuilder);
    }

    static ReactiveStreamsIngestion newIngestSuiteForPartitionedTable(RSIBuilder rSIBuilder) throws Exception {
        return new IngesterForPartitionedTable(rSIBuilder);
    }

    protected abstract void accept(Object var1);

    protected abstract void flushItemsIfDue(boolean var1);

    protected abstract void cleanup();

    protected AbstractIngester(RSIBuilder rSIBuilder) throws SQLException, UniversalConnectionPoolException {
        this.readConfiguration(rSIBuilder);
        this.configureRowBuffer();
    }

    private void readConfiguration(RSIBuilder rSIBuilder) {
        this.isUpsert = rSIBuilder.isUpsert;
        this.isUseDP = rSIBuilder.isUseDP;
        this.columns = rSIBuilder.columns;
        this.normalizedColumns = rSIBuilder.normalizedColumns;
        this.fields = rSIBuilder.fields;
        this.methods = rSIBuilder.methods;
        this.executor = rSIBuilder.executor;
        this.tableName = rSIBuilder.tableName;
        this.entityClass = rSIBuilder.entityClass;
        this.bufferInterval = rSIBuilder.bufferInterval;
        this.maxRowsToBuffer = rSIBuilder.maxRowsToBuffer;
        this.maxRowsPerStagingQueue = rSIBuilder.rowsPerBatch;
        this.dbUrl = rSIBuilder.dbUrl;
        this.dbUser = rSIBuilder.dbUser;
        this.dbSchema = rSIBuilder.dbSchema;
        this.dbPassword = rSIBuilder.dbPassword;
        this.shardedDbGlobalServiceName = rSIBuilder.shardedDbGlobalServiceName;
        this.transformer = rSIBuilder.transformer;
        this.dbMetadata = rSIBuilder.dbMetadata;
        this.isUseDataLoadMode = rSIBuilder.isUseDataLoadMode;
        this.initializePredeclaredColumnsMetadata();
        if (!this.isUseDP) {
            this.prepareInsertSql();
            if (this.isUpsert) {
                this.prepareUpdateSql();
            }
        } else {
            if (rSIBuilder.isUseDPParallel) {
                this.dpStmtProps.setProperty("DPPDEF_IN_PARALLEL", "true");
            }
            if (rSIBuilder.isUseDPNoLog) {
                this.dpStmtProps.setProperty("DPPDEF_IN_NOLOG", "true");
            }
            if (rSIBuilder.isUseDPSkipUnusableIndexes) {
                this.dpStmtProps.setProperty("DPPDEF_IN_SKIP_UNUSABLE_INDEX", "true");
            }
            if (rSIBuilder.isUseDPSkipIndexMaintenance) {
                this.dpStmtProps.setProperty("DPPDEF_IN_SKIP_INDEX_MAINT", "true");
            }
            if (rSIBuilder.directPathStorageInitValue != null) {
                this.dpStmtProps.setProperty("DPPDEF_IN_STORAGE_INIT", rSIBuilder.directPathStorageInitValue);
            }
            if (rSIBuilder.directPathStorageNextValue != null) {
                this.dpStmtProps.setProperty("DPPDEF_IN_STORAGE_NEXT", rSIBuilder.directPathStorageNextValue);
            }
        }
    }

    private final void initializePredeclaredColumnsMetadata() {
        List<String> list = Arrays.asList(this.normalizedColumns);
        for (int i = 0; i < this.columns.length; ++i) {
            Metadata.ColumnMetadata columnMetadata = this.dbMetadata.getTable().getColumn(list.get(i));
            if (columnMetadata == null) {
                String string = "Column does not exist - " + this.columns[i];
                this.trace(Level.SEVERE, CLASS_NAME, "initializePredeclaredColumnsMetadata", string, null, new Object[0]);
                throw new RSIException(string);
            }
            this.predeclaredColumnsMetadataList.add(columnMetadata);
            int n = columnMetadata.getLength();
            this.maxRowLength += n == 0 ? 1 : n;
        }
        this.primaryConstraintsColumns = (String[])Arrays.stream(this.dbMetadata.getTable().getPrimaryConstraintColumns()).filter(list::contains).collect(Collectors.toList()).toArray(String[]::new);
        if (this.primaryConstraintsColumns.length == 0) {
            this.isUpsert = false;
        }
    }

    private void configureRowBuffer() {
        if (this.maxRowsToBuffer == 0L) {
            long l = Runtime.getRuntime().maxMemory() / 2L;
            this.maxRowsToBuffer = l / (long)this.maxRowLength;
            if (this.maxRowsToBuffer > Integer.MAX_VALUE) {
                this.maxRowsToBuffer = Integer.MAX_VALUE;
            }
        }
        if (this.maxRowsPerStagingQueue == 0) {
            this.maxRowsPerStagingQueue = 0x200000 / this.maxRowLength;
            if ((long)this.maxRowsPerStagingQueue >= this.maxRowsToBuffer) {
                this.maxRowsPerStagingQueue = (int)this.maxRowsToBuffer;
            }
        }
    }

    protected void initDataSource() throws SQLException, UniversalConnectionPoolException {
        if (this.isUseDataLoadMode) {
            OracleDataSource oracleDataSource = new OracleDataSource();
            oracleDataSource.setURL(this.dbUrl);
            oracleDataSource.setUser(this.dbUser);
            oracleDataSource.setPassword(this.dbPassword.get());
            oracleDataSource.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
            this.dataSource = oracleDataSource;
        } else {
            PoolDataSourceImpl poolDataSourceImpl = new PoolDataSourceImpl();
            poolDataSourceImpl.setURL(this.dbUrl);
            poolDataSourceImpl.setUser(this.dbUser);
            poolDataSourceImpl.setPassword(this.dbPassword.get());
            poolDataSourceImpl.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
            this.dataSource = poolDataSourceImpl;
            this.startConnectionPool();
        }
    }

    protected void startConnectionPool() throws SQLException, UniversalConnectionPoolException {
        assert (this.dataSource instanceof PoolDataSourceImpl);
        PoolDataSourceImpl poolDataSourceImpl = (PoolDataSourceImpl)this.dataSource;
        poolDataSourceImpl.setInitialPoolSize(CONNECTION_POOL_SIZE);
        poolDataSourceImpl.setMinPoolSize(CONNECTION_POOL_SIZE);
        poolDataSourceImpl.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        poolDataSourceImpl.setShardingMode(false);
        if (this.isUpsert || !this.isUseDP) {
            if (this.dbMetadata.getTable().isPartitioned()) {
                poolDataSourceImpl.setMaxStatements(this.dbMetadata.getTable().getPartitionCount() * 2);
            } else {
                poolDataSourceImpl.setMaxStatements(2);
            }
        }
        this.ucpManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        this.ucpManager.createConnectionPool((UniversalConnectionPoolAdapter)poolDataSourceImpl);
        this.ucpManager.startConnectionPool(poolDataSourceImpl.getConnectionPoolName());
    }

    protected void destroyConnectionPool() throws UniversalConnectionPoolException {
        assert (this.dataSource instanceof PoolDataSourceImpl);
        this.ucpManager.destroyConnectionPool(((PoolDataSourceImpl)this.dataSource).getConnectionPoolName());
    }

    public void putRecord(Object object) throws RSIException {
        if (this.isClosed.get()) {
            throw new IllegalStateException(RSI_CLOSED_ERROR_MSG);
        }
        this.recordsDueFromSubscriptions.decrementAndGet();
        try {
            Object object2 = object;
            if (object == null) {
                throw new RSIException("Published item is null. Discarding.");
            }
            if (object instanceof byte[]) {
                if (this.transformer == null) {
                    throw new RSIException("Transformer lambda isn't supplied. Discarding the record.");
                }
                Object object3 = this.transformer.apply((byte[])object);
                if (object3 == null) {
                    throw new RSIException("Published item is transformed to null. Discarding.");
                }
                object2 = object3;
            }
            this.validate(object2);
            this.accept(object2);
            this.currentBufferedRows.incrementAndGet();
        }
        catch (Exception exception) {
            this.debug(Level.INFO, CLASS_NAME, "putRecord", null, exception, new Object[0]);
        }
    }

    protected void validate(Object object) {
        if (object.getClass().isAnnotationPresent(StreamEntity.class)) {
            if (this.entityClass == null) {
                throw new RSIException("The mapping entity class cannot be null for annotated records. Discarding");
            }
        } else if (!(object instanceof Object[]) && !(object instanceof Map)) {
            throw new RSIException("Unsupported item type. Discarding.");
        }
    }

    protected void handleRejectedExecutionException(int n, String string) {
        this.trace(Level.WARNING, CLASS_NAME, "handleRejectedExecutionException", string, null, new Object[0]);
        this.onBatchComplete(n);
    }

    private static void doUpdate(PreparedStatement preparedStatement, long[] lArray, List<Object[]> list, String[] stringArray, String[] stringArray2, List<Metadata.ColumnMetadata> list2) throws SQLException {
        if (lArray.length == 0) {
            AbstractIngester.addBatchForUpdate(preparedStatement, list.get(0), stringArray, stringArray2, list2);
        } else {
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] != -3L) continue;
                AbstractIngester.addBatchForUpdate(preparedStatement, list.get(i), stringArray, stringArray2, list2);
            }
        }
    }

    private static void addBatchForUpdate(PreparedStatement preparedStatement, Object[] objectArray, String[] stringArray, String[] stringArray2, List<Metadata.ColumnMetadata> list) {
        int n = 1;
        int n2 = stringArray.length - stringArray2.length + 1;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!AbstractIngester.isPrimaryKeyColumn(stringArray[i], stringArray2)) {
                    AbstractIngester.bindParameter(preparedStatement, n, objectArray[i], list.get(i));
                    ++n;
                    continue;
                }
                AbstractIngester.bindParameter(preparedStatement, n2, objectArray[i], list.get(i));
                ++n2;
            }
            preparedStatement.addBatch();
        }
        catch (SQLException sQLException) {
            RSIDiagnosable.getInstance().trace(Level.WARNING, CLASS_NAME, "addBatchForUpdate", "Discarding the record", sQLException, Arrays.toString(objectArray));
        }
    }

    private static void bindParameter(PreparedStatement preparedStatement, int n, Object object, Metadata.ColumnMetadata columnMetadata) throws SQLException {
        SQLType sQLType = columnMetadata.getSQLType();
        if (sQLType == OracleType.BINARY_FLOAT || sQLType == OracleType.BINARY_DOUBLE) {
            preparedStatement.setObject(n, object, sQLType);
        } else if (object instanceof InputStream) {
            if (sQLType == JDBCType.BINARY || sQLType == OracleType.RAW || sQLType == OracleType.LONG_RAW || sQLType == OracleType.BLOB) {
                preparedStatement.setBinaryStream(n, (InputStream)object);
            } else if (AbstractIngester.isNationalCharacterSetType(columnMetadata)) {
                preparedStatement.unwrap(OraclePreparedStatement.class).setFormOfUse(n, (short)2);
                preparedStatement.setAsciiStream(n, (InputStream)object);
            } else if (AbstractIngester.isAsciiCharacterSetType(sQLType)) {
                preparedStatement.setAsciiStream(n, (InputStream)object);
            } else {
                preparedStatement.setObject(n, object);
            }
        } else if (object instanceof Reader) {
            if (AbstractIngester.isNationalCharacterSetType(columnMetadata)) {
                preparedStatement.setNCharacterStream(n, (Reader)object);
            } else if (AbstractIngester.isAsciiCharacterSetType(sQLType)) {
                preparedStatement.setCharacterStream(n, (Reader)object);
            } else {
                preparedStatement.setObject(n, object);
            }
        } else {
            preparedStatement.setObject(n, object);
        }
    }

    private static boolean isAsciiCharacterSetType(SQLType sQLType) {
        return sQLType == OracleType.CHAR || sQLType == OracleType.VARCHAR2 || sQLType == OracleType.LONG || sQLType == OracleType.CLOB;
    }

    private static boolean isNationalCharacterSetType(Metadata.ColumnMetadata columnMetadata) {
        return columnMetadata.isNChar() || columnMetadata.isNClob();
    }

    private PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        if (!this.isUseDP) {
            return connection.prepareStatement(this.insertSql);
        }
        if (string != null) {
            return ((OracleConnection)connection).prepareDirectPath(this.dbSchema, this.tableName, this.columns, string, this.dpStmtProps);
        }
        return ((OracleConnection)connection).prepareDirectPath(this.dbSchema, this.tableName, this.columns, this.dpStmtProps);
    }

    private void prepareInsertSql() {
        if (this.insertSql == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("INSERT INTO " + this.tableName + " (");
            String string = Arrays.toString(this.columns);
            stringBuilder.append(string.substring(1, string.length() - 1));
            stringBuilder.append(") VALUES (");
            for (int i = 0; i < this.columns.length - 1; ++i) {
                stringBuilder.append("?, ");
            }
            stringBuilder.append("?)");
            this.insertSql = stringBuilder.toString();
        }
    }

    private void prepareUpdateSql() {
        if (this.updateSql == null) {
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("UPDATE " + this.tableName + " SET ");
            for (int i = 0; i < this.columns.length; ++i) {
                if (AbstractIngester.isPrimaryKeyColumn(this.columns[i], this.primaryConstraintsColumns)) {
                    arrayList.add((CallSite)((Object)("\n" + this.columns[i] + " = ?")));
                    continue;
                }
                arrayList2.add((CallSite)((Object)("\n" + this.columns[i] + " = ?")));
            }
            stringBuilder.append(String.join((CharSequence)", ", arrayList2));
            stringBuilder.append("\nWHERE ");
            stringBuilder.append(String.join((CharSequence)" AND ", arrayList));
            this.updateSql = stringBuilder.toString();
        }
    }

    private static boolean isPrimaryKeyColumn(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string2.equalsIgnoreCase(string = string.replaceAll("^\"|\"$", ""))) continue;
            return true;
        }
        return false;
    }

    private void onBatchComplete(int n) {
        this.currentBufferedRows.addAndGet(-n);
        this.jobsQueuedForExecution.decrementAndGet();
        if (!this.isClosed.get()) {
            this.resumeSubscribers();
        }
    }

    protected void scheduleBufferIntervalTask() {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.debug(Level.FINEST, CLASS_NAME, "scheduleBufferIntervalTask", "Scheduler initiated flush event. Buffer will be flushed if due.", null, new Object[0]);
                this.flushIfDue(false);
            }
            catch (Exception exception) {
                this.trace(Level.WARNING, CLASS_NAME, "scheduleBufferIntervalTask", "Buffer flush task encountered an error", exception, new Object[0]);
            }
        }, this.bufferInterval.toMillis(), this.bufferInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void flushIfDue(boolean bl) {
        this.flushItemsIfDue(bl);
    }

    private boolean isBufferAvailableFor(int n) {
        return (long)(this.currentBufferedRows.get() + this.recordsDueFromSubscriptions.get() + n) <= this.maxRowsToBuffer;
    }

    long getNextDemand() {
        if (this.isClosed.get()) {
            throw new IllegalStateException(RSI_CLOSED_ERROR_MSG);
        }
        if (this.isBufferAvailableFor(1)) {
            this.recordsDueFromSubscriptions.addAndGet(1);
            return 1L;
        }
        if (this.jobsQueuedForExecution.get() == 0) {
            String string = "Buffer is full. All previous ingest jobs have finished.  Stalling the subscribers and initiating flush event.";
            this.debug(Level.FINEST, CLASS_NAME, "getNextDemand", string, null, new Object[0]);
            this.flushIfDue(true);
        }
        return 0L;
    }

    private void resumeSubscribers() {
        this.subscribersList.forEach(flowSubscriber -> flowSubscriber.resume());
    }

    private void clearSubscribers() {
        for (FlowSubscriber flowSubscriber : this.subscribersList) {
            flowSubscriber.onComplete();
        }
        this.subscribersList.clear();
    }

    public Flow.Subscriber<Object> subscriber() {
        if (this.isClosed.get()) {
            throw new IllegalStateException(RSI_CLOSED_ERROR_MSG);
        }
        return new FlowSubscriber<Object>(this);
    }

    void register(FlowSubscriber<?> flowSubscriber) {
        if (this.isClosed.get()) {
            throw new IllegalStateException(RSI_CLOSED_ERROR_MSG);
        }
        this.subscribersList.add(flowSubscriber);
    }

    @Override
    public void close() {
        if (this.isClosed.get()) {
            return;
        }
        if (this.isClosed.compareAndSet(false, true)) {
            while (this.jobsQueuedForExecution.get() > 0) {
            }
            this.debug(Level.FINEST, CLASS_NAME, "close", "Initiating flush on close event.", null, new Object[0]);
            this.flushIfDue(true);
            while (this.currentBufferedRows.get() != 0) {
            }
            this.shutdown();
        }
    }

    private void shutdown() {
        this.cleanup();
        this.scheduledExecutorService.shutdown();
        this.clearSubscribers();
        if (this.isUseDataLoadMode) {
            this.threadContextMap.forEach((l, map) -> map.forEach((dataSource, threadLocalContext) -> threadLocalContext.commitAndClose()));
        } else {
            try {
                this.destroyConnectionPool();
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                this.trace(Level.WARNING, CLASS_NAME, "shutdown", null, universalConnectionPoolException, new Object[0]);
            }
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return RSIDiagnosable.getInstance();
    }

    class IngestJob
    implements Runnable {
        private final DataSource dataSource;
        private String partitionName = null;
        private final List<Object> items;

        public IngestJob(DataSource dataSource, List<Object> list) {
            this.dataSource = dataSource;
            this.items = list;
        }

        public IngestJob(DataSource dataSource, String string, List<Object> list) {
            this(dataSource, list);
            this.partitionName = string;
        }

        @Override
        public void run() {
            try {
                if (AbstractIngester.this.isUseDataLoadMode) {
                    this.ingestDataLoad();
                } else {
                    this.ingestStreamLoad();
                }
            }
            catch (SQLException sQLException) {
                AbstractIngester.this.trace(Level.SEVERE, CLASS_NAME, "run", null, sQLException, new Object[0]);
            }
            finally {
                AbstractIngester.this.onBatchComplete(this.items.size());
            }
        }

        private void ingestStreamLoad() throws SQLException {
            block9: {
                String string = "New ingest job is being run by " + Thread.currentThread().getName();
                AbstractIngester.this.debug(Level.FINEST, CLASS_NAME, "run", string, null, new Object[0]);
                try (Connection connection = this.dataSource.getConnection();){
                    connection.setAutoCommit(false);
                    List<Object[]> list = this.getValuesToBind();
                    try {
                        this.doInsert(connection, list);
                    }
                    catch (BatchUpdateException batchUpdateException) {
                        if (AbstractIngester.this.isUpsert && (batchUpdateException.getErrorCode() == 24381 || batchUpdateException.getErrorCode() == 1)) {
                            this.doUpdate(connection, batchUpdateException.getLargeUpdateCounts(), list);
                            break block9;
                        }
                        throw batchUpdateException;
                    }
                }
            }
        }

        private ThreadLocalContext getTLC() {
            ThreadLocalContext threadLocalContext;
            Map<DataSource, ThreadLocalContext> map = AbstractIngester.this.threadContextMap.get(Thread.currentThread().getId());
            if (map == null) {
                HashMap<DataSource, ThreadLocalContext> hashMap = new HashMap<DataSource, ThreadLocalContext>();
                threadLocalContext = new ThreadLocalContext(this.dataSource);
                hashMap.put(this.dataSource, threadLocalContext);
                AbstractIngester.this.threadContextMap.put(Thread.currentThread().getId(), hashMap);
            } else {
                threadLocalContext = map.get(this.dataSource);
                if (threadLocalContext == null) {
                    threadLocalContext = new ThreadLocalContext(this.dataSource);
                    map.put(this.dataSource, threadLocalContext);
                }
            }
            return threadLocalContext;
        }

        private void ingestDataLoad() throws SQLException {
            ThreadLocalContext threadLocalContext = this.getTLC();
            threadLocalContext.consume(this.getValuesToBind());
        }

        private List<Object[]> getValuesToBind() {
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(this.items.size());
            for (Object object : this.items) {
                try {
                    int n;
                    Object[] objectArray;
                    if (object instanceof Object[]) {
                        if (((Object[])object).length != AbstractIngester.this.columns.length) {
                            throw new IllegalArgumentException("Discarding the record due to invalid number of column values. Number of columns: " + AbstractIngester.this.columns.length + ", number of supplied values: " + ((Object[])object).length + ".");
                        }
                        arrayList.add((Object[])object);
                        continue;
                    }
                    if (object instanceof Map) {
                        objectArray = new Object[AbstractIngester.this.columns.length];
                        for (n = 0; n < AbstractIngester.this.columns.length; ++n) {
                            objectArray[n] = ((Map)object).get(AbstractIngester.this.columns[n]);
                        }
                        arrayList.add(objectArray);
                        continue;
                    }
                    objectArray = new Object[AbstractIngester.this.columns.length];
                    for (n = 0; n < AbstractIngester.this.columns.length; ++n) {
                        if (AbstractIngester.this.fields != null && n < AbstractIngester.this.fields.length) {
                            objectArray[n] = AbstractIngester.this.fields[n].get(object);
                            continue;
                        }
                        if (AbstractIngester.this.methods == null || n - AbstractIngester.this.fields.length >= AbstractIngester.this.methods.length) continue;
                        objectArray[n] = AbstractIngester.this.methods[n - AbstractIngester.this.fields.length].invoke(object, new Object[0]);
                    }
                    arrayList.add(objectArray);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    AbstractIngester.this.trace(Level.WARNING, CLASS_NAME, "getValuesToBind", null, exception, new Object[0]);
                }
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doInsert(Connection connection, List<Object[]> list) throws SQLException {
            try (PreparedStatement preparedStatement = AbstractIngester.this.prepareStatement(connection, this.partitionName);){
                for (Object[] objectArray : list) {
                    try {
                        for (int i = 0; i < AbstractIngester.this.columns.length; ++i) {
                            AbstractIngester.bindParameter(preparedStatement, i + 1, objectArray[i], AbstractIngester.this.predeclaredColumnsMetadataList.get(i));
                        }
                        preparedStatement.addBatch();
                    }
                    catch (SQLException sQLException) {
                        AbstractIngester.this.trace(Level.WARNING, CLASS_NAME, "doInsert", "Discarding the record.", sQLException, Arrays.toString(objectArray));
                    }
                }
                try {
                    preparedStatement.executeLargeBatch();
                }
                finally {
                    ((OracleConnection)connection).commit(COMMIT_OPTIONS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUpdate(Connection connection, long[] lArray, List<Object[]> list) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement(AbstractIngester.this.updateSql);){
                AbstractIngester.doUpdate(preparedStatement, lArray, list, AbstractIngester.this.columns, AbstractIngester.this.primaryConstraintsColumns, AbstractIngester.this.predeclaredColumnsMetadataList);
                try {
                    preparedStatement.executeLargeBatch();
                }
                finally {
                    ((OracleConnection)connection).commit(COMMIT_OPTIONS);
                }
            }
        }
    }

    private class ThreadLocalContext {
        private final String CLASS_NAME = ThreadLocalContext.class.getName();
        private final DataSource dataSource;
        private Connection connection;
        private PreparedStatement preparedStatement;
        private final ConcurrentHashMap<String, PreparedStatement> mapOfPartitionNameAndPreparedStatement = new ConcurrentHashMap();

        private ThreadLocalContext(DataSource dataSource) {
            this.dataSource = dataSource;
            try {
                this.connection = this.getNewConnection();
                this.connection.setAutoCommit(false);
                this.preparedStatement = AbstractIngester.this.prepareStatement(this.connection, null);
            }
            catch (SQLException sQLException) {
                AbstractIngester.this.trace(Level.SEVERE, this.CLASS_NAME, "ThreadLocalContext", null, sQLException, new Object[0]);
            }
        }

        private Connection getNewConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        public void commitAndClose() {
            try {
                ((OracleConnection)this.connection).commit(COMMIT_OPTIONS);
                this.preparedStatement.close();
                this.connection.close();
            }
            catch (SQLException sQLException) {
                RSIException rSIException = new RSIException();
                rSIException.initCause(sQLException);
                throw rSIException;
            }
        }

        public void consume(List<Object[]> list) throws SQLException {
            try {
                this.doInsert(this.preparedStatement, list);
            }
            catch (BatchUpdateException batchUpdateException) {
                if (AbstractIngester.this.isUpsert && (batchUpdateException.getErrorCode() == 24381 || batchUpdateException.getErrorCode() == 1)) {
                    this.doUpdate(this.preparedStatement, batchUpdateException.getLargeUpdateCounts(), list);
                }
                throw batchUpdateException;
            }
        }

        private void doInsert(PreparedStatement preparedStatement, List<Object[]> list) throws SQLException {
            for (Object[] objectArray : list) {
                for (int i = 0; i < AbstractIngester.this.columns.length; ++i) {
                    AbstractIngester.bindParameter(preparedStatement, i + 1, objectArray[i], AbstractIngester.this.predeclaredColumnsMetadataList.get(i));
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }

        private void doUpdate(PreparedStatement preparedStatement, long[] lArray, List<Object[]> list) throws SQLException {
            AbstractIngester.doUpdate(preparedStatement, lArray, list, AbstractIngester.this.columns, AbstractIngester.this.primaryConstraintsColumns, AbstractIngester.this.predeclaredColumnsMetadataList);
        }
    }
}

