/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;
import oracle.rsi.RSIException;
import oracle.rsi.internal.PushPublisher;
import oracle.rsi.internal.RSIBuilder;

public interface ReactiveStreamsIngestion
extends AutoCloseable {
    public static Builder builder() {
        return new RSIBuilder();
    }

    public static <T> oracle.rsi.PushPublisher<T> pushPublisher() {
        return new PushPublisher();
    }

    public <T> Flow.Subscriber<T> subscriber();

    @Override
    public void close();

    public static interface Builder {
        public Builder url(String var1);

        public Builder username(String var1);

        public Builder schema(String var1);

        public Builder password(String var1);

        public Builder globalServiceName(String var1);

        public Builder executor(Executor var1);

        public Builder bufferRows(int var1);

        public Builder rowsPerBatch(int var1);

        public Builder bufferInterval(Duration var1);

        public Builder transformer(Function<byte[], Object> var1);

        public Builder table(String var1);

        public Builder columns(String[] var1);

        public Builder entity(Class<?> var1);

        public Builder doUpsert();

        public Builder useDirectPath();

        @Deprecated
        public Builder useDirectPathParallel();

        public Builder useDirectPathParallel(boolean var1);

        public Builder useDirectPathNoLog();

        public Builder useDirectPathSkipUnusableIndexes();

        public Builder useDirectPathSkipIndexMaintenance();

        public Builder useDirectPathStorageInit(String var1);

        public Builder useDirectPathStorageNext(String var1);

        public Builder useDataLoadMode();

        public ReactiveStreamsIngestion build() throws RSIException;
    }
}

