/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Stream;
import oracle.jdbc.internal.OpaqueString;
import oracle.rsi.RSIException;
import oracle.rsi.ReactiveStreamsIngestion;
import oracle.rsi.StreamEntity;
import oracle.rsi.StreamField;
import oracle.rsi.diagnostics.Diagnosable;
import oracle.rsi.diagnostics.RSIDiagnosable;
import oracle.rsi.internal.IngestSuite;
import oracle.rsi.internal.Metadata;

public class RSIBuilder
implements ReactiveStreamsIngestion.Builder,
Cloneable,
Diagnosable {
    private static final String CLASS_NAME = RSIBuilder.class.getName();
    private static final int DB_SHARD_CATALOG = 4;
    private static final int DEFAULT_BUFFER_INTERVAL_DURATION_SECONDS = 5;
    private DatabaseType dbType = DatabaseType.NON_SHARDED;
    String dbUrl = null;
    String dbUser = null;
    String dbSchema = null;
    OpaqueString dbPassword = null;
    String shardedDbGlobalServiceName = null;
    String tableName = null;
    private String normalizedTableName = null;
    String[] columns = null;
    String[] normalizedColumns = null;
    Class<?> entityClass = null;
    Field[] fields = null;
    Method[] methods = null;
    boolean isUpsert = false;
    boolean isUseDP = false;
    boolean isUseDPParallel = false;
    boolean isUseDPNoLog = false;
    boolean isUseDPSkipUnusableIndexes = false;
    boolean isUseDPSkipIndexMaintenance = false;
    String directPathStorageInitValue = null;
    String directPathStorageNextValue = null;
    int maxRowsToBuffer = 0;
    int rowsPerBatch = 0;
    Duration bufferInterval = Duration.ofSeconds(0L);
    Executor executor = null;
    Function<byte[], Object> transformer = null;
    Metadata dbMetadata;

    @Override
    public ReactiveStreamsIngestion.Builder url(String string) {
        if (this.dbUrl != null) {
            throw new IllegalStateException("The database url is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database url cannot be null.");
        }
        this.dbUrl = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder username(String string) {
        if (this.dbUser != null) {
            throw new IllegalStateException("The database username is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database username cannot be null.");
        }
        this.dbUser = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder schema(String string) {
        if (this.dbSchema != null) {
            throw new IllegalStateException("The database schema is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database schema cannot be null.");
        }
        this.dbSchema = string.toUpperCase();
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder password(String string) {
        if (this.dbPassword != null) {
            throw new IllegalStateException("The database password is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database password cannot be null.");
        }
        this.dbPassword = OpaqueString.newOpaqueString((CharSequence)string);
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder globalServiceName(String string) {
        if (this.shardedDbGlobalServiceName != null) {
            throw new IllegalStateException("The global service name is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The global service name cannot be null.");
        }
        this.shardedDbGlobalServiceName = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder executor(Executor executor) {
        if (this.executor != null) {
            throw new IllegalStateException("The thread pool instance is already set.");
        }
        if (executor == null) {
            throw new IllegalStateException("The thread pool instance cannot be null.");
        }
        this.executor = executor;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder bufferRows(int n) {
        if (this.maxRowsToBuffer != 0) {
            throw new IllegalStateException("Number of rows allowed to buffer is already set.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Number of rows allowed to buffer cannot be zero or negative.");
        }
        this.maxRowsToBuffer = n;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder rowsPerBatch(int n) {
        if (this.rowsPerBatch != 0) {
            throw new IllegalStateException("Number of rows per batch is already set.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Number of rows per batch cannot be zero or negative.");
        }
        this.rowsPerBatch = n;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder bufferInterval(Duration duration) {
        if (!this.bufferInterval.isZero()) {
            throw new IllegalStateException("Buffer interval is already set.");
        }
        Duration duration2 = Duration.ofSeconds(2L);
        this.bufferInterval = duration.compareTo(duration2) < 0 ? duration2 : duration;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder transformer(Function<byte[], Object> function) {
        if (this.transformer != null) {
            throw new IllegalStateException("The transformer instance is already set.");
        }
        if (function == null) {
            throw new IllegalArgumentException("The transformer instance cannot be null.");
        }
        this.transformer = function;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder table(String string) {
        if (this.tableName != null) {
            throw new IllegalStateException("The database table name is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database table name cannot be null.");
        }
        this.tableName = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder columns(String[] stringArray) {
        if (this.columns != null) {
            throw new IllegalStateException("Column names are already set.");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Column names cannot be null.");
        }
        this.columns = stringArray;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder entity(Class<?> clazz) {
        if (this.entityClass != null) {
            throw new IllegalArgumentException("The mapping class is already set.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The mapping class cannot be bull.");
        }
        this.entityClass = clazz;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder doUpsert() {
        if (this.isUpsert) {
            throw new IllegalStateException("UPSERT is already enabled.");
        }
        if (this.isUseDP) {
            throw new IllegalStateException("Cannot use Direct Path load for Upsert.");
        }
        this.isUpsert = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPath() {
        if (this.isUseDP) {
            throw new IllegalStateException("The Direct Path load is already enabled.");
        }
        if (this.isUpsert) {
            throw new IllegalStateException("Cannot use Direct Path load for Upsert.");
        }
        this.isUseDP = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathParallel() {
        if (this.isUseDPParallel) {
            throw new IllegalStateException("The Direct Path PARALLEL statement option is already enabled.");
        }
        this.isUseDPParallel = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathNoLog() {
        if (this.isUseDPNoLog) {
            throw new IllegalStateException("The Direct Path NOLOG statement option is already enabled.");
        }
        this.isUseDPNoLog = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathSkipUnusableIndexes() {
        if (this.isUseDPSkipUnusableIndexes) {
            throw new IllegalStateException("The Direct Path SKIP_UNUSABLE_INDEXES statement option is already enabled.");
        }
        this.isUseDPSkipUnusableIndexes = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathSkipIndexMaintenance() {
        if (this.isUseDPSkipIndexMaintenance) {
            throw new IllegalStateException("The Direct Path SKIP_INDEX_MAINTENANCE statement option is already enabled.");
        }
        this.isUseDPSkipIndexMaintenance = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathStorageInit(String string) {
        if (this.directPathStorageInitValue != null) {
            throw new IllegalStateException("The Direct Path STORAGE_INIT value is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The Direct Path STORAGE_INIT value cannot be null.");
        }
        this.directPathStorageInitValue = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathStorageNext(String string) {
        if (this.directPathStorageNextValue != null) {
            throw new IllegalStateException("The Direct Path STORAGE_NEXT value is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The Direct Path STORAGE_NEXT value cannot be null.");
        }
        this.directPathStorageNextValue = string;
        return this;
    }

    private void validateAndReadMappingClass() {
        if (this.entityClass != null) {
            String string;
            if (this.tableName != null) {
                throw new IllegalStateException("Redundant parameter - table name. The mapping class is already supplied.");
            }
            if (this.columns != null) {
                throw new IllegalStateException("Redundant parameter - column names. The mapping class is already supplied.");
            }
            StreamEntity streamEntity = this.entityClass.getAnnotation(StreamEntity.class);
            this.tableName = string = streamEntity.tableName().isEmpty() ? this.entityClass.getSimpleName() : streamEntity.tableName();
            this.fields = (Field[])Stream.of(this.entityClass.getDeclaredFields()).filter(field -> field.getAnnotation(StreamField.class) != null).map(field -> {
                field.setAccessible(true);
                return field;
            }).toArray(Field[]::new);
            Stream<String> stream = Stream.of(this.fields).map(field -> field.getAnnotation(StreamField.class).columnName().isBlank() ? field.getName() : field.getAnnotation(StreamField.class).columnName());
            this.methods = (Method[])Stream.of(this.entityClass.getDeclaredMethods()).filter(method -> method.getAnnotation(StreamField.class) != null).toArray(Method[]::new);
            Stream<String> stream2 = Stream.of(this.methods).map(method -> method.getAnnotation(StreamField.class).columnName().isBlank() ? (method.getName().matches("get(.*)") ? method.getName().substring(3) : method.getName()) : method.getAnnotation(StreamField.class).columnName());
            this.columns = (String[])Stream.concat(stream, stream2).toArray(String[]::new);
        }
    }

    private final String normalizeSchemaObjectAndGet(String string, boolean bl) {
        String string2;
        Object object;
        String string3 = "ACCESS|ADD|ALL|ALTER|AND|ANY|AS|ASC|AUDIT|BETWEEN|BY|CHAR|CHECK|CLUSTER|COLUMN|COMMENT|COMPRESS|CONNECT|CREATE|CURRENT|DATE|DECIMAL|DEFAULT|DELETE|DESC|DISTINCT|DROP|ELSE|EXCLUSIVE|EXISTS|FILE|FLOAT|FOR|FROM|GRANT|GROUP|HAVING|IDENTIFIED|IMMEDIATE|IN|INCREMENT|INDEX|INITIAL|INSERT|INTEGER|INTERSECT|INTO|IS|LEVEL|LIKE|LOCK|LONG|MAXEXTENTS|MINUS|MLSLABEL|MODE|MODIFY|NOAUDIT|NOCOMPRESS|NOT|NOWAIT|NULL|NUMBER|OF|OFFLINE|ON|ONLINE|OPTION|OR|ORDER|PCTFREE|PRIOR|PUBLIC|RAW|RENAME|RESOURCE|REVOKE|ROW|ROWID|ROWNUM|ROWS|SELECT|SESSION|SET|SHARE|SIZE|SMALLINT|START|SUCCESSFUL|SYNONYM|SYSDATE|TABLE|THEN|TO|TRIGGER|UID|UNION|UNIQUE|UPDATE|USER|VALIDATE|VALUES|VARCHAR|VARCHAR2|VIEW|WHENEVER|WHERE|WITH";
        String string4 = string3 + "|COLUMN_VALUE|IS|NESTED_TABLE_ID";
        Object object2 = object = bl ? string4 : string3;
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            string2 = string.toUpperCase();
            if (!string2.matches("^[a-zA-Z][a-zA-Z0-9_]*$") || string.matches((String)object)) {
                String string5 = "Invalid schema object name: " + string + ".";
                this.trace(Level.SEVERE, CLASS_NAME, "normalizeSchemaObjectAndGet", string5, null, new Object[0]);
                throw new RSIException(string5);
            }
        } else {
            string2 = string.replaceAll("^\"|\"$", "");
            if (string2.matches("^.*[\"|\u0000].*$") || bl && string2.equals("ROWID")) {
                String string6 = "Invalid schema object name: " + string + ".";
                this.trace(Level.SEVERE, CLASS_NAME, "normalizeSchemaObjectAndGet", string6, null, new Object[0]);
                throw new RSIException(string6);
            }
        }
        return string2;
    }

    private void normalizeTableNameAndColumns() {
        this.normalizedTableName = this.normalizeSchemaObjectAndGet(this.tableName, false);
        this.normalizedColumns = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            this.normalizedColumns[i] = this.normalizeSchemaObjectAndGet(this.columns[i], true);
        }
    }

    private void configureDefaults() {
        if (this.columns == null || this.columns.length == 0) {
            this.trace(Level.SEVERE, CLASS_NAME, "configureDefaults", "Columns cannot be null or empty.", null, new Object[0]);
            throw new RSIException("Columns cannot be null or empty.");
        }
        this.executor = this.executor != null ? this.executor : ForkJoinPool.commonPool();
        this.bufferInterval = this.bufferInterval.isZero() ? Duration.ofSeconds(5L) : this.bufferInterval;
    }

    private void initDatabaseType(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT GSMADMIN_INTERNAL.GETSHARDINGMODE FROM DUAL");){
            int n;
            if (resultSet.next() && ((n = resultSet.getInt(1)) & 4) != 0) {
                this.dbType = DatabaseType.SHARDED;
                if (this.shardedDbGlobalServiceName == null) {
                    this.trace(Level.SEVERE, CLASS_NAME, "initDatabaseType", "Global Service Name cannot be null.", null, new Object[0]);
                    throw new RSIException("Global Service Name cannot be null.");
                }
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 904) {
                this.debug(Level.INFO, CLASS_NAME, "initDatabaseType", "Defaulting the database type to Non-Sharded.", sQLException, new Object[0]);
            }
            this.debug(Level.INFO, CLASS_NAME, "initDatabaseType", null, sQLException, new Object[0]);
            throw sQLException;
        }
    }

    private void initDbMetadata(Connection connection) {
        this.dbMetadata = Metadata.getMetadata(this.normalizedTableName, this.dbSchema, connection);
    }

    private void init() throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword.get());){
            this.initDatabaseType(connection);
            this.initDbMetadata(connection);
        }
    }

    @Override
    public ReactiveStreamsIngestion build() throws RSIException {
        this.validateAndReadMappingClass();
        this.normalizeTableNameAndColumns();
        this.configureDefaults();
        try {
            this.init();
            if (this.dbType.equals((Object)DatabaseType.SHARDED)) {
                this.debug(Level.INFO, CLASS_NAME, "build", "Database type is Sharded.", null, new Object[0]);
                return IngestSuite.newIngestSuiteForShardedDatabase(this);
            }
            this.debug(Level.INFO, CLASS_NAME, "build", "Database type is non-sharded.", null, new Object[0]);
            if (this.dbMetadata.getTable().isPartitioned()) {
                this.debug(Level.INFO, CLASS_NAME, "build", "Table is partitioned.", null, new Object[0]);
                return IngestSuite.newIngestSuiteForPartitionedTable(this);
            }
            return IngestSuite.newIngestSuiteForNonShardedDatabase(this);
        }
        catch (Exception exception) {
            RSIException rSIException = new RSIException(exception.getMessage(), exception.getCause());
            this.trace(Level.SEVERE, CLASS_NAME, "build", rSIException.getMessage(), rSIException, new Object[0]);
            throw rSIException;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return RSIDiagnosable.getInstance();
    }

    private static enum DatabaseType {
        NON_SHARDED,
        SHARDED;

    }
}

