/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.rsi.RSIException;
import oracle.rsi.ShardRecord;
import oracle.rsi.internal.IngestSuite;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.routing.ShardInfo;
import oracle.ucp.routing.oracle.OracleShardRoutingCache;

class IngestSuiteForShardedDatabase
extends IngestSuite {
    private static final String CLASS_NAME = IngestSuiteForShardedDatabase.class.getName();
    private OracleShardRoutingCache routingCache = null;
    private final PoolDataSourceImpl catalogDbPoolDataSource = new PoolDataSourceImpl();
    private final Map<String, PoolDataSourceStagingAreaDuo> mapOfShardNameAndPdsStagingAreaDuo = new HashMap<String, PoolDataSourceStagingAreaDuo>();

    protected IngestSuiteForShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.startConnectionPool();
        this.initializeStagingArea();
        this.scheduleBufferIntervalTask();
    }

    protected void startConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.initializeCatalogDbConnectionPool();
        this.initializeShardRoutingCache();
        this.initializeShardSpecificConnectionPools();
    }

    private void initializeCatalogDbConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.catalogDbPoolDataSource.setUser(this.dbUser);
        this.catalogDbPoolDataSource.setPassword(this.dbPassword.get());
        this.catalogDbPoolDataSource.setURL(this.dbUrl);
        this.catalogDbPoolDataSource.setInitialPoolSize(1);
        this.catalogDbPoolDataSource.setMinPoolSize(1);
        this.catalogDbPoolDataSource.setConnectionProperty("oracle.jdbc.TcpNoDelay", "true");
        this.catalogDbPoolDataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        universalConnectionPoolManager.createConnectionPool((UniversalConnectionPoolAdapter)this.catalogDbPoolDataSource);
        universalConnectionPoolManager.startConnectionPool(this.catalogDbPoolDataSource.getConnectionPoolName());
    }

    private void initializeShardRoutingCache() throws UniversalConnectionPoolException {
        Properties properties = new Properties();
        properties.setProperty("user", this.dbUser);
        properties.setProperty("password", this.dbPassword.get());
        properties.setProperty("url", this.dbUrl);
        properties.setProperty("serviceName", this.shardedDbGlobalServiceName);
        this.routingCache = new OracleShardRoutingCache(properties);
    }

    private void initializeShardSpecificConnectionPools() throws SQLException, UniversalConnectionPoolException {
        try (Connection connection = this.catalogDbPoolDataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT db_unique_name, connect_string FROM sha_databases WHERE is_primary='Y'");){
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                PoolDataSourceImpl poolDataSourceImpl = new PoolDataSourceImpl();
                poolDataSourceImpl.setUser(this.dbUser);
                poolDataSourceImpl.setPassword(this.dbPassword.get());
                poolDataSourceImpl.setInitialPoolSize(CONNECTION_POOL_SIZE);
                poolDataSourceImpl.setMinPoolSize(CONNECTION_POOL_SIZE);
                poolDataSourceImpl.setURL("jdbc:oracle:thin:@" + string2);
                poolDataSourceImpl.setShardingMode(false);
                poolDataSourceImpl.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
                poolDataSourceImpl.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
                if (this.isUpsert || !this.isUseDP) {
                    poolDataSourceImpl.setMaxStatements(2);
                }
                UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                universalConnectionPoolManager.createConnectionPool((UniversalConnectionPoolAdapter)poolDataSourceImpl);
                universalConnectionPoolManager.startConnectionPool(poolDataSourceImpl.getConnectionPoolName());
                this.mapOfShardNameAndPdsStagingAreaDuo.put(string, new PoolDataSourceStagingAreaDuo(poolDataSourceImpl));
            }
        }
    }

    @Override
    protected void destroyConnectionPool() throws UniversalConnectionPoolException {
        UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        universalConnectionPoolManager.destroyConnectionPool(this.catalogDbPoolDataSource.getConnectionPoolName());
        for (Map.Entry<String, PoolDataSourceStagingAreaDuo> entry : this.mapOfShardNameAndPdsStagingAreaDuo.entrySet()) {
            universalConnectionPoolManager.destroyConnectionPool(entry.getValue().poolDataSource().getConnectionPoolName());
        }
    }

    private void initializeStagingArea() {
        for (String string : this.mapOfShardNameAndPdsStagingAreaDuo.keySet()) {
            Consumer<List<Object>> consumer = list -> {
                try {
                    this.jobsQueuedForExecution.incrementAndGet();
                    PoolDataSourceImpl poolDataSourceImpl = this.mapOfShardNameAndPdsStagingAreaDuo.get(string).poolDataSource();
                    this.executor.execute(new IngestSuite.IngestJob(poolDataSourceImpl, (List<Object>)list));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
                }
            };
            this.mapOfShardNameAndPdsStagingAreaDuo.get(string).set(new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, consumer));
        }
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.mapOfShardNameAndPdsStagingAreaDuo.forEach((string, poolDataSourceStagingAreaDuo) -> poolDataSourceStagingAreaDuo.stagingArea().flushIfDue(bl));
    }

    @Override
    protected void validate(Object object) {
        if (!(object instanceof ShardRecord)) {
            throw new RSIException("Unknown item type. Discarding.");
        }
        super.validate(((ShardRecord)object).values());
    }

    @Override
    protected void accept(Object object) {
        ShardRecord shardRecord = (ShardRecord)object;
        Set set = this.routingCache.getChunkInfoForKey(shardRecord.shardingKey(), shardRecord.shardingGroupKey()).getShardInfo();
        Optional<ShardInfo> optional = set.stream().filter(shardInfo -> this.mapOfShardNameAndPdsStagingAreaDuo.containsKey(shardInfo.getName())).findFirst();
        if (!optional.isPresent()) {
            this.debug(Level.WARNING, CLASS_NAME, "accept", "Skipping the record as the sharding key does not map to any partition", null, new Object[0]);
            return;
        }
        String string = optional.get().getName();
        this.mapOfShardNameAndPdsStagingAreaDuo.get(string).stagingArea().accept(shardRecord.values());
    }

    @Override
    protected void cleanup() {
        this.mapOfShardNameAndPdsStagingAreaDuo.forEach((string, poolDataSourceStagingAreaDuo) -> poolDataSourceStagingAreaDuo.stagingArea().close());
    }

    private class PoolDataSourceStagingAreaDuo {
        private PoolDataSourceImpl poolDataSource;
        private StagingArea stagingArea;

        public PoolDataSourceStagingAreaDuo(PoolDataSourceImpl poolDataSourceImpl) {
            this.poolDataSource = poolDataSourceImpl;
        }

        public void set(StagingArea stagingArea) {
            this.stagingArea = stagingArea;
        }

        public StagingArea stagingArea() {
            return this.stagingArea;
        }

        public PoolDataSourceImpl poolDataSource() {
            return this.poolDataSource;
        }
    }
}

