/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import oracle.jdbc.internal.OracleConnection;
import oracle.rsi.RSIException;
import oracle.rsi.internal.IngestSuite;
import oracle.rsi.internal.PartitionManager;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSourceImpl;

class IngestSuiteForPartitionedTable
extends IngestSuite {
    private UniversalConnectionPoolManager ucpManager = null;
    private final PoolDataSourceImpl poolDataSource = new PoolDataSourceImpl();
    private final Map<String, StagingArea> partitionNameStagingAreaMap = new HashMap<String, StagingArea>();
    private int jdbcCharsetId;
    private PartitionManager partitionManager = null;

    protected IngestSuiteForPartitionedTable(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.initialize();
        this.scheduleBufferIntervalTask();
    }

    private void initialize() throws Exception {
        this.startConnectionPool();
        this.initializeJdbcCharsetId();
        this.partitionManager = new PartitionManager(this.dbMetadata, this.predeclaredColumnsMetadataList, this.jdbcCharsetId);
    }

    protected void startConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.poolDataSource.setUser(this.dbUser);
        this.poolDataSource.setPassword(this.dbPassword.get());
        this.poolDataSource.setURL(this.dbUrl);
        this.poolDataSource.setInitialPoolSize(CONNECTION_POOL_SIZE);
        this.poolDataSource.setMinPoolSize(CONNECTION_POOL_SIZE);
        this.poolDataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        this.poolDataSource.setShardingMode(false);
        this.poolDataSource.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
        if (this.isUpsert || !this.isUseDP) {
            this.poolDataSource.setMaxStatements(this.dbMetadata.getTable().getPartitionCount() * 2);
        }
        this.ucpManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        this.ucpManager.createConnectionPool((UniversalConnectionPoolAdapter)this.poolDataSource);
        this.ucpManager.startConnectionPool(this.poolDataSource.getConnectionPoolName());
    }

    @Override
    protected void destroyConnectionPool() throws UniversalConnectionPoolException {
        this.ucpManager.destroyConnectionPool(this.poolDataSource.getConnectionPoolName());
    }

    private void initializeJdbcCharsetId() throws SQLException {
        try (Connection connection = this.poolDataSource.getConnection();){
            Class<OracleConnection> clazz = OracleConnection.class;
            if (!connection.isWrapperFor(clazz)) {
                throw new RSIException("Connection is not a wrapper for internal OracleConnection");
            }
            OracleConnection oracleConnection = connection.unwrap(clazz);
            this.jdbcCharsetId = Short.toUnsignedInt(oracleConnection.getJdbcCsId());
        }
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.partitionNameStagingAreaMap.forEach((string, stagingArea) -> stagingArea.flushIfDue(bl));
    }

    @Override
    protected void accept(Object object) {
        String string = this.partitionManager.computePartition(object);
        this.partitionNameStagingAreaMap.computeIfAbsent(string, string2 -> new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, this.getPublishedItemsConsumer(string))).accept(object);
    }

    private Consumer<List<Object>> getPublishedItemsConsumer(String string) {
        return list -> {
            try {
                this.jobsQueuedForExecution.incrementAndGet();
                this.executor.execute(new IngestSuite.IngestJob(this.poolDataSource, string, (List<Object>)list));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
            }
        };
    }

    @Override
    protected void cleanup() {
        this.partitionNameStagingAreaMap.forEach((string, stagingArea) -> stagingArea.close());
    }
}

