/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import oracle.rsi.internal.IngestSuite;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSourceImpl;

class IngestSuiteForNonShardedDatabase
extends IngestSuite {
    private UniversalConnectionPoolManager ucpManager = null;
    private final PoolDataSourceImpl poolDataSource = new PoolDataSourceImpl();
    private StagingArea stagingArea = null;

    protected IngestSuiteForNonShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.startConnectionPool();
        this.initializeStagingArea();
        this.scheduleBufferIntervalTask();
    }

    private void startConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.poolDataSource.setUser(this.dbUser);
        this.poolDataSource.setPassword(this.dbPassword.get());
        this.poolDataSource.setURL(this.dbUrl);
        this.poolDataSource.setInitialPoolSize(CONNECTION_POOL_SIZE);
        this.poolDataSource.setMinPoolSize(CONNECTION_POOL_SIZE);
        this.poolDataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        this.poolDataSource.setShardingMode(false);
        this.poolDataSource.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
        if (this.isUpsert || !this.isUseDP) {
            this.poolDataSource.setMaxStatements(2);
        }
        this.ucpManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        this.ucpManager.createConnectionPool((UniversalConnectionPoolAdapter)this.poolDataSource);
        this.ucpManager.startConnectionPool(this.poolDataSource.getConnectionPoolName());
    }

    @Override
    protected void destroyConnectionPool() throws UniversalConnectionPoolException {
        this.ucpManager.destroyConnectionPool(this.poolDataSource.getConnectionPoolName());
    }

    private void initializeStagingArea() {
        Consumer<List<Object>> consumer = list -> {
            try {
                this.jobsQueuedForExecution.incrementAndGet();
                this.executor.execute(new IngestSuite.IngestJob(this.poolDataSource, (List<Object>)list));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
            }
        };
        this.stagingArea = new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, consumer);
    }

    @Override
    protected void accept(Object object) {
        this.stagingArea.accept(object);
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.stagingArea.flushIfDue(bl);
    }

    @Override
    protected void cleanup() {
        this.stagingArea.close();
    }
}

