/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.util.concurrent.Flow;
import java.util.logging.Logger;
import oracle.rsi.RSIException;
import oracle.rsi.internal.IngestSuite;

class FlowSubscriber<T>
implements Flow.Subscriber<T> {
    private boolean isSubscribed = false;
    private boolean isComplete = false;
    private final IngestSuite rsi;
    private Flow.Subscription activeSubscription;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    FlowSubscriber(IngestSuite ingestSuite) {
        this.rsi = ingestSuite;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.isSubscribed) {
            String string = "A Subscriber can subscribe to only one publisher.";
            throw new RSIException(string);
        }
        if (this.activeSubscription == null) {
            this.isSubscribed = true;
            this.activeSubscription = subscription;
            this.rsi.register(this);
            long l = this.rsi.getNextDemand();
            if (l > 0L) {
                this.activeSubscription.request(l);
            }
            return;
        }
        if (!this.activeSubscription.equals(subscription)) {
            subscription.cancel();
        }
    }

    @Override
    public void onNext(T t) {
        if (this.isComplete) {
            String string = "Subscriber is Closed.";
            throw new RSIException(string);
        }
        this.rsi.putRecord(t);
        long l = this.rsi.getNextDemand();
        if (l > 0L) {
            this.activeSubscription.request(l);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        throw new RSIException(throwable.getMessage());
    }

    @Override
    public void onComplete() {
        if (!this.isComplete) {
            this.isComplete = true;
        }
    }

    void resume() {
        if (this.isComplete) {
            return;
        }
        long l = this.rsi.getNextDemand();
        if (l > 0L) {
            this.activeSubscription.request(l);
        }
    }

    static {
        try {
            $$$methodRef$$$5 = FlowSubscriber.class.getDeclaredConstructor(IngestSuite.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = FlowSubscriber.class.getDeclaredMethod("resume", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = FlowSubscriber.class.getDeclaredMethod("onComplete", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = FlowSubscriber.class.getDeclaredMethod("onError", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = FlowSubscriber.class.getDeclaredMethod("onNext", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = FlowSubscriber.class.getDeclaredMethod("onSubscribe", Flow.Subscription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
    }
}

