/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.rsi.logging.ClioSupport;

class StagingArea {
    private final Duration bufferInterval;
    private final int maxRowsPerStagingQueue;
    private final Consumer<List<Object>> stagedItemsConsumer;
    private final ConcurrentHashMap<Long, TLCtx> threadSpecificCtx = new ConcurrentHashMap();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    StagingArea(int n, Duration duration, Consumer<List<Object>> consumer) {
        this.maxRowsPerStagingQueue = n;
        this.bufferInterval = duration;
        this.stagedItemsConsumer = consumer;
    }

    void accept(Object object) {
        TLCtx tLCtx = this.threadSpecificCtx.computeIfAbsent(Thread.currentThread().getId(), l -> new TLCtx());
        tLCtx.accept(object);
    }

    public void flushIfDue(boolean bl) {
        Iterator<Map.Entry<Long, TLCtx>> iterator = this.threadSpecificCtx.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, TLCtx> entry = iterator.next();
            TLCtx tLCtx = entry.getValue();
            if (bl) {
                tLCtx.flush();
                continue;
            }
            if (tLCtx.isBufferFlushDue().booleanValue() || tLCtx.isOwnerThreadTerminated()) {
                tLCtx.flush();
            }
            if (!tLCtx.isOwnerThreadTerminated()) continue;
            iterator.remove();
        }
    }

    void close() {
        this.threadSpecificCtx.clear();
    }

    static {
        try {
            $$$methodRef$$$4 = StagingArea.class.getDeclaredConstructor(Integer.TYPE, Duration.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = StagingArea.class.getDeclaredMethod("lambda$accept$0", Long.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = StagingArea.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = StagingArea.class.getDeclaredMethod("flushIfDue", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = StagingArea.class.getDeclaredMethod("accept", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
    }

    private class TLCtx {
        private final Thread ownerThread = Thread.currentThread();
        private final List<Object> stagingQueue;
        private Instant lastSubmittedToConsumerAt;
        private final AtomicReference<Boolean> writeLock;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        private TLCtx() {
            this.stagingQueue = new ArrayList<Object>(StagingArea.this.maxRowsPerStagingQueue);
            this.lastSubmittedToConsumerAt = Instant.now();
            this.writeLock = new AtomicReference<Boolean>(false);
        }

        private boolean tryAcquireWriteLock() {
            return this.writeLock.compareAndSet(false, true);
        }

        private void releaseWriteLock() {
            this.writeLock.compareAndSet(true, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void accept(Object object) {
            ArrayList<Object> arrayList = null;
            try {
                while (!this.tryAcquireWriteLock()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.stagingQueue.add(object);
                if (this.stagingQueue.size() >= StagingArea.this.maxRowsPerStagingQueue) {
                    String string = "The staging queue is full. Submitting the queue for ingestion.";
                    ClioSupport.ilogFinest(null, null, null, null, string);
                    arrayList = new ArrayList<Object>(this.stagingQueue.size());
                    arrayList.addAll(this.stagingQueue);
                    this.stagingQueue.clear();
                }
            }
            finally {
                this.releaseWriteLock();
            }
            this.submitToConsumer(arrayList);
        }

        Boolean isBufferFlushDue() {
            Duration duration = Duration.between(this.lastSubmittedToConsumerAt, Instant.now());
            return duration.compareTo(StagingArea.this.bufferInterval) >= 0;
        }

        void flush() {
            if (this.stagingQueue.size() == 0) {
                return;
            }
            ArrayList<Object> arrayList = null;
            try {
                while (!this.tryAcquireWriteLock()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                arrayList = new ArrayList<Object>(this.stagingQueue.size());
                arrayList.addAll(this.stagingQueue);
                this.stagingQueue.clear();
            }
            finally {
                this.releaseWriteLock();
            }
            this.submitToConsumer(arrayList);
        }

        private void submitToConsumer(List<Object> list) {
            if (list != null) {
                StagingArea.this.stagedItemsConsumer.accept(list);
                this.lastSubmittedToConsumerAt = Instant.now();
            }
        }

        boolean isOwnerThreadTerminated() {
            return Thread.State.TERMINATED == this.ownerThread.getState();
        }

        static {
            try {
                $$$methodRef$$$7 = TLCtx.class.getDeclaredConstructor(StagingArea.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = TLCtx.class.getDeclaredMethod("isOwnerThreadTerminated", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = TLCtx.class.getDeclaredMethod("submitToConsumer", List.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = TLCtx.class.getDeclaredMethod("flush", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = TLCtx.class.getDeclaredMethod("isBufferFlushDue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = TLCtx.class.getDeclaredMethod("accept", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = TLCtx.class.getDeclaredMethod("releaseWriteLock", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = TLCtx.class.getDeclaredMethod("tryAcquireWriteLock", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    }
}

