/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import oracle.rsi.RSIException;

public class PushPublisher<T>
implements oracle.rsi.PushPublisher<T> {
    private boolean isClosed = false;
    private Flow.Subscriber<? super T> rsiSubscriber;
    private AtomicLong request = new AtomicLong(0L);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (this.rsiSubscriber == null) {
            this.rsiSubscriber = subscriber;
            this.rsiSubscriber.onSubscribe(new FlowSubscription());
            return;
        }
        if (!this.rsiSubscriber.equals(subscriber)) {
            String string = "A Publisher can be subscribed with only one subscriber.";
            subscriber.onError(new RSIException(string));
        }
    }

    @Override
    public synchronized void accept(T t) {
        if (this.isClosed) {
            String string = "Cannot accept. Publisher is closed.";
            throw new RSIException(string);
        }
        if (this.request.get() == 0L) {
            String string = "Notifying memory pressure.";
            throw new RSIException(string);
        }
        this.rsiSubscriber.onNext(t);
        this.request.decrementAndGet();
    }

    @Override
    public void close() throws Exception {
        this.isClosed = true;
    }

    static {
        try {
            $$$methodRef$$$3 = PushPublisher.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = PushPublisher.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = PushPublisher.class.getDeclaredMethod("accept", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = PushPublisher.class.getDeclaredMethod("subscribe", Flow.Subscriber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
    }

    private class FlowSubscription
    implements Flow.Subscription {
        private boolean isCancelled = false;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        private FlowSubscription() {
        }

        @Override
        public void request(long l) {
            if (this.isCancelled) {
                return;
            }
            if (l <= 0L) {
                String string = "Non-positive request signals are illegal.";
                PushPublisher.this.rsiSubscriber.onError(new IllegalArgumentException(string));
            }
            PushPublisher.this.request.addAndGet(l);
        }

        @Override
        public void cancel() {
            if (!this.isCancelled) {
                this.isCancelled = true;
            }
        }

        static {
            try {
                $$$methodRef$$$2 = FlowSubscription.class.getDeclaredConstructor(PushPublisher.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = FlowSubscription.class.getDeclaredMethod("cancel", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = FlowSubscription.class.getDeclaredMethod("request", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    }
}

