/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.rsi.RSIException;
import oracle.rsi.ShardRecord;
import oracle.rsi.internal.IngestSuite;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;
import oracle.rsi.logging.ClioSupport;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.routing.ShardInfo;
import oracle.ucp.routing.oracle.OracleShardRoutingCache;

@Supports(value={Feature.RSI_TRACE})
class IngestSuiteForShardedDatabase
extends IngestSuite {
    private OracleShardRoutingCache routingCache = null;
    private final PoolDataSourceImpl catalogDbPoolDataSource = new PoolDataSourceImpl();
    private final Map<String, PoolDataSourceStagingAreaDuo> mapOfShardNameAndPdsStagingAreaDuo = new HashMap<String, PoolDataSourceStagingAreaDuo>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    protected IngestSuiteForShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.startConnectionPool();
        this.initializeStagingArea();
        this.scheduleBufferIntervalTask();
    }

    protected void startConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.initializeCatalogDbConnectionPool();
        this.initializeShardRoutingCache();
        this.initializeShardSpecificConnectionPools();
    }

    private void initializeCatalogDbConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.catalogDbPoolDataSource.setUser(this.dbUser);
        this.catalogDbPoolDataSource.setPassword(this.dbPassword.get());
        this.catalogDbPoolDataSource.setURL(this.dbUrl);
        this.catalogDbPoolDataSource.setInitialPoolSize(1);
        this.catalogDbPoolDataSource.setMinPoolSize(1);
        this.catalogDbPoolDataSource.setConnectionProperty("oracle.jdbc.TcpNoDelay", "true");
        this.catalogDbPoolDataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        universalConnectionPoolManager.createConnectionPool((UniversalConnectionPoolAdapter)this.catalogDbPoolDataSource);
        universalConnectionPoolManager.startConnectionPool(this.catalogDbPoolDataSource.getConnectionPoolName());
    }

    private void initializeShardRoutingCache() throws UniversalConnectionPoolException {
        Properties properties = new Properties();
        properties.setProperty("user", this.dbUser);
        properties.setProperty("password", this.dbPassword.get());
        properties.setProperty("url", this.dbUrl);
        properties.setProperty("serviceName", this.shardedDbGlobalServiceName);
        this.routingCache = new OracleShardRoutingCache(properties);
    }

    private void initializeShardSpecificConnectionPools() throws SQLException, UniversalConnectionPoolException {
        try (Connection connection = this.catalogDbPoolDataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT db_unique_name, connect_string FROM sha_databases WHERE is_primary='Y'");){
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                PoolDataSourceImpl poolDataSourceImpl = new PoolDataSourceImpl();
                poolDataSourceImpl.setUser(this.dbUser);
                poolDataSourceImpl.setPassword(this.dbPassword.get());
                poolDataSourceImpl.setInitialPoolSize(CONNECTION_POOL_SIZE);
                poolDataSourceImpl.setMinPoolSize(CONNECTION_POOL_SIZE);
                poolDataSourceImpl.setURL("jdbc:oracle:thin:@" + string2);
                poolDataSourceImpl.setShardingMode(false);
                poolDataSourceImpl.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
                poolDataSourceImpl.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
                if (this.isUpsert || !this.isUseDP) {
                    poolDataSourceImpl.setMaxStatements(2);
                }
                UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                universalConnectionPoolManager.createConnectionPool((UniversalConnectionPoolAdapter)poolDataSourceImpl);
                universalConnectionPoolManager.startConnectionPool(poolDataSourceImpl.getConnectionPoolName());
                this.mapOfShardNameAndPdsStagingAreaDuo.put(string, new PoolDataSourceStagingAreaDuo(poolDataSourceImpl));
            }
        }
    }

    @Override
    protected void destroyConnectionPool() throws UniversalConnectionPoolException {
        UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        universalConnectionPoolManager.destroyConnectionPool(this.catalogDbPoolDataSource.getConnectionPoolName());
        for (Map.Entry<String, PoolDataSourceStagingAreaDuo> entry : this.mapOfShardNameAndPdsStagingAreaDuo.entrySet()) {
            universalConnectionPoolManager.destroyConnectionPool(entry.getValue().poolDataSource().getConnectionPoolName());
        }
    }

    private void initializeStagingArea() {
        for (String string : this.mapOfShardNameAndPdsStagingAreaDuo.keySet()) {
            Consumer<List<Object>> consumer = list -> {
                try {
                    this.jobsQueuedForExecution.incrementAndGet();
                    PoolDataSourceImpl poolDataSourceImpl = this.mapOfShardNameAndPdsStagingAreaDuo.get(string).poolDataSource();
                    this.executor.execute(new IngestSuite.IngestJob(poolDataSourceImpl, (List<Object>)list));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
                }
            };
            this.mapOfShardNameAndPdsStagingAreaDuo.get(string).set(new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, consumer));
        }
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.mapOfShardNameAndPdsStagingAreaDuo.forEach((string, poolDataSourceStagingAreaDuo) -> poolDataSourceStagingAreaDuo.stagingArea().flushIfDue(bl));
    }

    @Override
    protected void validate(Object object) {
        if (!(object instanceof ShardRecord)) {
            throw new RSIException("Unknown item type. Discarding.");
        }
        super.validate(((ShardRecord)object).values());
    }

    @Override
    protected void accept(Object object) {
        ShardRecord shardRecord = (ShardRecord)object;
        Set set = this.routingCache.getChunkInfoForKey(shardRecord.shardingKey(), shardRecord.shardingGroupKey()).getShardInfo();
        Optional<ShardInfo> optional = set.stream().filter(shardInfo -> this.mapOfShardNameAndPdsStagingAreaDuo.containsKey(shardInfo.getName())).findFirst();
        if (!optional.isPresent()) {
            ClioSupport.ilogWarning(Logger.getLogger(this.getClass().getName()), null, null, null, "Skipping the record as the sharding key does not map to any partition");
            return;
        }
        String string = optional.get().getName();
        this.mapOfShardNameAndPdsStagingAreaDuo.get(string).stagingArea().accept(shardRecord.values());
    }

    @Override
    protected void cleanup() {
        this.mapOfShardNameAndPdsStagingAreaDuo.forEach((string, poolDataSourceStagingAreaDuo) -> poolDataSourceStagingAreaDuo.stagingArea().close());
    }

    static {
        try {
            $$$methodRef$$$14 = IngestSuiteForShardedDatabase.class.getDeclaredConstructor(RSIBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$13 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("lambda$initializeStagingArea$0", String.class, List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$12 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("lambda$flushItemsIfDue$1", Boolean.TYPE, String.class, PoolDataSourceStagingAreaDuo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$11 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("lambda$accept$2", ShardInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$10 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("lambda$cleanup$3", String.class, PoolDataSourceStagingAreaDuo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$9 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$8 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("accept", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$7 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("validate", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$6 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("flushItemsIfDue", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$5 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("initializeStagingArea", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("destroyConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("initializeShardSpecificConnectionPools", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("initializeShardRoutingCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("initializeCatalogDbConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = IngestSuiteForShardedDatabase.class.getDeclaredMethod("startConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
    }

    private class PoolDataSourceStagingAreaDuo {
        private PoolDataSourceImpl poolDataSource;
        private StagingArea stagingArea;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        public PoolDataSourceStagingAreaDuo(PoolDataSourceImpl poolDataSourceImpl) {
            this.poolDataSource = poolDataSourceImpl;
        }

        public void set(StagingArea stagingArea) {
            this.stagingArea = stagingArea;
        }

        public StagingArea stagingArea() {
            return this.stagingArea;
        }

        public PoolDataSourceImpl poolDataSource() {
            return this.poolDataSource;
        }

        static {
            try {
                $$$methodRef$$$3 = PoolDataSourceStagingAreaDuo.class.getDeclaredConstructor(IngestSuiteForShardedDatabase.class, PoolDataSourceImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = PoolDataSourceStagingAreaDuo.class.getDeclaredMethod("poolDataSource", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = PoolDataSourceStagingAreaDuo.class.getDeclaredMethod("stagingArea", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = PoolDataSourceStagingAreaDuo.class.getDeclaredMethod("set", StagingArea.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    }
}

