/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.jdbc.internal.OracleConnection;
import oracle.rsi.RSIException;
import oracle.rsi.internal.IngestSuite;
import oracle.rsi.internal.PartitionManager;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSourceImpl;

class IngestSuiteForPartitionedTable
extends IngestSuite {
    private UniversalConnectionPoolManager ucpManager = null;
    private final PoolDataSourceImpl poolDataSource = new PoolDataSourceImpl();
    private final Map<String, StagingArea> partitionNameStagingAreaMap = new HashMap<String, StagingArea>();
    private int jdbcCharsetId;
    private PartitionManager partitionManager = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    protected IngestSuiteForPartitionedTable(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.initialize();
        this.scheduleBufferIntervalTask();
    }

    private void initialize() throws Exception {
        this.startConnectionPool();
        this.initializeJdbcCharsetId();
        this.partitionManager = new PartitionManager(this.dbMetadata, this.predeclaredColumnsMetadataList, this.jdbcCharsetId);
    }

    protected void startConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.poolDataSource.setUser(this.dbUser);
        this.poolDataSource.setPassword(this.dbPassword.get());
        this.poolDataSource.setURL(this.dbUrl);
        this.poolDataSource.setInitialPoolSize(CONNECTION_POOL_SIZE);
        this.poolDataSource.setMinPoolSize(CONNECTION_POOL_SIZE);
        this.poolDataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        this.poolDataSource.setShardingMode(false);
        this.poolDataSource.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
        if (this.isUpsert || !this.isUseDP) {
            this.poolDataSource.setMaxStatements(this.dbMetadata.getTable().getPartitionCount() * 2);
        }
        this.ucpManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        this.ucpManager.createConnectionPool((UniversalConnectionPoolAdapter)this.poolDataSource);
        this.ucpManager.startConnectionPool(this.poolDataSource.getConnectionPoolName());
    }

    @Override
    protected void destroyConnectionPool() throws UniversalConnectionPoolException {
        this.ucpManager.destroyConnectionPool(this.poolDataSource.getConnectionPoolName());
    }

    private void initializeJdbcCharsetId() throws SQLException {
        try (Connection connection = this.poolDataSource.getConnection();){
            Class<OracleConnection> clazz = OracleConnection.class;
            if (!connection.isWrapperFor(clazz)) {
                throw new RSIException("Connection is not a wrapper for internal OracleConnection");
            }
            OracleConnection oracleConnection = connection.unwrap(clazz);
            this.jdbcCharsetId = Short.toUnsignedInt(oracleConnection.getJdbcCsId());
        }
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.partitionNameStagingAreaMap.forEach((string, stagingArea) -> stagingArea.flushIfDue(bl));
    }

    @Override
    protected void accept(Object object) {
        String string = this.partitionManager.computePartition(object);
        this.partitionNameStagingAreaMap.computeIfAbsent(string, string2 -> new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, this.getPublishedItemsConsumer(string))).accept(object);
    }

    private Consumer<List<Object>> getPublishedItemsConsumer(String string) {
        return list -> {
            try {
                this.jobsQueuedForExecution.incrementAndGet();
                this.executor.execute(new IngestSuite.IngestJob(this.poolDataSource, string, (List<Object>)list));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
            }
        };
    }

    @Override
    protected void cleanup() {
        this.partitionNameStagingAreaMap.forEach((string, stagingArea) -> stagingArea.close());
    }

    static {
        try {
            $$$methodRef$$$12 = IngestSuiteForPartitionedTable.class.getDeclaredConstructor(RSIBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$11 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("lambda$flushItemsIfDue$0", Boolean.TYPE, String.class, StagingArea.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$10 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("lambda$accept$1", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$9 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("lambda$getPublishedItemsConsumer$2", String.class, List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$8 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("lambda$cleanup$3", String.class, StagingArea.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$7 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$6 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("getPublishedItemsConsumer", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$5 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("accept", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("flushItemsIfDue", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("initializeJdbcCharsetId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("destroyConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("startConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = IngestSuiteForPartitionedTable.class.getDeclaredMethod("initialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
    }
}

