/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.invoke.CallSite;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.rsi.RSIException;
import oracle.rsi.ReactiveStreamsIngestion;
import oracle.rsi.StreamEntity;
import oracle.rsi.internal.FlowSubscriber;
import oracle.rsi.internal.IngestSuiteForNonShardedDatabase;
import oracle.rsi.internal.IngestSuiteForPartitionedTable;
import oracle.rsi.internal.IngestSuiteForShardedDatabase;
import oracle.rsi.internal.Metadata;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.logging.ClioSupport;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.PoolDataSourceImpl;

@Supports(value={Feature.RSI_TRACE})
abstract class IngestSuite
implements ReactiveStreamsIngestion {
    private final AtomicInteger currentBufferedRows = new AtomicInteger(0);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    protected final AtomicInteger jobsQueuedForExecution = new AtomicInteger(0);
    protected Executor executor;
    protected Duration bufferInterval;
    private long maxRowsToBuffer = 0L;
    protected int maxRowsPerStagingQueue = 0;
    protected boolean isUseDP;
    protected boolean isUpsert;
    protected String dbUrl;
    protected String dbSchema;
    protected String dbUser;
    protected OpaqueString dbPassword;
    protected String shardedDbGlobalServiceName;
    private String tableName;
    private String[] columns;
    private String[] normalizedColumns;
    private Class<?> entityClass;
    private Field[] fields;
    private Method[] methods;
    private final Properties dpStmtProps = new Properties();
    private Function<byte[], Object> transformer;
    private String insertSql = null;
    private String updateSql = null;
    protected Metadata dbMetadata;
    protected final List<Metadata.ColumnMetadata> predeclaredColumnsMetadataList = new ArrayList<Metadata.ColumnMetadata>();
    private String[] primaryConstraintsColumns = null;
    private int maxRowLength = 0;
    protected static final int CONNECTION_POOL_SIZE;
    private static final int NEW_DEMAND = 1;
    private final AtomicInteger recordsDueFromSubscriptions = new AtomicInteger(0);
    private final AtomicBoolean isSubscribersStalled = new AtomicBoolean(false);
    private final Queue<FlowSubscriber<?>> subscribersList = new ConcurrentLinkedQueue();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String RSI_CLOSED_ERROR_MSG = "Reactive Streams Ingestion is in closed state.";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    static ReactiveStreamsIngestion newIngestSuiteForNonShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        return new IngestSuiteForNonShardedDatabase(rSIBuilder);
    }

    static ReactiveStreamsIngestion newIngestSuiteForShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        return new IngestSuiteForShardedDatabase(rSIBuilder);
    }

    static ReactiveStreamsIngestion newIngestSuiteForPartitionedTable(RSIBuilder rSIBuilder) throws Exception {
        return new IngestSuiteForPartitionedTable(rSIBuilder);
    }

    protected abstract void destroyConnectionPool() throws UniversalConnectionPoolException;

    protected abstract void accept(Object var1);

    protected abstract void flushItemsIfDue(boolean var1);

    protected abstract void cleanup();

    protected IngestSuite(RSIBuilder rSIBuilder) throws SQLException, UniversalConnectionPoolException {
        this.readConfiguration(rSIBuilder);
        this.configureRowBuffer();
    }

    private void readConfiguration(RSIBuilder rSIBuilder) {
        this.isUpsert = rSIBuilder.isUpsert;
        this.isUseDP = rSIBuilder.isUseDP;
        this.columns = rSIBuilder.columns;
        this.normalizedColumns = rSIBuilder.normalizedColumns;
        this.fields = rSIBuilder.fields;
        this.methods = rSIBuilder.methods;
        this.executor = rSIBuilder.executor;
        this.tableName = rSIBuilder.tableName;
        this.entityClass = rSIBuilder.entityClass;
        this.bufferInterval = rSIBuilder.bufferInterval;
        this.maxRowsToBuffer = rSIBuilder.maxRowsToBuffer;
        this.dbUrl = rSIBuilder.dbUrl;
        this.dbUser = rSIBuilder.dbUser;
        this.dbSchema = rSIBuilder.dbSchema;
        this.dbPassword = rSIBuilder.dbPassword;
        this.shardedDbGlobalServiceName = rSIBuilder.shardedDbGlobalServiceName;
        this.transformer = rSIBuilder.transformer;
        this.dbMetadata = rSIBuilder.dbMetadata;
        this.initializePredeclaredColumnsMetadata();
        if (!this.isUseDP) {
            this.prepareInsertSql();
            if (this.isUpsert) {
                this.prepareUpdateSql();
            }
        } else {
            if (rSIBuilder.isUseDPParallel) {
                this.dpStmtProps.setProperty("DPPDEF_IN_PARALLEL", "true");
            }
            if (rSIBuilder.isUseDPNoLog) {
                this.dpStmtProps.setProperty("DPPDEF_IN_NOLOG", "true");
            }
            if (rSIBuilder.isUseDPSkipUnusableIndexes) {
                this.dpStmtProps.setProperty("DPPDEF_IN_SKIP_UNUSABLE_INDEX", "true");
            }
            if (rSIBuilder.isUseDPSkipIndexMaintenance) {
                this.dpStmtProps.setProperty("DPPDEF_IN_SKIP_INDEX_MAINT", "true");
            }
        }
    }

    private final void initializePredeclaredColumnsMetadata() {
        List<String> list = Arrays.asList(this.normalizedColumns);
        for (int i = 0; i < this.columns.length; ++i) {
            Metadata.ColumnMetadata columnMetadata = this.dbMetadata.getTable().getColumn(list.get(i));
            if (columnMetadata == null) {
                String string = "Column does not exist - " + this.columns[i];
                ClioSupport.ilogSevere(Logger.getLogger(this.getClass().getName()), null, null, null, string);
                throw new RSIException(string);
            }
            this.predeclaredColumnsMetadataList.add(columnMetadata);
            int n = columnMetadata.getLength();
            this.maxRowLength += n == 0 ? 1 : n;
        }
        this.primaryConstraintsColumns = (String[])Arrays.stream(this.dbMetadata.getTable().getPrimaryConstraintColumns()).filter(list::contains).collect(Collectors.toList()).toArray(String[]::new);
        if (this.primaryConstraintsColumns.length == 0) {
            this.isUpsert = false;
        }
    }

    private void configureRowBuffer() {
        if (this.maxRowsToBuffer == 0L) {
            long l = Runtime.getRuntime().maxMemory() / 2L;
            this.maxRowsToBuffer = l / (long)this.maxRowLength;
            if (this.maxRowsToBuffer > Integer.MAX_VALUE) {
                this.maxRowsToBuffer = Integer.MAX_VALUE;
            }
        }
        this.maxRowsPerStagingQueue = 0x200000 / this.maxRowLength;
        if ((long)this.maxRowsPerStagingQueue >= this.maxRowsToBuffer) {
            this.maxRowsPerStagingQueue = (int)this.maxRowsToBuffer;
        }
    }

    void putRecord(Object object) throws RSIException {
        if (this.isClosed.get()) {
            throw new IllegalStateException(RSI_CLOSED_ERROR_MSG);
        }
        try {
            Object object2 = object;
            if (object == null) {
                throw new RSIException("Published item is null. Discarding.");
            }
            if (object instanceof byte[]) {
                if (this.transformer == null) {
                    throw new RSIException("Transformer lambda isn't supplied. Discarding the record.");
                }
                Object object3 = this.transformer.apply((byte[])object);
                if (object3 == null) {
                    throw new RSIException("Published item is transformed to null. Discarding.");
                }
                object2 = object3;
            }
            this.validate(object2);
            this.accept(object2);
            this.currentBufferedRows.incrementAndGet();
            this.recordsDueFromSubscriptions.decrementAndGet();
        }
        catch (Exception exception) {
            ClioSupport.ilogWarning(this.logger, null, null, null, exception.getMessage());
        }
    }

    protected void validate(Object object) {
        if (object.getClass().isAnnotationPresent(StreamEntity.class)) {
            if (this.entityClass == null) {
                throw new RSIException("The mapping entity class cannot be null for annotated records. Discarding");
            }
        } else if (!(object instanceof Object[]) && !(object instanceof Map)) {
            throw new RSIException("Unsupported item type. Discarding.");
        }
    }

    protected void handleRejectedExecutionException(int n, String string) {
        ClioSupport.ilogSevere(Logger.getLogger(this.getClass().getName()), null, null, null, string);
        this.onBatchComplete(n);
    }

    private void prepareInsertSql() {
        if (this.insertSql == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("INSERT INTO " + this.tableName + " (");
            String string = Arrays.toString(this.columns);
            stringBuilder.append(string.substring(1, string.length() - 1));
            stringBuilder.append(") VALUES (");
            for (int i = 0; i < this.columns.length - 1; ++i) {
                stringBuilder.append("?, ");
            }
            stringBuilder.append("?)");
            this.insertSql = stringBuilder.toString();
        }
    }

    private void prepareUpdateSql() {
        if (this.updateSql == null) {
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("UPDATE " + this.tableName + " SET ");
            for (int i = 0; i < this.columns.length; ++i) {
                if (this.isPrimaryKeyColumn(this.columns[i])) {
                    arrayList.add((CallSite)((Object)("\n" + this.columns[i] + " = ?")));
                    continue;
                }
                arrayList2.add((CallSite)((Object)("\n" + this.columns[i] + " = ?")));
            }
            stringBuilder.append(String.join((CharSequence)", ", arrayList2));
            stringBuilder.append("\nWHERE ");
            stringBuilder.append(String.join((CharSequence)" AND ", arrayList));
            this.updateSql = stringBuilder.toString();
        }
    }

    private boolean isPrimaryKeyColumn(String string) {
        for (String string2 : this.primaryConstraintsColumns) {
            if (!string2.equalsIgnoreCase(string = string.replaceAll("^\"|\"$", ""))) continue;
            return true;
        }
        return false;
    }

    private void onBatchComplete(int n) {
        this.currentBufferedRows.addAndGet(-n);
        this.jobsQueuedForExecution.decrementAndGet();
        if (!this.isClosed.get() && this.isSubscribersStalled.compareAndSet(true, false)) {
            this.resumeSubscribers();
        }
    }

    protected void scheduleBufferIntervalTask() {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                ClioSupport.ilogFinest(null, null, null, null, "Scheduler initiated flush event. Buffer will be flushed if due.");
                this.flushIfDue(false);
            }
            catch (Exception exception) {
                ClioSupport.ilogWarning(this.logger, null, null, null, "Buffer flush task encountered an error: " + exception.getMessage());
            }
        }, this.bufferInterval.toMillis(), this.bufferInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void flushIfDue(boolean bl) {
        this.flushItemsIfDue(bl);
    }

    private boolean isBufferAvailableFor(int n) {
        return (long)(this.currentBufferedRows.get() + this.recordsDueFromSubscriptions.get() + n) <= this.maxRowsToBuffer;
    }

    long getNextDemand() {
        if (this.isClosed.get()) {
            throw new IllegalStateException(RSI_CLOSED_ERROR_MSG);
        }
        if (this.isBufferAvailableFor(1)) {
            this.recordsDueFromSubscriptions.addAndGet(1);
            return 1L;
        }
        if (this.isSubscribersStalled.compareAndSet(false, true) && this.jobsQueuedForExecution.get() == 0) {
            String string = "Buffer is full. All previous ingest jobs have finished.  Stalling the subscribers and initiating flush event.";
            ClioSupport.ilogFinest(null, null, null, null, string);
            this.flushIfDue(true);
        }
        return 0L;
    }

    private void resumeSubscribers() {
        this.subscribersList.forEach(flowSubscriber -> flowSubscriber.resume());
    }

    private void clearSubscribers() {
        for (FlowSubscriber flowSubscriber : this.subscribersList) {
            flowSubscriber.onComplete();
        }
        this.subscribersList.clear();
    }

    public Flow.Subscriber<Object> subscriber() {
        if (this.isClosed.get()) {
            throw new IllegalStateException(RSI_CLOSED_ERROR_MSG);
        }
        return new FlowSubscriber<Object>(this);
    }

    void register(FlowSubscriber<?> flowSubscriber) {
        if (this.isClosed.get()) {
            throw new IllegalStateException(RSI_CLOSED_ERROR_MSG);
        }
        this.subscribersList.add(flowSubscriber);
    }

    @Override
    public void close() {
        if (this.isClosed.get()) {
            return;
        }
        if (this.isClosed.compareAndSet(false, true)) {
            while (this.jobsQueuedForExecution.get() > 0) {
            }
            ClioSupport.ilogFinest(null, null, null, null, "Initiating flush on close event.");
            this.flushIfDue(true);
            while (this.currentBufferedRows.get() != 0) {
            }
            this.shutdown();
        }
    }

    private void shutdown() {
        this.cleanup();
        this.scheduledExecutorService.shutdown();
        this.clearSubscribers();
        try {
            this.destroyConnectionPool();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            ClioSupport.ilogWarning(this.logger, null, null, null, universalConnectionPoolException.getMessage());
        }
    }

    static {
        try {
            $$$methodRef$$$26 = IngestSuite.class.getDeclaredConstructor(RSIBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$25 = IngestSuite.class.getDeclaredMethod("lambda$initializePredeclaredColumnsMetadata$0", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$24 = IngestSuite.class.getDeclaredMethod("lambda$scheduleBufferIntervalTask$1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$23 = IngestSuite.class.getDeclaredMethod("lambda$resumeSubscribers$2", FlowSubscriber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$22 = IngestSuite.class.getDeclaredMethod("shutdown", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$21 = IngestSuite.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$20 = IngestSuite.class.getDeclaredMethod("register", FlowSubscriber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$19 = IngestSuite.class.getDeclaredMethod("subscriber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$18 = IngestSuite.class.getDeclaredMethod("clearSubscribers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$17 = IngestSuite.class.getDeclaredMethod("resumeSubscribers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$16 = IngestSuite.class.getDeclaredMethod("getNextDemand", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$15 = IngestSuite.class.getDeclaredMethod("isBufferAvailableFor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$14 = IngestSuite.class.getDeclaredMethod("flushIfDue", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$13 = IngestSuite.class.getDeclaredMethod("scheduleBufferIntervalTask", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$12 = IngestSuite.class.getDeclaredMethod("onBatchComplete", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$11 = IngestSuite.class.getDeclaredMethod("isPrimaryKeyColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$10 = IngestSuite.class.getDeclaredMethod("prepareUpdateSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$9 = IngestSuite.class.getDeclaredMethod("prepareInsertSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$8 = IngestSuite.class.getDeclaredMethod("handleRejectedExecutionException", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$7 = IngestSuite.class.getDeclaredMethod("validate", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$6 = IngestSuite.class.getDeclaredMethod("putRecord", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$5 = IngestSuite.class.getDeclaredMethod("configureRowBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = IngestSuite.class.getDeclaredMethod("initializePredeclaredColumnsMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = IngestSuite.class.getDeclaredMethod("readConfiguration", RSIBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = IngestSuite.class.getDeclaredMethod("newIngestSuiteForPartitionedTable", RSIBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = IngestSuite.class.getDeclaredMethod("newIngestSuiteForShardedDatabase", RSIBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = IngestSuite.class.getDeclaredMethod("newIngestSuiteForNonShardedDatabase", RSIBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        CONNECTION_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    }

    class IngestJob
    implements Runnable {
        private final PoolDataSourceImpl poolDataSource;
        private String partitionName = null;
        private final List<Object> items;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        public IngestJob(PoolDataSourceImpl poolDataSourceImpl, List<Object> list) {
            this.poolDataSource = poolDataSourceImpl;
            this.items = list;
        }

        public IngestJob(PoolDataSourceImpl poolDataSourceImpl, String string, List<Object> list) {
            this(poolDataSourceImpl, list);
            this.partitionName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                String string = "New ingest job is being run by " + Thread.currentThread().getName();
                ClioSupport.ilogFinest(IngestSuite.this.logger, null, null, null, string);
                try (Connection connection = this.poolDataSource.getConnection();){
                    connection.setAutoCommit(false);
                    try {
                        this.doInsert(connection);
                    }
                    catch (BatchUpdateException batchUpdateException) {
                        if (IngestSuite.this.isUpsert && (batchUpdateException.getErrorCode() == 24381 || batchUpdateException.getErrorCode() == 1)) {
                            this.doUpdate(connection, batchUpdateException.getLargeUpdateCounts());
                            break block14;
                        }
                        throw batchUpdateException;
                    }
                }
                catch (SQLException sQLException) {
                    ClioSupport.ilogSevere(IngestSuite.this.logger, null, null, null, sQLException.getMessage());
                }
                finally {
                    IngestSuite.this.onBatchComplete(this.items.size());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doInsert(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = this.prepareStatement(connection);){
                for (Object object : this.items) {
                    try {
                        this.addBatchForInsert(preparedStatement, object);
                    }
                    catch (IllegalAccessException | InvocationTargetException | SQLException exception) {
                        ClioSupport.ilogWarning(IngestSuite.this.logger, null, null, null, exception.getMessage());
                    }
                }
                try {
                    preparedStatement.executeLargeBatch();
                }
                finally {
                    connection.commit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUpdate(Connection connection, long[] lArray) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement(IngestSuite.this.updateSql);){
                if (lArray.length == 0) {
                    try {
                        this.addBatchForUpdate(preparedStatement, this.items.get(0));
                    }
                    catch (IllegalAccessException | InvocationTargetException | SQLException exception) {
                        ClioSupport.ilogWarning(IngestSuite.this.logger, null, null, null, exception.getMessage());
                    }
                } else {
                    for (int i = 0; i < lArray.length; ++i) {
                        if (lArray[i] != -3L) continue;
                        try {
                            this.addBatchForUpdate(preparedStatement, this.items.get(i));
                            continue;
                        }
                        catch (IllegalAccessException | InvocationTargetException | SQLException exception) {
                            ClioSupport.ilogWarning(IngestSuite.this.logger, null, null, null, exception.getMessage());
                        }
                    }
                }
                try {
                    preparedStatement.executeLargeBatch();
                }
                finally {
                    connection.commit();
                }
            }
        }

        private void addBatchForUpdate(PreparedStatement preparedStatement, Object object) throws SQLException, IllegalAccessException, InvocationTargetException {
            int n = 1;
            int n2 = IngestSuite.this.columns.length - IngestSuite.this.primaryConstraintsColumns.length + 1;
            for (int i = 0; i < IngestSuite.this.columns.length; ++i) {
                Object object2 = null;
                if (object instanceof Object[]) {
                    object2 = ((Object[])object)[i];
                } else if (object instanceof Map) {
                    object2 = ((Map)object).get(IngestSuite.this.columns[i]);
                } else if (IngestSuite.this.fields != null && i < IngestSuite.this.fields.length) {
                    object2 = IngestSuite.this.fields[i].get(object);
                } else if (IngestSuite.this.methods != null && i - IngestSuite.this.fields.length < IngestSuite.this.methods.length) {
                    object2 = IngestSuite.this.methods[i - IngestSuite.this.fields.length].invoke(object, new Object[0]);
                }
                if (!IngestSuite.this.isPrimaryKeyColumn(IngestSuite.this.columns[i])) {
                    preparedStatement.setObject(n++, object2, IngestSuite.this.predeclaredColumnsMetadataList.get(i).getSQLType());
                    continue;
                }
                preparedStatement.setObject(n2++, object2, IngestSuite.this.predeclaredColumnsMetadataList.get(i).getSQLType());
            }
            preparedStatement.addBatch();
        }

        private void addBatchForInsert(PreparedStatement preparedStatement, Object object) throws SQLException, IllegalAccessException, InvocationTargetException {
            if (object instanceof Object[] && ((Object[])object).length != IngestSuite.this.columns.length) {
                throw new IllegalArgumentException("Invalid number of column values supplied, discarding the record.");
            }
            if (!(object instanceof Object[]) && !(object instanceof Map) && IngestSuite.this.entityClass == null) {
                ClioSupport.ilogWarning(IngestSuite.this.logger, null, null, null, "Library has to be built with entity mapping class to use annotated records");
                return;
            }
            for (int i = 0; i < IngestSuite.this.columns.length; ++i) {
                Object object2 = null;
                if (object instanceof Object[]) {
                    object2 = ((Object[])object)[i];
                } else if (object instanceof Map) {
                    object2 = ((Map)object).get(IngestSuite.this.columns[i]);
                } else if (IngestSuite.this.fields != null && i < IngestSuite.this.fields.length) {
                    object2 = IngestSuite.this.fields[i].get(object);
                } else if (IngestSuite.this.methods != null && i - IngestSuite.this.fields.length < IngestSuite.this.methods.length) {
                    object2 = IngestSuite.this.methods[i - IngestSuite.this.fields.length].invoke(object, new Object[0]);
                }
                preparedStatement.setObject(i + 1, object2, IngestSuite.this.predeclaredColumnsMetadataList.get(i).getSQLType());
            }
            preparedStatement.addBatch();
        }

        private PreparedStatement prepareStatement(Connection connection) throws SQLException {
            if (!IngestSuite.this.isUseDP) {
                return connection.prepareStatement(IngestSuite.this.insertSql);
            }
            if (this.partitionName != null) {
                return ((OracleConnection)connection).prepareDirectPath(IngestSuite.this.dbSchema, IngestSuite.this.tableName, IngestSuite.this.columns, this.partitionName, IngestSuite.this.dpStmtProps);
            }
            return ((OracleConnection)connection).prepareDirectPath(IngestSuite.this.dbSchema, IngestSuite.this.tableName, IngestSuite.this.columns, IngestSuite.this.dpStmtProps);
        }

        static {
            try {
                $$$methodRef$$$7 = IngestJob.class.getDeclaredConstructor(IngestSuite.class, PoolDataSourceImpl.class, String.class, List.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = IngestJob.class.getDeclaredConstructor(IngestSuite.class, PoolDataSourceImpl.class, List.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = IngestJob.class.getDeclaredMethod("prepareStatement", Connection.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = IngestJob.class.getDeclaredMethod("addBatchForInsert", PreparedStatement.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = IngestJob.class.getDeclaredMethod("addBatchForUpdate", PreparedStatement.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = IngestJob.class.getDeclaredMethod("doUpdate", Connection.class, long[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = IngestJob.class.getDeclaredMethod("doInsert", Connection.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = IngestJob.class.getDeclaredMethod("run", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    }
}

