/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.logging.runtime;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.rsi.logging.annotations.Blinder;
import oracle.rsi.logging.annotations.DisableTrace;
import oracle.rsi.logging.annotations.Feature;
import oracle.rsi.logging.runtime.Features;
import oracle.rsi.logging.runtime.TraceController;

@DisableTrace
public class TraceControllerImpl
implements TraceController {
    private static final Features features;
    private RuntimeException reSuspended = new IllegalStateException("trace controller is currently suspended");
    public static long feature;
    private static long backup;
    private static int suspends;
    private static final ReentrantLock CLASS_LOCK;
    private static final Blinder<Object> bogusBlinder;
    private static final ConcurrentMap<Class<? extends Blinder<?>>, Blinder<?>> instantiatedBlindersMap;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(boolean bl, Feature ... featureArray) {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                throw this.reSuspended;
            }
            long l = 0L;
            for (Feature feature : featureArray) {
                l |= feature.bitVector();
            }
            feature = bl ? feature | l : feature & (l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getEnabledFeatures() {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                Feature[] featureArray = new Feature[]{};
                return featureArray;
            }
            ArrayList<Feature> arrayList = new ArrayList<Feature>();
            if (feature == Feature.ALL.bitVector()) {
                arrayList.add(Feature.ALL);
            } else {
                for (Feature feature : this.getSupportedFeatures()) {
                    if (Feature.ALL == feature || 0L == (TraceControllerImpl.feature & feature.bitVector())) continue;
                    arrayList.add(feature);
                }
            }
            Feature[] featureArray = arrayList.toArray(new Feature[0]);
            return featureArray;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getSupportedFeatures() {
        CLASS_LOCK.lock();
        try {
            ArrayList<Feature> arrayList = new ArrayList<Feature>();
            for (Feature feature : Feature.values()) {
                arrayList.add(feature);
            }
            Feature[] featureArray = arrayList.toArray(new Feature[0]);
            return featureArray;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    @Override
    public void suspend() {
        CLASS_LOCK.lock();
        try {
            if (0 == suspends++) {
                backup = feature;
                feature = 0L;
            }
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    @Override
    public void resume() {
        CLASS_LOCK.lock();
        try {
            int n = --suspends;
            if (0 == n) {
                feature = backup;
            } else if (n < 0) {
                suspends = 0;
            }
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTracing(Feature ... featureArray) {
        CLASS_LOCK.lock();
        try {
            if (0 != suspends) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            for (Feature feature : featureArray) {
                if (0L != (TraceControllerImpl.feature & feature.bitVector())) continue;
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    private static <T> Blinder<T> getBlinder(Class<? extends Blinder<T>> clazz2) {
        RuntimeException[] runtimeExceptionArray = new RuntimeException[]{null};
        Blinder blinder = instantiatedBlindersMap.computeIfAbsent(clazz2, clazz -> {
            try {
                return (Blinder)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                runtimeExceptionArray[0] = new RuntimeException(reflectiveOperationException);
                return bogusBlinder;
            }
        });
        if (Objects.nonNull(runtimeExceptionArray[0])) {
            throw runtimeExceptionArray[0];
        }
        return blinder;
    }

    public static <T> String blind(Class<? extends Blinder<T>> clazz, T t) {
        return TraceControllerImpl.getBlinder(clazz).blind(t);
    }

    static {
        String string;
        try {
            $$$methodRef$$$10 = TraceControllerImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$9 = TraceControllerImpl.class.getDeclaredMethod("lambda$static$0", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$8 = TraceControllerImpl.class.getDeclaredMethod("lambda$getBlinder$1", RuntimeException[].class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$7 = TraceControllerImpl.class.getDeclaredMethod("blind", Class.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$6 = TraceControllerImpl.class.getDeclaredMethod("getBlinder", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$5 = TraceControllerImpl.class.getDeclaredMethod("isTracing", Feature[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = TraceControllerImpl.class.getDeclaredMethod("resume", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = TraceControllerImpl.class.getDeclaredMethod("suspend", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = TraceControllerImpl.class.getDeclaredMethod("getSupportedFeatures", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = TraceControllerImpl.class.getDeclaredMethod("getEnabledFeatures", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = TraceControllerImpl.class.getDeclaredMethod("trace", Boolean.TYPE, Feature[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        features = new Features("oracle.rsi.logging.annotations.Supports");
        feature = Feature.ALL_UCP.bitVector();
        String string2 = System.getProperty("oracle.jdbc.Trace");
        if (null != string2 && ("true".equals(string = string2.trim().toLowerCase()) || "on".equals(string))) {
            feature |= Feature.ALL_JDBC.bitVector();
        }
        if (null != (string = System.getProperty("java.util.logging.config.file"))) {
            Properties properties = new Properties();
            InputStream inputStream = TraceControllerImpl.class.getClassLoader().getResourceAsStream(string);
            if (null == inputStream) {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (null != inputStream) {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            long l = 0L;
            for (Feature feature : Feature.values()) {
                String string3 = "clio.feature." + feature.toString().toLowerCase();
                String string4 = properties.getProperty(string3);
                if (null == string4) continue;
                String string5 = string4.toLowerCase().trim();
                if ("on".equals(string5) || "true".equals(string5)) {
                    l |= feature.bitVector();
                    continue;
                }
                if (!"off".equals(string5) && !"false".equals(string5)) continue;
                l &= feature.bitVector() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (0L != l) {
                feature = l;
            }
        }
        backup = 0L;
        suspends = 0;
        CLASS_LOCK = new ReentrantLock();
        bogusBlinder = object -> "*** error: bogus blinder invoked instead, an appropriate blinder was not properly instantiated ***";
        instantiatedBlindersMap = new ConcurrentHashMap();
    }
}

