/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import oracle.rsi.RSIException;
import oracle.rsi.internal.Metadata;
import oracle.rsi.internal.TypeConverter;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class PartitionManager {
    private final Metadata.NLSContext nlsContext;
    private final int jdbcCharsetId;
    private Metadata.Table table;
    final List<Metadata.ColumnMetadata> topPartitionKeyColumnsMetadataList;
    final List<Metadata.ColumnMetadata> predeclaredColumnsMetadataList;
    private final PartitionStrategy topPartitionStrategy;
    private final Map<Integer, PartitionStrategy> subPartitionStrategyMap;
    private final PartitionStrategy defaultSubPartitionStrategy;
    private static final int MAX_PARTITION_CNT = 1048575;
    private final PartitionFragOffsetRecord[] staticPartitionRecords;
    private final Map<Integer, PartitionFragOffsetRecord> staticPartitionFragOffsetMap;
    private final int subpartCountInDynamicPart;
    private final int lastStaticallyDefinedPartNum;
    private final int fragmentsInStaticPartitions;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    PartitionManager(Metadata metadata, List<Metadata.ColumnMetadata> list, int n) {
        this.nlsContext = metadata.getNLSContext();
        this.jdbcCharsetId = n;
        this.table = metadata.getTable();
        this.predeclaredColumnsMetadataList = list;
        this.topPartitionKeyColumnsMetadataList = this.table.getPartitionKeyColumnsMetadata();
        if (this.table.isPartitioned()) {
            if (this.table.isCompositePartition()) {
                Collection<Metadata.TablePartitionInfo> collection;
                Collection<Metadata.TablePartitionInfo> collection2 = this.table.getCompositePartitions();
                this.topPartitionStrategy = this.getPartitionStrategy(this.table.getPartitionType(), this.table.isIntervalPartition(), this.topPartitionKeyColumnsMetadataList, collection2);
                this.subPartitionStrategyMap = new HashMap<Integer, PartitionStrategy>();
                for (Metadata.TablePartitionInfo tablePartitionInfo : collection2) {
                    collection = this.getPartitionStrategy(this.table.getSubpartitionType(), false, this.table.getSubpartitionColumns(), ((Metadata.TableCompositePartition)tablePartitionInfo).getSubpartitions());
                    this.subPartitionStrategyMap.put(tablePartitionInfo.getPartitionNum(), (PartitionStrategy)((Object)collection));
                }
                Object object = null;
                int n2 = 0;
                if (this.table.isIntervalPartition()) {
                    collection = this.table.getTemplateSubPartitions();
                    n2 = collection.size();
                    if (n2 > 0) {
                        object = this.getPartitionStrategy(this.table.getSubpartitionType(), false, this.table.getSubpartitionColumns(), collection);
                    } else if (this.table.getSubpartitionType() == Metadata.PartitionType.HASH) {
                        n2 = this.table.getDefSubpartitionCount();
                        object = n2 == 1 ? new ConstantPartitionStrategy(1) : new HashPartition(this.topPartitionKeyColumnsMetadataList, n2);
                    }
                }
                if (object == null) {
                    n2 = 1;
                    object = new ConstantPartitionStrategy(1);
                }
                this.defaultSubPartitionStrategy = object;
                this.subpartCountInDynamicPart = n2;
                this.staticPartitionRecords = PartitionManager.getPartitionFragOffsetRecords(collection2);
                this.staticPartitionFragOffsetMap = PartitionManager.getSubPartitionFragOffsetMap(this.staticPartitionRecords);
                this.lastStaticallyDefinedPartNum = PartitionManager.getLastStaticallyDefinedPartitionNum(collection2);
                this.fragmentsInStaticPartitions = PartitionManager.getFragmentsInStaticPartitions(collection2);
            } else {
                Collection<Metadata.TablePartitionInfo> collection = this.table.getPartitions();
                this.topPartitionStrategy = this.getPartitionStrategy(this.table.getPartitionType(), this.table.isIntervalPartition(), this.topPartitionKeyColumnsMetadataList, collection);
                this.subPartitionStrategyMap = null;
                this.defaultSubPartitionStrategy = new ConstantPartitionStrategy(0);
                this.subpartCountInDynamicPart = 1;
                this.staticPartitionRecords = null;
                this.staticPartitionFragOffsetMap = null;
                this.lastStaticallyDefinedPartNum = PartitionManager.getLastStaticallyDefinedPartitionNum(collection);
                this.fragmentsInStaticPartitions = PartitionManager.getStaticallyDefinedPartitionCount(collection);
            }
        } else {
            this.topPartitionStrategy = new ConstantPartitionStrategy(0);
            this.subPartitionStrategyMap = null;
            this.defaultSubPartitionStrategy = this.topPartitionStrategy;
            this.subpartCountInDynamicPart = 0;
            this.staticPartitionRecords = null;
            this.staticPartitionFragOffsetMap = null;
            this.lastStaticallyDefinedPartNum = 0;
            this.fragmentsInStaticPartitions = 0;
        }
    }

    private int getIndexOfKeyColumnInSuppliedItem(Metadata.ColumnMetadata columnMetadata) {
        return this.predeclaredColumnsMetadataList.indexOf(columnMetadata);
    }

    private PartitionStrategy getPartitionStrategy(Metadata.PartitionType partitionType, boolean bl, List<Metadata.ColumnMetadata> list, Collection<Metadata.TablePartitionInfo> collection) {
        switch (partitionType) {
            case HASH: {
                return new HashPartition(list, collection);
            }
            case RANGE: {
                if (bl) {
                    return new IntervalRangePartition(this.table, list, collection);
                }
                return new StaticRangePartition(list, collection);
            }
            case LIST: {
                return new ListPartition(list, collection);
            }
        }
        throw new RSIException("Unsupported partition type.");
    }

    private static PartitionFragOffsetRecord[] getPartitionFragOffsetRecords(Collection<Metadata.TablePartitionInfo> collection) {
        Metadata.TablePartitionInfo tablePartitionInfo;
        Metadata.TableCompositePartition tableCompositePartition;
        ArrayList<PartitionFragOffsetRecord> arrayList = new ArrayList<PartitionFragOffsetRecord>();
        int n = 0;
        Iterator<Metadata.TablePartitionInfo> iterator = collection.iterator();
        while (iterator.hasNext() && (tableCompositePartition = (Metadata.TableCompositePartition)(tablePartitionInfo = iterator.next())).isPartitionStaticallyDefined()) {
            arrayList.add(new PartitionFragOffsetRecord(tableCompositePartition.getPartitionNum(), n));
            int n2 = tableCompositePartition.getSubpartitions().size();
            n += n2;
        }
        return arrayList.toArray(new PartitionFragOffsetRecord[arrayList.size()]);
    }

    private static Map<Integer, PartitionFragOffsetRecord> getSubPartitionFragOffsetMap(PartitionFragOffsetRecord[] partitionFragOffsetRecordArray) {
        HashMap<Integer, PartitionFragOffsetRecord> hashMap = new HashMap<Integer, PartitionFragOffsetRecord>();
        for (PartitionFragOffsetRecord partitionFragOffsetRecord : partitionFragOffsetRecordArray) {
            hashMap.put(partitionFragOffsetRecord.partNum, partitionFragOffsetRecord);
        }
        return hashMap;
    }

    private static int getLastStaticallyDefinedPartitionNum(Collection<Metadata.TablePartitionInfo> collection) {
        Metadata.TablePartitionInfo tablePartitionInfo = PartitionManager.getLastStaticallyDefinedPartitionInfo(collection);
        return tablePartitionInfo != null ? tablePartitionInfo.getPartitionNum() : 0;
    }

    private static Metadata.TablePartitionInfo getLastStaticallyDefinedPartitionInfo(Collection<Metadata.TablePartitionInfo> collection) {
        Metadata.TablePartitionInfo tablePartitionInfo = null;
        for (Metadata.TablePartitionInfo tablePartitionInfo2 : collection) {
            if (!tablePartitionInfo2.isPartitionStaticallyDefined()) break;
            tablePartitionInfo = tablePartitionInfo2;
        }
        return tablePartitionInfo;
    }

    private static int getFragmentsInStaticPartitions(Collection<Metadata.TablePartitionInfo> collection) {
        Metadata.TablePartitionInfo tablePartitionInfo;
        Metadata.TableCompositePartition tableCompositePartition;
        int n = 0;
        Iterator<Metadata.TablePartitionInfo> iterator = collection.iterator();
        while (iterator.hasNext() && (tableCompositePartition = (Metadata.TableCompositePartition)(tablePartitionInfo = iterator.next())).isPartitionStaticallyDefined()) {
            int n2 = tableCompositePartition.getSubpartitions().size();
            n += n2;
        }
        return n;
    }

    private static <TPI extends Metadata.TablePartitionInfo> int getStaticallyDefinedPartitionCount(Collection<TPI> collection) {
        Metadata.TablePartitionInfo tablePartitionInfo;
        int n = 0;
        Iterator<TPI> iterator = collection.iterator();
        while (iterator.hasNext() && (tablePartitionInfo = (Metadata.TablePartitionInfo)iterator.next()).isPartitionStaticallyDefined()) {
            ++n;
        }
        return n;
    }

    String computePartition(Object object) {
        int n = this.topPartitionStrategy.getPartitionId(object);
        PartitionStrategy partitionStrategy = null;
        if (this.subPartitionStrategyMap != null) {
            partitionStrategy = this.subPartitionStrategyMap.get(n);
        }
        if (partitionStrategy == null) {
            partitionStrategy = this.defaultSubPartitionStrategy;
        }
        int n2 = partitionStrategy.getPartitionId(object);
        this.checkORA14299(n, n2);
        if (this.table.isCompositePartition()) {
            return this.table.getSubPartitionName(n, n2);
        }
        if (this.table.isPartitioned()) {
            int n3 = this.computeAbsoluteFragmentNum(n, n2);
            return this.table.getPartitionName(n3);
        }
        return null;
    }

    private void validate(int n, String string) {
        if (n < 0) {
            throw new RSIException("Invalid DB " + string + " ID " + n + ".");
        }
        if (n > 1048575) {
            throw new RSIException(string + " exceeds maximum number of partitions.");
        }
    }

    private void checkORA14299(int n, int n2) {
        long l;
        if (n > this.lastStaticallyDefinedPartNum && n2 != 0 && (l = (long)this.fragmentsInStaticPartitions + (long)(n - this.lastStaticallyDefinedPartNum) * (long)this.subpartCountInDynamicPart) > 1048575L) {
            throw new RSIException("Exceeded the maximum sub-partition size.");
        }
    }

    private int computeAbsoluteFragmentNum(int n, int n2) {
        long l = 0L;
        if (n > this.lastStaticallyDefinedPartNum) {
            l = (long)this.fragmentsInStaticPartitions + (long)(n - this.lastStaticallyDefinedPartNum - 1) * (long)this.subpartCountInDynamicPart;
            if (n2 == 0) {
                n2 = 1;
            }
        } else if (this.staticPartitionFragOffsetMap == null) {
            l = n;
            if (n2 != 0) {
                throw new IllegalStateException("SubpartId should be 0 when table is not composite-partitioned");
            }
        } else {
            PartitionFragOffsetRecord partitionFragOffsetRecord = this.staticPartitionFragOffsetMap.get(n);
            l = partitionFragOffsetRecord.fragNumOffset;
        }
        int n3 = (int)(l + (long)n2);
        this.validate(n3, "Fragment");
        return n3;
    }

    private static Iterator<byte[]> decodeVariableLengthEncodedList(byte[] byArray) {
        return new VarLenDecoderIterator(byArray);
    }

    static {
        try {
            $$$methodRef$$$13 = PartitionManager.class.getDeclaredConstructor(Metadata.class, List.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$12 = PartitionManager.class.getDeclaredMethod("decodeVariableLengthEncodedList", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$11 = PartitionManager.class.getDeclaredMethod("computeAbsoluteFragmentNum", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$10 = PartitionManager.class.getDeclaredMethod("checkORA14299", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$9 = PartitionManager.class.getDeclaredMethod("validate", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$8 = PartitionManager.class.getDeclaredMethod("computePartition", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$7 = PartitionManager.class.getDeclaredMethod("getStaticallyDefinedPartitionCount", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$6 = PartitionManager.class.getDeclaredMethod("getFragmentsInStaticPartitions", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$5 = PartitionManager.class.getDeclaredMethod("getLastStaticallyDefinedPartitionInfo", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = PartitionManager.class.getDeclaredMethod("getLastStaticallyDefinedPartitionNum", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = PartitionManager.class.getDeclaredMethod("getSubPartitionFragOffsetMap", PartitionFragOffsetRecord[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = PartitionManager.class.getDeclaredMethod("getPartitionFragOffsetRecords", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = PartitionManager.class.getDeclaredMethod("getPartitionStrategy", Metadata.PartitionType.class, Boolean.TYPE, List.class, Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = PartitionManager.class.getDeclaredMethod("getIndexOfKeyColumnInSuppliedItem", Metadata.ColumnMetadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
    }

    private final class IntervalRangePartition
    extends StaticRangePartition {
        private final Calendar GMT_CAL;
        private final int SIZE_DATE = 7;
        private final int SIZE_TIMESTAMP = 11;
        private final NUMBER E6;
        final DynamicPartitionOffsetCalculator dynamicPartOffsetCalculator;
        final StaticRangePartition.RangePartitionValueSet transitionPointRangePartitionValueSet;
        final int basePartitionNumber;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        public IntervalRangePartition(Metadata.Table table, List<Metadata.ColumnMetadata> list, Collection<Metadata.TablePartitionInfo> collection) {
            super(list, collection);
            this.GMT_CAL = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
            this.SIZE_DATE = 7;
            this.SIZE_TIMESTAMP = 11;
            this.E6 = new NUMBER(1000000);
            byte[] byArray = PartitionManager.getLastStaticallyDefinedPartitionInfo(collection).getbHiboundVal();
            this.transitionPointRangePartitionValueSet = new StaticRangePartition.RangePartitionValueSet(PartitionManager.this.lastStaticallyDefinedPartNum, byArray);
            this.basePartitionNumber = PartitionManager.this.lastStaticallyDefinedPartNum != 0 ? PartitionManager.this.lastStaticallyDefinedPartNum + 1 : 0;
            byte[] byArray2 = this.transitionPointRangePartitionValueSet.getKeyColumnValues()[0];
            int n = table.getIntervalDataType();
            try {
                switch (n) {
                    case 2: {
                        this.dynamicPartOffsetCalculator = new DynamicPartitionOffsetCalculator_NUMBER(table.getIntervalBinaryValue(), byArray2);
                        break;
                    }
                    case 183: {
                        this.dynamicPartOffsetCalculator = new DynamicPartitionOffsetCalculator_DATETIME_DS(table.getIntervalBinaryValue(), byArray2);
                        break;
                    }
                    case 182: {
                        this.dynamicPartOffsetCalculator = new DynamicPartitionOffsetCalculator_DATETIME_YM(table.getIntervalBinaryValue(), byArray2);
                        break;
                    }
                    default: {
                        throw new RSIException("Invalid Interval Type : " + n);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new RSIException(sQLException.getMessage());
            }
        }

        @Override
        protected int getPartitionId(byte[][] byArray) {
            int n = this.comparator.compare(byArray, this.transitionPointRangePartitionValueSet.getKeyColumnValues());
            if (n < 0) {
                return super.getPartitionId(byArray);
            }
            if (n == 0) {
                return this.basePartitionNumber;
            }
            byte[] byArray2 = byArray[0];
            if (byArray2 == null) {
                throw new RSIException("Interval partitioning does not allow null value for key column.");
            }
            try {
                int n2 = this.dynamicPartOffsetCalculator.getPartitionOffset(byArray2);
                return n2 + this.basePartitionNumber;
            }
            catch (SQLException sQLException) {
                throw new RSIException(sQLException.getMessage());
            }
        }

        private NUMBER milliesToNUMBER(byte[] byArray) throws SQLException {
            int[] nArray = new int[1];
            GregorianCalendar gregorianCalendar = this.getCalendar(byArray, nArray);
            if (gregorianCalendar.get(0) == 0) {
                gregorianCalendar.add(1, -1);
            }
            return this.getNUMBER(gregorianCalendar, nArray[0]);
        }

        private NUMBER getNUMBER(GregorianCalendar gregorianCalendar, int n) throws SQLException {
            long l = gregorianCalendar.getTimeInMillis();
            NUMBER nUMBER = new NUMBER(l);
            if (n != 0) {
                nUMBER = nUMBER.add(new NUMBER(n).div(this.E6));
            }
            return nUMBER;
        }

        private GregorianCalendar getCalendar(byte[] byArray, int[] nArray) throws SQLException {
            return this.toCalendar(byArray, null, nArray);
        }

        private GregorianCalendar toCalendar(byte[] byArray, GregorianCalendar gregorianCalendar, int[] nArray) {
            GregorianCalendar gregorianCalendar2 = gregorianCalendar;
            if (gregorianCalendar2 == null) {
                gregorianCalendar2 = (GregorianCalendar)this.GMT_CAL.clone();
            }
            gregorianCalendar2.clear();
            int n = 100 * ((0xFF & byArray[0]) - 100) + ((0xFF & byArray[1]) - 100);
            if (n < 0) {
                gregorianCalendar2.set(0, 0);
                n = -n;
            } else {
                gregorianCalendar2.set(0, 1);
            }
            int n2 = byArray[2] - 1;
            byte by = byArray[3];
            int n3 = byArray[4] - 1;
            int n4 = byArray[5] - 1;
            int n5 = byArray[6] - 1;
            if (nArray != null && nArray.length > 0) {
                nArray[0] = byArray.length >= 11 ? this.getNanos(byArray, 7) : 0;
            }
            gregorianCalendar2.set(n, n2, by, n3, n4, n5);
            return gregorianCalendar2;
        }

        private final int getNanos(byte[] byArray, int n) {
            int n2 = (byArray[n] & 0xFF) << 24;
            n2 |= (byArray[n + 1] & 0xFF) << 16;
            n2 |= (byArray[n + 2] & 0xFF) << 8;
            return n2 |= byArray[n + 3] & 0xFF & 0xFF;
        }

        static {
            try {
                $$$methodRef$$$6 = IntervalRangePartition.class.getDeclaredConstructor(PartitionManager.class, Metadata.Table.class, List.class, Collection.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = IntervalRangePartition.class.getDeclaredMethod("getNanos", byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = IntervalRangePartition.class.getDeclaredMethod("toCalendar", byte[].class, GregorianCalendar.class, int[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = IntervalRangePartition.class.getDeclaredMethod("getCalendar", byte[].class, int[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = IntervalRangePartition.class.getDeclaredMethod("getNUMBER", GregorianCalendar.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = IntervalRangePartition.class.getDeclaredMethod("milliesToNUMBER", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = IntervalRangePartition.class.getDeclaredMethod("getPartitionId", byte[][].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        private class DynamicPartitionOffsetCalculator_DATETIME_YM
        extends DynamicPartitionOffsetCalculator {
            private final GregorianCalendar transitionPointCal;
            private final int transitionPointYear;
            private final int transitionPointMonth;
            private final int transitionPointDay;
            int interval;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            public DynamicPartitionOffsetCalculator_DATETIME_YM(byte[] byArray, byte[] byArray2) throws SQLException {
                this.interval = NUMBER.toInt((byte[])byArray);
                this.transitionPointCal = IntervalRangePartition.this.getCalendar(byArray2, null);
                this.transitionPointYear = this.transitionPointCal.get(0) == 1 ? this.transitionPointCal.get(1) : -this.transitionPointCal.get(1);
                this.transitionPointMonth = this.transitionPointCal.get(2);
                this.transitionPointDay = this.transitionPointCal.get(5);
            }

            @Override
            int getPartitionOffset(byte[] byArray) throws SQLException {
                int n;
                GregorianCalendar gregorianCalendar = IntervalRangePartition.this.getCalendar(byArray, null);
                int n2 = gregorianCalendar.get(1);
                if (gregorianCalendar.get(0) == 0) {
                    n2 = -n2;
                }
                int n3 = gregorianCalendar.get(2);
                int n4 = gregorianCalendar.get(5);
                int n5 = n2 - this.transitionPointYear;
                int n6 = n5 * 12 + (n3 - this.transitionPointMonth);
                int n7 = n6 >= 0 ? 1 : -1;
                int n8 = n4 - this.transitionPointDay;
                int n9 = n = n8 >= 0 ? 1 : -1;
                if (n7 * n < 0) {
                    if (n * n8 > 15) {
                        n6 -= n7;
                    }
                } else if (n * n8 >= 15) {
                    n6 += n;
                }
                int n10 = n6 / this.interval;
                GregorianCalendar gregorianCalendar2 = (GregorianCalendar)this.transitionPointCal.clone();
                gregorianCalendar2.add(2, n10 * this.interval);
                if (this.transitionPointCal.get(0) == 0 && gregorianCalendar2.get(0) == 1 && gregorianCalendar.get(0) == 1) {
                    gregorianCalendar2.add(1, -1);
                }
                if (gregorianCalendar.before(gregorianCalendar2)) {
                    --n10;
                }
                return n10;
            }

            static {
                try {
                    $$$methodRef$$$1 = DynamicPartitionOffsetCalculator_DATETIME_YM.class.getDeclaredConstructor(IntervalRangePartition.class, byte[].class, byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = DynamicPartitionOffsetCalculator_DATETIME_YM.class.getDeclaredMethod("getPartitionOffset", byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            }
        }

        private class DynamicPartitionOffsetCalculator_DATETIME_DS
        extends DynamicPartitionOffsetCalculator_NUMBER {
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;

            public DynamicPartitionOffsetCalculator_DATETIME_DS(byte[] byArray, byte[] byArray2) throws SQLException {
                super(new NUMBER(byArray).mul(new NUMBER(1000L)), IntervalRangePartition.this.milliesToNUMBER(byArray2));
            }

            static {
                try {
                    $$$methodRef$$$0 = DynamicPartitionOffsetCalculator_DATETIME_DS.class.getDeclaredConstructor(IntervalRangePartition.class, byte[].class, byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            }
        }

        private class DynamicPartitionOffsetCalculator_NUMBER
        extends DynamicPartitionOffsetCalculator {
            private final NUMBER MAX_OFFSET;
            private final NUMBER interval;
            private final NUMBER transitionPoint;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            public DynamicPartitionOffsetCalculator_NUMBER(byte[] byArray, byte[] byArray2) {
                this.MAX_OFFSET = new NUMBER(1048575);
                this.interval = new NUMBER(byArray);
                this.transitionPoint = new NUMBER(byArray2);
            }

            public DynamicPartitionOffsetCalculator_NUMBER(NUMBER nUMBER, NUMBER nUMBER2) {
                this.MAX_OFFSET = new NUMBER(1048575);
                this.interval = nUMBER;
                this.transitionPoint = nUMBER2;
            }

            @Override
            int getPartitionOffset(byte[] byArray) throws SQLException {
                NUMBER nUMBER = (NUMBER)TypeConverter.toDatum(PartitionManager.this.topPartitionKeyColumnsMetadataList.get(0), byArray, PartitionManager.this.nlsContext, PartitionManager.this.jdbcCharsetId);
                NUMBER nUMBER2 = nUMBER.sub(this.transitionPoint);
                NUMBER nUMBER3 = nUMBER2.div(this.interval);
                if (nUMBER3.compareTo(this.MAX_OFFSET) > 0) {
                    throw new RSIException("Exceeded the maximum allowed partition size");
                }
                int n = nUMBER3.intValue();
                return n;
            }

            static {
                try {
                    $$$methodRef$$$2 = DynamicPartitionOffsetCalculator_NUMBER.class.getDeclaredConstructor(IntervalRangePartition.class, NUMBER.class, NUMBER.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = DynamicPartitionOffsetCalculator_NUMBER.class.getDeclaredConstructor(IntervalRangePartition.class, byte[].class, byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = DynamicPartitionOffsetCalculator_NUMBER.class.getDeclaredMethod("getPartitionOffset", byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            }
        }

        private abstract class DynamicPartitionOffsetCalculator {
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;

            private DynamicPartitionOffsetCalculator() {
            }

            abstract int getPartitionOffset(byte[] var1) throws SQLException;

            static {
                try {
                    $$$methodRef$$$0 = DynamicPartitionOffsetCalculator.class.getDeclaredConstructor(IntervalRangePartition.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            }
        }
    }

    private class StaticRangePartition
    implements PartitionStrategy {
        private final RangePartitionValueSet[] rangePartitionValueSet;
        private final byte[][][] collectionOfKeyColumnValuesOfAllPartitionsInOrder;
        protected final RangePartitionValueSetComparator comparator = new RangePartitionValueSetComparator();
        private final List<Metadata.ColumnMetadata> keyColumnsMetadataList;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public StaticRangePartition(List<Metadata.ColumnMetadata> list, Collection<Metadata.TablePartitionInfo> collection) {
            this.keyColumnsMetadataList = list;
            Metadata.TablePartitionInfo[] tablePartitionInfoArray = new Metadata.TablePartitionInfo[]{};
            tablePartitionInfoArray = collection.toArray(tablePartitionInfoArray);
            int n = collection.size();
            this.rangePartitionValueSet = new RangePartitionValueSet[n];
            this.collectionOfKeyColumnValuesOfAllPartitionsInOrder = new byte[n][][];
            for (int i = 0; i < n; ++i) {
                this.rangePartitionValueSet[i] = new RangePartitionValueSet(tablePartitionInfoArray[i].getPartitionNum(), tablePartitionInfoArray[i].getbHiboundVal());
                this.collectionOfKeyColumnValuesOfAllPartitionsInOrder[i] = this.rangePartitionValueSet[i].getKeyColumnValues();
            }
        }

        @Override
        public int getPartitionId(Object object) {
            byte[][] byArrayArray;
            block3: {
                int n;
                block2: {
                    n = this.keyColumnsMetadataList.size();
                    byArrayArray = new byte[n][];
                    if (!(object instanceof Object[])) break block2;
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < n; ++i) {
                        int n2 = PartitionManager.this.getIndexOfKeyColumnInSuppliedItem(this.keyColumnsMetadataList.get(i));
                        Datum datum = TypeConverter.toDatum(this.keyColumnsMetadataList.get(i), objectArray[n2], PartitionManager.this.nlsContext, PartitionManager.this.jdbcCharsetId);
                        byArrayArray[i] = datum.shareBytes();
                        objectArray[n2] = datum;
                    }
                    break block3;
                }
                if (!(object instanceof Map)) break block3;
                Map map = (Map)object;
                for (int i = 0; i < n; ++i) {
                    Datum datum = TypeConverter.toDatum(this.keyColumnsMetadataList.get(i), map.get(this.keyColumnsMetadataList.get(i).getName()), PartitionManager.this.nlsContext, PartitionManager.this.jdbcCharsetId);
                    byArrayArray[i] = datum.shareBytes();
                    map.put(this.keyColumnsMetadataList.get(i).getName(), datum);
                }
            }
            return this.getPartitionId(byArrayArray);
        }

        protected int getPartitionId(byte[][] byArray) {
            int n = Arrays.binarySearch(this.collectionOfKeyColumnValuesOfAllPartitionsInOrder, byArray, this.comparator);
            if (n >= 0) {
                if (n != this.rangePartitionValueSet.length - 1 || !this.rangePartitionValueSet[n].isMaxValue) {
                    ++n;
                }
                if (n >= this.rangePartitionValueSet.length) {
                    throw new RSIException("Partition key not found.");
                }
            } else if ((n = -n - 1) >= this.rangePartitionValueSet.length) {
                throw new RSIException("Partition key not found.");
            }
            return this.rangePartitionValueSet[n].partitionNumber;
        }

        static {
            try {
                $$$methodRef$$$2 = StaticRangePartition.class.getDeclaredConstructor(PartitionManager.class, List.class, Collection.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = StaticRangePartition.class.getDeclaredMethod("getPartitionId", byte[][].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = StaticRangePartition.class.getDeclaredMethod("getPartitionId", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        private class RangePartitionValueSetComparator
        implements Comparator<byte[][]> {
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            private RangePartitionValueSetComparator() {
            }

            @Override
            public int compare(byte[][] byArray, byte[][] byArray2) {
                if (byArray.length != byArray2.length) {
                    throw new RSIException("Length of key columns does not match.");
                }
                int n = byArray.length;
                int n2 = 0;
                for (int i = 0; n2 == 0 && i < n; ++i) {
                    byte[] byArray3 = byArray[i];
                    byte[] byArray4 = byArray2[i];
                    n2 = byArray3.length == 0 ? (byArray4.length == 0 ? 0 : 1) : (byArray4.length == 0 ? -1 : this.compareBytes(byArray3, byArray4));
                }
                return n2;
            }

            private int compareBytes(byte[] byArray, byte[] byArray2) {
                int n = byArray.length;
                int n2 = byArray2.length;
                int n3 = Math.min(n, n2);
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < n3; ++i) {
                    n4 = byArray[i] & 0xFF;
                    n5 = byArray2[i] & 0xFF;
                    if (n4 == n5) continue;
                    if (n4 < n5) {
                        return -1;
                    }
                    return 1;
                }
                if (n == n2) {
                    return 0;
                }
                if (n > n2) {
                    return 1;
                }
                return -1;
            }

            static {
                try {
                    $$$methodRef$$$3 = RangePartitionValueSetComparator.class.getDeclaredConstructor(StaticRangePartition.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = RangePartitionValueSetComparator.class.getDeclaredMethod("compare", Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = RangePartitionValueSetComparator.class.getDeclaredMethod("compareBytes", byte[].class, byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = RangePartitionValueSetComparator.class.getDeclaredMethod("compare", byte[][].class, byte[][].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            }
        }

        protected class RangePartitionValueSet {
            private final int partitionNumber;
            private byte[][] keyColumnValues;
            private boolean isMaxValue = false;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            RangePartitionValueSet(int n, byte[] byArray) {
                this.partitionNumber = n;
                this.parseHiboundVal(byArray);
            }

            private void parseHiboundVal(byte[] byArray) {
                int n = StaticRangePartition.this.keyColumnsMetadataList.size();
                this.keyColumnValues = new byte[n][];
                Iterator<byte[]> iterator = PartitionManager.decodeVariableLengthEncodedList(byArray);
                for (int i = 0; i < n; ++i) {
                    if (!iterator.hasNext()) {
                        throw new RSIException("Hiboundval list length and number of key columns does not match. ");
                    }
                    this.keyColumnValues[i] = iterator.next();
                }
                if (iterator.hasNext()) {
                    throw new RSIException("Hiboundval list length and number of key columns does not match. ");
                }
                if (this.keyColumnValues != null && this.keyColumnValues.length > 0 && this.keyColumnValues[0].length == 0) {
                    this.isMaxValue = true;
                }
            }

            public byte[][] getKeyColumnValues() {
                return this.keyColumnValues;
            }

            static {
                try {
                    $$$methodRef$$$2 = RangePartitionValueSet.class.getDeclaredConstructor(StaticRangePartition.class, Integer.TYPE, byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = RangePartitionValueSet.class.getDeclaredMethod("getKeyColumnValues", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = RangePartitionValueSet.class.getDeclaredMethod("parseHiboundVal", byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            }
        }
    }

    final class ListPartition
    implements PartitionStrategy {
        private final ListPartitionValuesSet[] listPartitionRecords;
        private final int defaultPartitionNum;
        private final List<Metadata.ColumnMetadata> keyColumnsMetadataList;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        ListPartition(List<Metadata.ColumnMetadata> list, Collection<? extends Metadata.TablePartitionInfo> collection) {
            this.keyColumnsMetadataList = list;
            Metadata.TablePartitionInfo[] tablePartitionInfoArray = new Metadata.TablePartitionInfo[]{};
            tablePartitionInfoArray = collection.toArray(tablePartitionInfoArray);
            int n = tablePartitionInfoArray.length;
            this.defaultPartitionNum = tablePartitionInfoArray[n - 1].isDEFAULT() ? tablePartitionInfoArray[--n].getPartitionNum() : -1;
            this.listPartitionRecords = new ListPartitionValuesSet[n];
            for (int i = 0; i < n; ++i) {
                Metadata.TablePartitionInfo tablePartitionInfo = tablePartitionInfoArray[i];
                byte[] byArray = tablePartitionInfo.getbHiboundVal();
                Iterator<byte[]> iterator = PartitionManager.decodeVariableLengthEncodedList(byArray);
                ListPartitionValuesSet listPartitionValuesSet = new ListPartitionValuesSet(tablePartitionInfo.getPartitionNum());
                while (iterator.hasNext()) {
                    byte[] byArray2 = iterator.next();
                    listPartitionValuesSet.add(byArray2);
                }
                this.listPartitionRecords[i] = listPartitionValuesSet;
            }
        }

        @Override
        public int getPartitionId(Object object) {
            Object object2;
            byte[] byArray = null;
            if (object instanceof Object[]) {
                object2 = (Object[])object;
                int n = PartitionManager.this.getIndexOfKeyColumnInSuppliedItem(this.keyColumnsMetadataList.get(0));
                Datum datum = TypeConverter.toDatum(this.keyColumnsMetadataList.get(0), object2[n], PartitionManager.this.nlsContext, PartitionManager.this.jdbcCharsetId);
                byArray = datum.shareBytes();
                object2[n] = datum;
            } else if (object instanceof Map) {
                object2 = (Map)object;
                Datum datum = TypeConverter.toDatum(this.keyColumnsMetadataList.get(0), object2.get(this.keyColumnsMetadataList.get(0).getName()), PartitionManager.this.nlsContext, PartitionManager.this.jdbcCharsetId);
                byArray = datum.shareBytes();
                object2.put(this.keyColumnsMetadataList.get(0).getName(), datum);
            }
            for (ListPartitionValuesSet listPartitionValuesSet : this.listPartitionRecords) {
                if (!listPartitionValuesSet.contains(byArray)) continue;
                return listPartitionValuesSet.partitionNumber;
            }
            if (this.defaultPartitionNum < 0) {
                throw new RSIException("Partition key not found.");
            }
            return this.defaultPartitionNum;
        }

        static {
            try {
                $$$methodRef$$$1 = ListPartition.class.getDeclaredConstructor(PartitionManager.class, List.class, Collection.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = ListPartition.class.getDeclaredMethod("getPartitionId", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        private class ListPartitionValuesSet {
            private final int partitionNumber;
            private final Map<Integer, List<byte[]>> valuesMap = new HashMap<Integer, List<byte[]>>();
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            ListPartitionValuesSet(int n) {
                this.partitionNumber = n;
            }

            void add(byte[] byArray) {
                int n2 = this.getHashCode(byArray);
                List list = this.valuesMap.computeIfAbsent(n2, n -> {
                    LinkedList linkedList = new LinkedList();
                    return linkedList;
                });
                list.add(byArray);
            }

            boolean contains(byte[] byArray) {
                int n = this.getHashCode(byArray);
                List<byte[]> list = this.valuesMap.get(n);
                if (list != null) {
                    for (byte[] byArray2 : list) {
                        int n2;
                        if (byArray2.length != byArray.length) continue;
                        for (n2 = 0; n2 < byArray2.length && byArray2[n2] == byArray[n2]; ++n2) {
                        }
                        if (n2 != byArray2.length) continue;
                        return true;
                    }
                }
                return false;
            }

            private int getHashCode(byte[] byArray) {
                return Arrays.hashCode(byArray);
            }

            static {
                try {
                    $$$methodRef$$$4 = ListPartitionValuesSet.class.getDeclaredConstructor(ListPartition.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$3 = ListPartitionValuesSet.class.getDeclaredMethod("lambda$add$0", Integer.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = ListPartitionValuesSet.class.getDeclaredMethod("getHashCode", byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = ListPartitionValuesSet.class.getDeclaredMethod("contains", byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = ListPartitionValuesSet.class.getDeclaredMethod("add", byte[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            }
        }
    }

    private final class HashPartition
    implements PartitionStrategy {
        private final int[] partitionNumbers;
        private final long hashMask;
        private long FOUR_BYTE_MASK = 0xFFFFFFFFL;
        private long KPNMAXVAL;
        private long KPNINV = this.KPNMAXVAL = 0x100000L;
        private long KGG_HASS_NULL00 = this.kgghash(null, 0, 0L);
        private static final int GOLDEN_RATIO = -1640531527;
        private static final int ONE_BYTE_MASK = 255;
        private final List<Metadata.ColumnMetadata> keyColumnsMetadataList;
        private static final long TWO_TO_32 = 0x100000000L;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;

        HashPartition(List<Metadata.ColumnMetadata> list, Collection<? extends Metadata.TablePartitionInfo> collection) {
            this(list, collection.size());
            int n = 0;
            for (Metadata.TablePartitionInfo tablePartitionInfo : collection) {
                this.partitionNumbers[n++] = tablePartitionInfo.getPartitionNum();
            }
        }

        HashPartition(List<Metadata.ColumnMetadata> list, int n) {
            this.keyColumnsMetadataList = list;
            this.partitionNumbers = new int[n];
            for (int i = 0; i < n; ++i) {
                this.partitionNumbers[i] = i + 1;
            }
            this.hashMask = this.getHashValMask(n);
        }

        @Override
        public int getPartitionId(Object object) {
            int n;
            byte[][] byArrayArray = new byte[this.keyColumnsMetadataList.size()][];
            for (n = 0; n < this.keyColumnsMetadataList.size(); ++n) {
                Object object2;
                byte[] byArray = null;
                if (object instanceof Object[]) {
                    object2 = (Object[])object;
                    int n2 = PartitionManager.this.getIndexOfKeyColumnInSuppliedItem(this.keyColumnsMetadataList.get(n));
                    Datum datum = TypeConverter.toDatum(this.keyColumnsMetadataList.get(n), object2[n2], PartitionManager.this.nlsContext, PartitionManager.this.jdbcCharsetId);
                    byArray = datum.shareBytes();
                    object2[n2] = datum;
                } else if (object instanceof Map) {
                    object2 = (Map)object;
                    Datum datum = TypeConverter.toDatum(this.keyColumnsMetadataList.get(n), object2.get(this.keyColumnsMetadataList.get(n).getName()), PartitionManager.this.nlsContext, PartitionManager.this.jdbcCharsetId);
                    object2.put(this.keyColumnsMetadataList.get(n).getName(), datum);
                    byArray = datum.shareBytes();
                }
                byArrayArray[n] = byArray;
            }
            n = (int)this.kkpamHRGet(this.hashMask, this.partitionNumbers.length, byArrayArray, this.keyColumnsMetadataList, PartitionManager.this.nlsContext);
            PartitionManager.this.validate(n, "Partition");
            return this.partitionNumbers[n];
        }

        private long getHashValMask(long l) {
            long l2;
            long l3 = l - 1L;
            long l4 = l2 = l < this.KPNINV ? 0L : (this.KPNINV - 1L << 1) + 1L;
            while (l2 < l3) {
                l2 = (l2 << 1) + 1L;
            }
            return l2;
        }

        private long kkpamHVal(long l, byte[] byArray, boolean bl, boolean bl2, boolean bl3, Metadata.NLSContext nLSContext) {
            int n;
            int n2 = n = null == byArray ? 0 : byArray.length;
            if (bl) {
                return l + this.KGG_HASS_NULL00;
            }
            if (!bl2) {
                return l + this.kgghash(byArray, n, 0L);
            }
            int n3 = nLSContext.getNumBytesOfPadding(byArray, bl3 ? 2 : 1);
            int n4 = byArray.length - n3;
            return l + this.kgghash(byArray, n4, 0L);
        }

        private long kkpamHv2f(long l, int n, long l2) {
            long l3 = l2 & l;
            long l4 = l3 < (long)n ? l3 : l3 & l >> 1;
            return l4;
        }

        private long kkpamHRGet(long l, int n, byte[][] byArray, List<Metadata.ColumnMetadata> list, Metadata.NLSContext nLSContext) {
            int n2 = byArray.length;
            int n3 = 0;
            long l2 = 0L;
            for (int i = 0; i < n2; ++i) {
                Metadata.ColumnMetadata columnMetadata;
                boolean bl;
                byte[] byArray2 = byArray[i];
                n3 = null == byArray2 ? 0 : byArray2.length;
                boolean bl2 = bl = n3 == 0;
                if (0 == n3) {
                    byArray2 = null;
                }
                boolean bl3 = (columnMetadata = list.get(i)).getCharsetForm() == 2;
                boolean bl4 = columnMetadata.getSQLType().getVendorTypeNumber() == 1;
                l2 = this.kkpamHVal(l2, byArray2, bl, bl4, bl3, nLSContext);
            }
            return this.kkpamHv2f(l, n, l2);
        }

        private long kgghash(byte[] byArray, int n, long l) {
            int n2;
            int n3 = 0;
            int n4 = -1640531527;
            int n5 = -1640531527;
            int n6 = -1640531527;
            int n7 = this.getUnsignedIntAsInt(l);
            for (n2 = n; n2 >= 16; n2 -= 16) {
                n6 += this.pack4ConsecutiveBytes(byArray, n3);
                n5 += this.pack4ConsecutiveBytes(byArray, n3 += 4);
                n4 += this.pack4ConsecutiveBytes(byArray, n3 += 4);
                n3 += 4;
                n6 += (n7 += this.pack4ConsecutiveBytes(byArray, n3 += 4));
                n7 += n6;
                n6 ^= n6 >>> 7;
                n5 += n6;
                n6 += n5;
                n5 ^= n5 << 13;
                n4 += n5;
                n5 += n4;
                n4 ^= n4 >>> 17;
                n7 += n4;
                n4 += n7;
                n7 ^= n7 << 9;
                n6 += n7;
                n7 += n6;
                n6 ^= n6 >>> 3;
                n5 += n6;
                n6 += n5;
                n5 ^= n5 << 7;
                n4 += n5;
                n5 += n4;
                n4 ^= n4 >>> 15;
                n7 += n4;
                n4 += n7;
                n7 ^= n7 << 11;
            }
            n7 += n;
            switch (n2) {
                case 15: {
                    n7 += this.getMaskedByte(byArray, n3 + 14) << 24;
                }
                case 14: {
                    n7 += this.getMaskedByte(byArray, n3 + 13) << 16;
                }
                case 13: {
                    n7 += this.getMaskedByte(byArray, n3 + 12) << 8;
                }
                case 12: {
                    n4 += this.getMaskedByte(byArray, n3 + 11) << 24;
                }
                case 11: {
                    n4 += this.getMaskedByte(byArray, n3 + 10) << 16;
                }
                case 10: {
                    n4 += this.getMaskedByte(byArray, n3 + 9) << 8;
                }
                case 9: {
                    n4 += this.getMaskedByte(byArray, n3 + 8);
                }
                case 8: {
                    n5 += this.getMaskedByte(byArray, n3 + 7) << 24;
                }
                case 7: {
                    n5 += this.getMaskedByte(byArray, n3 + 6) << 16;
                }
                case 6: {
                    n5 += this.getMaskedByte(byArray, n3 + 5) << 8;
                }
                case 5: {
                    n5 += this.getMaskedByte(byArray, n3 + 4);
                }
                case 4: {
                    n6 += this.getMaskedByte(byArray, n3 + 3) << 24;
                }
                case 3: {
                    n6 += this.getMaskedByte(byArray, n3 + 2) << 16;
                }
                case 2: {
                    n6 += this.getMaskedByte(byArray, n3 + 1) << 8;
                }
                case 1: {
                    n6 += this.getMaskedByte(byArray, n3);
                }
            }
            n6 += n7;
            n7 += n6;
            n6 ^= n6 >>> 7;
            n5 += n6;
            n6 += n5;
            n5 ^= n5 << 13;
            n4 += n5;
            n5 += n4;
            n4 ^= n4 >>> 17;
            n7 += n4;
            n4 += n7;
            n7 ^= n7 << 9;
            n6 += n7;
            n7 += n6;
            n6 ^= n6 >>> 3;
            n5 += n6;
            n6 += n5;
            n5 ^= n5 << 7;
            n4 += n5;
            n5 += n4;
            n4 ^= n4 >>> 15;
            n7 += n4;
            n4 += n7;
            n7 ^= n7 << 11;
            return this.getUnsignedIntAsLong(n7);
        }

        private int getMaskedByte(byte[] byArray, int n) {
            return byArray[n] & 0xFF;
        }

        private int pack4ConsecutiveBytes(byte[] byArray, int n) {
            return this.getMaskedByte(byArray, n) + (this.getMaskedByte(byArray, n + 1) << 8) + (this.getMaskedByte(byArray, n + 2) << 16) + (this.getMaskedByte(byArray, n + 3) << 24);
        }

        private long getUnsignedIntAsLong(int n) {
            return 0x100000000L + (long)n & this.FOUR_BYTE_MASK;
        }

        private int getUnsignedIntAsInt(long l) {
            int n = (int)(l & this.FOUR_BYTE_MASK);
            return n;
        }

        static {
            try {
                $$$methodRef$$$11 = HashPartition.class.getDeclaredConstructor(PartitionManager.class, List.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = HashPartition.class.getDeclaredConstructor(PartitionManager.class, List.class, Collection.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = HashPartition.class.getDeclaredMethod("getUnsignedIntAsInt", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = HashPartition.class.getDeclaredMethod("getUnsignedIntAsLong", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = HashPartition.class.getDeclaredMethod("pack4ConsecutiveBytes", byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = HashPartition.class.getDeclaredMethod("getMaskedByte", byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = HashPartition.class.getDeclaredMethod("kgghash", byte[].class, Integer.TYPE, Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = HashPartition.class.getDeclaredMethod("kkpamHRGet", Long.TYPE, Integer.TYPE, byte[][].class, List.class, Metadata.NLSContext.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = HashPartition.class.getDeclaredMethod("kkpamHv2f", Long.TYPE, Integer.TYPE, Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = HashPartition.class.getDeclaredMethod("kkpamHVal", Long.TYPE, byte[].class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Metadata.NLSContext.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = HashPartition.class.getDeclaredMethod("getHashValMask", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = HashPartition.class.getDeclaredMethod("getPartitionId", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    }

    private final class ConstantPartitionStrategy
    implements PartitionStrategy {
        final int partId;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        public ConstantPartitionStrategy(int n) {
            this.partId = n;
        }

        @Override
        public int getPartitionId(Object object) {
            return this.partId;
        }

        static {
            try {
                $$$methodRef$$$1 = ConstantPartitionStrategy.class.getDeclaredConstructor(PartitionManager.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = ConstantPartitionStrategy.class.getDeclaredMethod("getPartitionId", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    }

    private static interface PartitionStrategy {
        public int getPartitionId(Object var1);
    }

    private static class PartitionFragOffsetRecord {
        final int partNum;
        final int fragNumOffset;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        public PartitionFragOffsetRecord(int n, int n2) {
            this.partNum = n;
            this.fragNumOffset = n2;
        }

        static {
            try {
                $$$methodRef$$$0 = PartitionFragOffsetRecord.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    }

    private static class VarLenDecoderIterator
    implements Iterator<byte[]> {
        private static final int KKPAMKEYLMAX = 4096;
        private static final int KDKLBLEN = 128;
        private static final int KDKLRSRV = 251;
        private static final int ONE_BYTE_MASK = 255;
        private final ByteBuffer buffer;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        VarLenDecoderIterator(byte[] byArray) {
            this(ByteBuffer.wrap(byArray));
        }

        VarLenDecoderIterator(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        private int getNextUnignedByte() {
            byte by = this.buffer.get();
            return 256 + by & 0xFF;
        }

        private int parseNextLength() {
            int n = this.getNextUnignedByte();
            if (n < 128) {
                return n;
            }
            if (n < 251) {
                int n2 = this.getNextUnignedByte();
                int n3 = (n - 128 << 8) + n2;
                if (n3 > 4096) {
                    throw new IllegalStateException("Token length exceeds 4096");
                }
                return n3;
            }
            return 0;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Call to next() after !hasNext()");
            }
            int n = this.parseNextLength();
            if (n != 0) {
                byte[] byArray = new byte[n];
                this.buffer.get(byArray);
                return byArray;
            }
            return new byte[0];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static {
            try {
                $$$methodRef$$$7 = VarLenDecoderIterator.class.getDeclaredConstructor(ByteBuffer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = VarLenDecoderIterator.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = VarLenDecoderIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = VarLenDecoderIterator.class.getDeclaredMethod("remove", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = VarLenDecoderIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = VarLenDecoderIterator.class.getDeclaredMethod("hasNext", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = VarLenDecoderIterator.class.getDeclaredMethod("parseNextLength", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = VarLenDecoderIterator.class.getDeclaredMethod("getNextUnignedByte", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    }
}

