/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.OracleType;
import oracle.rsi.RSIException;
import oracle.rsi.internal.HandlerDelegator;
import oracle.rsi.internal.Metadata;
import oracle.rsi.internal.MetadataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class MetadataImpl
extends MetadataHandler
implements Metadata {
    private TableImpl tableMeta = null;
    private StreamTable dpStreamTab = null;
    private DBProperties dbproperties = null;
    private Properties dbprops = null;
    private Metadata.NLSContext nlsContext = null;
    public static final String DBMETA_SQL = "resources/dbmeta.sql";
    private static String METADATA_SQL;
    public static final String INVALID_PATTERN = "invalid table name";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    public MetadataImpl(Connection connection, String string, String string2) throws Metadata.DBMetadataException {
        try {
            if (null == string || null == string2 || 0 == string.length() || 0 == string2.length()) {
                throw new Metadata.DBMetadataException(Metadata.DBMetadataException.CODE.GENERIC, "Invalid table name");
            }
            this.createSAXParser();
            Reader reader = MetadataImpl.fetchMetadata(connection, string, string2, false);
            this.parse(reader);
        }
        catch (IOException iOException) {
            throw new Metadata.DBMetadataException(Metadata.DBMetadataException.CODE.IO_ERROR, "Unable to open the meta sql", iOException);
        }
        catch (SQLException sQLException) {
            String string3 = MetadataImpl.enquoteDouble(string) + "." + MetadataImpl.enquoteDouble(string2);
            throw new Metadata.DBMetadataException(Metadata.DBMetadataException.CODE.IO_ERROR, "Failed to get the metadata for the table : " + string3, sQLException);
        }
    }

    public MetadataImpl(Reader reader) throws Metadata.DBMetadataException {
        if (null == reader) {
            throw new Metadata.DBMetadataException(Metadata.DBMetadataException.CODE.IO_ERROR, "Unable to parse the metadata [Reader is null]");
        }
        this.createSAXParser();
        this.parse(reader);
    }

    private void parse(Reader reader) throws Metadata.DBMetadataException {
        try {
            this.setHandler(this);
            this.parse(new InputSource(reader));
        }
        catch (SAXException sAXException) {
            throw new Metadata.DBMetadataException(Metadata.DBMetadataException.CODE.PARSE_ERROR, "Unable to parse the metadata", sAXException);
        }
        catch (IOException iOException) {
            throw new Metadata.DBMetadataException(Metadata.DBMetadataException.CODE.IO_ERROR, "Unable to parse the metadata", iOException);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public TableImpl getTable() {
        return this.tableMeta;
    }

    @Override
    public Metadata.NLSContext getNLSContext() {
        return this.nlsContext;
    }

    public Properties getDBProps() {
        return (Properties)this.dbprops.clone();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        switch (ROOT_CHILD_ELEMENTS.getName(string3)) {
            case DATABASE: {
                if (!this.parents.empty()) break;
                this.parents.push(string3);
                break;
            }
            case ROWSET: {
                if (this.parents.empty() || ROOT_CHILD_ELEMENTS.getName((String)this.parents.peek()) != ROOT_CHILD_ELEMENTS.DATABASE) break;
                this.parents.push(string3);
                break;
            }
            case ROW: {
                if (this.parents.empty() || ROOT_CHILD_ELEMENTS.getName((String)this.parents.peek()) != ROOT_CHILD_ELEMENTS.ROWSET) break;
                this.parents.push(string3);
                break;
            }
            case TABLE_T: {
                if (this.parents.empty() || ROOT_CHILD_ELEMENTS.getName((String)this.parents.peek()) != ROOT_CHILD_ELEMENTS.ROW) break;
                this.tableMeta = new TableImpl(this, string3, this.delegator);
                this.setHandler(this.tableMeta);
                break;
            }
            case DB_PROPERTIES: {
                if (this.parents.empty() || ROOT_CHILD_ELEMENTS.getName((String)this.parents.peek()) != ROOT_CHILD_ELEMENTS.DATABASE) break;
                this.dbproperties = new DBProperties(this, string3, this.delegator);
                this.setHandler(this.dbproperties);
                break;
            }
            case STRMTABLE_T: {
                if (this.parents.empty() || ROOT_CHILD_ELEMENTS.getName((String)this.parents.peek()) != ROOT_CHILD_ELEMENTS.DATABASE) break;
                this.dpStreamTab = new StreamTable(this, string3, this.delegator);
                this.setHandler(this.dpStreamTab);
                break;
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (!this.parents.empty() && ROOT_CHILD_ELEMENTS.getName((String)this.parents.peek()) == ROOT_CHILD_ELEMENTS.getName(string3)) {
            switch (ROOT_CHILD_ELEMENTS.getName(string3)) {
                case ROW: {
                    this.parents.pop();
                    break;
                }
                case ROWSET: {
                    this.parents.pop();
                    break;
                }
                case DATABASE: {
                    this.parents.pop();
                    this.nlsContext = new Metadata.NLSContext(this.dbproperties.getProperties());
                    this.dbprops = new Properties();
                    for (Map.Entry<String, String> entry : this.dbproperties.getProperties().entrySet()) {
                        this.dbprops.setProperty(entry.getKey(), entry.getValue());
                    }
                    this.dbproperties = null;
                    break;
                }
            }
        }
    }

    public static InputStream getResource(String string) {
        ClassLoader classLoader = MetadataImpl.class.getClassLoader();
        InputStream inputStream = AccessController.doPrivileged(() -> classLoader.getResourceAsStream(string));
        return inputStream;
    }

    private static String getMetadataSQL() throws IOException {
        if (METADATA_SQL != null) {
            return METADATA_SQL;
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = MetadataImpl.newBufferedReader(MetadataImpl.newInputStreamReader(MetadataImpl.getResource(DBMETA_SQL)));
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuilder.append(string);
                string = bufferedReader.readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                MetadataImpl.close(bufferedReader);
            }
        }
        METADATA_SQL = stringBuilder.toString();
        return METADATA_SQL;
    }

    static Reader fetchMetadata(Connection connection, String string, String string2, boolean bl) throws IOException, SQLException {
        return new BufferedReader(MetadataImpl.fetchMetadataClob(connection, string, string2, bl).getCharacterStream());
    }

    public static Clob fetchMetadataClob(Connection connection, String string, String string2, boolean bl) throws IOException, SQLException {
        try (CallableStatement callableStatement = connection.prepareCall(MetadataImpl.getMetadataSQL());){
            if (string == null) {
                callableStatement.setNull(1, 12);
            } else {
                callableStatement.setString(1, string);
            }
            callableStatement.setString(2, string2);
            callableStatement.setString(3, "<!--  -->");
            callableStatement.setInt(4, bl ? 1 : 0);
            callableStatement.registerOutParameter(5, 2005);
            callableStatement.execute();
            Clob clob = callableStatement.getClob(5);
            return clob;
        }
    }

    public static String enquote(String string, char c) {
        if (string == null) {
            return string;
        }
        return c + string + c;
    }

    public static String enquoteDouble(String string) {
        return MetadataImpl.enquote(string, '\"');
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStreamReader newInputStreamReader(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            InputStreamReader inputStreamReader2 = inputStreamReader = new InputStreamReader(inputStream);
            return inputStreamReader2;
        }
        finally {
            if (null == inputStreamReader) {
                MetadataImpl.close(inputStream);
            }
        }
    }

    public static BufferedReader newBufferedReader(Reader reader) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            BufferedReader bufferedReader2 = bufferedReader = new BufferedReader(reader);
            return bufferedReader2;
        }
        finally {
            if (null == bufferedReader) {
                MetadataImpl.close(reader);
            }
        }
    }

    public static BufferedWriter newBufferedWriter(Writer writer) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            BufferedWriter bufferedWriter2 = bufferedWriter = new BufferedWriter(writer);
            return bufferedWriter2;
        }
        finally {
            if (null == bufferedWriter) {
                MetadataImpl.close(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStreamWriter newOutputStreamWriter(OutputStream outputStream, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            OutputStreamWriter outputStreamWriter2 = outputStreamWriter = new OutputStreamWriter(outputStream, string);
            return outputStreamWriter2;
        }
        finally {
            if (null == outputStreamWriter) {
                MetadataImpl.close(outputStream);
            }
        }
    }

    public static byte[] hexStringToByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = i * 2;
            int n2 = Integer.parseInt(string.substring(n, n + 2), 16);
            byArray[i] = (byte)n2;
        }
        return byArray;
    }

    static {
        try {
            $$$methodRef$$$21 = MetadataImpl.class.getDeclaredConstructor(Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$20 = MetadataImpl.class.getDeclaredConstructor(Connection.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$19 = MetadataImpl.class.getDeclaredMethod("lambda$getResource$0", ClassLoader.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$18 = MetadataImpl.class.getDeclaredMethod("getTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$17 = MetadataImpl.class.getDeclaredMethod("hexStringToByteArray", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$16 = MetadataImpl.class.getDeclaredMethod("newOutputStreamWriter", OutputStream.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$15 = MetadataImpl.class.getDeclaredMethod("newBufferedWriter", Writer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$14 = MetadataImpl.class.getDeclaredMethod("newBufferedReader", Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$13 = MetadataImpl.class.getDeclaredMethod("newInputStreamReader", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$12 = MetadataImpl.class.getDeclaredMethod("close", Closeable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$11 = MetadataImpl.class.getDeclaredMethod("enquoteDouble", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$10 = MetadataImpl.class.getDeclaredMethod("enquote", String.class, Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$9 = MetadataImpl.class.getDeclaredMethod("fetchMetadataClob", Connection.class, String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$8 = MetadataImpl.class.getDeclaredMethod("fetchMetadata", Connection.class, String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$7 = MetadataImpl.class.getDeclaredMethod("getMetadataSQL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$6 = MetadataImpl.class.getDeclaredMethod("getResource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$5 = MetadataImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = MetadataImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = MetadataImpl.class.getDeclaredMethod("getDBProps", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = MetadataImpl.class.getDeclaredMethod("getNLSContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = MetadataImpl.class.getDeclaredMethod("getTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = MetadataImpl.class.getDeclaredMethod("parse", Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        METADATA_SQL = null;
    }

    private static class DBProperties
    extends MetadataHandler {
        private final Map<String, String> props = new HashMap<String, String>();
        private String propName = null;
        private String propValue = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        DBProperties(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            switch (CHILD_ELEMENTS.getName(string3)) {
                case DB_PROPERTY: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.DB_PROPERTIES) break;
                    this.parents.push(string3);
                    break;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.DB_PROPERTY) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case PROPERTY_NAME: {
                        this.propName = this.contents.toString();
                        break;
                    }
                    case PROPERTY_VALUE: {
                        this.propValue = this.contents.toString();
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case DB_PROPERTY: {
                        this.props.put(this.propName, this.propValue);
                        this.propName = null;
                        this.propValue = null;
                        this.parents.pop();
                        break;
                    }
                    case DB_PROPERTIES: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        Map<String, String> getProperties() {
            return this.props;
        }

        static {
            try {
                $$$methodRef$$$3 = DBProperties.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = DBProperties.class.getDeclaredMethod("getProperties", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = DBProperties.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = DBProperties.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        private static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS DB_PROPERTY;
            public static final /* enum */ CHILD_ELEMENTS DB_PROPERTIES;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                DB_PROPERTY = new CHILD_ELEMENTS();
                DB_PROPERTIES = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{DB_PROPERTY, DB_PROPERTIES, NOVALUE};
            }
        }

        private static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS PROPERTY_NAME;
            public static final /* enum */ LEAF_ELEMENTS PROPERTY_VALUE;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                PROPERTY_NAME = new LEAF_ELEMENTS();
                PROPERTY_VALUE = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{PROPERTY_NAME, PROPERTY_VALUE, NOVALUE};
            }
        }
    }

    private static class TemplateSubPartitionImpl
    extends MetadataHandler
    implements Metadata.TablePartitionInfo,
    Metadata.TemplateSubPartition {
        boolean seenBaseObjnum = false;
        boolean seenSpartPos = false;
        boolean seenSpartName = false;
        boolean seenFlags = false;
        boolean seenHiboundlen = false;
        boolean seenHiboundval = false;
        boolean seenBhiboundval = false;
        private int baseObjNum = 0;
        private int subPartitionPosition = 0;
        private String subPartitionName = null;
        private int flags = 0;
        private int highBoundLength = 0;
        private String highBoundValue = null;
        private byte[] binaryHighBoundValue = null;
        private Collection<Metadata.LobTemplateSubpartition> templateLobs = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;

        TemplateSubPartitionImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        void setbHiboundVal(byte[] byArray) {
            this.binaryHighBoundValue = byArray;
        }

        @Override
        public int getBaseObjnum() {
            return this.baseObjNum;
        }

        @Override
        public int getSpartPos() {
            return this.subPartitionPosition;
        }

        @Override
        public String getSpartName() {
            return this.subPartitionName;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public int getHiboundLen() {
            return this.highBoundLength;
        }

        @Override
        public String getHiboundVal() {
            return this.highBoundValue;
        }

        @Override
        public byte[] getbHiboundVal() {
            return this.binaryHighBoundValue;
        }

        @Override
        public int getPartitionNum() {
            return this.getSpartPos() + 1;
        }

        @Override
        public boolean isDEFAULT() {
            return "DEFAULT".compareTo(this.highBoundValue) == 0 || (this.getFlags() & 0x4000) != 0;
        }

        @Override
        public boolean isPartitionStaticallyDefined() {
            return true;
        }

        @Override
        public Collection<Metadata.LobTemplateSubpartition> getTemplateLobs() {
            return this.templateLobs;
        }

        private CHILD_ELEMENTS getTopofStack() {
            return this.parents.isEmpty() ? null : CHILD_ELEMENTS.getName((String)this.parents.peek());
        }

        private boolean isParentTSubpartsItem() {
            return this.getTopofStack() == CHILD_ELEMENTS.TSUBPARTS_ITEM;
        }

        private boolean isParentTLobs() {
            return this.getTopofStack() == CHILD_ELEMENTS.TLOBS;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            switch (CHILD_ELEMENTS.getName(string3)) {
                case TLOBS: {
                    if (!this.isParentTSubpartsItem()) break;
                    this.parents.push(string3);
                    break;
                }
                case TLOBS_ITEM: {
                    if (!this.isParentTLobs()) break;
                    if (null == this.templateLobs) {
                        this.templateLobs = new ArrayList<Metadata.LobTemplateSubpartition>();
                    }
                    LobTemplateSubpartitionImpl lobTemplateSubpartitionImpl = new LobTemplateSubpartitionImpl(this, string3, this.delegator);
                    this.templateLobs.add(lobTemplateSubpartitionImpl);
                    this.setHandler(lobTemplateSubpartitionImpl);
                    break;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.isParentTSubpartsItem()) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case BASE_OBJNUM: {
                        this.seenBaseObjnum = true;
                        this.baseObjNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPART_POS: {
                        this.seenSpartPos = true;
                        this.subPartitionPosition = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPART_NAME: {
                        this.seenSpartName = true;
                        this.subPartitionName = this.contents.toString();
                        break;
                    }
                    case FLAGS: {
                        this.seenFlags = true;
                        this.flags = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case HIBOUNDLEN: {
                        this.seenHiboundlen = true;
                        this.highBoundLength = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case HIBOUNDVAL: {
                        this.seenHiboundval = true;
                        this.highBoundValue = this.contents.toString();
                        break;
                    }
                    case BHIBOUNDVAL: {
                        this.seenBhiboundval = true;
                        this.binaryHighBoundValue = MetadataImpl.hexStringToByteArray(this.contents.toString());
                        break;
                    }
                }
            }
            if (this.getTopofStack() == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case TLOBS: {
                        this.parents.pop();
                        break;
                    }
                    case TLOBS_ITEM: 
                    case TSUBPARTS_ITEM: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        boolean isValid() {
            return this.seenBaseObjnum && this.seenSpartPos && this.seenSpartName && this.seenFlags && this.seenHiboundlen && this.seenHiboundval && this.seenBhiboundval;
        }

        static {
            try {
                $$$methodRef$$$18 = TemplateSubPartitionImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = TemplateSubPartitionImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = TemplateSubPartitionImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = TemplateSubPartitionImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = TemplateSubPartitionImpl.class.getDeclaredMethod("isParentTLobs", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = TemplateSubPartitionImpl.class.getDeclaredMethod("isParentTSubpartsItem", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = TemplateSubPartitionImpl.class.getDeclaredMethod("getTopofStack", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = TemplateSubPartitionImpl.class.getDeclaredMethod("getTemplateLobs", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = TemplateSubPartitionImpl.class.getDeclaredMethod("isPartitionStaticallyDefined", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = TemplateSubPartitionImpl.class.getDeclaredMethod("isDEFAULT", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = TemplateSubPartitionImpl.class.getDeclaredMethod("getPartitionNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = TemplateSubPartitionImpl.class.getDeclaredMethod("getbHiboundVal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = TemplateSubPartitionImpl.class.getDeclaredMethod("getHiboundVal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = TemplateSubPartitionImpl.class.getDeclaredMethod("getHiboundLen", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = TemplateSubPartitionImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = TemplateSubPartitionImpl.class.getDeclaredMethod("getSpartName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = TemplateSubPartitionImpl.class.getDeclaredMethod("getSpartPos", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = TemplateSubPartitionImpl.class.getDeclaredMethod("getBaseObjnum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = TemplateSubPartitionImpl.class.getDeclaredMethod("setbHiboundVal", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS TLOBS;
            public static final /* enum */ CHILD_ELEMENTS TLOBS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS TSUBPARTS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                TLOBS = new CHILD_ELEMENTS();
                TLOBS_ITEM = new CHILD_ELEMENTS();
                TSUBPARTS_ITEM = new CHILD_ELEMENTS();
                TAG_NOTPARSED = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{TLOBS, TLOBS_ITEM, TSUBPARTS_ITEM, TAG_NOTPARSED};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS BASE_OBJNUM;
            public static final /* enum */ LEAF_ELEMENTS SPART_POS;
            public static final /* enum */ LEAF_ELEMENTS SPART_NAME;
            public static final /* enum */ LEAF_ELEMENTS FLAGS;
            public static final /* enum */ LEAF_ELEMENTS HIBOUNDLEN;
            public static final /* enum */ LEAF_ELEMENTS HIBOUNDVAL;
            public static final /* enum */ LEAF_ELEMENTS BHIBOUNDVAL;
            public static final /* enum */ LEAF_ELEMENTS NULL;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NULL;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                BASE_OBJNUM = new LEAF_ELEMENTS();
                SPART_POS = new LEAF_ELEMENTS();
                SPART_NAME = new LEAF_ELEMENTS();
                FLAGS = new LEAF_ELEMENTS();
                HIBOUNDLEN = new LEAF_ELEMENTS();
                HIBOUNDVAL = new LEAF_ELEMENTS();
                BHIBOUNDVAL = new LEAF_ELEMENTS();
                NULL = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{BASE_OBJNUM, SPART_POS, SPART_NAME, FLAGS, HIBOUNDLEN, HIBOUNDVAL, BHIBOUNDVAL, NULL};
            }
        }
    }

    private static class TableSubPartitionImpl
    extends MetadataHandler
    implements Metadata.TablePartitionInfo,
    Metadata.TableSubPartition {
        private boolean seenSubpartnum = false;
        private boolean seenHiboundLen = false;
        private boolean seenHiboundVal = false;
        private SchemaImpl schemaObj = null;
        private int blockSize = 0;
        private StorageImpl storage = null;
        private DeferredStorageImpl deferredStorage = null;
        private int subPartNum = 0;
        private int highBoundLength = 0;
        private String highBoundValue = null;
        private byte[] binaryHighBoundValue = null;
        private int flags = 0;
        private int pctFree = 0;
        private Collection<Metadata.Lob> lobs = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;

        TableSubPartitionImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        private CHILD_ELEMENTS getTopofStack() {
            return this.parents.isEmpty() ? null : CHILD_ELEMENTS.getName((String)this.parents.peek());
        }

        @Override
        public boolean isParentSubpartsItem() {
            return this.getTopofStack() == CHILD_ELEMENTS.SUBPARTS_ITEM;
        }

        @Override
        public boolean isParentLobs() {
            return this.getTopofStack() == CHILD_ELEMENTS.LOBS;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            switch (CHILD_ELEMENTS.getName(string3)) {
                case SCHEMA_OBJ: {
                    if (null != this.schemaObj || !this.isParentSubpartsItem()) break;
                    this.schemaObj = new SchemaImpl(this, string3, this.delegator);
                    this.setHandler(this.schemaObj);
                    break;
                }
                case STORAGE: {
                    if (null != this.storage || !this.isParentSubpartsItem()) break;
                    this.storage = new StorageImpl(this, string3, this.delegator);
                    this.setHandler(this.storage);
                    break;
                }
                case DEFERRED_STG: {
                    if (null != this.deferredStorage || !this.isParentSubpartsItem()) break;
                    this.deferredStorage = new DeferredStorageImpl(this, string3, this.delegator);
                    this.setHandler(this.deferredStorage);
                    break;
                }
                case LOBS: {
                    if (!this.isParentSubpartsItem()) break;
                    this.parents.push(string3);
                    break;
                }
                case LOBS_ITEM: {
                    if (!this.isParentLobs()) break;
                    if (null == this.lobs) {
                        this.lobs = new ArrayList<Metadata.Lob>();
                    }
                    LobImpl lobImpl = new LobImpl(this, string3, this.delegator);
                    this.lobs.add(lobImpl);
                    this.setHandler(lobImpl);
                    break;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.isParentSubpartsItem()) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case BLOCKSIZE: {
                        this.blockSize = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SUBPART_NUM: {
                        this.seenSubpartnum = true;
                        this.subPartNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case HIBOUNDLEN: {
                        this.seenHiboundLen = true;
                        this.highBoundLength = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case HIBOUNDVAL: {
                        this.seenHiboundVal = true;
                        this.highBoundValue = this.contents.toString();
                        break;
                    }
                    case BHIBOUNDVAL: {
                        this.binaryHighBoundValue = MetadataImpl.hexStringToByteArray(this.contents.toString());
                        break;
                    }
                    case FLAGS: {
                        this.flags = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PCT_FREE: {
                        this.pctFree = Integer.parseInt(this.contents.toString());
                        break;
                    }
                }
            }
            if (this.getTopofStack() == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case DEFERRED_STG: 
                    case LOBS: {
                        this.parents.pop();
                        break;
                    }
                    case SUBPARTS_ITEM: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        void setbHiboundVal(byte[] byArray) {
            this.binaryHighBoundValue = byArray;
        }

        void setSubpartNum(int n) {
            this.subPartNum = n;
        }

        @Override
        public int getObjNum() {
            return this.getSchema().getObjNum();
        }

        @Override
        public SchemaImpl getSchema() {
            return this.schemaObj;
        }

        @Override
        public int getBlockSize() {
            return this.blockSize;
        }

        @Override
        public StorageImpl getStorage() {
            return this.storage;
        }

        @Override
        public Metadata.DeferredStorage getDeferredStorage() {
            return this.deferredStorage;
        }

        @Override
        public int getSubpartNum() {
            return this.subPartNum;
        }

        @Override
        public int getPartitionNum() {
            return this.getSubpartNum();
        }

        @Override
        public String getName() {
            return this.getSchema().getSubName();
        }

        @Override
        public int getHiboundLen() {
            return this.highBoundLength;
        }

        @Override
        public String getHiboundVal() {
            return this.highBoundValue;
        }

        @Override
        @Deprecated
        public String[] getHiboundVals() {
            return this.highBoundValue.split(",");
        }

        @Override
        public byte[] getbHiboundVal() {
            return this.binaryHighBoundValue;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public int getPctfree() {
            return this.pctFree;
        }

        @Override
        public Collection<Metadata.Lob> getLobs() {
            return this.lobs;
        }

        @Override
        public boolean isDEFAULT() {
            return (this.getFlags() & 0x4000) != 0;
        }

        @Override
        public boolean isPartitionStaticallyDefined() {
            return true;
        }

        boolean isValid() {
            return this.getSchema() != null && this.getSchema().isValid() && this.seenSubpartnum && this.seenHiboundLen && this.seenHiboundVal;
        }

        static {
            try {
                $$$methodRef$$$27 = TableSubPartitionImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$26 = TableSubPartitionImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$25 = TableSubPartitionImpl.class.getDeclaredMethod("getStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$24 = TableSubPartitionImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$23 = TableSubPartitionImpl.class.getDeclaredMethod("isPartitionStaticallyDefined", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$22 = TableSubPartitionImpl.class.getDeclaredMethod("isDEFAULT", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$21 = TableSubPartitionImpl.class.getDeclaredMethod("getLobs", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$20 = TableSubPartitionImpl.class.getDeclaredMethod("getPctfree", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$19 = TableSubPartitionImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$18 = TableSubPartitionImpl.class.getDeclaredMethod("getbHiboundVal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = TableSubPartitionImpl.class.getDeclaredMethod("getHiboundVals", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = TableSubPartitionImpl.class.getDeclaredMethod("getHiboundVal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = TableSubPartitionImpl.class.getDeclaredMethod("getHiboundLen", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = TableSubPartitionImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = TableSubPartitionImpl.class.getDeclaredMethod("getPartitionNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = TableSubPartitionImpl.class.getDeclaredMethod("getSubpartNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = TableSubPartitionImpl.class.getDeclaredMethod("getDeferredStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = TableSubPartitionImpl.class.getDeclaredMethod("getStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = TableSubPartitionImpl.class.getDeclaredMethod("getBlockSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = TableSubPartitionImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = TableSubPartitionImpl.class.getDeclaredMethod("getObjNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = TableSubPartitionImpl.class.getDeclaredMethod("setSubpartNum", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = TableSubPartitionImpl.class.getDeclaredMethod("setbHiboundVal", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = TableSubPartitionImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = TableSubPartitionImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = TableSubPartitionImpl.class.getDeclaredMethod("isParentLobs", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = TableSubPartitionImpl.class.getDeclaredMethod("isParentSubpartsItem", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = TableSubPartitionImpl.class.getDeclaredMethod("getTopofStack", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS SCHEMA_OBJ;
            public static final /* enum */ CHILD_ELEMENTS STORAGE;
            public static final /* enum */ CHILD_ELEMENTS DEFERRED_STG;
            public static final /* enum */ CHILD_ELEMENTS LOBS;
            public static final /* enum */ CHILD_ELEMENTS LOBS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS SUBPARTS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                SCHEMA_OBJ = new CHILD_ELEMENTS();
                STORAGE = new CHILD_ELEMENTS();
                DEFERRED_STG = new CHILD_ELEMENTS();
                LOBS = new CHILD_ELEMENTS();
                LOBS_ITEM = new CHILD_ELEMENTS();
                SUBPARTS_ITEM = new CHILD_ELEMENTS();
                TAG_NOTPARSED = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{SCHEMA_OBJ, STORAGE, DEFERRED_STG, LOBS, LOBS_ITEM, SUBPARTS_ITEM, TAG_NOTPARSED};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS BLOCKSIZE;
            public static final /* enum */ LEAF_ELEMENTS SUBPART_NUM;
            public static final /* enum */ LEAF_ELEMENTS HIBOUNDLEN;
            public static final /* enum */ LEAF_ELEMENTS HIBOUNDVAL;
            public static final /* enum */ LEAF_ELEMENTS BHIBOUNDVAL;
            public static final /* enum */ LEAF_ELEMENTS FLAGS;
            public static final /* enum */ LEAF_ELEMENTS PCT_FREE;
            public static final /* enum */ LEAF_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                BLOCKSIZE = new LEAF_ELEMENTS();
                SUBPART_NUM = new LEAF_ELEMENTS();
                HIBOUNDLEN = new LEAF_ELEMENTS();
                HIBOUNDVAL = new LEAF_ELEMENTS();
                BHIBOUNDVAL = new LEAF_ELEMENTS();
                FLAGS = new LEAF_ELEMENTS();
                PCT_FREE = new LEAF_ELEMENTS();
                TAG_NOTPARSED = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{BLOCKSIZE, SUBPART_NUM, HIBOUNDLEN, HIBOUNDVAL, BHIBOUNDVAL, FLAGS, PCT_FREE, TAG_NOTPARSED};
            }
        }
    }

    private static class TablePartitionImpl
    extends MetadataHandler
    implements Metadata.TablePartitionInfo,
    Metadata.TablePartition {
        private boolean seenPartnum = false;
        private boolean seenHiboundlen = false;
        private boolean seenHiboundval = false;
        private boolean seenFlags = false;
        private SchemaImpl schemaObj = null;
        private int blockSize;
        private StorageImpl storage;
        private DeferredStorageImpl deferredStorage;
        private int partNum;
        private int highBoundLength;
        private String highBoundValue = null;
        private byte[] binaryHighBoundValue = null;
        private int flags = 0;
        private int pctFree = 0;
        private Collection<Metadata.Lob> lobs = new ArrayList<Metadata.Lob>();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;

        TablePartitionImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        CHILD_ELEMENTS getTopofStack() {
            return this.parents.isEmpty() ? null : CHILD_ELEMENTS.getName((String)this.parents.peek());
        }

        @Override
        public boolean isParentPartListItem() {
            return this.getTopofStack() == CHILD_ELEMENTS.PART_LIST_ITEM;
        }

        @Override
        public boolean isParentLobs() {
            return this.getTopofStack() == CHILD_ELEMENTS.LOBS;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            switch (CHILD_ELEMENTS.getName(string3)) {
                case SCHEMA_OBJ: {
                    if (null != this.schemaObj || !this.isParentPartListItem()) break;
                    this.schemaObj = new SchemaImpl(this, string3, this.delegator);
                    this.setHandler(this.schemaObj);
                    break;
                }
                case STORAGE: {
                    if (null != this.storage || !this.isParentPartListItem()) break;
                    this.storage = new StorageImpl(this, string3, this.delegator);
                    this.setHandler(this.storage);
                    break;
                }
                case DEFERRED_STG: {
                    if (null != this.deferredStorage || !this.isParentPartListItem()) break;
                    this.deferredStorage = new DeferredStorageImpl(this, string3, this.delegator);
                    this.setHandler(this.deferredStorage);
                    break;
                }
                case LOBS_ITEM: {
                    if (!this.isParentLobs()) break;
                    if (null == this.lobs) {
                        this.lobs = new ArrayList<Metadata.Lob>();
                    }
                    LobImpl lobImpl = new LobImpl(this, string3, this.delegator);
                    this.lobs.add(lobImpl);
                    this.setHandler(lobImpl);
                    break;
                }
                case LOBS: 
                case NT: {
                    if (!this.isParentPartListItem()) break;
                    this.parents.push(string3);
                    break;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.isParentPartListItem()) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case BLOCKSIZE: {
                        this.blockSize = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PART_NUM: {
                        this.seenPartnum = true;
                        try {
                            this.partNum = Integer.parseInt(this.contents.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.partNum = 0;
                        }
                        break;
                    }
                    case HIBOUNDLEN: {
                        this.seenHiboundlen = true;
                        this.highBoundLength = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case HIBOUNDVAL: {
                        this.seenHiboundval = true;
                        this.highBoundValue = this.contents.toString();
                        break;
                    }
                    case PCT_FREE: {
                        this.pctFree = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case FLAGS: {
                        this.seenFlags = true;
                        this.flags = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case BHIBOUNDVAL: {
                        this.binaryHighBoundValue = MetadataImpl.hexStringToByteArray(this.contents.toString());
                        break;
                    }
                }
            }
            if (this.getTopofStack() == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case DEFERRED_STG: 
                    case LOBS: 
                    case NT: {
                        this.parents.pop();
                        break;
                    }
                    case PART_LIST_ITEM: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        void setbHiboundVal(byte[] byArray) {
            this.binaryHighBoundValue = byArray;
        }

        void setPartNum(int n) {
            this.partNum = n;
        }

        @Override
        public int getObjNum() {
            return this.getSchema().getObjNum();
        }

        @Override
        public SchemaImpl getSchema() {
            return this.schemaObj;
        }

        @Override
        public int getBlockSize() {
            return this.blockSize;
        }

        @Override
        public StorageImpl getStorage() {
            return this.storage;
        }

        @Override
        public Metadata.DeferredStorage getDeferredStorage() {
            return this.deferredStorage;
        }

        @Override
        public int getPartitionNum() {
            return this.partNum;
        }

        @Override
        public String getName() {
            return this.getSchema().getSubName();
        }

        @Override
        public int getHiboundLen() {
            return this.highBoundLength;
        }

        @Override
        public String getHiboundVal() {
            return this.highBoundValue;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public Collection<Metadata.Lob> getLobs() {
            return this.lobs;
        }

        @Override
        public boolean isPartitionStaticallyDefined() {
            return (this.getFlags() & 0x8000) == 0;
        }

        @Override
        public String[] getHiboundVals() {
            return this.highBoundValue.split(",");
        }

        @Override
        public byte[] getbHiboundVal() {
            return this.binaryHighBoundValue;
        }

        @Override
        public int getPctfree() {
            return this.pctFree;
        }

        @Override
        public boolean isDEFAULT() {
            return (this.getFlags() & 0x4000) != 0;
        }

        boolean isValid() {
            return this.getSchema() != null && this.getSchema().isValid() && this.seenPartnum && this.seenHiboundlen && this.seenHiboundval && this.seenFlags;
        }

        static {
            try {
                $$$methodRef$$$26 = TablePartitionImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$25 = TablePartitionImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$24 = TablePartitionImpl.class.getDeclaredMethod("getStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$23 = TablePartitionImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$22 = TablePartitionImpl.class.getDeclaredMethod("isDEFAULT", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$21 = TablePartitionImpl.class.getDeclaredMethod("getPctfree", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$20 = TablePartitionImpl.class.getDeclaredMethod("getbHiboundVal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$19 = TablePartitionImpl.class.getDeclaredMethod("getHiboundVals", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$18 = TablePartitionImpl.class.getDeclaredMethod("isPartitionStaticallyDefined", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = TablePartitionImpl.class.getDeclaredMethod("getLobs", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = TablePartitionImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = TablePartitionImpl.class.getDeclaredMethod("getHiboundVal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = TablePartitionImpl.class.getDeclaredMethod("getHiboundLen", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = TablePartitionImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = TablePartitionImpl.class.getDeclaredMethod("getPartitionNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = TablePartitionImpl.class.getDeclaredMethod("getDeferredStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = TablePartitionImpl.class.getDeclaredMethod("getStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = TablePartitionImpl.class.getDeclaredMethod("getBlockSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = TablePartitionImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = TablePartitionImpl.class.getDeclaredMethod("getObjNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = TablePartitionImpl.class.getDeclaredMethod("setPartNum", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = TablePartitionImpl.class.getDeclaredMethod("setbHiboundVal", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = TablePartitionImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = TablePartitionImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = TablePartitionImpl.class.getDeclaredMethod("isParentLobs", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = TablePartitionImpl.class.getDeclaredMethod("isParentPartListItem", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = TablePartitionImpl.class.getDeclaredMethod("getTopofStack", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS SCHEMA_OBJ;
            public static final /* enum */ CHILD_ELEMENTS STORAGE;
            public static final /* enum */ CHILD_ELEMENTS DEFERRED_STG;
            public static final /* enum */ CHILD_ELEMENTS LOBS;
            public static final /* enum */ CHILD_ELEMENTS LOBS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS NT;
            public static final /* enum */ CHILD_ELEMENTS PART_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                SCHEMA_OBJ = new CHILD_ELEMENTS();
                STORAGE = new CHILD_ELEMENTS();
                DEFERRED_STG = new CHILD_ELEMENTS();
                LOBS = new CHILD_ELEMENTS();
                LOBS_ITEM = new CHILD_ELEMENTS();
                NT = new CHILD_ELEMENTS();
                PART_LIST_ITEM = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{SCHEMA_OBJ, STORAGE, DEFERRED_STG, LOBS, LOBS_ITEM, NT, PART_LIST_ITEM, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS BLOCKSIZE;
            public static final /* enum */ LEAF_ELEMENTS PART_NUM;
            public static final /* enum */ LEAF_ELEMENTS HIBOUNDLEN;
            public static final /* enum */ LEAF_ELEMENTS HIBOUNDVAL;
            public static final /* enum */ LEAF_ELEMENTS PCT_FREE;
            public static final /* enum */ LEAF_ELEMENTS FLAGS;
            public static final /* enum */ LEAF_ELEMENTS BHIBOUNDVAL;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                BLOCKSIZE = new LEAF_ELEMENTS();
                PART_NUM = new LEAF_ELEMENTS();
                HIBOUNDLEN = new LEAF_ELEMENTS();
                HIBOUNDVAL = new LEAF_ELEMENTS();
                PCT_FREE = new LEAF_ELEMENTS();
                FLAGS = new LEAF_ELEMENTS();
                BHIBOUNDVAL = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{BLOCKSIZE, PART_NUM, HIBOUNDLEN, HIBOUNDVAL, PCT_FREE, FLAGS, BHIBOUNDVAL, NOVALUE};
            }
        }
    }

    private static class TableImpl
    extends MetadataHandler
    implements Metadata.Table {
        boolean seenTableT = false;
        boolean seenCols = false;
        boolean seenTSName = false;
        boolean seenSpare6 = false;
        public static final String CREATE_TABLE = "CREATE TABLE ";
        public static final char OPEN_PAREN = '(';
        public static final char CLOSE_PAREN = ')';
        public static final char DOT = '.';
        public static final char DOUBLE_Q = '\"';
        public static final String PROP_LINE_SEPARATOR = "line.separator";
        public static final String LINE_SEP = "\n";
        public static final char COMMA = ',';
        public static final String COL_INDENT = "   ";
        private SchemaImpl schemaObj;
        private String tsName;
        private int blockSize;
        private int pctFree;
        private int cols;
        private String spare6;
        private Vector<Metadata.ColumnMetadata> col_list = new Vector();
        private Collection<Metadata.ColumnMetadata> tabCols = null;
        private ColumnMetadataImpl[] tabColsArray = null;
        private ArrayList<Metadata.ColumnMetadata> notNullColList = null;
        private ArrayList<Metadata.ColumnMetadata> loadTargetColList = null;
        private HashMap<String, Metadata.ColumnMetadata> colMap = new HashMap();
        private Vector<Metadata.Constraint> con1List = new Vector();
        private Metadata.Constraint primaryConstraint = null;
        private Collection<Metadata.ColumnMetadata> primaryConstraintCols = null;
        private ArrayList<Metadata.Constraint> uniqueConstraints = null;
        private PartitionImpl part_obj;
        private Collection<Metadata.TablePartitionInfo> tablePartitions = null;
        private TreeMap<Integer, Metadata.TablePartitionInfo> tablePartitionsMap = null;
        private Collection<Metadata.TablePartitionInfo> tableCompositePartitions = null;
        private TreeMap<Integer, Metadata.TablePartitionInfo> tableCompositePartitionsMap = null;
        private Collection<Metadata.TablePartitionInfo> templateSubPartitions = null;
        private TreeMap<Integer, Metadata.TablePartitionInfo> templateSubPartitionsMap = null;
        private List<Metadata.ColumnMetadata> partitionCols = null;
        private List<Metadata.ColumnMetadata> subpartitionCols = null;
        private StorageImpl storage = null;
        private DeferredStorageImpl deferredStorage;
        private static final String CREATE_TAB_FORMAT = "CREATE TABLE  \"%1$s\".\"%2$s\"%3$s(%4$s";
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;
        private static Executable $$$methodRef$$$28;
        private static Logger $$$loggerRef$$$28;
        private static Executable $$$methodRef$$$29;
        private static Logger $$$loggerRef$$$29;
        private static Executable $$$methodRef$$$30;
        private static Logger $$$loggerRef$$$30;
        private static Executable $$$methodRef$$$31;
        private static Logger $$$loggerRef$$$31;
        private static Executable $$$methodRef$$$32;
        private static Logger $$$loggerRef$$$32;
        private static Executable $$$methodRef$$$33;
        private static Logger $$$loggerRef$$$33;
        private static Executable $$$methodRef$$$34;
        private static Logger $$$loggerRef$$$34;
        private static Executable $$$methodRef$$$35;
        private static Logger $$$loggerRef$$$35;
        private static Executable $$$methodRef$$$36;
        private static Logger $$$loggerRef$$$36;
        private static Executable $$$methodRef$$$37;
        private static Logger $$$loggerRef$$$37;
        private static Executable $$$methodRef$$$38;
        private static Logger $$$loggerRef$$$38;
        private static Executable $$$methodRef$$$39;
        private static Logger $$$loggerRef$$$39;
        private static Executable $$$methodRef$$$40;
        private static Logger $$$loggerRef$$$40;
        private static Executable $$$methodRef$$$41;
        private static Logger $$$loggerRef$$$41;
        private static Executable $$$methodRef$$$42;
        private static Logger $$$loggerRef$$$42;
        private static Executable $$$methodRef$$$43;
        private static Logger $$$loggerRef$$$43;
        private static Executable $$$methodRef$$$44;
        private static Logger $$$loggerRef$$$44;
        private static Executable $$$methodRef$$$45;
        private static Logger $$$loggerRef$$$45;
        private static Executable $$$methodRef$$$46;
        private static Logger $$$loggerRef$$$46;
        private static Executable $$$methodRef$$$47;
        private static Logger $$$loggerRef$$$47;
        private static Executable $$$methodRef$$$48;
        private static Logger $$$loggerRef$$$48;
        private static Executable $$$methodRef$$$49;
        private static Logger $$$loggerRef$$$49;
        private static Executable $$$methodRef$$$50;
        private static Logger $$$loggerRef$$$50;
        private static Executable $$$methodRef$$$51;
        private static Logger $$$loggerRef$$$51;

        public TableImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (!this.parents.empty()) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case SCHEMA_OBJ: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.TABLE_T) break;
                        this.schemaObj = new SchemaImpl(this, string3, this.delegator);
                        this.setHandler(this.schemaObj);
                        break;
                    }
                    case BASE_OBJ: 
                    case ANC_OBJ: 
                    case PARENT_OBJ: 
                    case TABCLUSTER: 
                    case FBA: 
                    case XMLCOLSET: 
                    case COL_LIST: 
                    case CON0_LIST: 
                    case CON2_LIST: 
                    case EXTTAB: 
                    case CUBETAB: {
                        this.parents.push(string3);
                        break;
                    }
                    case STORAGE: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.TABLE_T) break;
                        this.storage = new StorageImpl(this, string3, this.delegator);
                        this.setHandler(this.storage);
                        break;
                    }
                    case DEFERRED_STG: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.TABLE_T) break;
                        this.deferredStorage = new DeferredStorageImpl(this, string3, this.delegator);
                        this.setHandler(this.deferredStorage);
                        break;
                    }
                    case COL_LIST_ITEM: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.COL_LIST) break;
                        ColumnMetadataImpl columnMetadataImpl = new ColumnMetadataImpl(this, string3, this.delegator);
                        this.col_list.add(columnMetadataImpl);
                        this.setHandler(columnMetadataImpl);
                        break;
                    }
                    case PART_OBJ: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.TABLE_T) break;
                        this.part_obj = new PartitionImpl(this, string3, this.delegator);
                        this.setHandler(this.part_obj);
                        break;
                    }
                    case CON1_LIST: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.TABLE_T) break;
                        this.con1List = new Vector();
                        this.parents.push(string3);
                        break;
                    }
                    case CON1_LIST_ITEM: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.CON1_LIST) break;
                        ConstraintImpl constraintImpl = new ConstraintImpl(this, string3, this.delegator);
                        this.con1List.add(constraintImpl);
                        this.setHandler(constraintImpl);
                        break;
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.TABLE_T) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case COLS: {
                        if (0 == this.cols) {
                            this.cols = Integer.parseInt(this.contents.toString());
                        }
                        this.seenCols = true;
                        break;
                    }
                    case TS_NAME: {
                        if (null == this.tsName) {
                            this.tsName = this.contents.toString();
                        }
                        this.seenTSName = true;
                        break;
                    }
                    case BLOCKSIZE: {
                        if (0 != this.blockSize) break;
                        this.blockSize = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PCT_FREE: {
                        this.pctFree = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE6: {
                        if (null == this.spare6) {
                            this.spare6 = this.contents.toString();
                        }
                        this.seenSpare6 = true;
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case BASE_OBJ: 
                    case ANC_OBJ: 
                    case PARENT_OBJ: 
                    case TABCLUSTER: 
                    case FBA: 
                    case XMLCOLSET: 
                    case COL_LIST: 
                    case CON0_LIST: 
                    case CON2_LIST: 
                    case EXTTAB: 
                    case CUBETAB: 
                    case DEFERRED_STG: 
                    case CON1_LIST: {
                        this.parents.pop();
                        break;
                    }
                    case TABLE_T: {
                        this.seenTableT = true;
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        @Override
        public boolean isPartitioned() {
            if (this.getPartitionObj() == null) {
                return false;
            }
            return this.getPartitionType() != Metadata.PartitionType.UNSUPPORTED;
        }

        @Override
        public Metadata.PartitionType getPartitionType() {
            if (this.getPartitionObj() == null) {
                return null;
            }
            return this.getPartitionObj().getPartitionType();
        }

        @Override
        public boolean isCompositePartition() {
            if (this.getPartitionObj() == null) {
                return false;
            }
            return this.getPartitionObj().isCompositePartition();
        }

        @Override
        public boolean isIntervalPartition() {
            if (this.getPartitionObj() == null) {
                return false;
            }
            return this.getPartitionObj().isIntervalPartition();
        }

        @Override
        public int getDefSubpartitionCount() {
            if (this.getPartitionObj() == null) {
                return 1;
            }
            return this.getPartitionObj().getDefSubpartitionCount();
        }

        @Override
        public Metadata.PartitionType getSubpartitionType() {
            if (this.getPartitionObj() == null) {
                return null;
            }
            return this.getPartitionObj().getSubpartitionType();
        }

        @Override
        public synchronized List<Metadata.ColumnMetadata> getPartitionKeyColumnsMetadata() {
            if (this.getPartitionObj() == null) {
                return null;
            }
            if (this.partitionCols == null) {
                TreeMap<Integer, Metadata.ColumnMetadata> treeMap = new TreeMap<Integer, Metadata.ColumnMetadata>();
                for (Metadata.PartitionColumn partitionColumn : this.getPartitionObj().getPartitionColumns()) {
                    treeMap.put(partitionColumn.getPositionNum(), this.getColumn(partitionColumn.getColumn().getName()));
                }
                this.partitionCols = new ArrayList(treeMap.values());
            }
            return this.partitionCols;
        }

        @Override
        public int getPartitionCount() {
            int n = 0;
            if (this.getPartitionObj() != null) {
                n = this.getPartitionObj().getBasePartition().getPartitionCount();
            }
            return n;
        }

        @Override
        public synchronized List<Metadata.ColumnMetadata> getSubpartitionColumns() {
            if (this.getPartitionObj() == null) {
                return null;
            }
            if (this.subpartitionCols == null) {
                TreeMap<Integer, Metadata.ColumnMetadata> treeMap = new TreeMap<Integer, Metadata.ColumnMetadata>();
                for (Metadata.PartitionColumn partitionColumn : this.getPartitionObj().getSubpartitionColumns()) {
                    treeMap.put(partitionColumn.getPositionNum(), this.getColumn(partitionColumn.getColumn().getName()));
                }
                this.subpartitionCols = new ArrayList(treeMap.values());
            }
            return this.subpartitionCols;
        }

        @Override
        public synchronized Collection<Metadata.TablePartitionInfo> getPartitions() {
            if (this.getPartitionObj() == null) {
                return null;
            }
            if (this.tablePartitions == null) {
                this.tablePartitionsMap = new TreeMap();
                for (Metadata.TablePartition tablePartition : this.getPartitionObj().getPartitions()) {
                    this.tablePartitionsMap.put(tablePartition.getPartitionNum(), tablePartition);
                }
                this.tablePartitions = this.tablePartitionsMap.values();
            }
            return this.tablePartitions;
        }

        @Override
        public String getPartitionName(int n) {
            if (this.isCompositePartition()) {
                this.getCompositePartitions();
                Metadata.TableCompositePartition tableCompositePartition = (Metadata.TableCompositePartition)this.tableCompositePartitionsMap.get(n);
                return null == tableCompositePartition ? null : tableCompositePartition.getName();
            }
            if (this.isPartitioned()) {
                this.getPartitions();
                Metadata.TablePartition tablePartition = (Metadata.TablePartition)this.tablePartitionsMap.get(n);
                return null == tablePartition ? null : tablePartition.getName();
            }
            return null;
        }

        @Override
        public String getSubPartitionName(int n, int n2) {
            if (this.isCompositePartition()) {
                this.getCompositePartitions();
                Metadata.TableCompositePartition tableCompositePartition = (Metadata.TableCompositePartition)this.tableCompositePartitionsMap.get(n);
                if (tableCompositePartition == null) {
                    return null;
                }
                return tableCompositePartition.getSubPartitionName(n2);
            }
            return null;
        }

        @Override
        public synchronized Collection<Metadata.TablePartitionInfo> getCompositePartitions() {
            if (this.getPartitionObj() == null) {
                return null;
            }
            if (this.tableCompositePartitions == null) {
                this.tableCompositePartitionsMap = new TreeMap();
                for (Metadata.TableCompositePartition tableCompositePartition : this.getPartitionObj().getCompositePartitions()) {
                    this.tableCompositePartitionsMap.put(tableCompositePartition.getPartitionNum(), tableCompositePartition);
                }
                this.tableCompositePartitions = this.tableCompositePartitionsMap.values();
            }
            return this.tableCompositePartitions;
        }

        @Override
        public synchronized Collection<Metadata.TablePartitionInfo> getTemplateSubPartitions() {
            if (this.getPartitionObj() == null) {
                return null;
            }
            if (this.templateSubPartitions == null) {
                this.templateSubPartitionsMap = new TreeMap();
                for (Metadata.TemplateSubPartition templateSubPartition : this.getPartitionObj().getTemplateSubPartitions()) {
                    this.templateSubPartitionsMap.put(templateSubPartition.getSpartPos(), templateSubPartition);
                }
                this.templateSubPartitions = this.templateSubPartitionsMap.values();
            }
            return this.templateSubPartitions;
        }

        SchemaImpl getSchema() {
            return this.schemaObj;
        }

        String getTablespaceName() {
            return this.tsName;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public int getPctfree() {
            return this.pctFree;
        }

        public Metadata.Storage getStorage() {
            return this.storage;
        }

        public Metadata.DeferredStorage getDeferredStorage() {
            return this.deferredStorage;
        }

        @Override
        public int getColumnCount() {
            return this.cols;
        }

        @Override
        public String getName() {
            return this.schemaObj.getName();
        }

        public String getOwner() {
            return this.schemaObj.getOwnerName();
        }

        @Override
        public String getSchemaQualifiedName() {
            return MetadataImpl.enquoteDouble(this.getOwner()) + "." + MetadataImpl.enquoteDouble(this.getName());
        }

        String getSpare6() {
            return this.spare6;
        }

        @Override
        public synchronized Collection<Metadata.ColumnMetadata> getColumns() {
            if (this.tabCols == null) {
                TreeMap<Integer, Metadata.ColumnMetadata> treeMap = new TreeMap<Integer, Metadata.ColumnMetadata>();
                for (Metadata.ColumnMetadata columnMetadata : this.col_list) {
                    if (!treeMap.containsKey(columnMetadata.getColumnNum())) {
                        treeMap.put(columnMetadata.getColumnNum(), columnMetadata);
                        continue;
                    }
                    Metadata.ColumnMetadata columnMetadata2 = (Metadata.ColumnMetadata)treeMap.get(columnMetadata.getColumnNum());
                    if (Metadata.ObjectColumnType.isObjCol(columnMetadata2.getTypeNum())) continue;
                    treeMap.put(columnMetadata.getColumnNum(), columnMetadata);
                }
                this.tabCols = Collections.unmodifiableCollection(treeMap.values());
                this.tabColsArray = this.tabCols.toArray(new ColumnMetadataImpl[this.tabCols.size()]);
            }
            return this.tabCols;
        }

        @Override
        public ColumnMetadataImpl getColumn(int n) {
            if (this.tabColsArray == null) {
                this.getColumns();
            }
            return this.tabColsArray[n - 1];
        }

        @Override
        public synchronized Metadata.ColumnMetadata getColumn(String string) {
            if (this.colMap.size() == 0) {
                for (int i = 0; i < this.getColumns().size(); ++i) {
                    this.colMap.put(this.getColumn(i + 1).getName(), this.getColumn(i + 1));
                }
            }
            return this.colMap.get(string);
        }

        public synchronized Collection<Metadata.ColumnMetadata> getNotNullColumns() {
            if (this.notNullColList == null) {
                this.notNullColList = new ArrayList();
                for (Metadata.ColumnMetadata columnMetadata : this.getColumns()) {
                    if (!columnMetadata.isNotNull()) continue;
                    this.notNullColList.add(columnMetadata);
                }
            }
            return this.notNullColList;
        }

        public synchronized Collection<Metadata.ColumnMetadata> getColumnsToLoad() {
            if (this.loadTargetColList == null) {
                TreeMap<Integer, Metadata.ColumnMetadata> treeMap = new TreeMap<Integer, Metadata.ColumnMetadata>();
                for (Metadata.ColumnMetadata columnMetadata : this.getColumns()) {
                    if (!columnMetadata.isLoadTarget()) continue;
                    treeMap.put(columnMetadata.getSegmentColumnNum(), columnMetadata);
                }
                this.loadTargetColList = new ArrayList(treeMap.values());
            }
            return this.loadTargetColList;
        }

        void setAllColsAsLoadTargets() {
            for (Metadata.ColumnMetadata columnMetadata : this.getColumns()) {
                columnMetadata.setLoadTarget(true);
            }
        }

        public void unsetAllColsAsLoadTargets() {
            for (Metadata.ColumnMetadata columnMetadata : this.getColumns()) {
                columnMetadata.setLoadTarget(false);
            }
        }

        @Override
        public int getIntervalDataType() {
            if (this.isIntervalPartition()) {
                int n = this.part_obj.getBasePartition().getSpare3();
                return n & 0xFF;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public byte[] getIntervalBinaryValue() {
            if (this.isIntervalPartition()) {
                return this.part_obj.getBasePartition().getIntervalBinaryValue();
            }
            return null;
        }

        @Override
        public PartitionImpl getPartitionObj() {
            return this.part_obj;
        }

        @Override
        public Vector<Metadata.Constraint> getConstraints() {
            return this.con1List;
        }

        @Override
        public boolean hasPrimaryConstraint() {
            return this.getPrimaryConstraint() != null;
        }

        @Override
        public Metadata.Constraint getPrimaryConstraint() {
            if (this.primaryConstraint == null) {
                for (Metadata.Constraint constraint : this.getConstraints()) {
                    if (!constraint.isPrimary()) continue;
                    this.primaryConstraint = constraint;
                    break;
                }
            }
            return this.primaryConstraint;
        }

        @Override
        public Collection<Metadata.ColumnMetadata> getPrimaryConstraintColumnsMetadata() {
            if (null == this.getPrimaryConstraint()) {
                return new ArrayList<Metadata.ColumnMetadata>();
            }
            if (this.primaryConstraintCols == null) {
                this.primaryConstraintCols = this.getConstraintColumns(this.primaryConstraint);
            }
            return this.primaryConstraintCols;
        }

        @Override
        public String[] getPrimaryConstraintColumns() {
            ArrayList<Metadata.ColumnMetadata> arrayList = new ArrayList<Metadata.ColumnMetadata>(this.getPrimaryConstraintColumnsMetadata());
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = ((Metadata.ColumnMetadata)arrayList.get(i)).getName();
            }
            return stringArray;
        }

        @Override
        public Collection<Metadata.Constraint> getUniqueConstraints() {
            if (this.uniqueConstraints == null) {
                this.uniqueConstraints = new ArrayList();
                for (Metadata.Constraint constraint : this.getConstraints()) {
                    if (!constraint.isUnique()) continue;
                    this.uniqueConstraints.add(constraint);
                }
            }
            return this.uniqueConstraints;
        }

        @Override
        public Collection<Metadata.ColumnMetadata> getConstraintColumns(Metadata.Constraint constraint) {
            TreeMap<Integer, Metadata.ColumnMetadata> treeMap = new TreeMap<Integer, Metadata.ColumnMetadata>();
            for (Metadata.ConstraintColumn constraintColumn : constraint.getColumns()) {
                treeMap.put(constraintColumn.getPositionNum(), this.getColumn(constraintColumn.getColumn().getName()));
            }
            return treeMap.values();
        }

        public String createLoadDDL(String string, String string2) {
            return this.createLoadDDL(string, string2, false);
        }

        public String createLoadDDL(String string, String string2, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string == null || string.length() == 0 ? this.getOwner() : string;
            String string4 = string2 == null || string2.length() == 0 ? this.getName() : string2;
            stringBuilder.append(String.format(CREATE_TAB_FORMAT, string3, string4, LINE_SEP, LINE_SEP));
            boolean bl2 = true;
            String string5 = null;
            for (Metadata.ColumnMetadata columnMetadata : this.getColumnsToLoad()) {
                string5 = columnMetadata.createDDL(bl);
                if (string5.length() <= 0) continue;
                if (bl2) {
                    stringBuilder.append(COL_INDENT).append(string5);
                    bl2 = false;
                    continue;
                }
                stringBuilder.append(',').append(LINE_SEP).append(COL_INDENT).append(string5);
            }
            stringBuilder.append(LINE_SEP).append(')');
            return stringBuilder.toString();
        }

        boolean isValid() {
            if (!(this.seenTableT && this.seenTSName && this.seenCols && this.seenSpare6)) {
                return false;
            }
            if (this.getSchema() == null || !this.getSchema().isValid()) {
                return false;
            }
            if (this.getColumns() == null || this.getColumns().size() == 0) {
                return false;
            }
            Iterator<Object> iterator = this.getColumns().iterator();
            while (iterator.hasNext()) {
                if (((ColumnMetadataImpl)iterator.next()).isValid()) continue;
                return false;
            }
            if (this.getConstraints() == null || this.getConstraints().size() == 0) {
                return false;
            }
            iterator = this.getConstraints().iterator();
            while (iterator.hasNext()) {
                if (((ConstraintImpl)iterator.next()).isValid()) continue;
                return false;
            }
            return this.getPartitionObj() != null && this.getPartitionObj().isValid();
        }

        public void setDefaultDateTimeFormats(String string, String string2) {
            for (Metadata.ColumnMetadata columnMetadata : this.getColumns()) {
                if (!columnMetadata.isDateTimeType()) continue;
                if (columnMetadata.getSQLType().getVendorTypeNumber() == 91) {
                    columnMetadata.setInputFormat(string);
                    continue;
                }
                columnMetadata.setInputFormat(string2);
            }
        }

        @Override
        public boolean hasConstraints() {
            return this.con1List != null && !this.con1List.isEmpty();
        }

        static {
            try {
                $$$methodRef$$$51 = TableImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$50 = TableImpl.class.getDeclaredMethod("getColumn", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$49 = TableImpl.class.getDeclaredMethod("getPartitionObj", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$48 = TableImpl.class.getDeclaredMethod("hasConstraints", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$47 = TableImpl.class.getDeclaredMethod("setDefaultDateTimeFormats", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$46 = TableImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$45 = TableImpl.class.getDeclaredMethod("createLoadDDL", String.class, String.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$44 = TableImpl.class.getDeclaredMethod("createLoadDDL", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$43 = TableImpl.class.getDeclaredMethod("getConstraintColumns", Metadata.Constraint.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$42 = TableImpl.class.getDeclaredMethod("getUniqueConstraints", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$41 = TableImpl.class.getDeclaredMethod("getPrimaryConstraintColumns", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$40 = TableImpl.class.getDeclaredMethod("getPrimaryConstraintColumnsMetadata", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$39 = TableImpl.class.getDeclaredMethod("getPrimaryConstraint", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$38 = TableImpl.class.getDeclaredMethod("hasPrimaryConstraint", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$37 = TableImpl.class.getDeclaredMethod("getConstraints", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$36 = TableImpl.class.getDeclaredMethod("getPartitionObj", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$35 = TableImpl.class.getDeclaredMethod("getIntervalBinaryValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$34 = TableImpl.class.getDeclaredMethod("getIntervalDataType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$33 = TableImpl.class.getDeclaredMethod("unsetAllColsAsLoadTargets", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$32 = TableImpl.class.getDeclaredMethod("setAllColsAsLoadTargets", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$31 = TableImpl.class.getDeclaredMethod("getColumnsToLoad", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$30 = TableImpl.class.getDeclaredMethod("getNotNullColumns", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$29 = TableImpl.class.getDeclaredMethod("getColumn", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$28 = TableImpl.class.getDeclaredMethod("getColumn", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$27 = TableImpl.class.getDeclaredMethod("getColumns", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$26 = TableImpl.class.getDeclaredMethod("getSpare6", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$25 = TableImpl.class.getDeclaredMethod("getSchemaQualifiedName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$24 = TableImpl.class.getDeclaredMethod("getOwner", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$23 = TableImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$22 = TableImpl.class.getDeclaredMethod("getColumnCount", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$21 = TableImpl.class.getDeclaredMethod("getDeferredStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$20 = TableImpl.class.getDeclaredMethod("getStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$19 = TableImpl.class.getDeclaredMethod("getPctfree", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$18 = TableImpl.class.getDeclaredMethod("getBlockSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = TableImpl.class.getDeclaredMethod("getTablespaceName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = TableImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = TableImpl.class.getDeclaredMethod("getTemplateSubPartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = TableImpl.class.getDeclaredMethod("getCompositePartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = TableImpl.class.getDeclaredMethod("getSubPartitionName", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = TableImpl.class.getDeclaredMethod("getPartitionName", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = TableImpl.class.getDeclaredMethod("getPartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = TableImpl.class.getDeclaredMethod("getSubpartitionColumns", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = TableImpl.class.getDeclaredMethod("getPartitionCount", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = TableImpl.class.getDeclaredMethod("getPartitionKeyColumnsMetadata", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = TableImpl.class.getDeclaredMethod("getSubpartitionType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = TableImpl.class.getDeclaredMethod("getDefSubpartitionCount", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = TableImpl.class.getDeclaredMethod("isIntervalPartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = TableImpl.class.getDeclaredMethod("isCompositePartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = TableImpl.class.getDeclaredMethod("getPartitionType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = TableImpl.class.getDeclaredMethod("isPartitioned", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = TableImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = TableImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS COLS;
            public static final /* enum */ LEAF_ELEMENTS TS_NAME;
            public static final /* enum */ LEAF_ELEMENTS BLOCKSIZE;
            public static final /* enum */ LEAF_ELEMENTS PCT_FREE;
            public static final /* enum */ LEAF_ELEMENTS SPARE6;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COLS = new LEAF_ELEMENTS();
                TS_NAME = new LEAF_ELEMENTS();
                BLOCKSIZE = new LEAF_ELEMENTS();
                PCT_FREE = new LEAF_ELEMENTS();
                SPARE6 = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{COLS, TS_NAME, BLOCKSIZE, PCT_FREE, SPARE6, NOVALUE};
            }
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS SCHEMA_OBJ;
            public static final /* enum */ CHILD_ELEMENTS BASE_OBJ;
            public static final /* enum */ CHILD_ELEMENTS ANC_OBJ;
            public static final /* enum */ CHILD_ELEMENTS PARENT_OBJ;
            public static final /* enum */ CHILD_ELEMENTS STORAGE;
            public static final /* enum */ CHILD_ELEMENTS DEFERRED_STG;
            public static final /* enum */ CHILD_ELEMENTS TABCLUSTER;
            public static final /* enum */ CHILD_ELEMENTS FBA;
            public static final /* enum */ CHILD_ELEMENTS XMLCOLSET;
            public static final /* enum */ CHILD_ELEMENTS COL_LIST;
            public static final /* enum */ CHILD_ELEMENTS COL_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS CON0_LIST;
            public static final /* enum */ CHILD_ELEMENTS CON1_LIST;
            public static final /* enum */ CHILD_ELEMENTS CON1_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS CON2_LIST;
            public static final /* enum */ CHILD_ELEMENTS EXTTAB;
            public static final /* enum */ CHILD_ELEMENTS CUBETAB;
            public static final /* enum */ CHILD_ELEMENTS PART_OBJ;
            public static final /* enum */ CHILD_ELEMENTS TABLE_T;
            public static final /* enum */ CHILD_ELEMENTS DATABASE;
            public static final /* enum */ CHILD_ELEMENTS ROW;
            public static final /* enum */ CHILD_ELEMENTS ROWSET;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                SCHEMA_OBJ = new CHILD_ELEMENTS();
                BASE_OBJ = new CHILD_ELEMENTS();
                ANC_OBJ = new CHILD_ELEMENTS();
                PARENT_OBJ = new CHILD_ELEMENTS();
                STORAGE = new CHILD_ELEMENTS();
                DEFERRED_STG = new CHILD_ELEMENTS();
                TABCLUSTER = new CHILD_ELEMENTS();
                FBA = new CHILD_ELEMENTS();
                XMLCOLSET = new CHILD_ELEMENTS();
                COL_LIST = new CHILD_ELEMENTS();
                COL_LIST_ITEM = new CHILD_ELEMENTS();
                CON0_LIST = new CHILD_ELEMENTS();
                CON1_LIST = new CHILD_ELEMENTS();
                CON1_LIST_ITEM = new CHILD_ELEMENTS();
                CON2_LIST = new CHILD_ELEMENTS();
                EXTTAB = new CHILD_ELEMENTS();
                CUBETAB = new CHILD_ELEMENTS();
                PART_OBJ = new CHILD_ELEMENTS();
                TABLE_T = new CHILD_ELEMENTS();
                DATABASE = new CHILD_ELEMENTS();
                ROW = new CHILD_ELEMENTS();
                ROWSET = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{SCHEMA_OBJ, BASE_OBJ, ANC_OBJ, PARENT_OBJ, STORAGE, DEFERRED_STG, TABCLUSTER, FBA, XMLCOLSET, COL_LIST, COL_LIST_ITEM, CON0_LIST, CON1_LIST, CON1_LIST_ITEM, CON2_LIST, EXTTAB, CUBETAB, PART_OBJ, TABLE_T, DATABASE, ROW, ROWSET, NOVALUE};
            }
        }
    }

    private static class TableCompositePartitionImpl
    extends MetadataHandler
    implements Metadata.TablePartitionInfo,
    Metadata.TableCompositePartition {
        private boolean seenPartnum = false;
        private boolean seenHiboundlen = false;
        private boolean seenHiboundval = false;
        private boolean seenSubpartcnt = false;
        private boolean seenSmatch_tpl = false;
        private SchemaImpl schemaObj = null;
        private int partNum = 0;
        private int highBoundLen = 0;
        private String highBoundVal = null;
        private byte[] binaryHighBoundVal = null;
        private int subPartitionsCnt = 0;
        private int subPartitionsMatchTemplate = 0;
        private List<Metadata.TableSubPartition> subParts = null;
        private int lobsMatchTemplate = 0;
        private List<Metadata.LobPartition> lobPartitions = null;
        private int flags = 0;
        private int defaultPctFree = 0;
        private long spare2 = 0L;
        private Collection<Metadata.TablePartitionInfo> orderedSubParts = null;
        private TreeMap<Integer, Metadata.TablePartitionInfo> orderedSubPartsMap = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;
        private static Executable $$$methodRef$$$28;
        private static Logger $$$loggerRef$$$28;
        private static Executable $$$methodRef$$$29;
        private static Logger $$$loggerRef$$$29;
        private static Executable $$$methodRef$$$30;
        private static Logger $$$loggerRef$$$30;
        private static Executable $$$methodRef$$$31;
        private static Logger $$$loggerRef$$$31;

        TableCompositePartitionImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        private CHILD_ELEMENTS getTopofStack() {
            return this.parents.isEmpty() ? null : CHILD_ELEMENTS.getName((String)this.parents.peek());
        }

        @Override
        public boolean isParentCompartListItem() {
            return this.getTopofStack() == CHILD_ELEMENTS.COMPART_LIST_ITEM;
        }

        @Override
        public boolean isParentSubparts() {
            return this.getTopofStack() == CHILD_ELEMENTS.SUBPARTS;
        }

        @Override
        public boolean isParentLobs() {
            return this.getTopofStack() == CHILD_ELEMENTS.LOBS;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            switch (CHILD_ELEMENTS.getName(string3)) {
                case SCHEMA_OBJ: {
                    if (!this.isParentCompartListItem() || null != this.schemaObj) break;
                    this.schemaObj = new SchemaImpl(this, string3, this.delegator);
                    this.setHandler(this.schemaObj);
                    break;
                }
                case SUBPARTS_ITEM: {
                    if (!this.isParentSubparts()) break;
                    if (null == this.subParts) {
                        this.subParts = new ArrayList<Metadata.TableSubPartition>();
                    }
                    TableSubPartitionImpl tableSubPartitionImpl = new TableSubPartitionImpl(this, string3, this.delegator);
                    this.subParts.add(tableSubPartitionImpl);
                    this.setHandler(tableSubPartitionImpl);
                    break;
                }
                case SUBPARTS: 
                case LOBS: {
                    if (!this.isParentCompartListItem()) break;
                    this.parents.push(string3);
                    break;
                }
                case LOBS_ITEM: {
                    if (!this.isParentLobs()) break;
                    if (null == this.lobPartitions) {
                        this.lobPartitions = new ArrayList<Metadata.LobPartition>();
                    }
                    LobPartitionImpl lobPartitionImpl = new LobPartitionImpl(this, string3, this.delegator);
                    this.lobPartitions.add(lobPartitionImpl);
                    this.setHandler(lobPartitionImpl);
                    break;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.isParentCompartListItem()) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case PART_NUM: {
                        this.seenPartnum = true;
                        try {
                            this.partNum = Integer.parseInt(this.contents.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.partNum = 0;
                        }
                        break;
                    }
                    case HIBOUNDLEN: {
                        this.seenHiboundlen = true;
                        this.highBoundLen = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case HIBOUNDVAL: {
                        this.seenHiboundval = true;
                        this.highBoundVal = this.contents.toString();
                        break;
                    }
                    case BHIBOUNDVAL: {
                        this.binaryHighBoundVal = MetadataImpl.hexStringToByteArray(this.contents.toString());
                        break;
                    }
                    case SUBPARTCNT: {
                        this.seenSubpartcnt = true;
                        this.subPartitionsCnt = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SMATCH_TPL: {
                        this.seenSmatch_tpl = true;
                        this.subPartitionsMatchTemplate = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case LMATCH_TPL: {
                        this.lobsMatchTemplate = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case FLAGS: {
                        this.flags = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFPCTFREE: {
                        this.defaultPctFree = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE2: {
                        this.spare2 = Long.parseLong(this.contents.toString());
                        break;
                    }
                }
            }
            if (this.getTopofStack() == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case SUBPARTS: 
                    case LOBS: {
                        this.parents.pop();
                        break;
                    }
                    case COMPART_LIST_ITEM: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        void setbHiboundVal(byte[] byArray) {
            this.binaryHighBoundVal = byArray;
        }

        void setPartNum(int n) {
            this.partNum = n;
        }

        @Override
        public int getObjNum() {
            return this.getSchema().getObjNum();
        }

        @Override
        public SchemaImpl getSchema() {
            return this.schemaObj;
        }

        @Override
        public int getPartitionNum() {
            return this.partNum;
        }

        @Override
        public String getName() {
            return this.getSchema().getSubName();
        }

        @Override
        public int getHiboundLen() {
            return this.highBoundLen;
        }

        @Override
        public String getHiboundVal() {
            return this.highBoundVal;
        }

        @Override
        public byte[] getbHiboundVal() {
            return this.binaryHighBoundVal;
        }

        @Override
        public int getSubpartCount() {
            return this.subPartitionsCnt;
        }

        @Override
        public int getSmatchTPL() {
            return this.subPartitionsMatchTemplate;
        }

        @Override
        public Collection<Metadata.TableSubPartition> getSubpartitionsObj() {
            return this.subParts;
        }

        @Override
        public Collection<Metadata.LobPartition> getLobPartitions() {
            return this.lobPartitions;
        }

        @Override
        public int getLmatchTPL() {
            return this.lobsMatchTemplate;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public int getDefpctfree() {
            return this.defaultPctFree;
        }

        @Override
        public long getSpare2() {
            return this.spare2;
        }

        @Override
        public boolean isDirpathCompressionEnabled() {
            byte by = (byte)(this.spare2 & 0xFFL);
            return by == 1 || by == 5;
        }

        synchronized Collection<Metadata.TableSubPartition> getSubpartitions_bhival() {
            if (this.getSubpartitionsObj() == null) {
                return null;
            }
            TreeMap<Integer, Metadata.TableSubPartition> treeMap = new TreeMap<Integer, Metadata.TableSubPartition>();
            for (Metadata.TableSubPartition tableSubPartition : this.getSubpartitionsObj()) {
                treeMap.put(tableSubPartition.getObjNum(), tableSubPartition);
            }
            return treeMap.values();
        }

        @Override
        public synchronized Collection<Metadata.TablePartitionInfo> getSubpartitions() {
            if (this.getSubpartitionsObj() == null) {
                return null;
            }
            if (this.orderedSubParts == null) {
                this.orderedSubPartsMap = new TreeMap();
                for (Metadata.TableSubPartition tableSubPartition : this.getSubpartitionsObj()) {
                    this.orderedSubPartsMap.put(tableSubPartition.getSubpartNum(), tableSubPartition);
                }
                this.orderedSubParts = this.orderedSubPartsMap.values();
            }
            return this.orderedSubParts;
        }

        @Override
        public synchronized String getSubPartitionName(int n) {
            this.getSubpartitions();
            Metadata.TableSubPartition tableSubPartition = (Metadata.TableSubPartition)this.orderedSubPartsMap.get(n);
            return null == tableSubPartition ? null : tableSubPartition.getName();
        }

        @Override
        public boolean isPartitionStaticallyDefined() {
            return (this.getFlags() & 0x8000) == 0;
        }

        @Override
        public boolean isDEFAULT() {
            return (this.getFlags() & 0x4000) != 0;
        }

        boolean isValid() {
            if (!(this.getSchema() != null && this.getSchema().isValid() && this.seenPartnum && this.seenHiboundlen && this.seenHiboundval && this.seenSubpartcnt && this.seenSmatch_tpl)) {
                return false;
            }
            if (this.getSubpartitionsObj() == null || this.getSubpartitionsObj().size() == 0) {
                return false;
            }
            for (Metadata.TableSubPartition tableSubPartition : this.getSubpartitionsObj()) {
                if (((TableSubPartitionImpl)tableSubPartition).isValid()) continue;
                return false;
            }
            return true;
        }

        static {
            try {
                $$$methodRef$$$31 = TableCompositePartitionImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$30 = TableCompositePartitionImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$29 = TableCompositePartitionImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$28 = TableCompositePartitionImpl.class.getDeclaredMethod("isDEFAULT", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$27 = TableCompositePartitionImpl.class.getDeclaredMethod("isPartitionStaticallyDefined", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$26 = TableCompositePartitionImpl.class.getDeclaredMethod("getSubPartitionName", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$25 = TableCompositePartitionImpl.class.getDeclaredMethod("getSubpartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$24 = TableCompositePartitionImpl.class.getDeclaredMethod("getSubpartitions_bhival", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$23 = TableCompositePartitionImpl.class.getDeclaredMethod("isDirpathCompressionEnabled", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$22 = TableCompositePartitionImpl.class.getDeclaredMethod("getSpare2", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$21 = TableCompositePartitionImpl.class.getDeclaredMethod("getDefpctfree", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$20 = TableCompositePartitionImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$19 = TableCompositePartitionImpl.class.getDeclaredMethod("getLmatchTPL", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$18 = TableCompositePartitionImpl.class.getDeclaredMethod("getLobPartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = TableCompositePartitionImpl.class.getDeclaredMethod("getSubpartitionsObj", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = TableCompositePartitionImpl.class.getDeclaredMethod("getSmatchTPL", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = TableCompositePartitionImpl.class.getDeclaredMethod("getSubpartCount", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = TableCompositePartitionImpl.class.getDeclaredMethod("getbHiboundVal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = TableCompositePartitionImpl.class.getDeclaredMethod("getHiboundVal", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = TableCompositePartitionImpl.class.getDeclaredMethod("getHiboundLen", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = TableCompositePartitionImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = TableCompositePartitionImpl.class.getDeclaredMethod("getPartitionNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = TableCompositePartitionImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = TableCompositePartitionImpl.class.getDeclaredMethod("getObjNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = TableCompositePartitionImpl.class.getDeclaredMethod("setPartNum", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = TableCompositePartitionImpl.class.getDeclaredMethod("setbHiboundVal", byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = TableCompositePartitionImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = TableCompositePartitionImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = TableCompositePartitionImpl.class.getDeclaredMethod("isParentLobs", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = TableCompositePartitionImpl.class.getDeclaredMethod("isParentSubparts", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = TableCompositePartitionImpl.class.getDeclaredMethod("isParentCompartListItem", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = TableCompositePartitionImpl.class.getDeclaredMethod("getTopofStack", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS SCHEMA_OBJ;
            public static final /* enum */ CHILD_ELEMENTS SUBPARTS;
            public static final /* enum */ CHILD_ELEMENTS SUBPARTS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS LOBS;
            public static final /* enum */ CHILD_ELEMENTS LOBS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS COMPART_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                SCHEMA_OBJ = new CHILD_ELEMENTS();
                SUBPARTS = new CHILD_ELEMENTS();
                SUBPARTS_ITEM = new CHILD_ELEMENTS();
                LOBS = new CHILD_ELEMENTS();
                LOBS_ITEM = new CHILD_ELEMENTS();
                COMPART_LIST_ITEM = new CHILD_ELEMENTS();
                TAG_NOTPARSED = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{SCHEMA_OBJ, SUBPARTS, SUBPARTS_ITEM, LOBS, LOBS_ITEM, COMPART_LIST_ITEM, TAG_NOTPARSED};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS PART_NUM;
            public static final /* enum */ LEAF_ELEMENTS HIBOUNDLEN;
            public static final /* enum */ LEAF_ELEMENTS HIBOUNDVAL;
            public static final /* enum */ LEAF_ELEMENTS BHIBOUNDVAL;
            public static final /* enum */ LEAF_ELEMENTS SUBPARTCNT;
            public static final /* enum */ LEAF_ELEMENTS SMATCH_TPL;
            public static final /* enum */ LEAF_ELEMENTS LMATCH_TPL;
            public static final /* enum */ LEAF_ELEMENTS FLAGS;
            public static final /* enum */ LEAF_ELEMENTS DEFPCTFREE;
            public static final /* enum */ LEAF_ELEMENTS SPARE2;
            public static final /* enum */ LEAF_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                PART_NUM = new LEAF_ELEMENTS();
                HIBOUNDLEN = new LEAF_ELEMENTS();
                HIBOUNDVAL = new LEAF_ELEMENTS();
                BHIBOUNDVAL = new LEAF_ELEMENTS();
                SUBPARTCNT = new LEAF_ELEMENTS();
                SMATCH_TPL = new LEAF_ELEMENTS();
                LMATCH_TPL = new LEAF_ELEMENTS();
                FLAGS = new LEAF_ELEMENTS();
                DEFPCTFREE = new LEAF_ELEMENTS();
                SPARE2 = new LEAF_ELEMENTS();
                TAG_NOTPARSED = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{PART_NUM, HIBOUNDLEN, HIBOUNDVAL, BHIBOUNDVAL, SUBPARTCNT, SMATCH_TPL, LMATCH_TPL, FLAGS, DEFPCTFREE, SPARE2, TAG_NOTPARSED};
            }
        }
    }

    private static class StreamTable
    extends MetadataHandler {
        private static final String START_TAG = "<?xml version=\"1.0\"?><ROWSET><ROW>\n  <STRMTABLE_T>";
        private static final String END_TAG = "</STRMTABLE_T></ROW></ROWSET>";
        private final StringBuilder headStreamBuilder = new StringBuilder(576);
        private final ArrayList<StreamColumnImpl> strmColList = new ArrayList();
        private final Map<String, StreamColumnImpl> strmColMap = new HashMap<String, StreamColumnImpl>();
        private final Map<Integer, String> orderedStrmColMap = new TreeMap<Integer, String>();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        StreamTable(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (!this.parents.empty()) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case COL_LIST: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.STRMTABLE_T) break;
                        this.parents.push(string3);
                        break;
                    }
                    case COL_LIST_ITEM: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.COL_LIST) break;
                        StreamColumnImpl streamColumnImpl = new StreamColumnImpl(this, string3, this.delegator);
                        this.strmColList.add(streamColumnImpl);
                        this.setHandler(streamColumnImpl);
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.STRMTABLE_T) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case VERS_MAJOR: 
                    case VERS_MINOR: 
                    case VERS_DPAPI: 
                    case ENDIANNESS: 
                    case CHARSET: 
                    case NCHARSET: 
                    case DBTIMEZONE: 
                    case FDO: 
                    case OBJ_NUM: 
                    case OWNER_NAME: 
                    case NAME: 
                    case PROPERTY: {
                        if (this.headStreamBuilder.length() == 0) {
                            this.headStreamBuilder.append(START_TAG);
                        }
                        this.headStreamBuilder.append('<').append(string3).append('>');
                        this.headStreamBuilder.append(this.contents.toString());
                        this.headStreamBuilder.append("</").append(string3).append('>');
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case COL_LIST: {
                        this.parents.pop();
                        break;
                    }
                    case STRMTABLE_T: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        String getDPStreamMetaXML(Collection<ColumnMetadataImpl> collection) {
            StringBuilder stringBuilder = new StringBuilder(2048);
            stringBuilder.append((CharSequence)this.headStreamBuilder);
            if (this.strmColMap.size() == 0) {
                for (StreamColumnImpl object : this.strmColList) {
                    this.strmColMap.put(object.getName(), object);
                }
                this.strmColList.clear();
            }
            for (Metadata.ColumnMetadata columnMetadata : collection) {
                if (!this.strmColMap.containsKey(columnMetadata.getName())) continue;
                StreamColumnImpl streamColumnImpl = this.strmColMap.get(columnMetadata.getName());
                this.orderedStrmColMap.put(streamColumnImpl.getColNum(), streamColumnImpl.getXMLString());
            }
            stringBuilder.append('<').append(CHILD_ELEMENTS.COL_LIST.name()).append('>');
            for (String string : this.orderedStrmColMap.values()) {
                stringBuilder.append(string);
            }
            stringBuilder.append("</").append(CHILD_ELEMENTS.COL_LIST.name()).append('>');
            stringBuilder.append(END_TAG);
            return stringBuilder.toString();
        }

        static {
            try {
                $$$methodRef$$$3 = StreamTable.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = StreamTable.class.getDeclaredMethod("getDPStreamMetaXML", Collection.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = StreamTable.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = StreamTable.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS COL_LIST;
            public static final /* enum */ CHILD_ELEMENTS COL_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS STRMTABLE_T;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COL_LIST = new CHILD_ELEMENTS();
                COL_LIST_ITEM = new CHILD_ELEMENTS();
                STRMTABLE_T = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{COL_LIST, COL_LIST_ITEM, STRMTABLE_T, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS VERS_MAJOR;
            public static final /* enum */ LEAF_ELEMENTS VERS_MINOR;
            public static final /* enum */ LEAF_ELEMENTS VERS_DPAPI;
            public static final /* enum */ LEAF_ELEMENTS ENDIANNESS;
            public static final /* enum */ LEAF_ELEMENTS CHARSET;
            public static final /* enum */ LEAF_ELEMENTS NCHARSET;
            public static final /* enum */ LEAF_ELEMENTS DBTIMEZONE;
            public static final /* enum */ LEAF_ELEMENTS FDO;
            public static final /* enum */ LEAF_ELEMENTS OBJ_NUM;
            public static final /* enum */ LEAF_ELEMENTS OWNER_NAME;
            public static final /* enum */ LEAF_ELEMENTS NAME;
            public static final /* enum */ LEAF_ELEMENTS PROPERTY;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                VERS_MAJOR = new LEAF_ELEMENTS();
                VERS_MINOR = new LEAF_ELEMENTS();
                VERS_DPAPI = new LEAF_ELEMENTS();
                ENDIANNESS = new LEAF_ELEMENTS();
                CHARSET = new LEAF_ELEMENTS();
                NCHARSET = new LEAF_ELEMENTS();
                DBTIMEZONE = new LEAF_ELEMENTS();
                FDO = new LEAF_ELEMENTS();
                OBJ_NUM = new LEAF_ELEMENTS();
                OWNER_NAME = new LEAF_ELEMENTS();
                NAME = new LEAF_ELEMENTS();
                PROPERTY = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{VERS_MAJOR, VERS_MINOR, VERS_DPAPI, ENDIANNESS, CHARSET, NCHARSET, DBTIMEZONE, FDO, OBJ_NUM, OWNER_NAME, NAME, PROPERTY, NOVALUE};
            }
        }
    }

    private static class StreamColumnImpl
    extends MetadataHandler
    implements Metadata.StreamColumn {
        private static final String CLI_START = "<COL_LIST_ITEM>";
        private static final String CLI_END = "</COL_LIST_ITEM>";
        private String colName = null;
        private int colNum = -1;
        private StringBuilder col_item_builder = new StringBuilder(512);
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        StreamColumnImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.COL_LIST_ITEM) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case TYPEMD: {
                        this.parents.push(string3);
                        break;
                    }
                    case SUBTYPE_LIST: {
                        this.parents.push(string3);
                        break;
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.COL_LIST_ITEM) {
                if (this.col_item_builder.length() == 0) {
                    this.col_item_builder.append(CLI_START);
                }
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case OBJ_NUM: 
                    case COL_NUM: 
                    case INTCOL_NUM: 
                    case SEGCOL_NUM: 
                    case COL_SORTKEY: 
                    case BASE_INTCOL_NUM: 
                    case BASE_COL_TYPE: 
                    case BASE_COL_NAME: 
                    case PROPERTY: 
                    case PROPERTY2: 
                    case NAME: 
                    case ATTRNAME: 
                    case TYPE_NUM: 
                    case LENGTH: 
                    case PRECISION_NUM: 
                    case SCALE: 
                    case NOT_NULL: 
                    case CHARSETID: 
                    case CHARSETFORM: 
                    case CHARLENGTH: 
                    case LOB_PROPERTY: {
                        this.col_item_builder.append('<').append(string3).append('>');
                        this.col_item_builder.append(this.contents.toString());
                        this.col_item_builder.append("</").append(string3).append('>');
                        if (LEAF_ELEMENTS.getName(string3) == LEAF_ELEMENTS.NAME) {
                            this.colName = this.contents.toString();
                            break;
                        }
                        if (LEAF_ELEMENTS.getName(string3) != LEAF_ELEMENTS.COL_NUM) break;
                        this.colNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case TYPEMD: {
                        this.parents.pop();
                        break;
                    }
                    case SUBTYPE_LIST: {
                        this.parents.pop();
                        break;
                    }
                    case COL_LIST_ITEM: {
                        this.col_item_builder.append(CLI_END);
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        @Override
        public String getName() {
            return this.colName;
        }

        @Override
        public int getColNum() {
            return this.colNum;
        }

        String getXMLString() {
            return this.col_item_builder.toString();
        }

        static {
            try {
                $$$methodRef$$$5 = StreamColumnImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = StreamColumnImpl.class.getDeclaredMethod("getXMLString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = StreamColumnImpl.class.getDeclaredMethod("getColNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = StreamColumnImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = StreamColumnImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = StreamColumnImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS TYPEMD;
            public static final /* enum */ CHILD_ELEMENTS COL_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS SUBTYPE_LIST;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                TYPEMD = new CHILD_ELEMENTS();
                COL_LIST_ITEM = new CHILD_ELEMENTS();
                SUBTYPE_LIST = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{TYPEMD, COL_LIST_ITEM, SUBTYPE_LIST, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS OBJ_NUM;
            public static final /* enum */ LEAF_ELEMENTS COL_NUM;
            public static final /* enum */ LEAF_ELEMENTS INTCOL_NUM;
            public static final /* enum */ LEAF_ELEMENTS SEGCOL_NUM;
            public static final /* enum */ LEAF_ELEMENTS COL_SORTKEY;
            public static final /* enum */ LEAF_ELEMENTS BASE_INTCOL_NUM;
            public static final /* enum */ LEAF_ELEMENTS BASE_COL_TYPE;
            public static final /* enum */ LEAF_ELEMENTS PROPERTY;
            public static final /* enum */ LEAF_ELEMENTS PROPERTY2;
            public static final /* enum */ LEAF_ELEMENTS NAME;
            public static final /* enum */ LEAF_ELEMENTS ATTRNAME;
            public static final /* enum */ LEAF_ELEMENTS TYPE_NUM;
            public static final /* enum */ LEAF_ELEMENTS LENGTH;
            public static final /* enum */ LEAF_ELEMENTS PRECISION_NUM;
            public static final /* enum */ LEAF_ELEMENTS SCALE;
            public static final /* enum */ LEAF_ELEMENTS NOT_NULL;
            public static final /* enum */ LEAF_ELEMENTS CHARSETID;
            public static final /* enum */ LEAF_ELEMENTS CHARSETFORM;
            public static final /* enum */ LEAF_ELEMENTS CHARLENGTH;
            public static final /* enum */ LEAF_ELEMENTS LOB_PROPERTY;
            public static final /* enum */ LEAF_ELEMENTS BASE_COL_NAME;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                OBJ_NUM = new LEAF_ELEMENTS();
                COL_NUM = new LEAF_ELEMENTS();
                INTCOL_NUM = new LEAF_ELEMENTS();
                SEGCOL_NUM = new LEAF_ELEMENTS();
                COL_SORTKEY = new LEAF_ELEMENTS();
                BASE_INTCOL_NUM = new LEAF_ELEMENTS();
                BASE_COL_TYPE = new LEAF_ELEMENTS();
                PROPERTY = new LEAF_ELEMENTS();
                PROPERTY2 = new LEAF_ELEMENTS();
                NAME = new LEAF_ELEMENTS();
                ATTRNAME = new LEAF_ELEMENTS();
                TYPE_NUM = new LEAF_ELEMENTS();
                LENGTH = new LEAF_ELEMENTS();
                PRECISION_NUM = new LEAF_ELEMENTS();
                SCALE = new LEAF_ELEMENTS();
                NOT_NULL = new LEAF_ELEMENTS();
                CHARSETID = new LEAF_ELEMENTS();
                CHARSETFORM = new LEAF_ELEMENTS();
                CHARLENGTH = new LEAF_ELEMENTS();
                LOB_PROPERTY = new LEAF_ELEMENTS();
                BASE_COL_NAME = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{OBJ_NUM, COL_NUM, INTCOL_NUM, SEGCOL_NUM, COL_SORTKEY, BASE_INTCOL_NUM, BASE_COL_TYPE, PROPERTY, PROPERTY2, NAME, ATTRNAME, TYPE_NUM, LENGTH, PRECISION_NUM, SCALE, NOT_NULL, CHARSETID, CHARSETFORM, CHARLENGTH, LOB_PROPERTY, BASE_COL_NAME, NOVALUE};
            }
        }
    }

    private static class StorageImpl
    extends MetadataHandler
    implements Metadata.Storage {
        private long flags;
        private static final int ARCH_COMPRESSED = 0xE000000;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        StorageImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.STORAGE) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case FLAGS: {
                        this.flags = Long.parseLong(this.contents.toString());
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case STORAGE: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        @Override
        public long getFlags() {
            return this.flags;
        }

        @Override
        public Metadata.CompressionType getCompressionType() {
            if ((this.flags & 0x800L) != 0L) {
                if ((this.flags & 0xE000000L) != 0L) {
                    if ((this.flags & 0x2000000L) != 0L) {
                        return Metadata.CompressionType.QUERY_LOW;
                    }
                    if ((this.flags & 0x4000000L) != 0L) {
                        return Metadata.CompressionType.QUERY_HIGH;
                    }
                    if ((this.flags & 0x8000000L) != 0L) {
                        return Metadata.CompressionType.ARCHIVE_HIGH;
                    }
                }
                if ((this.flags & 0x1000000L) != 0L) {
                    return Metadata.CompressionType.OLTP;
                }
                return Metadata.CompressionType.BASIC;
            }
            return Metadata.CompressionType.NONE;
        }

        static {
            try {
                $$$methodRef$$$3 = StorageImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = StorageImpl.class.getDeclaredMethod("getCompressionType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = StorageImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = StorageImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS STORAGE;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                STORAGE = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{STORAGE, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS FILE_NUM;
            public static final /* enum */ LEAF_ELEMENTS BLOCK_NUM;
            public static final /* enum */ LEAF_ELEMENTS TYPE_NUM;
            public static final /* enum */ LEAF_ELEMENTS TS_NUM;
            public static final /* enum */ LEAF_ELEMENTS BLOCKS;
            public static final /* enum */ LEAF_ELEMENTS EXTENTS;
            public static final /* enum */ LEAF_ELEMENTS INIEXTS;
            public static final /* enum */ LEAF_ELEMENTS MINEXTS;
            public static final /* enum */ LEAF_ELEMENTS MAXEXTS;
            public static final /* enum */ LEAF_ELEMENTS EXTSIZE;
            public static final /* enum */ LEAF_ELEMENTS EXTPCT;
            public static final /* enum */ LEAF_ELEMENTS USER_NUM;
            public static final /* enum */ LEAF_ELEMENTS LISTS;
            public static final /* enum */ LEAF_ELEMENTS GROUPS;
            public static final /* enum */ LEAF_ELEMENTS BITMAPRANGES;
            public static final /* enum */ LEAF_ELEMENTS CACHEHINT;
            public static final /* enum */ LEAF_ELEMENTS SCANHINT;
            public static final /* enum */ LEAF_ELEMENTS HWMINCR;
            public static final /* enum */ LEAF_ELEMENTS FLAGS;
            public static final /* enum */ LEAF_ELEMENTS SPARE2;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                FILE_NUM = new LEAF_ELEMENTS();
                BLOCK_NUM = new LEAF_ELEMENTS();
                TYPE_NUM = new LEAF_ELEMENTS();
                TS_NUM = new LEAF_ELEMENTS();
                BLOCKS = new LEAF_ELEMENTS();
                EXTENTS = new LEAF_ELEMENTS();
                INIEXTS = new LEAF_ELEMENTS();
                MINEXTS = new LEAF_ELEMENTS();
                MAXEXTS = new LEAF_ELEMENTS();
                EXTSIZE = new LEAF_ELEMENTS();
                EXTPCT = new LEAF_ELEMENTS();
                USER_NUM = new LEAF_ELEMENTS();
                LISTS = new LEAF_ELEMENTS();
                GROUPS = new LEAF_ELEMENTS();
                BITMAPRANGES = new LEAF_ELEMENTS();
                CACHEHINT = new LEAF_ELEMENTS();
                SCANHINT = new LEAF_ELEMENTS();
                HWMINCR = new LEAF_ELEMENTS();
                FLAGS = new LEAF_ELEMENTS();
                SPARE2 = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{FILE_NUM, BLOCK_NUM, TYPE_NUM, TS_NUM, BLOCKS, EXTENTS, INIEXTS, MINEXTS, MAXEXTS, EXTSIZE, EXTPCT, USER_NUM, LISTS, GROUPS, BITMAPRANGES, CACHEHINT, SCANHINT, HWMINCR, FLAGS, SPARE2, NOVALUE};
            }
        }
    }

    private static class SimpleColumnImpl
    extends MetadataHandler
    implements Metadata.SimpleColumn {
        private boolean seenColNum = false;
        private boolean seenTypeNum = false;
        private boolean seenName = false;
        private boolean seenProperty = false;
        private int colNum;
        private int property;
        private String name = null;
        private int typeNum;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        SimpleColumnImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.COL) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case COL_NUM: {
                        this.seenColNum = true;
                        this.colNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PROPERTY: {
                        this.seenProperty = true;
                        this.property = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case NAME: {
                        this.seenName = true;
                        this.name = this.contents.toString();
                        break;
                    }
                    case TYPE_NUM: {
                        this.seenTypeNum = true;
                        this.typeNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case COL: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        @Override
        public int getColumnNum() {
            return this.colNum;
        }

        @Override
        public int getProperty() {
            return this.property;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getTypeNum() {
            return this.typeNum;
        }

        public boolean isValid() {
            return this.seenColNum && this.seenTypeNum && this.seenName && this.seenProperty;
        }

        static {
            try {
                $$$methodRef$$$6 = SimpleColumnImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = SimpleColumnImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = SimpleColumnImpl.class.getDeclaredMethod("getTypeNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = SimpleColumnImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = SimpleColumnImpl.class.getDeclaredMethod("getProperty", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = SimpleColumnImpl.class.getDeclaredMethod("getColumnNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = SimpleColumnImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS COL;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COL = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{COL, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS COL_NUM;
            public static final /* enum */ LEAF_ELEMENTS PROPERTY;
            public static final /* enum */ LEAF_ELEMENTS NAME;
            public static final /* enum */ LEAF_ELEMENTS TYPE_NUM;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COL_NUM = new LEAF_ELEMENTS();
                PROPERTY = new LEAF_ELEMENTS();
                NAME = new LEAF_ELEMENTS();
                TYPE_NUM = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{COL_NUM, PROPERTY, NAME, TYPE_NUM, NOVALUE};
            }
        }
    }

    private static class SchemaImpl
    extends MetadataHandler
    implements Metadata.Schema {
        private boolean seenObjNum = false;
        private boolean seenOwnerNum = false;
        private boolean seenOwnerName = false;
        private boolean seenName = false;
        private boolean seenSubname = false;
        private boolean seenTypeNum = false;
        private boolean seenTypeName = false;
        private boolean seenCtime = false;
        private boolean seenMtime = false;
        private boolean seenStime = false;
        private int objNum = 0;
        private int ownerNum = 0;
        private String ownerName = null;
        private String name = null;
        private String subName = null;
        private int typeNum = 0;
        private String typeName = null;
        private Timestamp ctime = null;
        private Timestamp mtime = null;
        private Timestamp stime = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;

        SchemaImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.SCHEMA_OBJ) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case OBJ_NUM: {
                        this.seenObjNum = true;
                        this.objNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case OWNER_NUM: {
                        this.seenOwnerNum = true;
                        this.ownerNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case OWNER_NAME: {
                        this.seenOwnerName = true;
                        this.ownerName = this.contents.toString();
                        break;
                    }
                    case NAME: {
                        this.seenName = true;
                        this.name = this.contents.toString();
                        break;
                    }
                    case SUBNAME: {
                        this.seenSubname = true;
                        this.subName = this.contents.toString();
                        break;
                    }
                    case TYPE_NUM: {
                        this.seenTypeNum = true;
                        this.typeNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case TYPE_NAME: {
                        this.seenTypeName = true;
                        this.typeName = this.contents.toString();
                        break;
                    }
                    case CTIME: {
                        this.seenCtime = true;
                        String string4 = this.contents.toString();
                        this.ctime = this.createTimestamp(string4);
                        break;
                    }
                    case MTIME: {
                        this.seenMtime = true;
                        String string5 = this.contents.toString();
                        this.mtime = this.createTimestamp(string5);
                        break;
                    }
                    case STIME: {
                        this.seenStime = true;
                        String string6 = this.contents.toString();
                        this.stime = this.createTimestamp(string6);
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case SCHEMA_OBJ: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        @Override
        public Timestamp createTimestamp(String string) {
            try {
                return Timestamp.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        @Override
        public boolean isTable() {
            return this.getTypeNum() == Metadata.SchemaType.TABLE.getType();
        }

        @Override
        public boolean isTablePartition() {
            return this.getTypeNum() == Metadata.SchemaType.TABLE_PARTITION.getType();
        }

        @Override
        public boolean isTableSubPartition() {
            return this.getTypeNum() == Metadata.SchemaType.TABLE_SUBPARTITION.getType();
        }

        @Override
        public boolean isLOB() {
            return this.getTypeNum() == Metadata.SchemaType.LOB.getType();
        }

        @Override
        public boolean isLOBPartition() {
            return this.getTypeNum() == Metadata.SchemaType.LOB_PARTITION.getType();
        }

        @Override
        public boolean isLOBSubPartition() {
            return this.getTypeNum() == Metadata.SchemaType.LOB_SUBPARTITION.getType();
        }

        @Override
        public int getObjNum() {
            return this.objNum;
        }

        @Override
        public int getOwnerNum() {
            return this.ownerNum;
        }

        @Override
        public String getOwnerName() {
            return this.ownerName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getTypeNum() {
            return this.typeNum;
        }

        @Override
        public Metadata.SchemaType getType() {
            return Metadata.SchemaType.getName(this.typeNum);
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public Timestamp getCreationTime() {
            return this.ctime;
        }

        @Override
        public Timestamp getDDLModificationTime() {
            return this.mtime;
        }

        @Override
        public Timestamp getSpecTime() {
            return this.stime;
        }

        @Override
        public String getSubName() {
            return this.subName;
        }

        boolean isValid() {
            return this.seenObjNum && this.seenOwnerNum && this.seenOwnerName && this.seenName && this.seenSubname && this.seenTypeNum && this.seenTypeName && this.seenCtime && this.seenMtime && this.seenStime;
        }

        static {
            try {
                $$$methodRef$$$20 = SchemaImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$19 = SchemaImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$18 = SchemaImpl.class.getDeclaredMethod("getSubName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = SchemaImpl.class.getDeclaredMethod("getSpecTime", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = SchemaImpl.class.getDeclaredMethod("getDDLModificationTime", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = SchemaImpl.class.getDeclaredMethod("getCreationTime", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = SchemaImpl.class.getDeclaredMethod("getTypeName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = SchemaImpl.class.getDeclaredMethod("getType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = SchemaImpl.class.getDeclaredMethod("getTypeNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = SchemaImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = SchemaImpl.class.getDeclaredMethod("getOwnerName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = SchemaImpl.class.getDeclaredMethod("getOwnerNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = SchemaImpl.class.getDeclaredMethod("getObjNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = SchemaImpl.class.getDeclaredMethod("isLOBSubPartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = SchemaImpl.class.getDeclaredMethod("isLOBPartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = SchemaImpl.class.getDeclaredMethod("isLOB", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = SchemaImpl.class.getDeclaredMethod("isTableSubPartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = SchemaImpl.class.getDeclaredMethod("isTablePartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = SchemaImpl.class.getDeclaredMethod("isTable", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = SchemaImpl.class.getDeclaredMethod("createTimestamp", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = SchemaImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS SCHEMA_OBJ;
            public static final /* enum */ CHILD_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                SCHEMA_OBJ = new CHILD_ELEMENTS();
                TAG_NOTPARSED = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{SCHEMA_OBJ, TAG_NOTPARSED};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS OBJ_NUM;
            public static final /* enum */ LEAF_ELEMENTS OWNER_NUM;
            public static final /* enum */ LEAF_ELEMENTS OWNER_NAME;
            public static final /* enum */ LEAF_ELEMENTS NAME;
            public static final /* enum */ LEAF_ELEMENTS SUBNAME;
            public static final /* enum */ LEAF_ELEMENTS TYPE_NUM;
            public static final /* enum */ LEAF_ELEMENTS TYPE_NAME;
            public static final /* enum */ LEAF_ELEMENTS CTIME;
            public static final /* enum */ LEAF_ELEMENTS MTIME;
            public static final /* enum */ LEAF_ELEMENTS STIME;
            public static final /* enum */ LEAF_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                OBJ_NUM = new LEAF_ELEMENTS();
                OWNER_NUM = new LEAF_ELEMENTS();
                OWNER_NAME = new LEAF_ELEMENTS();
                NAME = new LEAF_ELEMENTS();
                SUBNAME = new LEAF_ELEMENTS();
                TYPE_NUM = new LEAF_ELEMENTS();
                TYPE_NAME = new LEAF_ELEMENTS();
                CTIME = new LEAF_ELEMENTS();
                MTIME = new LEAF_ELEMENTS();
                STIME = new LEAF_ELEMENTS();
                TAG_NOTPARSED = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{OBJ_NUM, OWNER_NUM, OWNER_NAME, NAME, SUBNAME, TYPE_NUM, TYPE_NAME, CTIME, MTIME, STIME, TAG_NOTPARSED};
            }
        }
    }

    private static class PartitionImpl
    extends MetadataHandler
    implements Metadata.Partition {
        public static final int KKPACFRAGF_INTFRAG = 32768;
        public static final int KKPACFRAGF_DEFAULT = 16384;
        private BasePartitionImpl partObj = null;
        private final Vector<Metadata.PartitionColumn> partitionColumns = new Vector();
        private final Vector<Metadata.PartitionColumn> subPartCols = new Vector();
        private Vector<Metadata.TablePartition> partititonList = new Vector();
        private final Vector<Metadata.TableCompositePartition> compartList = new Vector();
        private final Vector<Metadata.TemplateSubPartition> tSubParts = new Vector();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;

        PartitionImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public BasePartitionImpl getBasePartition() {
            return this.partObj;
        }

        @Override
        public Collection<Metadata.PartitionColumn> getPartitionColumns() {
            return this.partitionColumns;
        }

        @Override
        public Collection<Metadata.PartitionColumn> getSubpartitionColumns() {
            return this.subPartCols;
        }

        @Override
        public Collection<Metadata.TablePartition> getPartitions() {
            return this.partititonList;
        }

        @Override
        public Collection<Metadata.TableCompositePartition> getCompositePartitions() {
            return this.compartList;
        }

        @Override
        public Collection<Metadata.TemplateSubPartition> getTemplateSubPartitions() {
            return this.tSubParts;
        }

        @Override
        public Metadata.PartitionType getPartitionType() {
            return this.getBasePartition().getPartitionType();
        }

        @Override
        public Metadata.PartitionType getSubpartitionType() {
            return this.getBasePartition().getSubpartitionType();
        }

        @Override
        public int getPartType() {
            return this.getBasePartition().getPartType();
        }

        @Override
        public boolean isCompositePartition() {
            return this.getBasePartition().isCompositePartition();
        }

        @Override
        public boolean isIntervalPartition() {
            return this.getBasePartition().isIntervalPartition();
        }

        @Override
        public int getSubpartType() {
            return this.getBasePartition().getSubpartType();
        }

        @Override
        public int getDefSubpartitionCount() {
            return this.getBasePartition().getDefSubpartitionCount();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            switch (CHILD_ELEMENTS.getName(string3)) {
                case PARTOBJ: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.PART_OBJ) break;
                    this.partObj = new BasePartitionImpl(this, string3, this.delegator);
                    this.setHandler(this.partObj);
                    break;
                }
                case PARTCOLS: 
                case PART_LIST: 
                case SUBPARTCOLS: 
                case TSUBPARTS: 
                case COMPART_LIST: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.PART_OBJ) break;
                    this.parents.push(string3);
                    break;
                }
                case PARTCOLS_ITEM: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.PARTCOLS) break;
                    PartitionColumnImpl partitionColumnImpl = new PartitionColumnImpl(this, string3, this.delegator);
                    this.partitionColumns.add(partitionColumnImpl);
                    this.setHandler(partitionColumnImpl);
                    break;
                }
                case SUBPARTCOLS_ITEM: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.SUBPARTCOLS) break;
                    PartitionColumnImpl partitionColumnImpl = new PartitionColumnImpl(this, string3, this.delegator);
                    this.subPartCols.add(partitionColumnImpl);
                    this.setHandler(partitionColumnImpl);
                    break;
                }
                case PART_LIST_ITEM: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.PART_LIST) break;
                    TablePartitionImpl tablePartitionImpl = new TablePartitionImpl(this, string3, this.delegator);
                    this.partititonList.add(tablePartitionImpl);
                    this.setHandler(tablePartitionImpl);
                    break;
                }
                case COMPART_LIST_ITEM: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.COMPART_LIST) break;
                    TableCompositePartitionImpl tableCompositePartitionImpl = new TableCompositePartitionImpl(this, string3, this.delegator);
                    this.compartList.add(tableCompositePartitionImpl);
                    this.setHandler(tableCompositePartitionImpl);
                    break;
                }
                case TSUBPARTS_ITEM: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.TSUBPARTS) break;
                    TemplateSubPartitionImpl templateSubPartitionImpl = new TemplateSubPartitionImpl(this, string3, this.delegator);
                    this.tSubParts.add(templateSubPartitionImpl);
                    this.setHandler(templateSubPartitionImpl);
                    break;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case PART_LIST: {
                        this.removeDynamicPartitions();
                        this.parents.pop();
                        break;
                    }
                    case PARTCOLS: 
                    case SUBPARTCOLS: 
                    case TSUBPARTS: 
                    case COMPART_LIST: {
                        this.parents.pop();
                        break;
                    }
                    case PART_OBJ: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        private void removeDynamicPartitions() {
            Vector<Metadata.TablePartition> vector = new Vector<Metadata.TablePartition>();
            for (Metadata.TablePartition tablePartition : this.partititonList) {
                if (!tablePartition.isPartitionStaticallyDefined()) continue;
                vector.add(tablePartition);
            }
            this.partititonList = vector;
        }

        boolean isValid() {
            if (!this.getBasePartition().isValid()) {
                return false;
            }
            if (this.getPartitionColumns() == null || this.getPartitionColumns().size() == 0) {
                return false;
            }
            Iterator<Object> iterator = this.getPartitionColumns().iterator();
            while (iterator.hasNext()) {
                if (((PartitionColumnImpl)iterator.next()).isValid()) continue;
                return false;
            }
            if (this.getSubpartitionColumns() != null && this.getSubpartitionColumns().size() > 0) {
                iterator = this.getSubpartitionColumns().iterator();
                while (iterator.hasNext()) {
                    if (((PartitionColumnImpl)iterator.next()).isValid()) continue;
                    return false;
                }
            }
            if (this.getPartitions() == null && this.getCompositePartitions() == null) {
                return false;
            }
            if (this.getPartitions().size() == 0 && this.getCompositePartitions().size() == 0) {
                return false;
            }
            if (this.getPartitions() != null && this.getPartitions().size() > 0) {
                iterator = this.getPartitions().iterator();
                while (iterator.hasNext()) {
                    if (((TablePartitionImpl)iterator.next()).isValid()) continue;
                    return false;
                }
            }
            if (this.getCompositePartitions() != null && this.getCompositePartitions().size() > 0) {
                iterator = this.getCompositePartitions().iterator();
                while (iterator.hasNext()) {
                    if (((TableCompositePartitionImpl)iterator.next()).isValid()) continue;
                    return false;
                }
            }
            return true;
        }

        static {
            try {
                $$$methodRef$$$18 = PartitionImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = PartitionImpl.class.getDeclaredMethod("getBasePartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = PartitionImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = PartitionImpl.class.getDeclaredMethod("removeDynamicPartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = PartitionImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = PartitionImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = PartitionImpl.class.getDeclaredMethod("getDefSubpartitionCount", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = PartitionImpl.class.getDeclaredMethod("getSubpartType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = PartitionImpl.class.getDeclaredMethod("isIntervalPartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = PartitionImpl.class.getDeclaredMethod("isCompositePartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = PartitionImpl.class.getDeclaredMethod("getPartType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = PartitionImpl.class.getDeclaredMethod("getSubpartitionType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = PartitionImpl.class.getDeclaredMethod("getPartitionType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = PartitionImpl.class.getDeclaredMethod("getTemplateSubPartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = PartitionImpl.class.getDeclaredMethod("getCompositePartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = PartitionImpl.class.getDeclaredMethod("getPartitions", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = PartitionImpl.class.getDeclaredMethod("getSubpartitionColumns", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = PartitionImpl.class.getDeclaredMethod("getPartitionColumns", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = PartitionImpl.class.getDeclaredMethod("getBasePartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS PARTOBJ;
            public static final /* enum */ CHILD_ELEMENTS PARTCOLS;
            public static final /* enum */ CHILD_ELEMENTS PARTCOLS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS SUBPARTCOLS;
            public static final /* enum */ CHILD_ELEMENTS SUBPARTCOLS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS PART_LIST;
            public static final /* enum */ CHILD_ELEMENTS PART_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS COMPART_LIST;
            public static final /* enum */ CHILD_ELEMENTS COMPART_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS TSUBPARTS;
            public static final /* enum */ CHILD_ELEMENTS TSUBPARTS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS PART_OBJ;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                PARTOBJ = new CHILD_ELEMENTS();
                PARTCOLS = new CHILD_ELEMENTS();
                PARTCOLS_ITEM = new CHILD_ELEMENTS();
                SUBPARTCOLS = new CHILD_ELEMENTS();
                SUBPARTCOLS_ITEM = new CHILD_ELEMENTS();
                PART_LIST = new CHILD_ELEMENTS();
                PART_LIST_ITEM = new CHILD_ELEMENTS();
                COMPART_LIST = new CHILD_ELEMENTS();
                COMPART_LIST_ITEM = new CHILD_ELEMENTS();
                TSUBPARTS = new CHILD_ELEMENTS();
                TSUBPARTS_ITEM = new CHILD_ELEMENTS();
                PART_OBJ = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{PARTOBJ, PARTCOLS, PARTCOLS_ITEM, SUBPARTCOLS, SUBPARTCOLS_ITEM, PART_LIST, PART_LIST_ITEM, COMPART_LIST, COMPART_LIST_ITEM, TSUBPARTS, TSUBPARTS_ITEM, PART_OBJ, NOVALUE};
            }
        }
    }

    private static class PartitionColumnImpl
    extends MetadataHandler
    implements Metadata.PartitionColumn {
        private boolean seenPosnum = false;
        private boolean seenPartColsEndElement = false;
        private boolean seenSubPartColsEndElement = false;
        private SimpleColumnImpl col = null;
        private int posNum = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        PartitionColumnImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (!this.parents.empty()) {
                switch (CHILD_ELEMENTS.getName((String)this.parents.peek())) {
                    case PARTCOLS_ITEM: 
                    case SUBPARTCOLS_ITEM: {
                        if (CHILD_ELEMENTS.getName(string3) != CHILD_ELEMENTS.COL) break;
                        this.col = new SimpleColumnImpl(this, string3, this.delegator);
                        this.setHandler(this.col);
                        break;
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty()) {
                switch (CHILD_ELEMENTS.getName((String)this.parents.peek())) {
                    case PARTCOLS_ITEM: 
                    case SUBPARTCOLS_ITEM: {
                        if (LEAF_ELEMENTS.getName(string3) != LEAF_ELEMENTS.POS_NUM) break;
                        this.seenPosnum = true;
                        this.posNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case PARTCOLS_ITEM: {
                        this.seenPartColsEndElement = true;
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                    case SUBPARTCOLS_ITEM: {
                        this.seenSubPartColsEndElement = true;
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        @Override
        public SimpleColumnImpl getColumn() {
            return this.col;
        }

        @Override
        public int getPositionNum() {
            return this.posNum;
        }

        boolean isValid() {
            return this.getColumn() != null && this.getColumn().isValid() && this.seenPosnum && (this.seenPartColsEndElement || this.seenSubPartColsEndElement);
        }

        static {
            try {
                $$$methodRef$$$6 = PartitionColumnImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = PartitionColumnImpl.class.getDeclaredMethod("getColumn", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = PartitionColumnImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = PartitionColumnImpl.class.getDeclaredMethod("getPositionNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = PartitionColumnImpl.class.getDeclaredMethod("getColumn", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = PartitionColumnImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = PartitionColumnImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS COL;
            public static final /* enum */ CHILD_ELEMENTS PARTCOLS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS SUBPARTCOLS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COL = new CHILD_ELEMENTS();
                PARTCOLS_ITEM = new CHILD_ELEMENTS();
                SUBPARTCOLS_ITEM = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{COL, PARTCOLS_ITEM, SUBPARTCOLS_ITEM, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS POS_NUM;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                POS_NUM = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{POS_NUM, NOVALUE};
            }
        }
    }

    private static class LobTemplateSubpartitionImpl
    extends MetadataHandler
    implements Metadata.LobTemplateSubpartition {
        private int baseObjNum = 0;
        private String colName = null;
        private int intColNum = 0;
        private int spartPos = 0;
        private int flags = 0;
        private String lobSpartName = null;
        private String tsName = null;
        private int tsNum = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        public LobTemplateSubpartitionImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public int getBaseObjnum() {
            return this.baseObjNum;
        }

        @Override
        public String getColName() {
            return this.colName;
        }

        @Override
        public int getIntColNum() {
            return this.intColNum;
        }

        @Override
        public int getSubpartPos() {
            return this.spartPos;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public String getLobSpartName() {
            return this.lobSpartName;
        }

        @Override
        public String getTablespaceName() {
            return this.tsName;
        }

        @Override
        public int getTablespaceNum() {
            return this.tsNum;
        }

        private boolean isParentTemplateLobsItem() {
            return !this.parents.empty() && TemplateSubPartitionImpl.CHILD_ELEMENTS.valueOf((String)this.parents.peek()) == TemplateSubPartitionImpl.CHILD_ELEMENTS.TLOBS_ITEM;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.isParentTemplateLobsItem()) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case BASE_OBJNUM: {
                        this.baseObjNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case COLNAME: {
                        this.colName = this.contents.toString();
                        break;
                    }
                    case INTCOL_NUM: {
                        this.intColNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPART_POS: {
                        this.spartPos = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case FLAGS: {
                        this.flags = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case LOB_SPART_NAME: {
                        this.lobSpartName = this.contents.toString();
                        break;
                    }
                    case TS_NAME: {
                        this.tsName = this.contents.toString();
                        break;
                    }
                    case TS_NUM: {
                        this.tsNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case TLOBS_ITEM: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                    }
                }
            }
        }

        static {
            try {
                $$$methodRef$$$10 = LobTemplateSubpartitionImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("isParentTemplateLobsItem", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("getTablespaceNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("getTablespaceName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("getLobSpartName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("getSubpartPos", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("getIntColNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("getColName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = LobTemplateSubpartitionImpl.class.getDeclaredMethod("getBaseObjnum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS BASE_OBJNUM;
            public static final /* enum */ LEAF_ELEMENTS COLNAME;
            public static final /* enum */ LEAF_ELEMENTS INTCOL_NUM;
            public static final /* enum */ LEAF_ELEMENTS SPART_POS;
            public static final /* enum */ LEAF_ELEMENTS FLAGS;
            public static final /* enum */ LEAF_ELEMENTS LOB_SPART_NAME;
            public static final /* enum */ LEAF_ELEMENTS TS_NAME;
            public static final /* enum */ LEAF_ELEMENTS TS_NUM;
            public static final /* enum */ LEAF_ELEMENTS TLOBS_ITEM;
            public static final /* enum */ LEAF_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                BASE_OBJNUM = new LEAF_ELEMENTS();
                COLNAME = new LEAF_ELEMENTS();
                INTCOL_NUM = new LEAF_ELEMENTS();
                SPART_POS = new LEAF_ELEMENTS();
                FLAGS = new LEAF_ELEMENTS();
                LOB_SPART_NAME = new LEAF_ELEMENTS();
                TS_NAME = new LEAF_ELEMENTS();
                TS_NUM = new LEAF_ELEMENTS();
                TLOBS_ITEM = new LEAF_ELEMENTS();
                TAG_NOTPARSED = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{BASE_OBJNUM, COLNAME, INTCOL_NUM, SPART_POS, FLAGS, LOB_SPART_NAME, TS_NAME, TS_NUM, TLOBS_ITEM, TAG_NOTPARSED};
            }
        }
    }

    private static class LobPartitionImpl
    extends MetadataHandler
    implements Metadata.LobPartition {
        private int partitioningNum = 0;
        private SchemaImpl schemaObj = null;
        private String defaultTableSpaceName = null;
        private int defaultBlockSize = 0;
        private int defaultChunk = 0;
        private int defaultPctVersion = 0;
        private int defFlags = 0;
        private int defaultPartitionProperty = 0;
        private int defIniExts = 0;
        private int defaultExtentSize = 0;
        private int defMinExts = 0;
        private int defMaxExts = 0;
        private int defExtPct = 0;
        private int defLists = 0;
        private int defGroups = 0;
        private int defBufPool = 0;
        private int spare1 = 0;
        private int spare2 = 0;
        private int spare3 = 0;
        private int defMaxSize = 0;
        private int defretention = 0;
        private int defmintime = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;
        private static Executable $$$methodRef$$$28;
        private static Logger $$$loggerRef$$$28;
        private static Executable $$$methodRef$$$29;
        private static Logger $$$loggerRef$$$29;

        LobPartitionImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public boolean hasPartNum() {
            return this.getPartNum() != 0;
        }

        @Override
        public int getPartNum() {
            return this.partitioningNum;
        }

        @Override
        public SchemaImpl getSchema() {
            return this.schemaObj;
        }

        @Override
        public String getDefaultTablespaceName() {
            return this.defaultTableSpaceName;
        }

        @Override
        public int getDefaultBlocksize() {
            return this.defaultBlockSize;
        }

        @Override
        public int getDefaultChunk() {
            return this.defaultChunk;
        }

        @Override
        public int getDefaultPctVersion() {
            return this.defaultPctVersion;
        }

        @Override
        public int getDefaultFlags() {
            return this.defFlags;
        }

        @Override
        public int getDefaultPartitionProperty() {
            return this.defaultPartitionProperty;
        }

        @Override
        public int getDefaultIntialExtentSize() {
            return this.defIniExts;
        }

        @Override
        public int getDefaultNextExtentSize() {
            return this.defaultExtentSize;
        }

        @Override
        public int getDefaultMinExtents() {
            return this.defMinExts;
        }

        @Override
        public int getDefaultMaxExtents() {
            return this.defMaxExts;
        }

        @Override
        public int getDefaultPctIncrease() {
            return this.defExtPct;
        }

        @Override
        public int getDefaultFreelists() {
            return this.defLists;
        }

        @Override
        public int getDefaultFreelistGroups() {
            return this.defGroups;
        }

        @Override
        public int getDefaultBufferPool() {
            return this.defBufPool;
        }

        @Override
        public int getSpare1() {
            return this.spare1;
        }

        @Override
        public int getSpare2() {
            return this.spare2;
        }

        @Override
        public int getSpare3() {
            return this.spare3;
        }

        @Override
        public int getDefaultMaxSize() {
            return this.defMaxSize;
        }

        @Override
        public int getDefaultRetention() {
            return this.defretention;
        }

        @Override
        public int getDefaultMinRetentionTime() {
            return this.defmintime;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (this.processChildren()) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case SCHEMA_OBJ: {
                        this.schemaObj = new SchemaImpl(this, string3, this.delegator);
                        this.setHandler(this.schemaObj);
                        break;
                    }
                }
            }
        }

        private CHILD_ELEMENTS getTopofStack() {
            if (!this.parents.empty()) {
                return CHILD_ELEMENTS.getName((String)this.parents.peek());
            }
            return null;
        }

        private boolean processChildren() {
            return this.processChildren(this.getTopofStack());
        }

        private boolean processChildren(CHILD_ELEMENTS cHILD_ELEMENTS) {
            return cHILD_ELEMENTS == CHILD_ELEMENTS.PLOBMD || cHILD_ELEMENTS == CHILD_ELEMENTS.LOBS_ITEM;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.processChildren()) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case PART_NUM: {
                        this.partitioningNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFTS_NAME: {
                        this.defaultTableSpaceName = this.contents.toString();
                        break;
                    }
                    case DEFBLOCKSIZE: {
                        this.defaultBlockSize = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFCHUNK: {
                        this.defaultChunk = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFPCTVERSION: {
                        this.defaultPctVersion = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFFLAGS: {
                        this.defFlags = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFPRO: {
                        this.defaultPartitionProperty = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFINIEXTS: {
                        this.defIniExts = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFEXTSIZE: {
                        this.defaultExtentSize = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFMINEXTS: {
                        this.defMinExts = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFMAXEXTS: {
                        this.defMaxExts = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFEXTPCT: {
                        this.defExtPct = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFLISTS: {
                        this.defLists = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFGROUPS: {
                        this.defGroups = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFBUFPOOL: {
                        this.defBufPool = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE1: {
                        this.spare1 = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE2: {
                        this.spare2 = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE3: {
                        this.spare3 = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFMAXSIZE: {
                        this.defMaxSize = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFRETENTION: {
                        this.defretention = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFMINTIME: {
                        this.defmintime = Integer.parseInt(this.contents.toString());
                        break;
                    }
                }
                if (this.getTopofStack() == CHILD_ELEMENTS.getName(string3)) {
                    switch (CHILD_ELEMENTS.getName(string3)) {
                        case PLOBMD: 
                        case LOBS_ITEM: {
                            this.parents.pop();
                            this.setHandler(this.parent);
                            break;
                        }
                    }
                }
            }
        }

        static {
            try {
                $$$methodRef$$$29 = LobPartitionImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$28 = LobPartitionImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$27 = LobPartitionImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$26 = LobPartitionImpl.class.getDeclaredMethod("processChildren", CHILD_ELEMENTS.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$25 = LobPartitionImpl.class.getDeclaredMethod("processChildren", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$24 = LobPartitionImpl.class.getDeclaredMethod("getTopofStack", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$23 = LobPartitionImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$22 = LobPartitionImpl.class.getDeclaredMethod("getDefaultMinRetentionTime", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$21 = LobPartitionImpl.class.getDeclaredMethod("getDefaultRetention", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$20 = LobPartitionImpl.class.getDeclaredMethod("getDefaultMaxSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$19 = LobPartitionImpl.class.getDeclaredMethod("getSpare3", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$18 = LobPartitionImpl.class.getDeclaredMethod("getSpare2", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = LobPartitionImpl.class.getDeclaredMethod("getSpare1", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = LobPartitionImpl.class.getDeclaredMethod("getDefaultBufferPool", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = LobPartitionImpl.class.getDeclaredMethod("getDefaultFreelistGroups", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = LobPartitionImpl.class.getDeclaredMethod("getDefaultFreelists", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = LobPartitionImpl.class.getDeclaredMethod("getDefaultPctIncrease", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = LobPartitionImpl.class.getDeclaredMethod("getDefaultMaxExtents", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = LobPartitionImpl.class.getDeclaredMethod("getDefaultMinExtents", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = LobPartitionImpl.class.getDeclaredMethod("getDefaultNextExtentSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = LobPartitionImpl.class.getDeclaredMethod("getDefaultIntialExtentSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = LobPartitionImpl.class.getDeclaredMethod("getDefaultPartitionProperty", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = LobPartitionImpl.class.getDeclaredMethod("getDefaultFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = LobPartitionImpl.class.getDeclaredMethod("getDefaultPctVersion", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = LobPartitionImpl.class.getDeclaredMethod("getDefaultChunk", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = LobPartitionImpl.class.getDeclaredMethod("getDefaultBlocksize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = LobPartitionImpl.class.getDeclaredMethod("getDefaultTablespaceName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = LobPartitionImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = LobPartitionImpl.class.getDeclaredMethod("getPartNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = LobPartitionImpl.class.getDeclaredMethod("hasPartNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS PART_NUM;
            public static final /* enum */ LEAF_ELEMENTS DEFTS_NAME;
            public static final /* enum */ LEAF_ELEMENTS DEFBLOCKSIZE;
            public static final /* enum */ LEAF_ELEMENTS DEFCHUNK;
            public static final /* enum */ LEAF_ELEMENTS DEFPCTVERSION;
            public static final /* enum */ LEAF_ELEMENTS DEFFLAGS;
            public static final /* enum */ LEAF_ELEMENTS DEFPRO;
            public static final /* enum */ LEAF_ELEMENTS DEFINIEXTS;
            public static final /* enum */ LEAF_ELEMENTS DEFEXTSIZE;
            public static final /* enum */ LEAF_ELEMENTS DEFMINEXTS;
            public static final /* enum */ LEAF_ELEMENTS DEFMAXEXTS;
            public static final /* enum */ LEAF_ELEMENTS DEFEXTPCT;
            public static final /* enum */ LEAF_ELEMENTS DEFLISTS;
            public static final /* enum */ LEAF_ELEMENTS DEFGROUPS;
            public static final /* enum */ LEAF_ELEMENTS DEFBUFPOOL;
            public static final /* enum */ LEAF_ELEMENTS SPARE1;
            public static final /* enum */ LEAF_ELEMENTS SPARE2;
            public static final /* enum */ LEAF_ELEMENTS SPARE3;
            public static final /* enum */ LEAF_ELEMENTS DEFMAXSIZE;
            public static final /* enum */ LEAF_ELEMENTS DEFRETENTION;
            public static final /* enum */ LEAF_ELEMENTS DEFMINTIME;
            public static final /* enum */ LEAF_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                PART_NUM = new LEAF_ELEMENTS();
                DEFTS_NAME = new LEAF_ELEMENTS();
                DEFBLOCKSIZE = new LEAF_ELEMENTS();
                DEFCHUNK = new LEAF_ELEMENTS();
                DEFPCTVERSION = new LEAF_ELEMENTS();
                DEFFLAGS = new LEAF_ELEMENTS();
                DEFPRO = new LEAF_ELEMENTS();
                DEFINIEXTS = new LEAF_ELEMENTS();
                DEFEXTSIZE = new LEAF_ELEMENTS();
                DEFMINEXTS = new LEAF_ELEMENTS();
                DEFMAXEXTS = new LEAF_ELEMENTS();
                DEFEXTPCT = new LEAF_ELEMENTS();
                DEFLISTS = new LEAF_ELEMENTS();
                DEFGROUPS = new LEAF_ELEMENTS();
                DEFBUFPOOL = new LEAF_ELEMENTS();
                SPARE1 = new LEAF_ELEMENTS();
                SPARE2 = new LEAF_ELEMENTS();
                SPARE3 = new LEAF_ELEMENTS();
                DEFMAXSIZE = new LEAF_ELEMENTS();
                DEFRETENTION = new LEAF_ELEMENTS();
                DEFMINTIME = new LEAF_ELEMENTS();
                TAG_NOTPARSED = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{PART_NUM, DEFTS_NAME, DEFBLOCKSIZE, DEFCHUNK, DEFPCTVERSION, DEFFLAGS, DEFPRO, DEFINIEXTS, DEFEXTSIZE, DEFMINEXTS, DEFMAXEXTS, DEFEXTPCT, DEFLISTS, DEFGROUPS, DEFBUFPOOL, SPARE1, SPARE2, SPARE3, DEFMAXSIZE, DEFRETENTION, DEFMINTIME, TAG_NOTPARSED};
            }
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS PLOBMD;
            public static final /* enum */ CHILD_ELEMENTS LOBS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS SCHEMA_OBJ;
            public static final /* enum */ CHILD_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                PLOBMD = new CHILD_ELEMENTS();
                LOBS_ITEM = new CHILD_ELEMENTS();
                SCHEMA_OBJ = new CHILD_ELEMENTS();
                TAG_NOTPARSED = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{PLOBMD, LOBS_ITEM, SCHEMA_OBJ, TAG_NOTPARSED};
            }
        }
    }

    private static class LobImpl
    extends MetadataHandler
    implements Metadata.Lob {
        private int partitionNum = 0;
        private int property = 0;
        private int columnNum = 0;
        private SchemaImpl schemaObj = null;
        private StorageImpl storage = null;
        private DeferredStorageImpl deferredStg = null;
        private String tableSpaceName = null;
        private int blockSize = 0;
        private int chunk = 0;
        private int pctVersion = 0;
        private int flags = 0;
        private int retention = 0;
        private int freePools = 0;
        private int spare1 = 0;
        private int spare2 = 0;
        private String spare3 = null;
        private int spare3Num = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;

        LobImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public int getPartNum() {
            return this.partitionNum;
        }

        @Override
        public int getColNum() {
            return this.columnNum;
        }

        @Override
        public SchemaImpl getSchema() {
            return this.schemaObj;
        }

        @Override
        public StorageImpl getStorage() {
            return this.storage;
        }

        @Override
        public DeferredStorageImpl getDeferredStorage() {
            return this.deferredStg;
        }

        @Override
        public String getTablespaceName() {
            return this.tableSpaceName;
        }

        @Override
        public int getBlocksize() {
            return this.blockSize;
        }

        @Override
        public int getChunk() {
            return this.chunk;
        }

        @Override
        public int getPctVersion() {
            return this.pctVersion;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public int getProperty() {
            return this.property;
        }

        @Override
        public int getRetentionTime() {
            return this.retention;
        }

        @Override
        public int getFreepools() {
            return this.freePools;
        }

        @Override
        public int getSpare1() {
            return this.spare1;
        }

        @Override
        public int getSpare2() {
            return this.spare2;
        }

        @Override
        public String getSpare3() {
            return this.spare3;
        }

        @Override
        public int getSpare3Num() {
            return this.spare3Num;
        }

        @Override
        public boolean isPartitioned() {
            return 0 != this.getPartNum();
        }

        private CHILD_ELEMENTS getTopofStack() {
            if (!this.parents.empty()) {
                return CHILD_ELEMENTS.getName((String)this.parents.peek());
            }
            return null;
        }

        private boolean processChildren(CHILD_ELEMENTS cHILD_ELEMENTS) {
            return cHILD_ELEMENTS == CHILD_ELEMENTS.LOBMD || cHILD_ELEMENTS == CHILD_ELEMENTS.LOBS_ITEM;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (this.processChildren(this.getTopofStack())) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case SCHEMA_OBJ: {
                        this.schemaObj = new SchemaImpl(this, string3, this.delegator);
                        this.setHandler(this.schemaObj);
                        break;
                    }
                    case STORAGE: {
                        this.storage = new StorageImpl(this, string3, this.delegator);
                        this.setHandler(this.storage);
                        break;
                    }
                    case DEFERRED_STG: {
                        this.deferredStg = new DeferredStorageImpl(this, string3, this.delegator);
                        this.setHandler(this.deferredStg);
                        break;
                    }
                    case LOBINDEX: {
                        this.parents.push(string3);
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.processChildren(this.getTopofStack())) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case COL_NUM: {
                        this.columnNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PART_NUM: {
                        this.partitionNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case TS_NAME: {
                        this.tableSpaceName = this.contents.toString();
                        break;
                    }
                    case BLOCKSIZE: {
                        this.blockSize = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case CHUNK: {
                        this.chunk = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PCTVERSION: {
                        this.pctVersion = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case FLAGS: {
                        this.flags = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PROPERTY: {
                        this.property = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case RETENTION: {
                        this.retention = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case FREEPOOLS: {
                        this.freePools = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE1: {
                        this.spare1 = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE2: {
                        this.spare2 = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE3: {
                        if (this.isPartitioned()) {
                            this.spare3Num = Integer.parseInt(this.contents.toString());
                            break;
                        }
                        this.spare3 = this.contents.toString();
                        break;
                    }
                }
            }
            if (this.getTopofStack() == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case LOBINDEX: {
                        this.parents.pop();
                        break;
                    }
                    case LOBMD: 
                    case LOBS_ITEM: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        static {
            try {
                $$$methodRef$$$25 = LobImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$24 = LobImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$23 = LobImpl.class.getDeclaredMethod("getStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$22 = LobImpl.class.getDeclaredMethod("getDeferredStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$21 = LobImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$20 = LobImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$19 = LobImpl.class.getDeclaredMethod("processChildren", CHILD_ELEMENTS.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$18 = LobImpl.class.getDeclaredMethod("getTopofStack", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = LobImpl.class.getDeclaredMethod("isPartitioned", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = LobImpl.class.getDeclaredMethod("getSpare3Num", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = LobImpl.class.getDeclaredMethod("getSpare3", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = LobImpl.class.getDeclaredMethod("getSpare2", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = LobImpl.class.getDeclaredMethod("getSpare1", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = LobImpl.class.getDeclaredMethod("getFreepools", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = LobImpl.class.getDeclaredMethod("getRetentionTime", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = LobImpl.class.getDeclaredMethod("getProperty", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = LobImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = LobImpl.class.getDeclaredMethod("getPctVersion", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = LobImpl.class.getDeclaredMethod("getChunk", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = LobImpl.class.getDeclaredMethod("getBlocksize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = LobImpl.class.getDeclaredMethod("getTablespaceName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = LobImpl.class.getDeclaredMethod("getDeferredStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = LobImpl.class.getDeclaredMethod("getStorage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = LobImpl.class.getDeclaredMethod("getSchema", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = LobImpl.class.getDeclaredMethod("getColNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = LobImpl.class.getDeclaredMethod("getPartNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS COL_NUM;
            public static final /* enum */ LEAF_ELEMENTS PART_NUM;
            public static final /* enum */ LEAF_ELEMENTS TS_NAME;
            public static final /* enum */ LEAF_ELEMENTS BLOCKSIZE;
            public static final /* enum */ LEAF_ELEMENTS CHUNK;
            public static final /* enum */ LEAF_ELEMENTS PCTVERSION;
            public static final /* enum */ LEAF_ELEMENTS FLAGS;
            public static final /* enum */ LEAF_ELEMENTS PROPERTY;
            public static final /* enum */ LEAF_ELEMENTS RETENTION;
            public static final /* enum */ LEAF_ELEMENTS FREEPOOLS;
            public static final /* enum */ LEAF_ELEMENTS SPARE1;
            public static final /* enum */ LEAF_ELEMENTS SPARE2;
            public static final /* enum */ LEAF_ELEMENTS SPARE3;
            public static final /* enum */ LEAF_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COL_NUM = new LEAF_ELEMENTS();
                PART_NUM = new LEAF_ELEMENTS();
                TS_NAME = new LEAF_ELEMENTS();
                BLOCKSIZE = new LEAF_ELEMENTS();
                CHUNK = new LEAF_ELEMENTS();
                PCTVERSION = new LEAF_ELEMENTS();
                FLAGS = new LEAF_ELEMENTS();
                PROPERTY = new LEAF_ELEMENTS();
                RETENTION = new LEAF_ELEMENTS();
                FREEPOOLS = new LEAF_ELEMENTS();
                SPARE1 = new LEAF_ELEMENTS();
                SPARE2 = new LEAF_ELEMENTS();
                SPARE3 = new LEAF_ELEMENTS();
                TAG_NOTPARSED = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{COL_NUM, PART_NUM, TS_NAME, BLOCKSIZE, CHUNK, PCTVERSION, FLAGS, PROPERTY, RETENTION, FREEPOOLS, SPARE1, SPARE2, SPARE3, TAG_NOTPARSED};
            }
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS SCHEMA_OBJ;
            public static final /* enum */ CHILD_ELEMENTS STORAGE;
            public static final /* enum */ CHILD_ELEMENTS DEFERRED_STG;
            public static final /* enum */ CHILD_ELEMENTS LOBINDEX;
            public static final /* enum */ CHILD_ELEMENTS LOBMD;
            public static final /* enum */ CHILD_ELEMENTS LOBS_ITEM;
            public static final /* enum */ CHILD_ELEMENTS TAG_NOTPARSED;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return TAG_NOTPARSED;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                SCHEMA_OBJ = new CHILD_ELEMENTS();
                STORAGE = new CHILD_ELEMENTS();
                DEFERRED_STG = new CHILD_ELEMENTS();
                LOBINDEX = new CHILD_ELEMENTS();
                LOBMD = new CHILD_ELEMENTS();
                LOBS_ITEM = new CHILD_ELEMENTS();
                TAG_NOTPARSED = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{SCHEMA_OBJ, STORAGE, DEFERRED_STG, LOBINDEX, LOBMD, LOBS_ITEM, TAG_NOTPARSED};
            }
        }
    }

    private static class DeferredStorageImpl
    extends MetadataHandler
    implements Metadata.DeferredStorage {
        private int pctFreeStg;
        private int flagsStg;
        private int compressionFlagStg;
        private int compressionLevelStg;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        DeferredStorageImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.DEFERRED_STG) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case PCTFREE_STG: {
                        this.pctFreeStg = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case FLAGS_STG: {
                        this.flagsStg = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case CMPFLAG_STG: {
                        this.compressionFlagStg = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case CMPLVL_STG: {
                        this.compressionLevelStg = Integer.parseInt(this.contents.toString());
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case DEFERRED_STG: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        @Override
        public int getPctfree() {
            return this.pctFreeStg;
        }

        @Override
        public int getFlags() {
            return this.flagsStg;
        }

        @Override
        public int getCmpFlag() {
            return this.compressionFlagStg;
        }

        @Override
        public int getCmpLvl() {
            return this.compressionLevelStg;
        }

        @Override
        public Metadata.CompressionType getCompressionType() {
            if ((this.flagsStg & 4) != 4) {
                return Metadata.CompressionType.NONE;
            }
            switch (this.compressionFlagStg & 3) {
                case 1: {
                    return Metadata.CompressionType.BASIC;
                }
                case 2: {
                    return Metadata.CompressionType.OLTP;
                }
            }
            switch (this.compressionLevelStg) {
                case 1: {
                    return Metadata.CompressionType.QUERY_LOW;
                }
                case 2: {
                    return Metadata.CompressionType.QUERY_HIGH;
                }
                case 3: {
                    return Metadata.CompressionType.ARCHIVE_LOW;
                }
            }
            return Metadata.CompressionType.ARCHIVE_HIGH;
        }

        static {
            try {
                $$$methodRef$$$6 = DeferredStorageImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = DeferredStorageImpl.class.getDeclaredMethod("getCompressionType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = DeferredStorageImpl.class.getDeclaredMethod("getCmpLvl", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = DeferredStorageImpl.class.getDeclaredMethod("getCmpFlag", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = DeferredStorageImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = DeferredStorageImpl.class.getDeclaredMethod("getPctfree", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = DeferredStorageImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS DEFERRED_STG;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                DEFERRED_STG = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{DEFERRED_STG, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS OBJ_NUM;
            public static final /* enum */ LEAF_ELEMENTS PCTFREE_STG;
            public static final /* enum */ LEAF_ELEMENTS FLAGS_STG;
            public static final /* enum */ LEAF_ELEMENTS CMPFLAG_STG;
            public static final /* enum */ LEAF_ELEMENTS CMPLVL_STG;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                OBJ_NUM = new LEAF_ELEMENTS();
                PCTFREE_STG = new LEAF_ELEMENTS();
                FLAGS_STG = new LEAF_ELEMENTS();
                CMPFLAG_STG = new LEAF_ELEMENTS();
                CMPLVL_STG = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{OBJ_NUM, PCTFREE_STG, FLAGS_STG, CMPFLAG_STG, CMPLVL_STG, NOVALUE};
            }
        }
    }

    private static class ConstraintImpl
    extends MetadataHandler
    implements Metadata.Constraint {
        private boolean seenName = false;
        private boolean seenCon_num = false;
        private boolean seenNumcols = false;
        private boolean seenContype = false;
        private boolean seenEnabled = false;
        private boolean seenMtime = false;
        private boolean seenOid = false;
        private String name;
        private int constraintNum;
        private int numOfColumns;
        private int contraintType;
        private int enabled = 0;
        private String time;
        private int oIdOrSetId;
        private Vector<Metadata.ConstraintColumn> columnsList = new Vector();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;

        ConstraintImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (!this.parents.empty()) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case IND: 
                    case COL_LIST: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.CON1_LIST_ITEM) break;
                        this.parents.push(string3);
                        break;
                    }
                    case COL_LIST_ITEM: {
                        if (CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.COL_LIST) break;
                        ConstraintColumnImpl constraintColumnImpl = new ConstraintColumnImpl(this, string3, this.delegator);
                        this.columnsList.add(constraintColumnImpl);
                        this.setHandler(constraintColumnImpl);
                        break;
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty()) {
                if (CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.CON1_LIST_ITEM) {
                    switch (LEAF_ELEMENTS.getName(string3)) {
                        case NAME: {
                            if (null != this.name) break;
                            this.name = this.contents.toString();
                            this.seenName = true;
                            break;
                        }
                        case CON_NUM: {
                            if (0 != this.constraintNum) break;
                            this.constraintNum = Integer.parseInt(this.contents.toString());
                            this.seenCon_num = true;
                            break;
                        }
                        case NUMCOLS: {
                            if (0 != this.numOfColumns) break;
                            this.numOfColumns = Integer.parseInt(this.contents.toString());
                            this.seenNumcols = true;
                            break;
                        }
                        case CONTYPE: {
                            if (0 != this.contraintType) break;
                            this.contraintType = Integer.parseInt(this.contents.toString());
                            this.seenContype = true;
                            break;
                        }
                        case ENABLED: {
                            if (0 != this.enabled) break;
                            this.enabled = Integer.parseInt(this.contents.toString());
                            this.seenEnabled = true;
                            break;
                        }
                        case MTIME: {
                            if (this.time != null) break;
                            this.time = this.contents.toString();
                            this.seenMtime = true;
                            break;
                        }
                        case OID_OR_SETID: {
                            if (0 != this.oIdOrSetId) break;
                            this.oIdOrSetId = Integer.parseInt(this.contents.toString());
                            this.seenOid = true;
                            break;
                        }
                    }
                }
                if (CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                    switch (CHILD_ELEMENTS.getName(string3)) {
                        case CON1_LIST_ITEM: {
                            this.parents.pop();
                            this.setHandler(this.parent);
                            break;
                        }
                        case IND: 
                        case COL_LIST: {
                            this.parents.pop();
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public boolean isPrimary() {
            return this.contraintType == Metadata.ConstraintType.PRIMARY.getTypecode();
        }

        @Override
        public boolean isUnique() {
            return this.contraintType == Metadata.ConstraintType.UNIQUE.getTypecode();
        }

        boolean isNotNull() {
            return this.contraintType == Metadata.ConstraintType.NOTNULL.getTypecode();
        }

        String getName() {
            return this.name;
        }

        int getId() {
            return this.constraintNum;
        }

        int getColumnCount() {
            return this.numOfColumns;
        }

        int getConType() {
            return this.contraintType;
        }

        @Override
        public Metadata.ConstraintType getType() {
            return Metadata.ConstraintType.getName(this.contraintType);
        }

        boolean isEnabled() {
            return this.enabled != 0;
        }

        String getModificationTime() {
            return this.time;
        }

        int getOid_or_setid() {
            return this.oIdOrSetId;
        }

        @Override
        public Vector<Metadata.ConstraintColumn> getColumns() {
            return this.columnsList;
        }

        boolean isValid() {
            if (!(this.seenName && this.seenCon_num && this.seenNumcols && this.seenContype && this.seenEnabled && this.seenMtime && this.seenOid)) {
                return false;
            }
            if (this.getColumns() == null || this.getColumns().isEmpty()) {
                return false;
            }
            Iterator<Metadata.ConstraintColumn> iterator = this.getColumns().iterator();
            while (iterator.hasNext()) {
                if (((ConstraintColumnImpl)iterator.next()).isValid()) continue;
                return false;
            }
            return true;
        }

        static {
            try {
                $$$methodRef$$$15 = ConstraintImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = ConstraintImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = ConstraintImpl.class.getDeclaredMethod("getColumns", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = ConstraintImpl.class.getDeclaredMethod("getOid_or_setid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = ConstraintImpl.class.getDeclaredMethod("getModificationTime", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = ConstraintImpl.class.getDeclaredMethod("isEnabled", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = ConstraintImpl.class.getDeclaredMethod("getType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = ConstraintImpl.class.getDeclaredMethod("getConType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = ConstraintImpl.class.getDeclaredMethod("getColumnCount", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = ConstraintImpl.class.getDeclaredMethod("getId", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = ConstraintImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = ConstraintImpl.class.getDeclaredMethod("isNotNull", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = ConstraintImpl.class.getDeclaredMethod("isUnique", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = ConstraintImpl.class.getDeclaredMethod("isPrimary", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = ConstraintImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = ConstraintImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS COL_LIST;
            public static final /* enum */ CHILD_ELEMENTS COL_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS IND;
            public static final /* enum */ CHILD_ELEMENTS CON1_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COL_LIST = new CHILD_ELEMENTS();
                COL_LIST_ITEM = new CHILD_ELEMENTS();
                IND = new CHILD_ELEMENTS();
                CON1_LIST_ITEM = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{COL_LIST, COL_LIST_ITEM, IND, CON1_LIST_ITEM, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS NAME;
            public static final /* enum */ LEAF_ELEMENTS CON_NUM;
            public static final /* enum */ LEAF_ELEMENTS NUMCOLS;
            public static final /* enum */ LEAF_ELEMENTS CONTYPE;
            public static final /* enum */ LEAF_ELEMENTS ENABLED;
            public static final /* enum */ LEAF_ELEMENTS MTIME;
            public static final /* enum */ LEAF_ELEMENTS OID_OR_SETID;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                NAME = new LEAF_ELEMENTS();
                CON_NUM = new LEAF_ELEMENTS();
                NUMCOLS = new LEAF_ELEMENTS();
                CONTYPE = new LEAF_ELEMENTS();
                ENABLED = new LEAF_ELEMENTS();
                MTIME = new LEAF_ELEMENTS();
                OID_OR_SETID = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{NAME, CON_NUM, NUMCOLS, CONTYPE, ENABLED, MTIME, OID_OR_SETID, NOVALUE};
            }
        }
    }

    private static class ConstraintColumnImpl
    extends MetadataHandler
    implements Metadata.ConstraintColumn {
        private boolean seenConNum = false;
        private boolean seenPosNum = false;
        private boolean seenOId = false;
        private boolean seenColListItemEndElement = false;
        private int constraintNum;
        private int columnPositionNum;
        private int oIdOrSetId;
        private SimpleColumnImpl col;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        public ConstraintColumnImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            switch (CHILD_ELEMENTS.getName(string3)) {
                case COL: {
                    if (this.parents.empty() || CHILD_ELEMENTS.getName((String)this.parents.peek()) != CHILD_ELEMENTS.COL_LIST_ITEM) break;
                    this.col = new SimpleColumnImpl(this, string3, this.delegator);
                    this.setHandler(this.col);
                    break;
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.COL_LIST_ITEM) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case CON_NUM: {
                        if (0 != this.constraintNum) break;
                        this.constraintNum = Integer.parseInt(this.contents.toString());
                        this.seenConNum = true;
                        break;
                    }
                    case POS_NUM: {
                        if (0 != this.columnPositionNum) break;
                        this.columnPositionNum = Integer.parseInt(this.contents.toString());
                        this.seenPosNum = true;
                        break;
                    }
                    case OID_OR_SETID: {
                        if (0 != this.oIdOrSetId) break;
                        this.oIdOrSetId = Integer.parseInt(this.contents.toString());
                        this.seenOId = true;
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.COL_LIST_ITEM && CHILD_ELEMENTS.getName(string3) == CHILD_ELEMENTS.COL_LIST_ITEM) {
                this.seenColListItemEndElement = true;
                this.parents.pop();
                this.setHandler(this.parent);
            }
        }

        @Override
        public int getConstraintNum() {
            return this.constraintNum;
        }

        @Override
        public int getPositionNum() {
            return this.columnPositionNum;
        }

        @Override
        public int getOidOrSetid() {
            return this.oIdOrSetId;
        }

        @Override
        public SimpleColumnImpl getColumn() {
            return this.col;
        }

        boolean isValid() {
            return this.seenConNum && this.seenPosNum && this.seenOId && this.getColumn() != null && this.getColumn().isValid() && !this.seenColListItemEndElement;
        }

        static {
            try {
                $$$methodRef$$$8 = ConstraintColumnImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = ConstraintColumnImpl.class.getDeclaredMethod("getColumn", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = ConstraintColumnImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = ConstraintColumnImpl.class.getDeclaredMethod("getColumn", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = ConstraintColumnImpl.class.getDeclaredMethod("getOidOrSetid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = ConstraintColumnImpl.class.getDeclaredMethod("getPositionNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = ConstraintColumnImpl.class.getDeclaredMethod("getConstraintNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = ConstraintColumnImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = ConstraintColumnImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS COL;
            public static final /* enum */ CHILD_ELEMENTS COL_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COL = new CHILD_ELEMENTS();
                COL_LIST_ITEM = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{COL, COL_LIST_ITEM, NOVALUE};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS CON_NUM;
            public static final /* enum */ LEAF_ELEMENTS POS_NUM;
            public static final /* enum */ LEAF_ELEMENTS OID_OR_SETID;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                CON_NUM = new LEAF_ELEMENTS();
                POS_NUM = new LEAF_ELEMENTS();
                OID_OR_SETID = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{CON_NUM, POS_NUM, OID_OR_SETID, NOVALUE};
            }
        }
    }

    private static class ColumnMetadataImpl
    extends MetadataHandler
    implements Metadata.ColumnMetadata {
        boolean seenColNum = false;
        boolean seenSegColNum = false;
        boolean seenName = false;
        boolean seenTypeNum = false;
        boolean seenLength = false;
        boolean seenNotNull = false;
        boolean seenProperty = false;
        boolean seenCharsetId = false;
        boolean seenCharsetForm = false;
        boolean seenColListItem = false;
        boolean seenLobMd = false;
        boolean seenPLobMd = false;
        public static final int NUM_DEFAULT_SCALE = 0;
        public static final int NUM_DEFAULT_PRECISION = 38;
        private static final int NCHARSET_FORM = 2;
        private static final int CHAR_COL_PROPERTY = 0x800000;
        private static final int VIRTUAL_COL_PROPERTY = 65536;
        private SQLType sqlType;
        private String inputFieldName = null;
        private String inputFormat = "";
        private boolean loadTargetCol = true;
        private int columnNum = 0;
        private int segmentColumnNumber = 0;
        private String name = null;
        private int typeNum = 0;
        private int length = 0;
        private int precisionNum = Integer.MIN_VALUE;
        private int scale = Integer.MIN_VALUE;
        private int notNull = 0;
        private int defaultLength = 0;
        private int baseColumnType = 0;
        private int property = 0;
        private int charSetId = 0;
        private int charSetForm = 0;
        private int spare3 = 0;
        private LobImpl lobMetadata = null;
        private LobPartitionImpl partLobMetadata = null;
        private static final String NUM_PS_COL_FORMAT = "%1$-33s%2$s(%3$d,%4$d)%5$s";
        private static final String FLOAT_COL_FORMAT = "%1$-33sFLOAT(%2$d)%3$s";
        private static final String LENGTH_COL_FORMAT = "%1$-33s%2$s(%3$d)%4$s";
        private static final String NOLENGTH_COL_FORMAT = "%1$-33s%2$s%3$s";
        private static final String CHAR_LENGTH_COL_FORMAT = "%1$-33s%2$s(%3$d CHAR)%4$s";
        private static final String NCHAR_COL_FORMAT = "%1$-33sN%2$s(%3$d)%4$s";
        private static final String TIMESTAMPTZ_COL_FORMAT = "%1$-33sTIMESTAMP(%2$d) WITH TIME ZONE%3$s";
        private static final String TIMESTAMPLTZ_COL_FORMAT = "%1$-33sTIMESTAMP(%2$d) WITH LOCAL TIME ZONE%3$s";
        private static final String INTERVALYTM_COL_FORMAT = "%1$-33sINTERVAL YEAR(%2$d) TO MONTH%3$s";
        private static final String INTERVALDTS_COL_FORMAT = "%1$-33sINTERVAL DAY(%2$d) TO SECOND(%3$d)%4$s";
        private String NOT_NULL_STR = "";
        private static final String NOT_NULL = " NOT NULL";
        public static final int ZERO_PRECISION = 0;
        public static final int NO_SCALE = -127;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;
        private static Executable $$$methodRef$$$28;
        private static Logger $$$loggerRef$$$28;
        private static Executable $$$methodRef$$$29;
        private static Logger $$$loggerRef$$$29;
        private static Executable $$$methodRef$$$30;
        private static Logger $$$loggerRef$$$30;
        private static Executable $$$methodRef$$$31;
        private static Logger $$$loggerRef$$$31;
        private static Executable $$$methodRef$$$32;
        private static Logger $$$loggerRef$$$32;
        private static Executable $$$methodRef$$$33;
        private static Logger $$$loggerRef$$$33;
        private static Executable $$$methodRef$$$34;
        private static Logger $$$loggerRef$$$34;
        private static Executable $$$methodRef$$$35;
        private static Logger $$$loggerRef$$$35;
        private static Executable $$$methodRef$$$36;
        private static Logger $$$loggerRef$$$36;
        private static Executable $$$methodRef$$$37;
        private static Logger $$$loggerRef$$$37;
        private static Executable $$$methodRef$$$38;
        private static Logger $$$loggerRef$$$38;
        private static Executable $$$methodRef$$$39;
        private static Logger $$$loggerRef$$$39;
        private static Executable $$$methodRef$$$40;
        private static Logger $$$loggerRef$$$40;
        private static Executable $$$methodRef$$$41;
        private static Logger $$$loggerRef$$$41;
        private static Executable $$$methodRef$$$42;
        private static Logger $$$loggerRef$$$42;
        private static Executable $$$methodRef$$$43;
        private static Logger $$$loggerRef$$$43;
        private static Executable $$$methodRef$$$44;
        private static Logger $$$loggerRef$$$44;
        private static Executable $$$methodRef$$$45;
        private static Logger $$$loggerRef$$$45;
        private static Executable $$$methodRef$$$46;
        private static Logger $$$loggerRef$$$46;
        private static Executable $$$methodRef$$$47;
        private static Logger $$$loggerRef$$$47;
        private static Executable $$$methodRef$$$48;
        private static Logger $$$loggerRef$$$48;
        private static Executable $$$methodRef$$$49;
        private static Logger $$$loggerRef$$$49;
        private static Executable $$$methodRef$$$50;
        private static Logger $$$loggerRef$$$50;

        ColumnMetadataImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        private CHILD_ELEMENTS getTopofStack() {
            return this.parents.isEmpty() ? null : CHILD_ELEMENTS.getName((String)this.parents.peek());
        }

        private boolean isParentColListItem() {
            return this.getTopofStack() == CHILD_ELEMENTS.COL_LIST_ITEM;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (this.isParentColListItem()) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case PARSED_DEF: 
                    case CON: 
                    case TYPEMD: 
                    case OPQMD: 
                    case OIDINDEX: {
                        this.parents.push(string3);
                        break;
                    }
                    case LOBMD: {
                        this.lobMetadata = new LobImpl(this, string3, this.delegator);
                        this.setHandler(this.lobMetadata);
                        break;
                    }
                    case PLOBMD: {
                        this.partLobMetadata = new LobPartitionImpl(this, string3, this.delegator);
                        this.setHandler(this.partLobMetadata);
                        break;
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.isParentColListItem()) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case COL_NUM: {
                        this.seenColNum = true;
                        this.columnNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SEGCOL_NUM: {
                        this.seenSegColNum = true;
                        this.segmentColumnNumber = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case NAME: {
                        this.seenName = true;
                        this.inputFieldName = this.name = this.contents.toString();
                        break;
                    }
                    case TYPE_NUM: {
                        this.seenTypeNum = true;
                        this.typeNum = Integer.parseInt(this.contents.toString());
                        this.setSQLType();
                        break;
                    }
                    case LENGTH: {
                        this.seenLength = true;
                        this.length = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case NOT_NULL: {
                        this.seenNotNull = true;
                        this.notNull = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case DEFLENGTH: {
                        this.defaultLength = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PRECISION_NUM: {
                        this.precisionNum = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SCALE: {
                        this.scale = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case BASE_COL_TYPE: {
                        this.baseColumnType = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PROPERTY: {
                        this.seenProperty = true;
                        this.property = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case CHARSETID: {
                        this.seenCharsetId = true;
                        this.charSetId = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case CHARSETFORM: {
                        this.seenCharsetForm = true;
                        this.charSetForm = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case SPARE3: {
                        this.spare3 = Integer.parseInt(this.contents.toString());
                        break;
                    }
                }
            }
            if (this.getTopofStack() == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case PARSED_DEF: 
                    case CON: 
                    case TYPEMD: 
                    case OPQMD: 
                    case OIDINDEX: {
                        this.parents.pop();
                        break;
                    }
                    case LOBMD: {
                        this.seenLobMd = true;
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                    case PLOBMD: {
                        this.seenPLobMd = true;
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                    case COL_LIST_ITEM: {
                        this.seenColListItem = true;
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        private void setSQLType() {
            try {
                Integer n = Metadata.dbTypeToOracleTypeMap.get(this.typeNum);
                if (n == null) {
                    throw new RSIException("Unknown column type: " + this.typeNum);
                }
                this.sqlType = OracleType.toOracleType((int)n);
            }
            catch (SQLException sQLException) {
                throw new RSIException(sQLException.getMessage(), sQLException.getCause());
            }
        }

        boolean isValid() {
            return this.seenColNum && this.seenSegColNum && this.seenName && this.seenTypeNum && this.seenLength && this.seenNotNull && this.seenCharsetId && this.seenCharsetForm;
        }

        @Override
        public int getColumnNum() {
            return this.columnNum;
        }

        @Override
        public int getSegmentColumnNum() {
            return this.segmentColumnNumber;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getTypeNum() {
            return this.typeNum;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getPrecisionNum() {
            return this.precisionNum;
        }

        @Override
        public int getScale() {
            return this.hasScale() ? this.scale : -127;
        }

        int getBaseColType() {
            return this.baseColumnType;
        }

        boolean isZero_baseColType() {
            return this.baseColumnType == 0;
        }

        @Override
        public boolean isNotNull() {
            return this.notNull != 0;
        }

        public int getProperty() {
            return this.property;
        }

        @Override
        public int getCharsetId() {
            return this.charSetId;
        }

        @Override
        public int getCharsetForm() {
            return this.charSetForm;
        }

        @Override
        public int getSpare3() {
            return this.spare3;
        }

        @Override
        public int getCharLength() {
            return this.spare3;
        }

        @Override
        public int getPrecision() {
            return this.hasPrecision() ? this.precisionNum : 0;
        }

        public String getInputName() {
            return this.inputFieldName;
        }

        @Override
        public String getInputFormat() {
            return this.inputFormat;
        }

        public LobImpl getLob() {
            return this.lobMetadata;
        }

        public LobPartitionImpl getLobPartition() {
            return this.partLobMetadata;
        }

        @Override
        public boolean isLoadTarget() {
            return this.loadTargetCol;
        }

        @Override
        public boolean isVirtualColumn() {
            return (this.getProperty() & 0x10000) == 65536 && this.defaultLength != 0;
        }

        @Override
        public boolean isCharType() {
            return this.sqlType.getVendorTypeNumber() == 12 || this.sqlType.getVendorTypeNumber() == 1;
        }

        @Override
        public boolean isFloatType() {
            return this.isNumberType() && this.hasPrecision() && !this.hasScale();
        }

        @Override
        public boolean isNumberType() {
            return this.sqlType.getVendorTypeNumber() == 2 || this.sqlType.getVendorTypeNumber() == 100 || this.sqlType.getVendorTypeNumber() == 101;
        }

        @Override
        public boolean isCharacterType() {
            return this.sqlType.getVendorTypeNumber() == 12 || this.sqlType.getVendorTypeNumber() == 1;
        }

        @Override
        public boolean isBinaryType() {
            return this.sqlType.getVendorTypeNumber() == -2 || this.sqlType.getVendorTypeNumber() == 2004;
        }

        @Override
        public boolean isDateTimeType() {
            return this.sqlType.getVendorTypeNumber() == 91 || this.sqlType.getVendorTypeNumber() == 93 || this.sqlType.getVendorTypeNumber() == -101 || this.sqlType.getVendorTypeNumber() == -102;
        }

        @Override
        public boolean isIntervalType() {
            return this.sqlType.getVendorTypeNumber() == -103 || this.sqlType.getVendorTypeNumber() == -104;
        }

        @Override
        public boolean isNChar() {
            return this.isCharType() && this.getCharsetForm() == 2;
        }

        @Override
        public boolean isLobType() {
            return this.isLob();
        }

        @Override
        public boolean isLob() {
            return this.isBlob() || this.isClob() || this.isNClob();
        }

        @Override
        public boolean isBlob() {
            return this.sqlType.getVendorTypeNumber() == 2004;
        }

        @Override
        public boolean isClob() {
            return this.sqlType.getVendorTypeNumber() == 2005;
        }

        @Override
        public boolean isNClob() {
            return this.isClob() && this.getCharsetForm() == 2;
        }

        @Override
        public void setLoadTarget(boolean bl) {
            this.loadTargetCol = bl;
        }

        public void setInputFieldName(String string) {
            this.inputFieldName = null == string ? "" : string;
        }

        @Override
        public void setInputFormat(String string) {
            this.inputFormat = null == string ? "" : string;
        }

        @Override
        public boolean hasPrecision() {
            return this.precisionNum != Integer.MIN_VALUE;
        }

        @Override
        public boolean hasScale() {
            return this.scale != Integer.MIN_VALUE;
        }

        @Override
        public boolean isColumnLengthInChars() {
            return (this.getProperty() & 0x800000) != 0;
        }

        String createDDL() {
            return this.createDDL(false);
        }

        @Override
        public String createDDL(boolean bl) {
            this.NOT_NULL_STR = "";
            if (bl) {
                this.NOT_NULL_STR = this.isNotNull() ? NOT_NULL : "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isVirtualColumn()) {
                return stringBuilder.toString();
            }
            switch (this.sqlType.getVendorTypeNumber()) {
                case 1: 
                case 12: {
                    if (this.isNChar()) {
                        stringBuilder.append(String.format(NCHAR_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.getSpare3(), this.NOT_NULL_STR));
                        break;
                    }
                    if (this.isColumnLengthInChars()) {
                        stringBuilder.append(String.format(CHAR_LENGTH_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.getSpare3(), this.NOT_NULL_STR));
                        break;
                    }
                    stringBuilder.append(String.format(LENGTH_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.getSpare3(), this.NOT_NULL_STR));
                    break;
                }
                case 2: {
                    if (this.hasPrecision()) {
                        if (this.hasScale()) {
                            stringBuilder.append(String.format(NUM_PS_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.getPrecisionNum(), this.getScale(), this.NOT_NULL_STR));
                            break;
                        }
                        stringBuilder.append(String.format(FLOAT_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.getPrecisionNum(), this.NOT_NULL_STR));
                        break;
                    }
                    stringBuilder.append(String.format(NOLENGTH_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.NOT_NULL_STR));
                    break;
                }
                case 91: {
                    stringBuilder.append(String.format(NOLENGTH_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.NOT_NULL_STR));
                    break;
                }
                case -2: {
                    stringBuilder.append(String.format(LENGTH_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.getLength(), this.NOT_NULL_STR));
                    break;
                }
                case 100: 
                case 101: {
                    stringBuilder.append(String.format(NOLENGTH_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.NOT_NULL_STR));
                    break;
                }
                case 93: {
                    stringBuilder.append(String.format(LENGTH_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.sqlType.getName(), this.getScale(), this.NOT_NULL_STR));
                    break;
                }
                case -101: {
                    stringBuilder.append(String.format(TIMESTAMPTZ_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.getScale(), this.NOT_NULL_STR));
                    break;
                }
                case -102: {
                    stringBuilder.append(String.format(TIMESTAMPLTZ_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.getScale(), this.NOT_NULL_STR));
                    break;
                }
                case -103: {
                    stringBuilder.append(String.format(INTERVALYTM_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.getPrecisionNum(), this.NOT_NULL_STR));
                    break;
                }
                case -104: {
                    stringBuilder.append(String.format(INTERVALDTS_COL_FORMAT, MetadataImpl.enquoteDouble(this.getName()), this.getPrecisionNum(), this.getScale(), this.NOT_NULL_STR));
                    break;
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public SQLType getSQLType() {
            return this.sqlType;
        }

        static {
            try {
                $$$methodRef$$$50 = ColumnMetadataImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$49 = ColumnMetadataImpl.class.getDeclaredMethod("getSQLType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$48 = ColumnMetadataImpl.class.getDeclaredMethod("createDDL", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$47 = ColumnMetadataImpl.class.getDeclaredMethod("createDDL", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$46 = ColumnMetadataImpl.class.getDeclaredMethod("isColumnLengthInChars", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$45 = ColumnMetadataImpl.class.getDeclaredMethod("hasScale", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$44 = ColumnMetadataImpl.class.getDeclaredMethod("hasPrecision", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$43 = ColumnMetadataImpl.class.getDeclaredMethod("setInputFormat", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$42 = ColumnMetadataImpl.class.getDeclaredMethod("setInputFieldName", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$41 = ColumnMetadataImpl.class.getDeclaredMethod("setLoadTarget", Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$40 = ColumnMetadataImpl.class.getDeclaredMethod("isNClob", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$39 = ColumnMetadataImpl.class.getDeclaredMethod("isClob", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$38 = ColumnMetadataImpl.class.getDeclaredMethod("isBlob", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$37 = ColumnMetadataImpl.class.getDeclaredMethod("isLob", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$36 = ColumnMetadataImpl.class.getDeclaredMethod("isLobType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$35 = ColumnMetadataImpl.class.getDeclaredMethod("isNChar", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$34 = ColumnMetadataImpl.class.getDeclaredMethod("isIntervalType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$33 = ColumnMetadataImpl.class.getDeclaredMethod("isDateTimeType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$32 = ColumnMetadataImpl.class.getDeclaredMethod("isBinaryType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$31 = ColumnMetadataImpl.class.getDeclaredMethod("isCharacterType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$30 = ColumnMetadataImpl.class.getDeclaredMethod("isNumberType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$29 = ColumnMetadataImpl.class.getDeclaredMethod("isFloatType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$28 = ColumnMetadataImpl.class.getDeclaredMethod("isCharType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$27 = ColumnMetadataImpl.class.getDeclaredMethod("isVirtualColumn", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$26 = ColumnMetadataImpl.class.getDeclaredMethod("isLoadTarget", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$25 = ColumnMetadataImpl.class.getDeclaredMethod("getLobPartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$24 = ColumnMetadataImpl.class.getDeclaredMethod("getLob", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$23 = ColumnMetadataImpl.class.getDeclaredMethod("getInputFormat", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$22 = ColumnMetadataImpl.class.getDeclaredMethod("getInputName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$21 = ColumnMetadataImpl.class.getDeclaredMethod("getPrecision", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$20 = ColumnMetadataImpl.class.getDeclaredMethod("getCharLength", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$19 = ColumnMetadataImpl.class.getDeclaredMethod("getSpare3", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$18 = ColumnMetadataImpl.class.getDeclaredMethod("getCharsetForm", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = ColumnMetadataImpl.class.getDeclaredMethod("getCharsetId", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = ColumnMetadataImpl.class.getDeclaredMethod("getProperty", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = ColumnMetadataImpl.class.getDeclaredMethod("isNotNull", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = ColumnMetadataImpl.class.getDeclaredMethod("isZero_baseColType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = ColumnMetadataImpl.class.getDeclaredMethod("getBaseColType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = ColumnMetadataImpl.class.getDeclaredMethod("getScale", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = ColumnMetadataImpl.class.getDeclaredMethod("getPrecisionNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = ColumnMetadataImpl.class.getDeclaredMethod("getLength", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = ColumnMetadataImpl.class.getDeclaredMethod("getTypeNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = ColumnMetadataImpl.class.getDeclaredMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = ColumnMetadataImpl.class.getDeclaredMethod("getSegmentColumnNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = ColumnMetadataImpl.class.getDeclaredMethod("getColumnNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = ColumnMetadataImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = ColumnMetadataImpl.class.getDeclaredMethod("setSQLType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = ColumnMetadataImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = ColumnMetadataImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = ColumnMetadataImpl.class.getDeclaredMethod("isParentColListItem", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = ColumnMetadataImpl.class.getDeclaredMethod("getTopofStack", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS PARSED_DEF;
            public static final /* enum */ CHILD_ELEMENTS CON;
            public static final /* enum */ CHILD_ELEMENTS TYPEMD;
            public static final /* enum */ CHILD_ELEMENTS LOBMD;
            public static final /* enum */ CHILD_ELEMENTS PLOBMD;
            public static final /* enum */ CHILD_ELEMENTS OPQMD;
            public static final /* enum */ CHILD_ELEMENTS OIDINDEX;
            public static final /* enum */ CHILD_ELEMENTS COL_LIST_ITEM;
            public static final /* enum */ CHILD_ELEMENTS NULL;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NULL;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                PARSED_DEF = new CHILD_ELEMENTS();
                CON = new CHILD_ELEMENTS();
                TYPEMD = new CHILD_ELEMENTS();
                LOBMD = new CHILD_ELEMENTS();
                PLOBMD = new CHILD_ELEMENTS();
                OPQMD = new CHILD_ELEMENTS();
                OIDINDEX = new CHILD_ELEMENTS();
                COL_LIST_ITEM = new CHILD_ELEMENTS();
                NULL = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{PARSED_DEF, CON, TYPEMD, LOBMD, PLOBMD, OPQMD, OIDINDEX, COL_LIST_ITEM, NULL};
            }
        }

        static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS COL_NUM;
            public static final /* enum */ LEAF_ELEMENTS SEGCOL_NUM;
            public static final /* enum */ LEAF_ELEMENTS NAME;
            public static final /* enum */ LEAF_ELEMENTS TYPE_NUM;
            public static final /* enum */ LEAF_ELEMENTS LENGTH;
            public static final /* enum */ LEAF_ELEMENTS NOT_NULL;
            public static final /* enum */ LEAF_ELEMENTS DEFLENGTH;
            public static final /* enum */ LEAF_ELEMENTS PRECISION_NUM;
            public static final /* enum */ LEAF_ELEMENTS SCALE;
            public static final /* enum */ LEAF_ELEMENTS BASE_COL_TYPE;
            public static final /* enum */ LEAF_ELEMENTS PROPERTY;
            public static final /* enum */ LEAF_ELEMENTS CHARSETID;
            public static final /* enum */ LEAF_ELEMENTS CHARSETFORM;
            public static final /* enum */ LEAF_ELEMENTS SPARE3;
            public static final /* enum */ LEAF_ELEMENTS NULL;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NULL;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                COL_NUM = new LEAF_ELEMENTS();
                SEGCOL_NUM = new LEAF_ELEMENTS();
                NAME = new LEAF_ELEMENTS();
                TYPE_NUM = new LEAF_ELEMENTS();
                LENGTH = new LEAF_ELEMENTS();
                NOT_NULL = new LEAF_ELEMENTS();
                DEFLENGTH = new LEAF_ELEMENTS();
                PRECISION_NUM = new LEAF_ELEMENTS();
                SCALE = new LEAF_ELEMENTS();
                BASE_COL_TYPE = new LEAF_ELEMENTS();
                PROPERTY = new LEAF_ELEMENTS();
                CHARSETID = new LEAF_ELEMENTS();
                CHARSETFORM = new LEAF_ELEMENTS();
                SPARE3 = new LEAF_ELEMENTS();
                NULL = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{COL_NUM, SEGCOL_NUM, NAME, TYPE_NUM, LENGTH, NOT_NULL, DEFLENGTH, PRECISION_NUM, SCALE, BASE_COL_TYPE, PROPERTY, CHARSETID, CHARSETFORM, SPARE3, NULL};
            }
        }
    }

    private static class BasePartitionImpl
    extends MetadataHandler
    implements Metadata.BasePartition {
        private boolean seenFlags = false;
        private boolean seenSpare2 = false;
        private boolean seenSpare3 = false;
        private int spare2Byte0 = 0;
        private int partType;
        private int partitionsCount;
        private int partitioningKeyColumns;
        private int flags;
        private long spare2;
        private int spare3;
        private String intervalStr = null;
        private byte[] intervalBiVal;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;

        BasePartitionImpl(MetadataHandler metadataHandler, String string, HandlerDelegator handlerDelegator) {
            this.parent = metadataHandler;
            this.parents.push(string);
            this.delegator = handlerDelegator;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.PARTOBJ) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case INSERT_TS_LIST: {
                        this.parents.push(string3);
                        break;
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.PARTOBJ) {
                switch (LEAF_ELEMENTS.getName(string3)) {
                    case PARTTYPE: {
                        this.partType = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PARTCNT: {
                        this.partitionsCount = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case PARTKEYCOLS: {
                        this.partitioningKeyColumns = Integer.parseInt(this.contents.toString());
                        break;
                    }
                    case FLAGS: {
                        this.flags = Integer.parseInt(this.contents.toString());
                        this.seenFlags = true;
                        break;
                    }
                    case SPARE2: {
                        this.spare2 = Long.parseLong(this.contents.toString());
                        this.seenSpare2 = true;
                        if (this.spare2 == 0L) break;
                        this.spare2Byte0 = (byte)(0xFFL & this.spare2);
                        break;
                    }
                    case SPARE3: {
                        this.spare3 = Integer.parseInt(this.contents.toString());
                        this.seenSpare3 = true;
                        break;
                    }
                    case INTERVAL_STR: {
                        this.intervalStr = this.contents.toString();
                        break;
                    }
                    case INTERVAL_BIVAL: {
                        this.intervalBiVal = MetadataImpl.hexStringToByteArray(this.contents.toString());
                        break;
                    }
                }
            }
            if (!this.parents.empty() && CHILD_ELEMENTS.getName((String)this.parents.peek()) == CHILD_ELEMENTS.getName(string3)) {
                switch (CHILD_ELEMENTS.getName(string3)) {
                    case INSERT_TS_LIST: {
                        this.parents.pop();
                        break;
                    }
                    case PARTOBJ: {
                        this.parents.pop();
                        this.setHandler(this.parent);
                        break;
                    }
                }
            }
        }

        @Override
        public boolean isIntervalPartition() {
            return 64 == this.getFlags();
        }

        @Override
        public boolean isCompositePartition() {
            return this.spare2Byte0 != 0;
        }

        @Override
        public boolean isDirpathCompressionEnabled() {
            byte by = (byte)(this.spare2 >> 32 & 0xFFL);
            return by == 1 || by == 5;
        }

        @Override
        public Metadata.PartitionType getPartitionType() {
            return Metadata.PartitionType.getName(this.getPartType());
        }

        @Override
        public Metadata.PartitionType getSubpartitionType() {
            return Metadata.PartitionType.getName(this.spare2Byte0);
        }

        @Override
        public int getPartType() {
            return this.partType;
        }

        @Override
        public int getPartitionCount() {
            return this.partitionsCount;
        }

        @Override
        public int getPartitionKeyColumnsNum() {
            return this.partitioningKeyColumns;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public long getSpare2() {
            return this.spare2;
        }

        @Override
        public int getSubpartType() {
            return this.spare2Byte0;
        }

        @Override
        public int getDefSubpartitionCount() {
            return (int)(this.spare2 >> 16) & 0xFFFF;
        }

        @Override
        public int getSpare3() {
            return this.spare3;
        }

        @Override
        public String getIntervalString() {
            return this.intervalStr;
        }

        @Override
        public byte[] getIntervalBinaryValue() {
            return this.intervalBiVal;
        }

        boolean isValid() {
            if (0 == this.getPartType() || 0 == this.getPartitionCount() || 0 == this.getPartitionKeyColumnsNum()) {
                return false;
            }
            if (!this.seenFlags || !this.seenSpare2) {
                return false;
            }
            return !this.isIntervalPartition() || this.seenSpare3;
        }

        static {
            try {
                $$$methodRef$$$18 = BasePartitionImpl.class.getDeclaredConstructor(MetadataHandler.class, String.class, HandlerDelegator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = BasePartitionImpl.class.getDeclaredMethod("isValid", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = BasePartitionImpl.class.getDeclaredMethod("getIntervalBinaryValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = BasePartitionImpl.class.getDeclaredMethod("getIntervalString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = BasePartitionImpl.class.getDeclaredMethod("getSpare3", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = BasePartitionImpl.class.getDeclaredMethod("getDefSubpartitionCount", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = BasePartitionImpl.class.getDeclaredMethod("getSubpartType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = BasePartitionImpl.class.getDeclaredMethod("getSpare2", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = BasePartitionImpl.class.getDeclaredMethod("getFlags", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = BasePartitionImpl.class.getDeclaredMethod("getPartitionKeyColumnsNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = BasePartitionImpl.class.getDeclaredMethod("getPartitionCount", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = BasePartitionImpl.class.getDeclaredMethod("getPartType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = BasePartitionImpl.class.getDeclaredMethod("getSubpartitionType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = BasePartitionImpl.class.getDeclaredMethod("getPartitionType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = BasePartitionImpl.class.getDeclaredMethod("isDirpathCompressionEnabled", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = BasePartitionImpl.class.getDeclaredMethod("isCompositePartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = BasePartitionImpl.class.getDeclaredMethod("isIntervalPartition", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = BasePartitionImpl.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = BasePartitionImpl.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        private static final class CHILD_ELEMENTS
        extends Enum<CHILD_ELEMENTS> {
            public static final /* enum */ CHILD_ELEMENTS INSERT_TS_LIST;
            public static final /* enum */ CHILD_ELEMENTS PARTOBJ;
            public static final /* enum */ CHILD_ELEMENTS NOVALUE;
            private static final /* synthetic */ CHILD_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static CHILD_ELEMENTS[] values() {
                return (CHILD_ELEMENTS[])$VALUES.clone();
            }

            public static CHILD_ELEMENTS valueOf(String string) {
                return Enum.valueOf(CHILD_ELEMENTS.class, string);
            }

            static CHILD_ELEMENTS getName(String string) {
                try {
                    return CHILD_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                INSERT_TS_LIST = new CHILD_ELEMENTS();
                PARTOBJ = new CHILD_ELEMENTS();
                NOVALUE = new CHILD_ELEMENTS();
                $VALUES = new CHILD_ELEMENTS[]{INSERT_TS_LIST, PARTOBJ, NOVALUE};
            }
        }

        private static final class LEAF_ELEMENTS
        extends Enum<LEAF_ELEMENTS> {
            public static final /* enum */ LEAF_ELEMENTS PARTTYPE;
            public static final /* enum */ LEAF_ELEMENTS PARTCNT;
            public static final /* enum */ LEAF_ELEMENTS PARTKEYCOLS;
            public static final /* enum */ LEAF_ELEMENTS FLAGS;
            public static final /* enum */ LEAF_ELEMENTS SPARE2;
            public static final /* enum */ LEAF_ELEMENTS SPARE3;
            public static final /* enum */ LEAF_ELEMENTS INTERVAL_STR;
            public static final /* enum */ LEAF_ELEMENTS INTERVAL_BIVAL;
            public static final /* enum */ LEAF_ELEMENTS NOVALUE;
            private static final /* synthetic */ LEAF_ELEMENTS[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static LEAF_ELEMENTS[] values() {
                return (LEAF_ELEMENTS[])$VALUES.clone();
            }

            public static LEAF_ELEMENTS valueOf(String string) {
                return Enum.valueOf(LEAF_ELEMENTS.class, string);
            }

            static LEAF_ELEMENTS getName(String string) {
                try {
                    return LEAF_ELEMENTS.valueOf(string);
                }
                catch (Throwable throwable) {
                    return NOVALUE;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = LEAF_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$2 = LEAF_ELEMENTS.class.getDeclaredMethod("getName", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = LEAF_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = LEAF_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                PARTTYPE = new LEAF_ELEMENTS();
                PARTCNT = new LEAF_ELEMENTS();
                PARTKEYCOLS = new LEAF_ELEMENTS();
                FLAGS = new LEAF_ELEMENTS();
                SPARE2 = new LEAF_ELEMENTS();
                SPARE3 = new LEAF_ELEMENTS();
                INTERVAL_STR = new LEAF_ELEMENTS();
                INTERVAL_BIVAL = new LEAF_ELEMENTS();
                NOVALUE = new LEAF_ELEMENTS();
                $VALUES = new LEAF_ELEMENTS[]{PARTTYPE, PARTCNT, PARTKEYCOLS, FLAGS, SPARE2, SPARE3, INTERVAL_STR, INTERVAL_BIVAL, NOVALUE};
            }
        }
    }

    private static final class ROOT_CHILD_ELEMENTS
    extends Enum<ROOT_CHILD_ELEMENTS> {
        public static final /* enum */ ROOT_CHILD_ELEMENTS TABLE_T;
        public static final /* enum */ ROOT_CHILD_ELEMENTS TABLE_PART_KEYS;
        public static final /* enum */ ROOT_CHILD_ELEMENTS STRMTABLE_T;
        public static final /* enum */ ROOT_CHILD_ELEMENTS ROW;
        public static final /* enum */ ROOT_CHILD_ELEMENTS ROWSET;
        public static final /* enum */ ROOT_CHILD_ELEMENTS DB_PROPERTIES;
        public static final /* enum */ ROOT_CHILD_ELEMENTS DATABASE;
        public static final /* enum */ ROOT_CHILD_ELEMENTS NOVALUE;
        private static final /* synthetic */ ROOT_CHILD_ELEMENTS[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        public static ROOT_CHILD_ELEMENTS[] values() {
            return (ROOT_CHILD_ELEMENTS[])$VALUES.clone();
        }

        public static ROOT_CHILD_ELEMENTS valueOf(String string) {
            return Enum.valueOf(ROOT_CHILD_ELEMENTS.class, string);
        }

        static ROOT_CHILD_ELEMENTS getName(String string) {
            try {
                return ROOT_CHILD_ELEMENTS.valueOf(string);
            }
            catch (Throwable throwable) {
                return NOVALUE;
            }
        }

        static {
            try {
                $$$methodRef$$$3 = ROOT_CHILD_ELEMENTS.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = ROOT_CHILD_ELEMENTS.class.getDeclaredMethod("getName", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = ROOT_CHILD_ELEMENTS.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = ROOT_CHILD_ELEMENTS.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            TABLE_T = new ROOT_CHILD_ELEMENTS();
            TABLE_PART_KEYS = new ROOT_CHILD_ELEMENTS();
            STRMTABLE_T = new ROOT_CHILD_ELEMENTS();
            ROW = new ROOT_CHILD_ELEMENTS();
            ROWSET = new ROOT_CHILD_ELEMENTS();
            DB_PROPERTIES = new ROOT_CHILD_ELEMENTS();
            DATABASE = new ROOT_CHILD_ELEMENTS();
            NOVALUE = new ROOT_CHILD_ELEMENTS();
            $VALUES = new ROOT_CHILD_ELEMENTS[]{TABLE_T, TABLE_PART_KEYS, STRMTABLE_T, ROW, ROWSET, DB_PROPERTIES, DATABASE, NOVALUE};
        }
    }
}

