/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.rsi.internal.IngestSuite;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSourceImpl;

@Supports(value={Feature.RSI_TRACE})
class IngestSuiteForNonShardedDatabase
extends IngestSuite {
    private UniversalConnectionPoolManager ucpManager = null;
    private final PoolDataSourceImpl poolDataSource = new PoolDataSourceImpl();
    private StagingArea stagingArea = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    protected IngestSuiteForNonShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.startConnectionPool();
        this.initializeStagingArea();
        this.scheduleBufferIntervalTask();
    }

    private void startConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.poolDataSource.setUser(this.dbUser);
        this.poolDataSource.setPassword(this.dbPassword.get());
        this.poolDataSource.setURL(this.dbUrl);
        this.poolDataSource.setInitialPoolSize(CONNECTION_POOL_SIZE);
        this.poolDataSource.setMinPoolSize(CONNECTION_POOL_SIZE);
        this.poolDataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        this.poolDataSource.setShardingMode(false);
        this.poolDataSource.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
        if (this.isUpsert || !this.isUseDP) {
            this.poolDataSource.setMaxStatements(2);
        }
        this.ucpManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        this.ucpManager.createConnectionPool((UniversalConnectionPoolAdapter)this.poolDataSource);
        this.ucpManager.startConnectionPool(this.poolDataSource.getConnectionPoolName());
    }

    @Override
    protected void destroyConnectionPool() throws UniversalConnectionPoolException {
        this.ucpManager.destroyConnectionPool(this.poolDataSource.getConnectionPoolName());
    }

    private void initializeStagingArea() {
        Consumer<List<Object>> consumer = list -> {
            try {
                this.jobsQueuedForExecution.incrementAndGet();
                this.executor.execute(new IngestSuite.IngestJob(this.poolDataSource, (List<Object>)list));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
            }
        };
        this.stagingArea = new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, consumer);
    }

    @Override
    protected void accept(Object object) {
        this.stagingArea.accept(object);
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.stagingArea.flushIfDue(bl);
    }

    @Override
    protected void cleanup() {
        this.stagingArea.close();
    }

    static {
        try {
            $$$methodRef$$$7 = IngestSuiteForNonShardedDatabase.class.getDeclaredConstructor(RSIBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$6 = IngestSuiteForNonShardedDatabase.class.getDeclaredMethod("lambda$initializeStagingArea$0", List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$5 = IngestSuiteForNonShardedDatabase.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = IngestSuiteForNonShardedDatabase.class.getDeclaredMethod("flushItemsIfDue", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = IngestSuiteForNonShardedDatabase.class.getDeclaredMethod("accept", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = IngestSuiteForNonShardedDatabase.class.getDeclaredMethod("initializeStagingArea", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = IngestSuiteForNonShardedDatabase.class.getDeclaredMethod("destroyConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = IngestSuiteForNonShardedDatabase.class.getDeclaredMethod("startConnectionPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
    }
}

