/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.KeywordValueI;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIdcb;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIimplres;
import oracle.jdbc.driver.T4CTTIiov;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleTypeADT;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4C8Oall
extends T4CTTIfun {
    Vector<IOException> nonFatalIOExceptions = null;
    static final byte[] EMPTY_BYTES;
    static final int UOPF_PRS = 1;
    static final int UOPF_BND = 8;
    static final int UOPF_EXE = 32;
    static final int UOPF_FEX = 512;
    static final int UOPF_FCH = 64;
    static final int UOPF_CAN = 128;
    static final int UOPF_COM = 256;
    static final int UOPF_DSY = 131072;
    static final int UOPF_SIO = 1024;
    static final int UOPF_NPL = 32768;
    static final int UOPF_DFN = 16;
    static final int UOPF_NCF = 262144;
    static final int EXE_COMMIT_ON_SUCCESS = 1;
    static final int EXE_LEAVE_CUR_MAPPED = 2;
    static final int EXE_BATCH_DML_ERRORS = 4;
    static final int EXE_SCROL_READ_ONLY = 8;
    static final int EXE_DISABLE_ROWSHIP = 16;
    static final int EXE_RESULT_CACHE = 32;
    static final int EXE_NO_RESULT_CACHE = 64;
    static final int EXE_ACET = 128;
    static final int KPUCXEXE = 32;
    static final int KPUCXFCH = 64;
    static final int KPUCXCAN = 128;
    static final int KPUCXCOM = 256;
    static final int KPUCXFEX = 512;
    static final int KPUCXNCF = 262144;
    static final int AL8EX_GET_PIDMLRC = 16384;
    static final int AL8KW_MAXLANG = 63;
    static final int AL8KW_TIMEZONE = 163;
    static final int AL8KW_ERR_OVLAP = 164;
    static final int AL8KW_SESSION_ID = 165;
    static final int AL8KW_SERIAL_NUM = 166;
    static final int AL8KW_TAG_FOUND = 167;
    static final int AL8KW_SCHEMA_NAME = 168;
    static final int AL8KW_SCHEMA_ID = 169;
    static final int AL8KW_ENABLED_ROLES = 170;
    static final int AL8KW_AUX_SESSSTATE = 171;
    static final int AL8KW_EDITION = 172;
    static final String AL8KW_ERR_OVLAP_STR = "AL8KW_ERR_OVLAP";
    static final String AL8KW_SCHEMA_NAME_STR = "AL8KW_SCHEMA_NAME";
    static final String AL8KW_ENABLED_ROLES_STR = "AL8KW_ENABLED_ROLES";
    static final String AL8KW_EDITION_STR = "AL8KW_EDITION";
    static final String AL8KW_AUX_SESSSTATE_STR = "AL8KW_AUX_SESSSTATE";
    static final int AL8KW_OPENCURSORS = 175;
    static final int AL8KW_PDBUID = 176;
    static final int AL8KW_DBID = 177;
    static final int AL8KW_GUDBID = 178;
    static final int AL8KW_DBNAME = 179;
    static final int AL8KW_SERVICE_NAME = 183;
    static final int AL8KW_CONTAINER_NAME = 197;
    static final String AL8KW_CONTAINER_NAME_STR = "CONTAINER_NAME";
    static final String[] NLS_KEYS;
    static final int LDIREGIDFLAG = 120;
    static final int LDIREGIDSET = 181;
    static final int LDIMAXTIMEFIELD = 60;
    static final int AL8EX_IMPL_RESULTS_CLIENT = 32768;
    long rowsProcessed;
    int numberOfDefinePositions;
    long options;
    int cursor;
    byte[] sqlStmt = new byte[0];
    final long[] al8i4 = new long[13];
    boolean plsql = false;
    Accessor[] definesAccessors;
    int definesLength;
    Accessor[] outBindAccessors;
    int numberOfBindPositions;
    InputStream[][] parameterStream;
    short[] bindIndicators;
    byte[] bindBytes;
    char[] bindChars;
    ByteArray bindData;
    boolean bindUseDBA = false;
    long[] bindDataOffsets = null;
    int[] bindDataLengths = null;
    int bindDataIndex;
    int bindIndicatorSubRange;
    byte[] tmpBindsByteArray;
    DBConversion conversion;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    boolean sendBindsDefinition = false;
    OracleStatement oracleStatement;
    short dbCharSet;
    short NCharSet;
    T4CTTIrxd rxd;
    T4C8TTIrxh rxh;
    T4CTTIdcb dcb;
    T4CTTIimplres implres;
    OracleStatement.SqlKind typeOfStatement;
    int defCols = 0;
    int rowsToFetch;
    boolean aFetchWasDone = false;
    T4CTTIoac[] oacdefBindsSent;
    T4CTTIoac[] oacdefDefines;
    int[] definedColumnSize;
    int[] definedColumnType;
    int[] definedColumnFormOfUse;
    NTFDCNRegistration registration = null;
    static final int AL8TXCUR = 1;
    static final int AL8TXDON = 2;
    static final int AL8TXRON = 4;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    T4C8Oall(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)94);
        this.rxh = new T4C8TTIrxh(t4CConnection);
        this.rxd = new T4CTTIrxd(t4CConnection);
        this.dcb = new T4CTTIdcb(t4CConnection);
        this.implres = new T4CTTIimplres(t4CConnection);
    }

    void doOALL(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, OracleStatement.SqlKind sqlKind, int n2, byte[] byArray, int n3, Accessor[] accessorArray, int n4, Accessor[] accessorArray2, int n5, byte[] byArray2, char[] cArray, short[] sArray, int n6, DBConversion dBConversion, byte[] byArray3, InputStream[][] inputStreamArray, OracleStatement oracleStatement, byte[] byArray4, char[] cArray2, short[] sArray2, T4CTTIoac[] t4CTTIoacArray, int[] nArray, int[] nArray2, int[] nArray3, NTFDCNRegistration nTFDCNRegistration, ByteArray byteArray, long[] lArray, int[] nArray4, boolean bl6) throws SQLException, IOException {
        this.typeOfStatement = sqlKind;
        this.cursor = n2;
        this.sqlStmt = bl ? byArray : EMPTY_BYTES;
        this.rowsToFetch = n3;
        this.outBindAccessors = accessorArray;
        this.numberOfBindPositions = n4;
        this.definesAccessors = accessorArray2;
        this.definesLength = n5;
        this.bindBytes = byArray2;
        this.bindChars = cArray;
        this.bindIndicators = sArray;
        this.bindIndicatorSubRange = n6;
        this.conversion = dBConversion;
        this.tmpBindsByteArray = byArray3;
        this.parameterStream = inputStreamArray;
        this.oracleStatement = oracleStatement;
        this.ibtBindBytes = byArray4;
        this.ibtBindChars = cArray2;
        this.ibtBindIndicators = sArray2;
        this.oacdefBindsSent = t4CTTIoacArray;
        this.definedColumnType = nArray;
        this.definedColumnSize = nArray2;
        this.definedColumnFormOfUse = nArray3;
        this.registration = nTFDCNRegistration;
        this.bindData = byteArray;
        this.bindDataOffsets = lArray;
        this.bindDataLengths = nArray4;
        this.bindUseDBA = bl6;
        this.dbCharSet = dBConversion.getServerCharSetId();
        this.NCharSet = dBConversion.getNCharSetId();
        int n7 = 0;
        if (this.bindIndicators != null) {
            n7 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
        }
        if (byArray == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 431).fillInStackTrace();
        }
        if (!this.typeOfStatement.isDML() && n7 > 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
        }
        this.rowsProcessed = 0L;
        this.options = 0L;
        this.plsql = this.typeOfStatement.isPlsqlOrCall();
        this.sendBindsDefinition = false;
        if (this.receiveState != 0) {
            this.receiveState = 0;
        }
        this.rxh.init();
        this.rxd.init();
        this.oer.init();
        if (bl5 && this.typeOfStatement.isSELECT()) {
            this.initDefinesDefinition();
        }
        if (this.numberOfBindPositions > 0 && this.bindIndicators != null) {
            if (this.oacdefBindsSent == null) {
                this.oacdefBindsSent = new T4CTTIoac[this.numberOfBindPositions];
            }
            this.sendBindsDefinition = this.initBindsDefinition(this.oacdefBindsSent);
        }
        this.options = this.setOptions(bl, bl2, bl3, bl5);
        this.al8i4[0] = (this.options & 1L) > 0L ? 1L : 0L;
        this.al8i4[1] = this.plsql || this.typeOfStatement.isOTHER() ? 1L : (bl4 ? (bl3 && this.oracleStatement.isFetchStreams ? (long)this.rowsToFetch : 0L) : (this.typeOfStatement.isDML() ? (n7 == 0 ? (long)this.oracleStatement.batch : (long)n7) : (bl3 && !bl4 ? (long)this.rowsToFetch : 0L)));
        this.al8i4[7] = this.typeOfStatement.isSELECT() ? 1L : 0L;
        long l2 = this.oracleStatement.inScn;
        int n8 = (int)l2;
        int n9 = (int)(l2 >> 32);
        this.al8i4[5] = n8;
        this.al8i4[6] = n9;
        this.al8i4[9] = this.typeOfStatement.isDML() ? this.al8i4[9] | 0x4000L : this.al8i4[9] & 0xFFFFFFFFFFFFBFFFL;
        this.rowsProcessed = 0L;
        this.aFetchWasDone = false;
        this.rxd.setNumberOfColumns(this.definesLength);
        if ((this.options & 0x40L) != 0L && (this.options & 0x20L) == 0L && (this.options & 1L) == 0L && (this.options & 8L) == 0L && (this.options & 0x10L) == 0L && !this.oracleStatement.needToSendOalToFetch) {
            this.setFunCode((short)5);
        } else if (this.oracleStatement.inScn == 0L && (this.options & 0x20L) != 0L && (this.options & 1L) == 0L && (this.options & 0x10L) == 0L && (this.options & 8L) == 0L && (this.options & 0x8000L) != 0L && (this.options & 0x40L) != 0L) {
            this.setFunCode((short)78);
        } else {
            this.setFunCode((short)94);
        }
        this.al8i4[9] = (this.options & 0x20L) != 0L ? this.al8i4[9] | 0x8000L : this.al8i4[9] & 0xFFFFFFFFFFFF7FFFL;
        if (this.getFunCode() == 94 || this.getFunCode() == 78) {
            ((T4CConnection)this.oracleStatement.connection).setExecutingRPCSQL(this.oracleStatement.sqlObject.actualSql);
        }
        this.nonFatalIOExceptions = null;
        this.doRPC();
        if ((this.options & 0x20L) != 0L) {
            this.oracleStatement.inScn = 0L;
        }
        this.ibtBindIndicators = null;
        this.ibtBindChars = null;
        this.ibtBindBytes = null;
        this.tmpBindsByteArray = null;
        this.outBindAccessors = null;
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        this.oracleStatement = null;
        this.parameterStream = null;
        if (this.nonFatalIOExceptions != null) {
            IOException iOException = this.nonFatalIOExceptions.get(0);
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 266).fillInStackTrace();
            }
            catch (SQLException sQLException) {
                sQLException.initCause(iOException);
                throw sQLException;
            }
        }
    }

    @Override
    void readBVC() throws IOException, SQLException {
        int n2 = this.meg.unmarshalUB2();
        this.rxd.unmarshalBVC(n2);
    }

    @Override
    void readIOV() throws IOException, SQLException {
        T4CTTIiov t4CTTIiov = new T4CTTIiov(this.connection, this.rxh, this.rxd);
        t4CTTIiov.init();
        t4CTTIiov.unmarshalV10();
        if (!this.oracleStatement.isDmlReturning && !t4CTTIiov.isIOVectorEmpty()) {
            byte[] byArray = t4CTTIiov.getIOVector();
            this.outBindAccessors = t4CTTIiov.processRXD(this.outBindAccessors, this.numberOfBindPositions, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.conversion, this.tmpBindsByteArray, byArray, this.parameterStream, this.oracleStatement, null, null, null);
        }
    }

    @Override
    void readRXH() throws IOException, SQLException {
        this.rxh.init();
        this.rxh.unmarshalV10(this.rxd);
        if (this.rxh.uacBufLength > 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 405).fillInStackTrace();
        }
        if ((this.rxh.rxhflg & 8) == 8) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 449).fillInStackTrace();
        }
        if ((this.rxh.rxhflg & 0x10) == 16) {
            for (int i2 = 0; i2 < this.definesAccessors.length; ++i2) {
                if (this.definesAccessors[i2].udskpos < 0 || this.definesAccessors[i2].udskpos == i2) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 450).fillInStackTrace();
            }
        }
    }

    @Override
    void processSLG() throws IOException, SQLException {
        this.readRXH();
        int[] nArray = new int[this.numberOfBindPositions];
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            nArray[i2] = this.oacdefBindsSent[i2].oacmxl;
        }
        this.nonFatalIOExceptions = this.marshalBinds(nArray, true);
    }

    @Override
    boolean readRXD() throws IOException, SQLException {
        this.aFetchWasDone = true;
        if (this.oracleStatement.isDmlReturning && this.numberOfBindPositions > 0) {
            boolean bl = false;
            for (int i2 = 0; i2 < this.oracleStatement.numberOfBindPositions; ++i2) {
                Accessor accessor = this.oracleStatement.accessors[i2];
                if (accessor == null) continue;
                int n2 = (int)this.meg.unmarshalUB4();
                this.oracleStatement.increaseCapacity(n2);
                this.oracleStatement.rowsDmlReturned += n2;
                for (int i3 = 0; i3 < n2; ++i3) {
                    accessor.unmarshalOneRow();
                    ++this.oracleStatement.storedRowCount;
                }
            }
            this.oracleStatement.returnParamsFetched = true;
        } else if (this.iovProcessed || this.outBindAccessors != null && this.definesAccessors == null ? this.rxd.unmarshal(this.outBindAccessors, this.numberOfBindPositions) : this.rxd.unmarshal(this.definesAccessors, this.definesLength)) {
            return true;
        }
        return false;
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int n2;
        Object[] objectArray;
        int n3;
        int n4;
        int n5 = 32768;
        int n6 = this.meg.unmarshalUB2();
        int[] nArray = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray[n4] = (int)this.meg.unmarshalUB4();
        }
        n4 = nArray[0];
        int n7 = nArray[1] & ~n5;
        long l2 = (long)n4 & 0xFFFFFFFFL | ((long)n7 & 0xFFFFFFFFL) << 32;
        if (l2 != 0L) {
            this.oracleStatement.connection.outScn = l2;
        }
        this.cursor = nArray[2];
        int n8 = this.meg.unmarshalUB2();
        byte[] byArray = null;
        if (n8 > 0) {
            byArray = this.meg.unmarshalNBytes(n8);
        }
        int n9 = this.meg.unmarshalUB2();
        KeywordValue[] keywordValueArray = new KeywordValue[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            keywordValueArray[n3] = KeywordValueI.unmarshal(this.meg);
        }
        this.connection.updateSessionProperties(keywordValueArray);
        this.oracleStatement.dcnQueryId = -1L;
        this.oracleStatement.dcnTableName = null;
        if (this.connection.getTTCVersion() >= 4) {
            n3 = (int)this.meg.unmarshalUB4();
            objectArray = this.meg.unmarshalNBytes(n3);
            if (n3 > 0 && this.registration != null) {
                String string;
                n2 = 0;
                Properties properties = this.registration.getRegistrationOptions();
                if (properties != null && (string = properties.getProperty("DCN_QUERY_CHANGE_NOTIFICATION")) != null && string.compareToIgnoreCase("true") == 0) {
                    n2 = 1;
                }
                int n10 = n3;
                if (n2 != 0) {
                    n10 = n3 - 8;
                }
                String string2 = new String((byte[])objectArray, 0, n10);
                char[] cArray = new char[]{'\u0000'};
                String[] stringArray = string2.split(new String(cArray));
                this.registration.addTablesName(stringArray, stringArray.length);
                this.oracleStatement.dcnTableName = stringArray;
                if (n2 != 0) {
                    long l3;
                    int n11 = objectArray[n3 - 1] & 0xFF | (objectArray[n3 - 2] & 0xFF) << 8 | (objectArray[n3 - 3] & 0xFF) << 16 | (objectArray[n3 - 4] & 0xFF) << 24;
                    int n12 = objectArray[n3 - 5] & 0xFF | (objectArray[n3 - 6] & 0xFF) << 8 | (objectArray[n3 - 7] & 0xFF) << 16 | (objectArray[n3 - 8] & 0xFF) << 24;
                    this.oracleStatement.dcnQueryId = l3 = (long)n12 & 0xFFFFFFFFL | ((long)n11 & 0xFFFFFFFFL) << 32;
                }
            }
        }
        if (this.connection.getTTCVersion() >= 7 && this.typeOfStatement.isDML()) {
            n3 = (int)this.meg.unmarshalUB4();
            objectArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray[n2] = (byte)this.meg.unmarshalSB8();
            }
            this.oracleStatement.batchRowsUpdatedArray = objectArray;
        }
    }

    @Override
    void readDCB() throws IOException, SQLException {
        this.dcb.init(this.oracleStatement, 0);
        this.definesAccessors = this.dcb.receive(this.definesAccessors);
        this.definesLength = this.numberOfDefinePositions = this.dcb.numuds;
        this.rxd.setNumberOfColumns(this.numberOfDefinePositions);
    }

    @Override
    void readRSH() throws IOException, SQLException {
        long l2 = this.meg.unmarshalSB8();
        this.connection.kpdqidcscn.unmarshal();
        long l3 = this.connection.kpdqidcscn.getSCN();
        this.oracleStatement.setQueryId(l2);
    }

    @Override
    void readIMPLRES() throws IOException, SQLException {
        int n2;
        this.implres.init(this.oracleStatement);
        this.oracleStatement.implicitResultSetStatements = new ArrayDeque(n2);
        for (n2 = (int)this.meg.unmarshalUB4(); n2 != 0; --n2) {
            this.implres.readImplicitResultSet();
        }
        this.oracleStatement.implicitResultSetIterator = this.oracleStatement.implicitResultSetStatements.iterator();
    }

    @Override
    void processError() throws SQLException {
        this.cursor = this.oer.currCursorID;
        this.rowsProcessed = this.oer.getCurRowNumber();
        this.oracleStatement.isAllFetched = this.oracleStatement.isAllFetched | this.oer.retCode == 1403L;
        if (this.typeOfStatement.isSELECT() && this.oer.retCode == 1403L) {
            this.aFetchWasDone = true;
        }
        if (!this.typeOfStatement.isSELECT() || this.typeOfStatement.isSELECT() && this.oer.retCode != 1403L) {
            if (this.oracleStatement.connection.checksumMode.needToCalculateFetchChecksum() && this.oer.retCode != 0L) {
                long l2;
                this.oracleStatement.checkSum = l2 = this.oer.updateChecksum(this.oracleStatement.checkSum);
            }
            this.oer.processError(this.oracleStatement);
        }
    }

    int getCursorId() {
        return this.cursor;
    }

    void continueReadRow(int n2, OracleStatement oracleStatement) throws SQLException, IOException {
        try {
            this.oracleStatement = oracleStatement;
            this.receiveState = 2;
            if (this.rxd.unmarshal(this.definesAccessors, n2, this.definesLength)) {
                this.receiveState = 3;
                return;
            }
            this.resumeReceive();
        }
        finally {
            this.oracleStatement = null;
        }
    }

    long getNumRows() {
        long l2 = 0L;
        if (this.typeOfStatement == null) {
            return l2;
        }
        if (this.receiveState == 3) {
            l2 = -2L;
        } else {
            switch (this.typeOfStatement) {
                case DELETE: 
                case INSERT: 
                case MERGE: 
                case UPDATE: 
                case ALTER_SESSION: 
                case OTHER: 
                case PLSQL_BLOCK: 
                case CALL_BLOCK: {
                    l2 = this.rowsProcessed;
                    break;
                }
                case SELECT_FOR_UPDATE: 
                case SELECT: {
                    assert (this.definesAccessors == null || this.definesAccessors[0] != null) : "definesAccessors is not null but definesAccessors[0] is null";
                    l2 = this.definesAccessors != null && this.definesLength > 0 && this.definesAccessors[0] != null ? (long)this.definesAccessors[0].lastRowProcessed : 0L;
                }
            }
        }
        return l2;
    }

    @Override
    void marshal() throws IOException {
        if (this.getFunCode() == 5) {
            this.meg.marshalSWORD(this.cursor);
            this.meg.marshalSWORD((int)this.al8i4[1]);
        } else if (this.getFunCode() == 78) {
            this.meg.marshalSWORD(this.cursor);
            this.meg.marshalSWORD((int)this.al8i4[1]);
            int n2 = 96;
            this.meg.marshalSWORD(n2);
            int n3 = 0;
            if ((this.options & 0x100L) == 256L) {
                n3 |= 1;
            }
            this.meg.marshalSWORD(n3);
            int[] nArray = new int[this.numberOfBindPositions];
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                nArray[i2] = this.oacdefBindsSent[i2].oacmxl;
            }
            if (this.numberOfBindPositions > 0 && this.bindIndicators != null) {
                this.marshalBinds(nArray, false);
            }
        } else {
            int n4;
            if (this.oracleStatement.needToSendOalToFetch) {
                this.oracleStatement.needToSendOalToFetch = false;
            }
            this.marshalPisdef();
            this.meg.marshalCHR(this.sqlStmt);
            this.meg.marshalUB4Array(this.al8i4);
            int[] nArray = new int[this.numberOfBindPositions];
            for (n4 = 0; n4 < this.numberOfBindPositions; ++n4) {
                nArray[n4] = this.oacdefBindsSent[n4].oacmxl;
            }
            if ((this.options & 8L) != 0L && this.numberOfBindPositions > 0 && this.bindIndicators != null && this.sendBindsDefinition) {
                this.marshalBindsTypes(this.oacdefBindsSent);
            }
            if (this.connection.getTTCVersion() >= 2 && (this.options & 0x10L) != 0L) {
                for (n4 = 0; n4 < this.defCols; ++n4) {
                    this.oacdefDefines[n4].marshal();
                }
            }
            if ((this.options & 0x20L) != 0L && this.numberOfBindPositions > 0 && this.bindIndicators != null) {
                this.nonFatalIOExceptions = this.marshalBinds(nArray, false);
            }
        }
    }

    void marshalPisdef() throws IOException {
        this.meg.marshalUB4(this.options);
        this.meg.marshalSWORD(this.cursor);
        if (this.sqlStmt.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSWORD(this.sqlStmt.length);
        if (this.al8i4.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSWORD(this.al8i4.length);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        if ((this.options & 0x40L) == 0L && (this.options & 0x20L) != 0L && (this.options & 1L) != 0L && this.typeOfStatement.isSELECT()) {
            this.meg.marshalUB4(Long.MAX_VALUE);
            this.meg.marshalUB4(this.rowsToFetch);
        } else {
            this.meg.marshalUB4(0L);
            this.meg.marshalUB4(0L);
        }
        if (!this.typeOfStatement.isPlsqlOrCall()) {
            this.meg.marshalUB4(Integer.MAX_VALUE);
        } else {
            this.meg.marshalUB4(32760L);
        }
        if ((this.options & 8L) != 0L && this.numberOfBindPositions > 0 && this.sendBindsDefinition) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.numberOfBindPositions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        if (this.connection.getTTCVersion() >= 2) {
            if (this.defCols > 0 && (this.options & 0x10L) != 0L) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(this.defCols);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
        }
        if (this.connection.getTTCVersion() >= 4) {
            int n2 = 0;
            int n3 = 0;
            if (this.registration != null) {
                long l2 = this.registration.getRegId();
                n2 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
                n3 = (int)((l2 & 0xFFFFFFFF00000000L) >> 32);
            }
            this.meg.marshalUB4(n2);
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            if (this.connection.getTTCVersion() >= 5) {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
                this.meg.marshalUB4(n3);
                if (this.connection.getTTCVersion() >= 7) {
                    if (this.typeOfStatement.isDML()) {
                        this.meg.marshalPTR();
                        this.meg.marshalUB4(this.oracleStatement.currentRank);
                        this.meg.marshalPTR();
                    } else {
                        this.meg.marshalNULLPTR();
                        this.meg.marshalUB4(0L);
                        this.meg.marshalNULLPTR();
                    }
                    if (this.connection.getTTCVersion() >= 8) {
                        this.meg.marshalNULLPTR();
                        this.meg.marshalUB4(0L);
                        this.meg.marshalNULLPTR();
                        this.meg.marshalUB4(0L);
                        this.meg.marshalNULLPTR();
                        if (this.connection.getTTCVersion() >= 9) {
                            this.meg.marshalNULLPTR();
                            this.meg.marshalUB4(0L);
                        }
                    }
                }
            }
        }
    }

    boolean initBindsDefinition(T4CTTIoac[] t4CTTIoacArray) throws SQLException, IOException {
        boolean bl = false;
        if (t4CTTIoacArray.length != this.numberOfBindPositions) {
            bl = true;
            t4CTTIoacArray = new T4CTTIoac[this.numberOfBindPositions];
        }
        short[] sArray = this.bindIndicators;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            T4CTTIoac t4CTTIoac = new T4CTTIoac(this.connection);
            int n4 = this.bindIndicatorSubRange + 5 + 10 * i2;
            short s2 = sArray[n4 + 9];
            int n5 = sArray[n4 + 0] & 0xFFFF;
            switch (n5) {
                case 8: 
                case 24: {
                    n2 = this.plsql ? 32760 : Integer.MAX_VALUE;
                    t4CTTIoac.init((short)n5, n2);
                    t4CTTIoac.setFormOfUse(s2);
                    t4CTTIoac.setCharset(s2 == 2 ? this.NCharSet : this.dbCharSet);
                    break;
                }
                case 998: {
                    int n6;
                    if (this.outBindAccessors != null && this.outBindAccessors[i2] != null) {
                        PlsqlIbtBindInfo plsqlIbtBindInfo = this.outBindAccessors[i2].plsqlIndexTableBindInfo();
                        t4CTTIoac.init((short)plsqlIbtBindInfo.element_internal_type, plsqlIbtBindInfo.elemMaxLen);
                        t4CTTIoac.setMal(plsqlIbtBindInfo.maxLen);
                        t4CTTIoac.addFlg((short)64);
                        ++n3;
                        break;
                    }
                    if (this.ibtBindIndicators[6 + n3 * 8] != 0) {
                        short s3 = this.ibtBindIndicators[6 + n3 * 8];
                        n6 = (this.ibtBindIndicators[6 + n3 * 8 + 2] & 0xFFFF) << 16 | this.ibtBindIndicators[6 + n3 * 8 + 3] & 0xFFFF;
                        n2 = this.ibtBindIndicators[6 + n3 * 8 + 1] * this.conversion.sMaxCharSize;
                        t4CTTIoac.init(s3, n2);
                        t4CTTIoac.setMal(n6);
                        t4CTTIoac.addFlg((short)64);
                        ++n3;
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "Binding PLSQL index-by table but no type defined").fillInStackTrace();
                }
                case 109: 
                case 111: {
                    if (this.outBindAccessors != null && this.outBindAccessors[i2] != null) {
                        if (this.outBindAccessors[i2].internalOtype == null) break;
                        t4CTTIoac.init((short)n5, n5 == 109 ? 11 : 4000);
                        t4CTTIoac.setADT((OracleTypeADT)((TypeAccessor)this.outBindAccessors[i2]).internalOtype);
                        break;
                    }
                    if (this.oracleStatement instanceof OraclePreparedStatement && ((OraclePreparedStatement)this.oracleStatement).binders != null && ((OraclePreparedStatement)this.oracleStatement).binders[this.oracleStatement.firstRowInBatch] != null) {
                        t4CTTIoac.init((short)n5, n5 == 109 ? 11 : 4000);
                        Binder binder = ((OraclePreparedStatement)this.oracleStatement).binders[this.oracleStatement.firstRowInBatch][i2];
                        if (binder == null && ((OraclePreparedStatement)this.oracleStatement).lastBinders != null) {
                            binder = ((OraclePreparedStatement)this.oracleStatement).lastBinders[i2];
                        }
                        t4CTTIoac.setADT(((OraclePreparedStatement)this.oracleStatement).getOtype(binder));
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "Binding NAMED_TYPE but no type defined").fillInStackTrace();
                }
                case 994: {
                    int[] nArray = this.oracleStatement.returnParamMeta;
                    n5 = nArray[3 + i2 * 4 + 0];
                    n2 = nArray[3 + i2 * 4 + 2];
                    s2 = (short)nArray[3 + i2 * 4 + 3];
                    if (n5 == 109 || n5 == 111) {
                        TypeAccessor typeAccessor = (TypeAccessor)this.oracleStatement.accessors[i2];
                        t4CTTIoac.init((short)n5, n5 == 109 ? 11 : 4000);
                        t4CTTIoac.setADT((OracleTypeADT)typeAccessor.internalOtype);
                        break;
                    }
                    t4CTTIoac.init((short)n5, n2);
                    t4CTTIoac.setFormOfUse(s2);
                    t4CTTIoac.setCharset(s2 == 2 ? this.NCharSet : this.dbCharSet);
                    break;
                }
                case 180: {
                    boolean bl2;
                    n2 = this.bindUseDBA ? 11 : sArray[n4 + 1] & 0xFFFF;
                    t4CTTIoac.init((short)n5, n2);
                    t4CTTIoac.addFlg2(0x8000000);
                    t4CTTIoac.setTimestampFractionalSecondsPrecision((short)9);
                    int n7 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
                    if (n7 != 1) break;
                    int n6 = ((sArray[n4 + 7] & 0xFFFF) << 16) + (sArray[n4 + 8] & 0xFFFF);
                    short s4 = sArray[n6];
                    int n8 = ((this.bindIndicators[n4 + 5] & 0xFFFF) << 16) + (this.bindIndicators[n4 + 6] & 0xFFFF);
                    boolean bl3 = bl2 = sArray[n8] == -1;
                    if (!bl2 && s4 != 7) break;
                    t4CTTIoac.setTimestampFractionalSecondsPrecision((short)0);
                    break;
                }
                case 182: {
                    n2 = sArray[n4 + 1] & 0xFFFF;
                    t4CTTIoac.init((short)n5, n2);
                    t4CTTIoac.setFormOfUse(s2);
                    t4CTTIoac.setCharset(s2 == 2 ? this.NCharSet : this.dbCharSet);
                    t4CTTIoac.setPrecision((short)9);
                    t4CTTIoac.addFlg2(0x8000000);
                    break;
                }
                case 183: {
                    n2 = sArray[n4 + 1] & 0xFFFF;
                    t4CTTIoac.init((short)n5, n2);
                    t4CTTIoac.setFormOfUse(s2);
                    t4CTTIoac.setCharset(s2 == 2 ? this.NCharSet : this.dbCharSet);
                    t4CTTIoac.setPrecision((short)9);
                    t4CTTIoac.addFlg2(0x8000000);
                    t4CTTIoac.setScale((short)9);
                    break;
                }
                default: {
                    n2 = sArray[n4 + 1] & 0xFFFF;
                    if (n2 == 0) {
                        n2 = sArray[n4 + 2] & 0xFFFF;
                        if (n5 == 996) {
                            n2 *= 2;
                        } else if (n2 > 1) {
                            --n2;
                        }
                        if (s2 == 2) {
                            n2 *= this.conversion.maxNCharSize;
                        }
                        if (this.typeOfStatement == OracleStatement.SqlKind.PLSQL_BLOCK || this.connection.versionNumber >= 10200 && this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK) {
                            n2 = n2 == 0 ? this.connection.maxVcsBytesPlsql : (n2 *= this.conversion.sMaxCharSize);
                        } else if (this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK) {
                            if (n2 < 4001) {
                                n2 = 4001;
                            }
                        } else if (s2 != 2) {
                            int n9 = this.connection.maxVarcharLength;
                            n2 = ((T4CConnection)this.oracleStatement.connection).retainV9BindBehavior && n2 <= n9 ? Math.min(n2 * this.conversion.sMaxCharSize, n9) : (n2 *= this.conversion.sMaxCharSize);
                        }
                        if (n2 == 0 && this.bindUseDBA && this.bindDataLengths[i2] > 0) {
                            n2 = this.bindDataLengths[i2];
                        }
                        if (n2 == 0) {
                            n2 = 32;
                        }
                    }
                    t4CTTIoac.init((short)n5, n2);
                    t4CTTIoac.setFormOfUse(s2);
                    t4CTTIoac.setCharset(s2 == 2 ? this.NCharSet : this.dbCharSet);
                }
            }
            if (this.oracleStatement.parameterMaxLength != null && this.oracleStatement.parameterMaxLength[i2] > n2) {
                t4CTTIoac.init((short)n5, this.oracleStatement.parameterMaxLength[i2]);
            }
            if (t4CTTIoacArray[i2] != null && t4CTTIoac.isOldSufficient(t4CTTIoacArray[i2])) continue;
            t4CTTIoacArray[i2] = t4CTTIoac;
            bl = true;
        }
        if (this.oracleStatement.parameterMaxLength != null) {
            this.oracleStatement.parameterMaxLength = null;
        }
        if (bl) {
            this.oracleStatement.nbPostPonedColumns[0] = 0;
        }
        return bl;
    }

    void initDefinesDefinition() throws SQLException, IOException {
        int n2;
        this.defCols = 0;
        for (n2 = 0; n2 < this.definedColumnType.length && this.definedColumnType[n2] != 0; ++n2) {
            ++this.defCols;
        }
        this.oacdefDefines = new T4CTTIoac[this.defCols];
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        short s2 = 0;
        for (int i2 = 0; i2 < this.oacdefDefines.length; ++i2) {
            this.oacdefDefines[i2] = new T4CTTIoac(this.connection);
            s2 = (short)this.oracleStatement.getInternalType(this.definedColumnType[i2]);
            n3 = Integer.MAX_VALUE;
            n2 = 0;
            n4 = 0;
            short s3 = 1;
            if (this.definedColumnFormOfUse != null && this.definedColumnFormOfUse.length > i2 && this.definedColumnFormOfUse[i2] == 2) {
                s3 = 2;
            }
            if (s2 == 8) {
                s2 = 1;
            } else if (s2 == 24) {
                s2 = (short)23;
            } else if (s2 == 1 || s2 == 96) {
                s2 = 1;
                n3 = this.connection.maxVarcharLength * this.conversion.sMaxCharSize;
                if (this.definedColumnSize != null && this.definedColumnSize.length > i2 && this.definedColumnSize[i2] > 0) {
                    n3 = this.definedColumnSize[i2] * this.conversion.sMaxCharSize;
                }
            } else if (this.connection.useLobPrefetch && (s2 == 113 || s2 == 112 || s2 == 114)) {
                n3 = 0;
                n2 = 0x2000000;
                if (this.definedColumnSize != null && this.definedColumnSize.length > i2 && this.definedColumnSize[i2] > 0) {
                    n4 = this.definedColumnSize[i2];
                }
            } else if (s2 == 23) {
                n3 = this.connection.maxRawLength;
            }
            this.oacdefDefines[i2].init(s2, n3);
            this.oacdefDefines[i2].addFlg2(n2);
            this.oacdefDefines[i2].setMxlc(n4);
            this.oacdefDefines[i2].setFormOfUse(s3);
            this.oacdefDefines[i2].setCharset(s3 == 2 ? this.NCharSet : this.dbCharSet);
        }
    }

    void marshalBindsTypes(T4CTTIoac[] t4CTTIoacArray) throws IOException {
        if (t4CTTIoacArray == null) {
            return;
        }
        for (int i2 = 0; i2 < t4CTTIoacArray.length; ++i2) {
            t4CTTIoacArray[i2].marshal();
        }
    }

    Vector<IOException> marshalBinds(int[] nArray, boolean bl) throws IOException {
        boolean bl2;
        int n2;
        Vector<IOException> vector = null;
        int n3 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
        if (bl) {
            n2 = this.rxh.iterNum;
            bl2 = true;
        } else {
            n2 = 0;
            bl2 = false;
        }
        while (n2 < n3) {
            int n4 = this.oracleStatement.firstRowInBatch + n2;
            InputStream[] inputStreamArray = null;
            if (this.parameterStream != null) {
                inputStreamArray = this.parameterStream[n4];
            }
            Vector<IOException> vector2 = this.rxd.marshal(this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.tmpBindsByteArray, this.conversion, inputStreamArray, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, null, n2, nArray, this.plsql, this.oracleStatement.returnParamMeta, this.oracleStatement.nbPostPonedColumns, this.oracleStatement.indexOfPostPonedColumn, bl2, this.bindData, this.bindDataOffsets, this.bindDataLengths, this.bindUseDBA);
            bl2 = false;
            if (vector2 != null) {
                if (vector == null) {
                    vector = new Vector<IOException>();
                }
                vector.addAll(vector2);
            }
            ++n2;
        }
        return vector;
    }

    long setOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        block15: {
            long l2;
            block17: {
                block16: {
                    block14: {
                        l2 = 0L;
                        if (!bl || bl2 || bl3) break block14;
                        l2 |= 1L;
                        break block15;
                    }
                    if (!bl || !bl2 || bl3) break block16;
                    l2 = 32801L;
                    break block15;
                }
                if (!bl2 || !bl3) break block17;
                if (bl) {
                    l2 |= 1L;
                }
                switch (this.typeOfStatement) {
                    case SELECT_FOR_UPDATE: 
                    case SELECT: {
                        l2 |= 0x8060L;
                        break block15;
                    }
                    case PLSQL_BLOCK: 
                    case CALL_BLOCK: {
                        if (this.numberOfBindPositions > 0) {
                            l2 |= 0x420L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0);
                            if (this.sendBindsDefinition) {
                                l2 |= 8L;
                            }
                        } else {
                            l2 |= 0x20L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0);
                        }
                        break block15;
                    }
                    case DELETE: 
                    case INSERT: 
                    case MERGE: 
                    case UPDATE: 
                    case ALTER_SESSION: 
                    case OTHER: {
                        l2 = this.oracleStatement.isDmlReturning ? (l2 |= 0x420L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0)) : (l2 |= 0x8020L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0));
                        break block15;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 432).fillInStackTrace();
                    }
                }
            }
            if (!bl && !bl2 && bl3) {
                l2 = 32832L;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 432).fillInStackTrace();
            }
        }
        if (!this.typeOfStatement.isPlsqlOrCall()) {
            if ((bl || bl2 || !bl3) && this.numberOfBindPositions > 0 && this.sendBindsDefinition) {
                l2 |= 8L;
            }
            if (this.connection.versionNumber >= 9000 && bl4 && this.typeOfStatement.isSELECT()) {
                l2 |= 0x10L;
            }
        }
        return l2 &= 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$22 = T4C8Oall.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4C8Oall.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4C8Oall.class.getDeclaredMethod("setOptions", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4C8Oall.class.getDeclaredMethod("marshalBinds", int[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4C8Oall.class.getDeclaredMethod("marshalBindsTypes", T4CTTIoac[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4C8Oall.class.getDeclaredMethod("initDefinesDefinition", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4C8Oall.class.getDeclaredMethod("initBindsDefinition", T4CTTIoac[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4C8Oall.class.getDeclaredMethod("marshalPisdef", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4C8Oall.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4C8Oall.class.getDeclaredMethod("getNumRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4C8Oall.class.getDeclaredMethod("continueReadRow", Integer.TYPE, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4C8Oall.class.getDeclaredMethod("getCursorId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4C8Oall.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4C8Oall.class.getDeclaredMethod("readIMPLRES", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4C8Oall.class.getDeclaredMethod("readRSH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4C8Oall.class.getDeclaredMethod("readDCB", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4C8Oall.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4C8Oall.class.getDeclaredMethod("readRXD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4C8Oall.class.getDeclaredMethod("processSLG", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4C8Oall.class.getDeclaredMethod("readRXH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4C8Oall.class.getDeclaredMethod("readIOV", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4C8Oall.class.getDeclaredMethod("readBVC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4C8Oall.class.getDeclaredMethod("doOALL", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, OracleStatement.SqlKind.class, Integer.TYPE, byte[].class, Integer.TYPE, Accessor[].class, Integer.TYPE, Accessor[].class, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, DBConversion.class, byte[].class, InputStream[][].class, OracleStatement.class, byte[].class, char[].class, short[].class, T4CTTIoac[].class, int[].class, int[].class, int[].class, NTFDCNRegistration.class, ByteArray.class, long[].class, int[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        EMPTY_BYTES = new byte[0];
        NLS_KEYS = new String[]{"AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", null, null, null, null, "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCTERRITORY", "SESSION_NLS_LXCCHARSET", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", null, null, null, "AUTH_NLS_LXLAN", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "AUTH_NLS_LXNLSCOMP", null, "AUTH_NLS_LXCUNIONCUR", null, null, null, null, "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_NLS_LXCNLSLENSEM", "SESSION_NLS_LXCNCHAREXCP", "SESSION_NLS_LXCNCHARIMP"};
    }
}

