/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.REF;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.COLLECTION_METADATA})
public class ArrayDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Array,
Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, string, connection);
            }
            return ArrayDescriptor.createDescriptor(string, connection, false, false);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, string, connection, bl, bl2);
            }
            if (string == null || string.length() == 0 || connection == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(60, "ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null.").fillInStackTrace();
                if (bl3) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, sQLException);
                }
                throw sQLException;
            }
            SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
            String string2 = sQLName.getName();
            ArrayDescriptor arrayDescriptor = null;
            if (!bl2) {
                arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2);
            }
            if (arrayDescriptor == null) {
                short s2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getVersionNumber();
                arrayDescriptor = s2 >= 12000 ? new ArrayDescriptor(string, connection) : new ArrayDescriptor(sQLName, connection);
                if (bl) {
                    arrayDescriptor.initNamesRecursively();
                }
                ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, arrayDescriptor);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, sQLName, connection);
            }
            return ArrayDescriptor.createDescriptor(sQLName, connection, false, false);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, sQLName, connection, bl, bl2);
            }
            String string = sQLName.getName();
            ArrayDescriptor arrayDescriptor = null;
            if (!bl2) {
                arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string);
            }
            if (arrayDescriptor == null) {
                arrayDescriptor = new ArrayDescriptor(sQLName, connection);
                if (bl) {
                    arrayDescriptor.initNamesRecursively();
                }
                ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, arrayDescriptor);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, oracleTypeCOLLECTION);
            }
            String string = oracleTypeCOLLECTION.getFullName();
            OracleConnection oracleConnection = oracleTypeCOLLECTION.getConnection();
            ArrayDescriptor arrayDescriptor = (ArrayDescriptor)oracleConnection.getDescriptor(string);
            if (arrayDescriptor == null) {
                SQLName sQLName = new SQLName(oracleTypeCOLLECTION.getSchemaName(), oracleTypeCOLLECTION.getSimpleName(), oracleTypeCOLLECTION.getConnection());
                arrayDescriptor = new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
                oracleConnection.putDescriptor(string, (Object)arrayDescriptor);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, sQLName, byArray, n2, byArray2, oracleConnection);
            }
            OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, oracleConnection);
            oracleTypeADT.init(byArray2, oracleConnection);
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            return new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(String string, Connection connection) throws SQLException {
        super((short)122, string, connection);
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$47, null, string, connection);
            }
            this.initPickler();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$47, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$47, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)122, sQLName, connection);
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, sQLName, connection);
            }
            this.initPickler();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(SQLName sQLName, OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super((short)122, sQLName, oracleTypeCOLLECTION, connection);
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$49, null, sQLName, oracleTypeCOLLECTION, connection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$49, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$49, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super((short)122, oracleTypeCOLLECTION, connection);
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, oracleTypeCOLLECTION, connection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    ArrayDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)122);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            return OracleTypeMetaData.Kind.ARRAY;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, new Object[0]);
            }
            int n2 = ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getBaseName() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            String string = null;
            switch (this.getBaseType()) {
                case 12: {
                    string = "VARCHAR";
                    break;
                }
                case 1: {
                    string = "CHAR";
                    break;
                }
                case -9: {
                    string = "NVARCHAR";
                    break;
                }
                case -15: {
                    string = "NCHAR";
                    break;
                }
                case -2: {
                    string = "RAW";
                    break;
                }
                case 6: {
                    string = "FLOAT";
                    break;
                }
                case 2: {
                    string = "NUMBER";
                    break;
                }
                case 8: {
                    string = "DOUBLE";
                    break;
                }
                case 3: {
                    string = "DECIMAL";
                    break;
                }
                case 91: {
                    string = "DATE";
                    break;
                }
                case 93: {
                    string = "TIMESTAMP";
                    break;
                }
                case -101: {
                    string = "TIMESTAMP WITH TIME ZONE";
                    break;
                }
                case -102: {
                    string = "TIMESTAMP WITH LOCAL TIME ZONE";
                    break;
                }
                case 2004: {
                    string = "BLOB";
                    break;
                }
                case 2005: {
                    string = "CLOB";
                    break;
                }
                case 2011: {
                    string = "NCLOB";
                    break;
                }
                case -13: {
                    string = "BFILE";
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    string = oracleNamedType.getFullName();
                    break;
                }
                case 2006: {
                    OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    string = "REF " + ((OracleTypeREF)oracleNamedType).getFullName();
                    break;
                }
                case 100: {
                    string = "BINARY_FLOAT";
                    break;
                }
                case 101: {
                    string = "BINARY_DOUBLE";
                    break;
                }
                case -104: {
                    string = "INTERVALDS";
                    break;
                }
                case -103: {
                    string = "INTERVALYM";
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, new Object[0]);
            }
            return (OracleTypeCOLLECTION)this.pickler;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleTypeMetaData.ArrayStorage getArrayStorage() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, new Object[0]);
            }
            return OracleTypeMetaData.ArrayStorage.withCode(this.getArrayType());
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getArrayType() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, new Object[0]);
            }
            int n2 = ((OracleTypeCOLLECTION)this.pickler).getUserCode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getMaxLength() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, new Object[0]);
            }
            long l3 = l2 = this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, l2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public String descType() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, new Object[0]);
            }
            StringBuffer stringBuffer = new StringBuffer();
            return this.descType(stringBuffer, 0);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        int n3 = this.getBaseType();
        if (n3 == 2002 || n3 == 2008) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            structDescriptor.descType(stringBuffer, n2 + 1);
        } else if (n3 == 2003) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            arrayDescriptor.descType(stringBuffer, n2 + 1);
        } else if (n3 == 2007) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            opaqueDescriptor.descType(stringBuffer, n2 + 1);
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(this.getBaseName());
            stringBuffer.append("\n");
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int toLength(ARRAY aRRAY) throws SQLException {
        if (aRRAY.numElems != -1) return aRRAY.numElems;
        if (aRRAY.datumArray != null) {
            aRRAY.numElems = aRRAY.datumArray.length;
            return aRRAY.numElems;
        } else if (aRRAY.objArray != null) {
            if (aRRAY.objArray instanceof Object[]) {
                aRRAY.numElems = ((Object[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof int[]) {
                aRRAY.numElems = ((long[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof long[]) {
                aRRAY.numElems = ((float[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof float[]) {
                aRRAY.numElems = ((double[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof double[]) {
                aRRAY.numElems = ((boolean[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof boolean[]) {
                aRRAY.numElems = ((int[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof byte[]) {
                aRRAY.numElems = ((byte[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof short[]) {
                aRRAY.numElems = ((short[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else {
                if (!(aRRAY.objArray instanceof char[])) return aRRAY.numElems;
                aRRAY.numElems = ((char[])aRRAY.objArray).length;
            }
            return aRRAY.numElems;
        } else if (aRRAY.locator != null) {
            aRRAY.numElems = this.toLengthFromLocator(aRRAY.locator);
            return aRRAY.numElems;
        } else {
            if (aRRAY.shareBytes() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
            this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, 0, null);
            if (aRRAY.numElems != -1) return aRRAY.numElems;
            if (aRRAY.locator == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to get array length").fillInStackTrace();
            aRRAY.numElems = this.toLengthFromLocator(aRRAY.locator);
        }
        return aRRAY.numElems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] toBytes(ARRAY aRRAY, boolean bl) throws SQLException {
        byte[] byArray = aRRAY.shareBytes();
        if (byArray == null) {
            if (aRRAY.datumArray != null || aRRAY.locator != null) {
                byArray = this.pickler.linearize(aRRAY);
                if (bl) return byArray;
                aRRAY.setShareBytes(null);
                return byArray;
            } else {
                if (aRRAY.objArray == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                aRRAY.datumArray = this.toOracleArray(aRRAY.objArray, 1L, -1);
                byArray = this.pickler.linearize(aRRAY);
                if (bl) return byArray;
                aRRAY.datumArray = null;
                aRRAY.setShareBytes(null);
            }
            return byArray;
        } else {
            if (aRRAY.imageLength == 0L || aRRAY.imageOffset == 0L && aRRAY.imageLength == (long)byArray.length) return byArray;
            byte[] byArray2 = new byte[(int)aRRAY.imageLength];
            System.arraycopy(byArray, (int)aRRAY.imageOffset, byArray2, 0, (int)aRRAY.imageLength);
            aRRAY.setImage(byArray2, 0L, 0L);
            return byArray2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Datum[] toOracleArray(ARRAY aRRAY, long l2, int n2, boolean bl) throws SQLException {
        Datum[] datumArray = aRRAY.datumArray;
        if (datumArray == null) {
            if (aRRAY.objArray != null) {
                datumArray = this.toOracleArray(aRRAY.objArray, l2, n2);
            } else if (aRRAY.locator != null) {
                datumArray = this.toOracleArrayFromLocator(aRRAY.locator, l2, n2, null);
            } else {
                if (aRRAY.shareBytes() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status.").fillInStackTrace();
                this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l2, n2, 1, null);
                datumArray = aRRAY.locator != null ? this.toOracleArrayFromLocator(aRRAY.locator, l2, n2, null) : aRRAY.datumArray;
                if (!bl) {
                    aRRAY.datumArray = null;
                }
            }
        } else {
            if (l2 > (long)datumArray.length) {
                return new Datum[0];
            }
            int n3 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
            datumArray = new Datum[n3];
            System.arraycopy(aRRAY.datumArray, (int)l2 - 1, datumArray, 0, n3);
        }
        Datum[] datumArray2 = null;
        if (!bl) return datumArray;
        aRRAY.datumArray = datumArray;
        return (Datum[])datumArray.clone();
    }

    Object[] toJavaArray(ARRAY aRRAY, long l2, int n2, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (aRRAY.objArray != null) {
            objectArray = (Object[])((Object[])aRRAY.objArray).clone();
            int n3 = objectArray.length;
            int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
            if (n4 <= 0) {
                Object[] objectArray2 = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
                return objectArray2;
            }
            objectArray = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
            System.arraycopy(aRRAY.objArray, (int)l2 - 1, objectArray, 0, n4);
        } else {
            if (aRRAY.datumArray != null) {
                objectArray = (Object[])this.toJavaArray(aRRAY.datumArray, l2, n2, map);
            } else if (aRRAY.locator != null) {
                objectArray = this.toArrayFromLocator(aRRAY.locator, l2, n2, map);
            } else if (aRRAY.shareBytes() != null) {
                this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l2, n2, 2, map);
                objectArray = aRRAY.locator != null ? this.toArrayFromLocator(aRRAY.locator, l2, n2, map) : (Object[])aRRAY.objArray;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
            }
            aRRAY.objArray = bl && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objectArray != null ? objectArray.clone() : null;
        }
        return objectArray;
    }

    private Datum[] toOracleArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
        Datum[] datumArray = null;
        if (n4 <= 0) {
            datumArray = new Datum[]{};
        } else {
            datumArray = new Datum[n4];
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, map);
            int n5 = 0;
            while (resultSet.next()) {
                datumArray[n5] = ((OracleResultSet)resultSet).getOracleObject(2);
                ++n5;
            }
            resultSet.close();
        }
        return datumArray;
    }

    private Object[] toArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
        Object[] objectArray = null;
        if (n4 <= 0) {
            objectArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        } else {
            objectArray = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, map);
            int n5 = 0;
            while (resultSet.next()) {
                objectArray[n5] = ((OracleResultSet)resultSet).getObject(2, map);
                ++n5;
            }
            resultSet.close();
        }
        return objectArray;
    }

    public ResultSet toResultSet(ARRAY aRRAY, long l2, int n2, Map map, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, aRRAY, l2, n2, map, bl);
            }
            ResultSet resultSet = null;
            if (aRRAY.datumArray != null) {
                resultSet = this.toResultSet(aRRAY.datumArray, l2, n2, map);
            } else if (aRRAY.locator != null) {
                resultSet = this.toResultSetFromLocator(aRRAY.locator, l2, n2, map);
            } else if (aRRAY.objArray != null) {
                resultSet = this.toResultSet(this.toOracleArray(aRRAY.objArray, l2, n2), 1L, -1, map);
            } else if (aRRAY.shareBytes() != null) {
                if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(aRRAY.shareBytes(), (int)aRRAY.imageOffset)) {
                    resultSet = this.toResultSetFromImage(aRRAY, l2, n2, map);
                } else {
                    this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, 1, null);
                    if (aRRAY.locator != null) {
                        resultSet = this.toResultSetFromLocator(aRRAY.locator, l2, n2, map);
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            if (resultSet == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to create array ResultSet").fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, sQLException);
                }
                throw sQLException;
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSet(Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, datumArray, l2, n2, map);
            }
            ResultSet resultSet = null;
            resultSet = n2 == -1 ? this.connection.newArrayDataResultSet(datumArray, l2, datumArray.length, map) : this.connection.newArrayDataResultSet(datumArray, l2, n2, map);
            return resultSet;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, byArray, l2, n2, map);
            }
            ResultSet resultSet = this.connection.newArrayLocatorResultSet(this, byArray, l2, n2, map);
            return resultSet;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSetFromImage(ARRAY aRRAY, long l2, int n2, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, aRRAY, l2, n2, map);
            }
            ResultSet resultSet = this.connection.newArrayDataResultSet(aRRAY, l2, n2, map);
            return resultSet;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    public static Object[] makeJavaArray(int n2, int n3) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, null, n2, n3);
            }
            Object[] objectArray = null;
            switch (n3) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = new BigDecimal[n2];
                    break;
                }
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    objectArray = new String[n2];
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    objectArray = new Timestamp[n2];
                    break;
                }
                case -102: 
                case -101: {
                    objectArray = new OffsetDateTime[n2];
                    break;
                }
                case 2002: 
                case 2008: {
                    objectArray = new Object[n2];
                    break;
                }
                case -13: {
                    objectArray = new BFILE[n2];
                    break;
                }
                case 2004: {
                    objectArray = new BLOB[n2];
                    break;
                }
                case 2005: 
                case 2011: {
                    objectArray = new CLOB[n2];
                    break;
                }
                case -3: 
                case -2: {
                    objectArray = (Object[])new byte[n2][];
                    break;
                }
                case 2006: {
                    objectArray = new REF[n2];
                    break;
                }
                case 2003: {
                    objectArray = new Object[n2];
                    break;
                }
                case 100: {
                    objectArray = new Float[n2];
                    break;
                }
                case 101: {
                    objectArray = new Double[n2];
                    break;
                }
                case -104: {
                    objectArray = new INTERVALDS[n2];
                    break;
                }
                case -103: {
                    objectArray = new INTERVALYM[n2];
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "makeJavaArray doesn't support type " + n3).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    private int toLengthFromLocator(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, (Object)null);
        aRRAY.setLocator(byArray);
        int n2 = 0;
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        if (!oracleResultSet.next()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fail to access array storage table").fillInStackTrace();
        }
        n2 = oracleResultSet.getInt(1);
        oracleResultSet.close();
        oraclePreparedStatement.close();
        return n2;
    }

    Datum[] toOracleArray(Object object, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            OracleType oracleType = this.getElementType();
            datumArray = oracleType.toDatumArray(object, this.connection, l2, n2);
        }
        return datumArray;
    }

    private Object toJavaArray(Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        int n3 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
        if (n3 < 0) {
            n3 = 0;
        }
        Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
        if (this.getBaseType() == 2002) {
            STRUCT sTRUCT = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                sTRUCT = (STRUCT)datumArray[(int)l2 + i2 - 1];
                objectArray[i2] = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
            }
        } else {
            Datum datum = null;
            for (int i3 = 0; i3 < n3; ++i3) {
                datum = datumArray[(int)l2 + i3 - 1];
                objectArray[i3] = datum != null ? datum.toJdbc() : null;
            }
        }
        return objectArray;
    }

    private Object toNumericArray(Datum[] datumArray, long l2, int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        int n4 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
        if (n4 < 0) {
            n4 = 0;
        }
        switch (n3) {
            case 4: {
                int[] nArray = new int[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    Datum datum = datumArray[(int)l2 + i2 - 1];
                    if (datum == null) continue;
                    nArray[i2] = datum.intValue();
                }
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    Datum datum = datumArray[(int)l2 + i3 - 1];
                    if (datum == null) continue;
                    dArray[i3] = datum.doubleValue();
                }
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    Datum datum = datumArray[(int)l2 + i4 - 1];
                    if (datum == null) continue;
                    fArray[i4] = datum.floatValue();
                }
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n4];
                for (int i5 = 0; i5 < n4; ++i5) {
                    Datum datum = datumArray[(int)l2 + i5 - 1];
                    if (datum == null) continue;
                    lArray[i5] = datum.longValue();
                }
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n4];
                for (int i6 = 0; i6 < n4; ++i6) {
                    Datum datum = datumArray[(int)l2 + i6 - 1];
                    if (datum == null) continue;
                    sArray[i6] = ((NUMBER)datum).shortValue();
                }
                objectArray = sArray;
                break;
            }
            default: {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
        }
        return objectArray;
    }

    private Object toNumericArrayFromLocator(byte[] byArray, long l2, int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        int n4 = this.toLengthFromLocator(byArray);
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, null);
        int n5 = 0;
        switch (n3) {
            case 4: {
                int[] nArray = new int[n4];
                while (resultSet.next() && n5 < n4) {
                    nArray[n5++] = ((OracleResultSet)resultSet).getInt(2);
                }
                resultSet.close();
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                while (resultSet.next() && n5 < n4) {
                    dArray[n5++] = ((OracleResultSet)resultSet).getDouble(2);
                }
                resultSet.close();
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n4];
                while (resultSet.next() && n5 < n4) {
                    fArray[n5++] = ((OracleResultSet)resultSet).getFloat(2);
                }
                resultSet.close();
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n4];
                while (resultSet.next() && n5 < n4) {
                    lArray[n5++] = ((OracleResultSet)resultSet).getLong(2);
                }
                resultSet.close();
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n4];
                while (resultSet.next() && n5 < n4) {
                    sArray[n5++] = ((OracleResultSet)resultSet).getShort(2);
                }
                resultSet.close();
                objectArray = sArray;
                break;
            }
            default: {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
        }
        return objectArray;
    }

    Object toNumericArray(ARRAY aRRAY, long l2, int n2, int n3, boolean bl) throws SQLException {
        OracleType oracleType = this.getElementType();
        if (!(oracleType instanceof OracleTypeNUMBER) && !(oracleType instanceof OracleTypeFLOAT)) {
            SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLFeatureNotSupportedException.fillInStackTrace();
            throw sQLFeatureNotSupportedException;
        }
        Object object = null;
        if (aRRAY.objArray != null) {
            if (n3 == 4 && aRRAY.objArray instanceof int[]) {
                int n4 = ((int[])aRRAY.objArray).length;
                if (l2 > (long)n4) {
                    return new int[0];
                }
                n4 = (int)(n2 == -1 ? (long)n4 - l2 + 1L : Math.min((long)n4 - l2 + 1L, (long)n2));
                int[] nArray = new int[n4];
                System.arraycopy(aRRAY.objArray, (int)l2 - 1, nArray, 0, n4);
                object = nArray;
            } else if (n3 == 5 && aRRAY.objArray instanceof double[]) {
                int n5 = ((double[])aRRAY.objArray).length;
                if (l2 > (long)n5) {
                    return new double[0];
                }
                n5 = (int)(n2 == -1 ? (long)n5 - l2 + 1L : Math.min((long)n5 - l2 + 1L, (long)n2));
                double[] dArray = new double[n5];
                System.arraycopy(aRRAY.objArray, (int)l2 - 1, dArray, 0, n5);
                object = dArray;
            } else if (n3 == 6 && aRRAY.objArray instanceof float[]) {
                int n6 = ((float[])aRRAY.objArray).length;
                if (l2 > (long)n6) {
                    return new float[0];
                }
                n6 = (int)(n2 == -1 ? (long)n6 - l2 + 1L : Math.min((long)n6 - l2 + 1L, (long)n2));
                float[] fArray = new float[n6];
                System.arraycopy(aRRAY.objArray, (int)l2 - 1, fArray, 0, n6);
                object = fArray;
            } else if (n3 == 7 && aRRAY.objArray instanceof long[]) {
                int n7 = ((long[])aRRAY.objArray).length;
                if (l2 > (long)n7) {
                    return new long[0];
                }
                n7 = (int)(n2 == -1 ? (long)n7 - l2 + 1L : Math.min((long)n7 - l2 + 1L, (long)n2));
                long[] lArray = new long[n7];
                System.arraycopy(aRRAY.objArray, (int)l2 - 1, lArray, 0, n7);
                object = lArray;
            } else if (n3 == 8 && aRRAY.objArray instanceof short[]) {
                int n8 = ((short[])aRRAY.objArray).length;
                if (l2 > (long)n8) {
                    return new short[0];
                }
                n8 = (int)(n2 == -1 ? (long)n8 - l2 + 1L : Math.min((long)n8 - l2 + 1L, (long)n2));
                short[] sArray = new short[n8];
                System.arraycopy(aRRAY.objArray, (int)l2 - 1, sArray, 0, n8);
                object = sArray;
            }
        } else {
            if (aRRAY.datumArray != null) {
                object = this.toNumericArray(aRRAY.datumArray, l2, n2, n3);
            } else if (aRRAY.locator != null) {
                object = this.toNumericArrayFromLocator(aRRAY.locator, l2, n2, n3);
            } else if (aRRAY.shareBytes() != null) {
                this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l2, n2, n3, null);
                object = aRRAY.locator != null ? this.toNumericArrayFromLocator(aRRAY.locator, l2, n2, n3) : aRRAY.objArray;
            } else {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
            if (!bl) {
                aRRAY.objArray = null;
            }
        }
        return object;
    }

    private void initPickler() throws SQLException {
        try {
            String string = this.typeNameByUser;
            if (string == null) {
                string = this.getName();
            }
            OracleTypeADT oracleTypeADT = new OracleTypeADT(string, (Connection)this.connection);
            oracleTypeADT.init(this.connection);
            this.pickler = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            this.toid = ((OracleTypeADT)this.pickler).getTOID();
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + this.getName() + "\"").fillInStackTrace();
        }
    }

    private OracleType getElementType() throws SQLException {
        OracleType oracleType = ((OracleTypeCOLLECTION)this.pickler).getElementType();
        return oracleType;
    }

    @Override
    public int getTypeCode() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$34, this, new Object[0]);
            }
            int n3 = n2 = 2003;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$34, this, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$34, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    public SQLInput toJdbcToSQLInput(ARRAY aRRAY, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, aRRAY, map);
            }
            return new OracleJdbc2SQLInput(this.toOracleArray(aRRAY, 0L, aRRAY.length(), false), map, this.connection);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, new Object[]{datumArray});
            }
            ARRAY aRRAY = new ARRAY(this, this.connection, datumArray);
            return this.pickler.linearize(aRRAY);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, new Object[]{objectArray});
            }
            Datum[] datumArray = this.toArray(objectArray);
            byte[] byArray = this.toBytes(datumArray);
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    public int length(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, new Object[]{byArray});
            }
            ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
            int n3 = n2 = this.toLength(aRRAY);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, new Object[]{byArray});
            }
            Datum[] datumArray = null;
            if (byArray != null) {
                ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
                datumArray = this.toOracleArray(aRRAY, 1L, -1, false);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    public Datum[] toArray(Object object) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, object);
            }
            Datum[] datumArray = this.toOracleArray(object, 1L, -1);
            return datumArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSet(byte[] byArray, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, byArray, map);
            }
            ResultSet resultSet = null;
            if (byArray != null) {
                ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
                resultSet = this.toResultSet(aRRAY, 1L, -1, map, false);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSet(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, byArray, l2, n2, map);
            }
            ResultSet resultSet = null;
            if (byArray != null) {
                ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
                resultSet = this.toResultSet(aRRAY, l2, n2, map, false);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    String tagName() {
        return "ArrayDescriptor";
    }

    public static int getCacheStyle(ARRAY aRRAY) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$44, null, aRRAY);
            }
            int n2 = 2;
            if (aRRAY.getAutoIndexing() && (aRRAY.getAccessDirection() == 2 || aRRAY.getAccessDirection() == 3)) {
                n2 = 1;
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$44, null, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$44, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$44, null, throwable2);
            }
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    static {
        try {
            $$$methodRef$$$51 = ArrayDescriptor.class.getDeclaredConstructor(byte[].class, Integer.TYPE, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = ArrayDescriptor.class.getDeclaredConstructor(OracleTypeCOLLECTION.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = ArrayDescriptor.class.getDeclaredConstructor(SQLName.class, OracleTypeCOLLECTION.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = ArrayDescriptor.class.getDeclaredConstructor(SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = ArrayDescriptor.class.getDeclaredConstructor(String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = ArrayDescriptor.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = ArrayDescriptor.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = ArrayDescriptor.class.getDeclaredMethod("getCacheStyle", ARRAY.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = ArrayDescriptor.class.getDeclaredMethod("tagName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", byte[].class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = ArrayDescriptor.class.getDeclaredMethod("toArray", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = ArrayDescriptor.class.getDeclaredMethod("toArray", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = ArrayDescriptor.class.getDeclaredMethod("length", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = ArrayDescriptor.class.getDeclaredMethod("toBytes", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = ArrayDescriptor.class.getDeclaredMethod("toBytes", Datum[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = ArrayDescriptor.class.getDeclaredMethod("toJdbcToSQLInput", ARRAY.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = ArrayDescriptor.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = ArrayDescriptor.class.getDeclaredMethod("getElementType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = ArrayDescriptor.class.getDeclaredMethod("initPickler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = ArrayDescriptor.class.getDeclaredMethod("toNumericArray", ARRAY.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = ArrayDescriptor.class.getDeclaredMethod("toNumericArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = ArrayDescriptor.class.getDeclaredMethod("toNumericArray", Datum[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = ArrayDescriptor.class.getDeclaredMethod("toJavaArray", Datum[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = ArrayDescriptor.class.getDeclaredMethod("toOracleArray", Object.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = ArrayDescriptor.class.getDeclaredMethod("toLengthFromLocator", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = ArrayDescriptor.class.getDeclaredMethod("makeJavaArray", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = ArrayDescriptor.class.getDeclaredMethod("toResultSetFromImage", ARRAY.class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = ArrayDescriptor.class.getDeclaredMethod("toResultSetFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", Datum[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", ARRAY.class, Long.TYPE, Integer.TYPE, Map.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = ArrayDescriptor.class.getDeclaredMethod("toArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = ArrayDescriptor.class.getDeclaredMethod("toOracleArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = ArrayDescriptor.class.getDeclaredMethod("toJavaArray", ARRAY.class, Long.TYPE, Integer.TYPE, Map.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = ArrayDescriptor.class.getDeclaredMethod("toOracleArray", ARRAY.class, Long.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = ArrayDescriptor.class.getDeclaredMethod("toBytes", ARRAY.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = ArrayDescriptor.class.getDeclaredMethod("toLength", ARRAY.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = ArrayDescriptor.class.getDeclaredMethod("descType", StringBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = ArrayDescriptor.class.getDeclaredMethod("descType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = ArrayDescriptor.class.getDeclaredMethod("getMaxLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = ArrayDescriptor.class.getDeclaredMethod("getArrayType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = ArrayDescriptor.class.getDeclaredMethod("getArrayStorage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = ArrayDescriptor.class.getDeclaredMethod("getOracleTypeCOLLECTION", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = ArrayDescriptor.class.getDeclaredMethod("getBaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = ArrayDescriptor.class.getDeclaredMethod("getBaseType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = ArrayDescriptor.class.getDeclaredMethod("getKind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, byte[].class, Integer.TYPE, byte[].class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", OracleTypeCOLLECTION.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, Connection.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", String.class, Connection.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

