/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.SessionAtts;

public class NIONSDataChannel
extends NIOPacket {
    int sessionIdSize;
    protected byte[] compressedDataBuffer;
    protected byte[] decompressedDataBuffer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    public NIONSDataChannel(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 6;
        this.sessionIdSize = sessionAtts.poolEnabled ? 16 : 0;
    }

    public int getDataExpansionByteSize() {
        return 0;
    }

    public void readDataFromSocketChannel() throws IOException {
        this.session.payloadDataBuffer.position(this.session.payloadDataBuffer.limit());
        this.readFromSocketChannel(true);
        this.session.payloadDataBuffer.clear();
        this.session.payloadDataBuffer.limit(this.session.payloadBuffer.limit() - 2);
        short s2 = this.session.payloadBuffer.getShort();
        if ((s2 & 0x400) != 0) {
            try {
                int n2;
                if (this.session.buffer.hasArray()) {
                    n2 = this.session.compressionCodec.decompress(this.session.buffer.array(), 10, this.session.payloadDataBuffer.limit(), this.decompressedDataBuffer);
                } else {
                    this.session.payloadDataBuffer.get(this.compressedDataBuffer, 0, this.session.payloadDataBuffer.limit());
                    n2 = this.session.compressionCodec.decompress(this.compressedDataBuffer, 0, this.session.payloadDataBuffer.limit(), this.decompressedDataBuffer);
                }
                this.session.payloadDataBuffer.clear();
                this.session.payloadDataBuffer.put(this.decompressedDataBuffer, 0, n2);
                this.session.payloadDataBuffer.rewind();
                this.session.payloadDataBuffer.limit(n2);
            }
            catch (DataFormatException dataFormatException) {
                throw (IOException)new IOException("Network Compression failure").initCause(dataFormatException);
            }
        }
    }

    public void sendEOF() throws IOException {
        this.session.payloadBuffer.clear();
        this.session.payloadBuffer.put((byte)0);
        this.session.payloadBuffer.put((byte)64);
        this.writeToSocketChannel();
    }

    public void writeDataToSocketChannel() throws IOException {
        this.writeDataToSocketChannel(0);
    }

    public void writeDataToSocketChannel(int n2) throws IOException {
        if (this.session.payloadDataBuffer.position() > 0) {
            this.session.payloadBuffer.clear();
            this.header.type = 6;
            if (this.session.networkCompressionEnabled && this.session.payloadDataBuffer.position() + 10 > this.session.networkCompressionThreshold) {
                try {
                    int n3;
                    int n4 = this.session.payloadDataBuffer.position();
                    if (this.session.buffer.hasArray()) {
                        n3 = this.session.compressionCodec.compress(this.session.buffer.array(), 10, n4, this.compressedDataBuffer);
                    } else {
                        this.session.payloadDataBuffer.rewind();
                        this.session.payloadDataBuffer.get(this.decompressedDataBuffer, 0, n4);
                        n3 = this.session.compressionCodec.compress(this.decompressedDataBuffer, 0, n4, this.compressedDataBuffer);
                    }
                    if (n3 < n4) {
                        n2 |= 0x400;
                        this.session.payloadDataBuffer.rewind();
                        this.session.payloadDataBuffer.put(this.compressedDataBuffer, 0, n3);
                    }
                }
                catch (DataFormatException dataFormatException) {
                    throw (IOException)new IOException("Network Compression failure").initCause(dataFormatException);
                }
            }
            this.session.payloadBuffer.position(this.session.payloadDataBuffer.position() + 2);
            this.session.payloadBuffer.put(0, (byte)(n2 / 256));
            this.session.payloadBuffer.put(1, (byte)(n2 % 256));
            this.writeToSocketChannel();
        }
        this.session.payloadDataBuffer.clear();
        this.session.payloadDataBuffer.limit(this.session.payloadDataBuffer.capacity() - this.getDataExpansionByteSize());
    }

    public ByteBuffer getDataBuffer() {
        return this.session.payloadDataBuffer;
    }

    void initializeNetworkCompressionBuffers() {
        this.compressedDataBuffer = new byte[this.session.getSDU()];
        this.decompressedDataBuffer = new byte[this.session.getSDU()];
    }

    byte[] readPayloadDataFromSocketChannel(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; i2 += n3) {
            this.readDataFromSocketChannel();
            n3 = this.session.payloadDataBuffer.limit();
            this.session.payloadDataBuffer.get(byArray, i2, n3);
        }
        return byArray;
    }

    void writeDataToSocketChannel(byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += n2) {
            n2 = this.session.payloadDataBuffer.limit() - this.session.payloadDataBuffer.position();
            if (n2 > byArray.length - i2) {
                n2 = byArray.length - i2;
            }
            n3 = byArray.length > n2 ? 32 : 0;
            this.session.payloadDataBuffer.put(byArray, i2, n2);
            this.writeDataToSocketChannel(n3);
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        throw new UnsupportedOperationException("Data Byte buffers are not duplicated and accessed directly by the upper layer");
    }

    static {
        try {
            $$$methodRef$$$10 = NIONSDataChannel.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NIONSDataChannel.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NIONSDataChannel.class.getDeclaredMethod("writeDataToSocketChannel", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NIONSDataChannel.class.getDeclaredMethod("readPayloadDataFromSocketChannel", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NIONSDataChannel.class.getDeclaredMethod("initializeNetworkCompressionBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NIONSDataChannel.class.getDeclaredMethod("getDataBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NIONSDataChannel.class.getDeclaredMethod("writeDataToSocketChannel", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NIONSDataChannel.class.getDeclaredMethod("writeDataToSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NIONSDataChannel.class.getDeclaredMethod("sendEOF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NIONSDataChannel.class.getDeclaredMethod("readDataFromSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NIONSDataChannel.class.getDeclaredMethod("getDataExpansionByteSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

