/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
final class NIOMarkerPacket
extends NIOPacket {
    private boolean isReset;
    private boolean isBreak;
    private ByteBuffer markerBuffer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    NIOMarkerPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 12;
        this.markerBuffer = ByteBuffer.allocate(11);
    }

    NIOMarkerPacket(NIOHeader nIOHeader, SessionAtts sessionAtts) throws IOException {
        super(nIOHeader, sessionAtts);
        nIOHeader.type = 12;
    }

    void writeToSocketChannel(int n2, byte by) throws IOException {
        this.markerBuffer.clear();
        if (this.session.isLargeSDU) {
            this.markerBuffer.putInt(this.markerBuffer.capacity());
        } else {
            this.markerBuffer.putShort((short)this.markerBuffer.capacity());
            this.markerBuffer.putShort((short)0);
        }
        this.markerBuffer.put((byte)this.header.type);
        this.markerBuffer.put((byte)this.header.flags);
        this.markerBuffer.putShort((short)0);
        this.markerBuffer.put((byte)n2);
        this.markerBuffer.put((byte)0);
        this.markerBuffer.put(by);
        this.markerBuffer.limit(this.markerBuffer.position());
        this.markerBuffer.rewind();
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ((MQLNTAdapter)this.session.nt).writeToRemoteQueue(this.markerBuffer, false);
        } else {
            while (this.markerBuffer.hasRemaining()) {
                this.session.socketChannel.write(this.markerBuffer);
            }
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        byte by = this.session.payloadBuffer.get();
        byte by2 = this.session.payloadBuffer.get();
        switch (by) {
            case 0: {
                this.isBreak = true;
                break;
            }
            case 1: {
                byte by3 = this.session.payloadBuffer.get();
                if (by3 == 2) {
                    this.isBreak = false;
                    this.isReset = true;
                    break;
                }
                this.isReset = false;
                this.isBreak = true;
                break;
            }
            default: {
                throw new NetException(205);
            }
        }
    }

    boolean isBreakPkt() {
        return this.isBreak;
    }

    boolean isResetPkt() {
        return this.isReset;
    }

    static {
        try {
            $$$methodRef$$$5 = NIOMarkerPacket.class.getDeclaredConstructor(NIOHeader.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = NIOMarkerPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = NIOMarkerPacket.class.getDeclaredMethod("isResetPkt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NIOMarkerPacket.class.getDeclaredMethod("isBreakPkt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NIOMarkerPacket.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NIOMarkerPacket.class.getDeclaredMethod("writeToSocketChannel", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

