/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oci.OracleOCIConnection;
import oracle.jdbc.pool.OracleDataSource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OracleOCIConnectionPool
extends OracleDataSource {
    public OracleOCIConnection m_connection_pool;
    public static final String IS_CONNECTION_POOLING = "is_connection_pooling";
    private int m_conn_min_limit = 0;
    private int m_conn_max_limit = 0;
    private int m_conn_increment = 0;
    private int m_conn_active_size = 0;
    private int m_conn_pool_size = 0;
    private int m_conn_timeout = 0;
    private String m_conn_nowait = "false";
    private int m_is_transactions_distributed = 0;
    public static final String CONNPOOL_OBJECT = "connpool_object";
    public static final String CONNPOOL_LOGON_MODE = "connection_pool";
    public static final String CONNECTION_POOL = "connection_pool";
    public static final String CONNPOOL_CONNECTION = "connpool_connection";
    public static final String CONNPOOL_PROXY_CONNECTION = "connpool_proxy_connection";
    public static final String CONNPOOL_ALIASED_CONNECTION = "connpool_alias_connection";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_DISTINGUISHED_NAME = "proxy_distinguished_name";
    public static final String PROXY_CERTIFICATE = "proxy_certificate";
    public static final String PROXY_ROLES = "proxy_roles";
    public static final String PROXY_NUM_ROLES = "proxy_num_roles";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String PROXYTYPE = "proxytype";
    public static final String PROXYTYPE_USER_NAME = "proxytype_user_name";
    public static final String PROXYTYPE_DISTINGUISHED_NAME = "proxytype_distinguished_name";
    public static final String PROXYTYPE_CERTIFICATE = "proxytype_certificate";
    public static final String CONNECTION_ID = "connection_id";
    public static final String CONNPOOL_MIN_LIMIT = "connpool_min_limit";
    public static final String CONNPOOL_MAX_LIMIT = "connpool_max_limit";
    public static final String CONNPOOL_INCREMENT = "connpool_increment";
    public static final String CONNPOOL_ACTIVE_SIZE = "connpool_active_size";
    public static final String CONNPOOL_POOL_SIZE = "connpool_pool_size";
    public static final String CONNPOOL_TIMEOUT = "connpool_timeout";
    public static final String CONNPOOL_NOWAIT = "connpool_nowait";
    public static final String CONNPOOL_IS_POOLCREATED = "connpool_is_poolcreated";
    public static final String TRANSACTIONS_DISTRIBUTED = "transactions_distributed";
    private Hashtable m_lconnections = null;
    private Lifecycle lifecycle = Lifecycle.NEW;
    private OracleDriver m_oracleDriver = new OracleDriver();
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    private void ensureOpen() throws SQLException {
        if (this.lifecycle == Lifecycle.NEW) {
            this.createConnectionPool(null);
        }
        if (this.lifecycle != Lifecycle.OPEN) {
            throw (SQLException)DatabaseError.createSqlException(8).fillInStackTrace();
        }
    }

    public OracleOCIConnectionPool(String string, String string2, String string3, Properties properties) throws SQLException {
        this();
        this.setURL(string3);
        this.setUser(string);
        this.setPassword(string2);
        this.createConnectionPool(properties);
    }

    public OracleOCIConnectionPool(String string, String string2, String string3) throws SQLException {
        this();
        this.setURL(string3);
        this.setUser(string);
        this.setPassword(string2);
        this.createConnectionPool(null);
    }

    public OracleOCIConnectionPool() throws SQLException {
        this.isOracleDataSource = false;
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.ensureOpen();
        Connection connection = this.getConnection(this.user, this.password.get());
        return connection;
    }

    @Override
    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        this.ensureOpen();
        Properties properties = this.connectionProperties != null ? new Properties(this.connectionProperties) : new Properties();
        properties.put(IS_CONNECTION_POOLING, "true");
        properties.put("user", string);
        properties.put("password", string2);
        properties.put("connection_pool", CONNPOOL_CONNECTION);
        properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
        if (oracleOCIConnection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(reference);
        reference.add(new StringRefAddr(CONNPOOL_MIN_LIMIT, String.valueOf(this.m_conn_min_limit)));
        reference.add(new StringRefAddr(CONNPOOL_MAX_LIMIT, String.valueOf(this.m_conn_max_limit)));
        reference.add(new StringRefAddr(CONNPOOL_INCREMENT, String.valueOf(this.m_conn_increment)));
        reference.add(new StringRefAddr(CONNPOOL_ACTIVE_SIZE, String.valueOf(this.m_conn_active_size)));
        reference.add(new StringRefAddr(CONNPOOL_POOL_SIZE, String.valueOf(this.m_conn_pool_size)));
        reference.add(new StringRefAddr(CONNPOOL_TIMEOUT, String.valueOf(this.m_conn_timeout)));
        reference.add(new StringRefAddr(CONNPOOL_NOWAIT, this.m_conn_nowait));
        reference.add(new StringRefAddr(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated())));
        reference.add(new StringRefAddr(TRANSACTIONS_DISTRIBUTED, String.valueOf(this.isDistributedTransEnabled())));
        return reference;
    }

    public synchronized OracleConnection getProxyConnection(String string, Properties properties) throws SQLException {
        this.ensureOpen();
        if (PROXYTYPE_USER_NAME.equals(string)) {
            properties.put("user", properties.getProperty(PROXY_USER_NAME));
        } else if (PROXYTYPE_DISTINGUISHED_NAME.equals(string)) {
            properties.put("user", properties.getProperty(PROXY_DISTINGUISHED_NAME));
        } else if (PROXYTYPE_CERTIFICATE.equals(string)) {
            properties.put("user", String.valueOf(properties.getProperty(PROXY_USER_NAME)));
        } else {
            throw (SQLException)DatabaseError.createSqlException(107, "null properties").fillInStackTrace();
        }
        properties.put(IS_CONNECTION_POOLING, "true");
        properties.put(PROXYTYPE, string);
        String[] stringArray = (String[])properties.get(PROXY_ROLES);
        if (stringArray != null) {
            properties.put(PROXY_NUM_ROLES, new Integer(stringArray.length));
        } else {
            properties.put(PROXY_NUM_ROLES, new Integer(0));
        }
        properties.put("connection_pool", CONNPOOL_PROXY_CONNECTION);
        properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
        if (oracleOCIConnection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    public synchronized OracleConnection getAliasedConnection(byte[] byArray) throws SQLException {
        this.ensureOpen();
        Properties properties = new Properties();
        properties.put(IS_CONNECTION_POOLING, "true");
        properties.put(CONNECTION_ID, byArray);
        properties.put("connection_pool", CONNPOOL_ALIASED_CONNECTION);
        properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
        if (oracleOCIConnection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.lifecycle != Lifecycle.OPEN) {
            return;
        }
        this.lifecycle = Lifecycle.CLOSING;
        Iterator iterator = this.m_lconnections.values().iterator();
        while (iterator.hasNext()) {
            OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)iterator.next();
            if (oracleOCIConnection != null && oracleOCIConnection != this.m_connection_pool) {
                oracleOCIConnection.close();
            }
            iterator.remove();
        }
        this.m_connection_pool.close();
        this.lifecycle = Lifecycle.CLOSED;
    }

    public synchronized void setPoolConfig(Properties properties) throws SQLException {
        if (properties == null) {
            throw (SQLException)DatabaseError.createSqlException(106, "null properties").fillInStackTrace();
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(properties);
        } else {
            Properties properties2 = new Properties();
            this.checkPoolConfig(properties, properties2);
            int[] nArray = new int[6];
            OracleOCIConnectionPool.readPoolConfig(properties2, nArray);
            this.m_connection_pool.setConnectionPoolInfo(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
        }
        this.storePoolProperties();
    }

    public static void readPoolConfig(int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int[] nArray) {
        for (int i2 = 0; i2 < 6; ++i2) {
            nArray[i2] = 0;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        nArray[2] = n4;
        nArray[3] = n5;
        if (bl) {
            nArray[4] = 1;
        }
        if (bl2) {
            nArray[5] = 1;
        }
    }

    public static void readPoolConfig(Properties properties, int[] nArray) {
        String string = properties.getProperty(CONNPOOL_MIN_LIMIT);
        if (string != null) {
            nArray[0] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_MAX_LIMIT)) != null) {
            nArray[1] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_INCREMENT)) != null) {
            nArray[2] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_TIMEOUT)) != null) {
            nArray[3] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_NOWAIT)) != null && string.equalsIgnoreCase("true")) {
            nArray[4] = 1;
        }
        if ((string = properties.getProperty(TRANSACTIONS_DISTRIBUTED)) != null && string.equalsIgnoreCase("true")) {
            nArray[5] = 1;
        }
    }

    private void checkPoolConfig(Properties properties, Properties properties2) throws SQLException {
        String string = (String)properties.get(TRANSACTIONS_DISTRIBUTED);
        String string2 = (String)properties.get(CONNPOOL_NOWAIT);
        if (string != null && !string.equalsIgnoreCase("true") || string2 != null && !string2.equalsIgnoreCase("true") || properties.get(CONNPOOL_MIN_LIMIT) == null || properties.get(CONNPOOL_MAX_LIMIT) == null || properties.get(CONNPOOL_INCREMENT) == null || Integer.decode((String)properties.get(CONNPOOL_MIN_LIMIT)) < 0 || Integer.decode((String)properties.get(CONNPOOL_MAX_LIMIT)) < 0 || Integer.decode((String)properties.get(CONNPOOL_INCREMENT)) < 0) {
            throw (SQLException)DatabaseError.createSqlException(106, "").fillInStackTrace();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = properties.getProperty(string3);
            if (TRANSACTIONS_DISTRIBUTED.equals(string3) || CONNPOOL_NOWAIT.equals(string3)) {
                properties2.put(string3, "true");
                continue;
            }
            properties2.put(string3, string4);
        }
    }

    private synchronized void storePoolProperties() throws SQLException {
        Properties properties = this.getPoolConfig();
        this.m_conn_min_limit = Integer.decode(properties.getProperty(CONNPOOL_MIN_LIMIT));
        this.m_conn_max_limit = Integer.decode(properties.getProperty(CONNPOOL_MAX_LIMIT));
        this.m_conn_increment = Integer.decode(properties.getProperty(CONNPOOL_INCREMENT));
        this.m_conn_active_size = Integer.decode(properties.getProperty(CONNPOOL_ACTIVE_SIZE));
        this.m_conn_pool_size = Integer.decode(properties.getProperty(CONNPOOL_POOL_SIZE));
        this.m_conn_timeout = Integer.decode(properties.getProperty(CONNPOOL_TIMEOUT));
        this.m_conn_nowait = properties.getProperty(CONNPOOL_NOWAIT);
    }

    public synchronized Properties getPoolConfig() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        properties.put(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated()));
        return properties;
    }

    public synchronized int getActiveSize() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_ACTIVE_SIZE);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized int getPoolSize() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_POOL_SIZE);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized int getTimeout() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_TIMEOUT);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized String getNoWait() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        return properties.getProperty(CONNPOOL_NOWAIT);
    }

    public synchronized int getMinLimit() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_MIN_LIMIT);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized int getMaxLimit() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_MAX_LIMIT);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized int getConnectionIncrement() throws SQLException {
        this.ensureOpen();
        Properties properties = this.m_connection_pool.getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_INCREMENT);
        int n2 = Integer.decode(string);
        return n2;
    }

    public synchronized boolean isDistributedTransEnabled() {
        return this.m_is_transactions_distributed == 1;
    }

    private void createConnectionPool(Properties properties) throws SQLException {
        if (this.lifecycle != Lifecycle.NEW) {
            return;
        }
        if (this.user == null || this.password == null || this.password.isNull()) {
            throw (SQLException)DatabaseError.createSqlException(106, " ").fillInStackTrace();
        }
        Properties properties2 = new Properties();
        if (properties != null) {
            this.checkPoolConfig(properties, properties2);
        }
        properties2.put(IS_CONNECTION_POOLING, "true");
        properties2.put("user", this.user);
        properties2.put("password", this.password.get());
        properties2.put("connection_pool", "connection_pool");
        if (this.getURL() == null) {
            this.makeURL();
        }
        this.m_connection_pool = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties2);
        if (this.m_connection_pool == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        this.m_connection_pool.setConnectionPool(this);
        this.m_lconnections.put(this.m_connection_pool, this.m_connection_pool);
        this.lifecycle = Lifecycle.OPEN;
        this.storePoolProperties();
        if (properties != null && "true".equalsIgnoreCase(properties.getProperty(TRANSACTIONS_DISTRIBUTED))) {
            this.m_is_transactions_distributed = 1;
        }
    }

    public synchronized boolean isPoolCreated() {
        return this.lifecycle == Lifecycle.OPEN;
    }

    public synchronized void connectionClosed(OracleOCIConnection oracleOCIConnection) throws SQLException {
        if (this.lifecycle != Lifecycle.CLOSING && this.m_lconnections.remove(oracleOCIConnection) == null) {
            throw (SQLException)DatabaseError.createSqlException(1, "internal OracleOCIConnectionPool error").fillInStackTrace();
        }
    }

    public synchronized void setStmtCacheSize(int n2) throws SQLException {
        this.setStmtCacheSize(n2, false);
    }

    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        this.m_stmtCacheSize = n2;
        this.m_stmtClearMetaData = bl;
    }

    public synchronized int getStmtCacheSize() {
        return this.m_stmtCacheSize;
    }

    public synchronized boolean isStmtCacheEnabled() {
        return this.m_stmtCacheSize > 0;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$31 = OracleOCIConnectionPool.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleOCIConnectionPool.class.getDeclaredConstructor(String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleOCIConnectionPool.class.getDeclaredConstructor(String.class, String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleOCIConnectionPool.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleOCIConnectionPool.class.getDeclaredMethod("isStmtCacheEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleOCIConnectionPool.class.getDeclaredMethod("getStmtCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleOCIConnectionPool.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleOCIConnectionPool.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleOCIConnectionPool.class.getDeclaredMethod("connectionClosed", OracleOCIConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleOCIConnectionPool.class.getDeclaredMethod("isPoolCreated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleOCIConnectionPool.class.getDeclaredMethod("createConnectionPool", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleOCIConnectionPool.class.getDeclaredMethod("isDistributedTransEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleOCIConnectionPool.class.getDeclaredMethod("getConnectionIncrement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleOCIConnectionPool.class.getDeclaredMethod("getMaxLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleOCIConnectionPool.class.getDeclaredMethod("getMinLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleOCIConnectionPool.class.getDeclaredMethod("getNoWait", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleOCIConnectionPool.class.getDeclaredMethod("getTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleOCIConnectionPool.class.getDeclaredMethod("getPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleOCIConnectionPool.class.getDeclaredMethod("getActiveSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleOCIConnectionPool.class.getDeclaredMethod("getPoolConfig", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleOCIConnectionPool.class.getDeclaredMethod("storePoolProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleOCIConnectionPool.class.getDeclaredMethod("checkPoolConfig", Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleOCIConnectionPool.class.getDeclaredMethod("readPoolConfig", Properties.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleOCIConnectionPool.class.getDeclaredMethod("readPoolConfig", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleOCIConnectionPool.class.getDeclaredMethod("setPoolConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleOCIConnectionPool.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleOCIConnectionPool.class.getDeclaredMethod("getAliasedConnection", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleOCIConnectionPool.class.getDeclaredMethod("getProxyConnection", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleOCIConnectionPool.class.getDeclaredMethod("getReference", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleOCIConnectionPool.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleOCIConnectionPool.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleOCIConnectionPool.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static final class Lifecycle
    extends Enum<Lifecycle> {
        public static final /* enum */ Lifecycle NEW;
        public static final /* enum */ Lifecycle OPEN;
        public static final /* enum */ Lifecycle CLOSING;
        public static final /* enum */ Lifecycle CLOSED;
        private static final /* synthetic */ Lifecycle[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static Lifecycle[] values() {
            return (Lifecycle[])$VALUES.clone();
        }

        public static Lifecycle valueOf(String string) {
            return Enum.valueOf(Lifecycle.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = Lifecycle.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Lifecycle.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Lifecycle.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            NEW = new Lifecycle();
            OPEN = new Lifecycle();
            CLOSING = new Lifecycle();
            CLOSED = new Lifecycle();
            $VALUES = new Lifecycle[]{NEW, OPEN, CLOSING, CLOSED};
        }
    }
}

