/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrmp;
import oracle.jdbc.driver.T4CTTIkpdnrnf;
import oracle.jdbc.driver.T4CTTIkpdnrpay;
import oracle.jdbc.driver.T4CTTIkpdnrreq;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIoaqnfy
extends T4CTTIfun {
    byte[] jmsConnectionId = null;
    boolean isMarshalOver = false;
    boolean needToBeClosed = false;
    OracleConnection conn = null;
    T4CTTIkpdnrnf notificationHeader = null;
    T4CTTIkpdnrmp messageProperties = null;
    T4CTTIkpdnrpay payload = null;
    NTFManager ntfManager = null;
    T4CMAREngine mar;
    String databaseUniqueIdentifier;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    T4CTTIoaqnfy(T4CConnection t4CConnection, String string) throws SQLException {
        super(t4CConnection, (byte)3);
        assert (t4CConnection != null && string != null) : "connection is " + t4CConnection + ", jmsConnectionId is " + string;
        this.setFunCode((short)187);
        this.conn = t4CConnection;
        this.mar = t4CConnection.mare;
        this.jmsConnectionId = this.mar.conv.StringToCharBytes(string);
    }

    @Override
    void marshal() throws IOException {
        T4CTTIkpdnrreq t4CTTIkpdnrreq = new T4CTTIkpdnrreq((T4CConnection)this.conn);
        t4CTTIkpdnrreq.send(this.jmsConnectionId, T4CTTIkpdnrreq.OpCode.INIT_KPDNRREQ);
        this.isMarshalOver = true;
    }

    @Override
    void readOAC() throws SQLException, IOException {
        this.notificationHeader = new T4CTTIkpdnrnf((T4CConnection)this.conn);
        this.messageProperties = new T4CTTIkpdnrmp((T4CConnection)this.conn);
        this.payload = new T4CTTIkpdnrpay((T4CConnection)this.conn);
        while (true) {
            this.notificationHeader.receive();
            if (this.notificationHeader.messageType != 4) {
                this.messageProperties.receive();
                this.payload.receive();
                this.createAndGenerateEvent();
                continue;
            }
            this.throwException(this.notificationHeader.errorCode);
        }
    }

    private void throwException(int n2) {
        try {
            int n3 = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
            NTFJMSRegistration nTFJMSRegistration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(n3);
            switch (n2) {
                case 24035: {
                    nTFJMSRegistration.raiseException(2);
                    break;
                }
                case 24010: {
                    nTFJMSRegistration.raiseException(3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createAndGenerateEvent() throws SQLException {
        int n2 = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
        NTFJMSRegistration nTFJMSRegistration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(n2);
        NTFJMSEvent nTFJMSEvent = new NTFJMSEvent(this);
        nTFJMSEvent.setAqMessageProperites(this.messageProperties.getAqMessageProperties());
        nTFJMSEvent.setJmsMessageProperties(this.messageProperties.getJmsMessageProperties());
        nTFJMSEvent.setMessageId(this.messageProperties.getMessageId());
        nTFJMSEvent.setPayload(this.payload.getRawPayload());
        nTFJMSEvent.setConsumerName(this.notificationHeader.getConsumerName());
        nTFJMSEvent.setQueueName(this.notificationHeader.getNotificationQueue());
        nTFJMSEvent.setRegistration(this.notificationHeader.getNotificationQueue());
        nTFJMSRegistration.notify(nTFJMSEvent);
    }

    public void stopListening() {
        while (!this.isMarshalOver) {
        }
        this.needToBeClosed = true;
    }

    static {
        try {
            $$$methodRef$$$5 = T4CTTIoaqnfy.class.getDeclaredConstructor(T4CConnection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIoaqnfy.class.getDeclaredMethod("stopListening", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoaqnfy.class.getDeclaredMethod("createAndGenerateEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoaqnfy.class.getDeclaredMethod("throwException", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoaqnfy.class.getDeclaredMethod("readOAC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoaqnfy.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

